/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.transport.multiplex.config;

import javax.management.MBeanServer;

import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.test.remoting.transport.multiplex.config.MemoryTestClient.MemoryWatcher;

/**
* @author <a href="mailto:tim.fox@jboss.com">Tim Fox</a>
*
*/
public class MemoryTestServer
{
  // Constants -----------------------------------------------------
  
  private static final Logger log = Logger.getLogger(MemoryTestServer.class);
  private MemoryTestClient.MemoryWatcher memoryWatcher = new MemoryTestClient.MemoryWatcher();
  private Connector serverConnector;
  SimpleServerInvocationHandler invocationHandler;
  
  public void startServer() throws Throwable
  {
     //Start a server
     
     serverConnector = new Connector();
     InvokerLocator serverLocator = new InvokerLocator("multiplex://localhost:9099");
     serverConnector.setInvokerLocator(serverLocator.getLocatorURI());
     serverConnector.create();
     invocationHandler = new SimpleServerInvocationHandler();
     serverConnector.addInvocationHandler("JMS", invocationHandler);
     serverConnector.start(); 
     log.info("Server started");
     System.out.println("Server started: " + serverLocator.getLocatorURI());
  }
  
  public void stopServer() throws Throwable
  {
	  Thread.sleep(2000);
	  serverConnector.stop();
	  serverConnector = null;
	  invocationHandler = null;
//	  Thread.sleep(300000);
  }
  
  public static void main(String[] args)
  {
	  MemoryTestServer server = new MemoryTestServer();
	  
	  try {
		  server.startServer();
		  
		  while (server.invocationHandler.getCounter() < 2 * MemoryTestClient.ITERATIONS)
		  {
//			  System.out.println("counter: " + server.invocationHandler.getCounter());
			  server.memoryWatcher.checkMemory("" + server.invocationHandler.getCounter());
			  Thread.sleep(20);
		  }
		  
		  System.out.println("stopping");
		  server.stopServer();
	  } catch (Throwable e) {
		  e.printStackTrace();
	  }
  }
  
  
  class SimpleServerInvocationHandler implements ServerInvocationHandler
  {
	  int counter;
	  
     InvokerCallbackHandler handler;
    
     public void addListener(InvokerCallbackHandler callbackHandler)
     {
        this.handler = callbackHandler;
     }

     public Object invoke(InvocationRequest invocation) throws Throwable
     {
    	 counter++;
        return "Sausages";
     }

     public void removeListener(InvokerCallbackHandler callbackHandler)
     {
     }

     public void setInvoker(ServerInvoker invoker)
     {
     }

     public void setMBeanServer(MBeanServer server)
     {
     }
     
     public int getCounter()
     {
    	 return counter;
     }
  }
  
}



