package com.ibm.bsf.util;

import com.ibm.bsf.util.event.*;
import com.ibm.bsf.*;
import java.io.PrintStream;

/**
 * This is used to support binding scripts to be run when an event
 * occurs. 
 *
 * @author Sanjiva Weerawarana
 */
public class BSFEventProcessor implements EventProcessor {
  BSFEngine engine;
  BSFManager manager;
  String filter;
  String source;
  int lineNo;
  int columnNo;
  Object script;

  /**
   * Package-protected constructor makes this class unavailable for
   * public use.
   */
  BSFEventProcessor (BSFEngine engine, BSFManager manager, String filter,
		     String source, int lineNo, int columnNo, Object script)
       throws BSFException {
    this.engine = engine;
    this.manager = manager;
    this.filter = filter;
    this.source = source;
    this.lineNo = lineNo;
    this.columnNo = columnNo;
    this.script = script;
  }
  
  //////////////////////////////////////////////////////////////////////////
  //
  // event is delegated to me by the adapters using this. inFilter is
  // in general the name of the method via which the event was received
  // at the adapter. For prop/veto change events, inFilter is the name
  // of the property. In any case, in the event processor, I only forward
  // those events if for which the filters match (if one is specified).

  public void processEvent (String inFilter, Object[] evtInfo) {
    try {
      processExceptionableEvent (inFilter, evtInfo);
    } catch (RuntimeException re) {
      // rethrow this .. I don't want to intercept run-time stuff 
      // that can in fact occur legit
      throw re;
    } catch (Exception e) {
      // should not occur
      System.err.println ("BSFError: non-exceptionable event delivery " +
			  "threw exception (that's not nice): " + e);
      e.printStackTrace ();
    }
  }


  //////////////////////////////////////////////////////////////////////////
  //
  // same as above, but used when the method event method may generate
  // an exception which must go all the way back to the source (as in
  // the vetoableChange case)

  public void processExceptionableEvent (String inFilter, Object[] evtInfo) 
                                                         throws Exception {
    if ((filter != null) && !filter.equals (inFilter)) {
      // ignore this event
      return;
    }

    // run the script
    engine.exec (source, lineNo, columnNo, script);
  }
}
