package org.biojava.utils.bytecode;

import java.util.*;

/**
 * A CodeGenerator that just marks a label that can be used for jumps.
 *
 * @author Matthew Pocock
 */

public class MarkLabel implements CodeGenerator {
  private final Label label;
  
  public MarkLabel(Label label) {
    this.label = label;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.markLabel(label);
  }
  
  public int stackDepth() {
    return 0;
  }
  
  public int stackDelta() {
    return 0;
  }
}

