package org.biojava.utils.bytecode;

/**
 * Encapsulate a refererence to a Label which has not been resolved.
 *
 * @author Thomas Down
 */

class BranchFixup implements OutstandingReference {
    private final Label label;
    private final int branchSource;
    private final ParentContext cc;

    public BranchFixup(Label l, int bs, ParentContext cc) {
	this.label = l;
	this.branchSource = bs;
	this.cc = cc;
    }

    public Label getLabel() {
	return label;
    }

    public void resolve(int offset) throws CodeException {
	cc.writeShortAt(branchSource, offset - branchSource + 1);
    }
}
