
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.lookandfeel;

/**
 * Represents an object that can change the swing look and feel to a
 * given look and feel.
 */
public interface LookAndFeelSetter {
    /**
     * Changes the swing look and feel to the given look and feel.
     * It is assumed that no action at all has already been taken to set
     * the look and feel.
     * <p>
     * This routine will generally call
     * <tt>lookAndFeel.setLookAndFeel()</tt> as well as
     * <tt>lookAndFeel.updateLookAndFeel()</tt> for each top-level
     * container.
     *
     * @param lookAndFeel the look and feel to change to.
     * @return <tt>true</tt> if and only if the change to the new look
     * and feel was successful.
     */
    public boolean setLookAndFeel(LookAndFeelItem lookAndFeel);
}

