<?php
/**
*
* common.php [Norwegian Bokmaal]
*
* @package language
* @version $Id: $
* @copyright (c) 2008 phpBB Group
* @author 2008-01-20 - phpBB.no
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'TOPIC_LOCKED_SHORT'	=> 'Emnet er låst',
	'LOGIN_EXPLAIN_VIEWONLINE'	=> 'For å kunne se hvem som er pålogget i forumet, er du selv nødt til å være registrert og innlogget.',
	'TOO_LONG_DATEFORMAT'	=> 'Datoformatet du har skrevet inn er for langt.',
	'TOO_SHORT_DATEFORMAT'	=> 'Datoformatet du har skrevet inn er for kort.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Du abonnerer ikke lenger på de valgte emnene.',
	'WROTE'	=> 'skrev',
	'NEXT_STEP'	=> 'Neste',
	'PREVIOUS_STEP'	=> 'Forrige',
	'SEND_EMAIL_USER'	=> 'E-post',
	'SELECT_ALL_CODE'	=> 'Merk alt',
	'ACCOUNT_DEACTIVATED'	=> 'Brukerkontoen din er blitt deaktivert manuelt, og kan kun åpnes av en administrator.',
	'ATTACHED_IMAGE_NOT_IMAGE'	=> 'Filen du prøvde å legge ved er ikke en gyldig bildefil.',
	'AVATAR_EMPTY_FILEUPLOAD'	=> 'Filen du lastet opp som avatar er tom.',
	'COLLAPSE_VIEW'	=> 'Skjul visning',
	'DOWNLOAD_COUNT_NONE'	=> 'Ikke lastet ned ennå',
	'VIEWED_COUNT'	=> 'Vist %d gang',
	'VIEWED_COUNTS'	=> 'Vist %d ganger',
	'VIEWED_COUNT_NONE'	=> 'Ikke vist ennå',
	'EMPTY_MESSAGE_SUBJECT'	=> 'Du må skrive inn et emne når du skriver en ny melding.',
	'GENERAL_ERROR'	=> 'Generell feil',
	'GB'                  => 'GB',
	'GIB'                  => 'GiB',
	'LOGIN_ERROR_PASSWORD_CONVERT'	=> 'Grunnet en oppdatering av forumsystemet denne siden bruker måtte passordet ditt krypteres til en ny og sikrere form. En feil skjedde under denne prosessen. Vennligst %sbe om et nytt passord via e-post%s. Hvis dette ikke hjelper, %skontakt en forumadministrator%s.',
	'MERGE'	=> 'Slå sammen',
	'MERGE_POSTS'	=> 'Slå sammen innlegg',
	'NOT_AUTHORISED'	=> 'Du har ikke tilgang til dette området.',
	'NOTIFY_ADMIN'	=> 'Vennligst gi beskjed til en forumadministrator eller webansvarlig.',
	'NOTIFY_ADMIN_EMAIL'	=> 'Vennligst gi beskjed til en forumadministrator eller webansvarlig: <a href="mailto:%1$s">%1$s</a>',
	'NO_SUBJECT'	=> 'Intet emne er spesifisert',
	'POST_REPLY'	=> 'Skriv et svar',
	'POST_TOPIC'	=> 'Legg inn et nytt emne',
	'VARIANT_DATE_SEPARATOR'	=> ' / ',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'TRANSLATION_INFO'	=> '<a href="http://phpbb.no">phpBB.no</a> - Norsk phpBB-support',
	'USER_LANG'	=> 'no-nb',
	'AGE'	=> 'Alder',
	'AIM'	=> 'AIM',
	'AUTH_NO_PROFILE_CREATED'	=> 'Feil under opprettelse av brukerprofil',
	'BAN_TRIGGERED_BY_EMAIL'	=> 'Utestengelsen gjelder din e-postadresse.',
	'BAN_TRIGGERED_BY_IP'	=> 'Utestengelsen gjelder din IP-adresse.',
	'BAN_TRIGGERED_BY_USER'	=> 'Utestengelsen gjelder ditt brukernavn.',
	'BOARD_DISABLED'	=> 'Tilgangen til forumet er for tiden sperret.',
	'CHANGE_FONT_SIZE'	=> 'Endre skriftstørrelsen',
	'CHANGING_PREFERENCES'	=> 'Endrer forumpreferanser',
	'CHANGING_PROFILE'	=> 'Endrer profilinnstillinger',
	'COMMA_SEPARATOR'	=> ', ',
	'CONFIRM_OPERATION'	=> 'Er du sikker på at du vil utføre denne operasjonen?',
	'ERR_WRONG_PATH_TO_PHPBB'	=> 'Den angitte stien til phpBB ser ut til å være feil.',
	'EXPAND_VIEW'	=> 'Utvid visningen',
	'FILEDATE'	=> 'Fildato',
	'FSOCK_DISABLED'	=> 'Operasjonen feilet fordi fsock-funksjonene har blitt deaktivert, eller fordi serveren som skulle behandle spørringene ikke ble funnet.',
	'ICQ'	=> 'ICQ',
	'IMAGE_FILETYPE_INVALID'	=> 'Bildefiltypen %d for mimetypen %s er ikke støttet.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Ikke samsvar i bildefiltypen: Forventet %1$, men utvidelsen %2$ ble gitt.',
	'IP_BLACKLISTED'	=> 'Din IP %1$s har blitt blokkert fordi den er svartelistet. For flere detaljer, se <a href="%2$s">%2$s</a>.',
	'JABBER'	=> 'Jabber',
	'LAST_VISIT'	=> 'Siste besøk',
	'LDAP_NO_LDAP_EXTENSION'	=> 'LDAP-utvidelsen er ikke tilgjengelig.',
	'LDAP_NO_SERVER_CONNECTION'	=> 'Kunne ikke koble til LDAP-serveren.',
	'MSNM'	=> 'MSNM/WLM',
	'NEVER'	=> 'Aldri',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Du har ikke tillatelse til å administrere denne gruppen fra administrasjonspanelet.',
	'NO_ACTION'	=> 'Ingen handling er spesifisert.',
	'NO_ADMINISTRATORS'	=> 'Det er ikke satt opp noen administratorer på dette forumet.',
	'NO_IPS_DEFINED'	=> 'Ingen adresser er spesifisert.',
	'NO_MODE'	=> 'Ingen modus er spesifisert.',
	'NO_MODERATORS'	=> 'Det er ikke satt opp noen moderatorer på dette forumet.',
	'NO_ONLINE_USERS'	=> 'Ingen registrerte brukere',
	'NO_POSTS_TIME_FRAME'	=> 'Det finnes ingen innlegg i dette emnet for det valgte tidsrommet.',
	'NO_TOPICS_TIME_FRAME'	=> 'Det finnes ingen emner i dette forumet for det valgte tidsrommet.',
	'NO_UPLOAD_FORM_FOUND'	=> 'Opplastning iverksatt, men ingen gyldig filopplastningsform funnet.',
	'NO_USER_SPECIFIED'	=> 'Ingen brukernavn spesifisert',
	'PLAY_QUICKTIME_FILE'	=> 'Spill Quicktime-fil',
	'POSTING_PRIVATE_MESSAGE'	=> 'Skriver en personlig melding',
	'POSTED_IN_FORUM'	=> 'i',
	'POSTED_ON_DATE'	=> '',
	'POST_BY_AUTHOR'	=> '',
	'POST_PCT_ACTIVE'	=> '%.2f%% av brukerens poster',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% av dine poster',
	'READING_LINK'	=> 'Følger forumlinken %s',
	'REDIRECT'	=> 'Videresend',
	'SEARCH_MINI'	=> 'Søk…',
	'SEARCH_FORUM'	=> 'Søk i dette forumet',
	'SEARCH_POSTS_BY'	=> 'Søk etter poster av',
	'SEARCH_TOPIC'	=> 'Søk i dette emnet…',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Du har ikke rettighetene som er nødvendige for å laste ned dette vedlegget.',
	'TRACKED_PHP_ERROR'	=> 'Loggede PHP-feil: %s',
	'UNABLE_GET_IMAGE_SIZE'	=> 'Kunne ikke få tilgang til bildet, muligens fordi filen ikke en gyldig bildefil.',
	'UNABLE_TO_DELIVER_FILE'	=> 'Kunne ikke levere filen.',
	'USER_AVATAR'	=> 'Brukerens avatar',
	'VIEWING_MCP'	=> 'Ser på moderatorkontrollpanelet',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Ser på personlige meldinger',
	'VIEWING_REGISTER'	=> 'Registrerer seg',
	'VIEW_TOPIC_GLOBAL'	=> 'Global annonsering:',
	'VISIT_WEBSITE'	=> 'Besøk nettside',
	'YIM'	=> 'YIM',
	'DIRECTION'	=> 'ltr',
	'DATE_FORMAT'	=> '|d M Y|',
	'1_DAY'	=> '1 <br />dag',
	'1_MONTH'	=> '1 måned',
	'1_YEAR'	=> '1 år',
	'2_WEEKS'	=> '2 uker',
	'3_MONTHS'	=> '3 måneder',
	'6_MONTHS'	=> '6 måneder',
	'7_DAYS'	=> '7 dager',
	'ACCOUNT_ALREADY_ACTIVATED'	=> 'Brukeren er allerede aktivert',
	'ACCOUNT_NOT_ACTIVATED'	=> 'Din konto er ennå ikke aktivert.',
	'ACP'	=> 'Administrasjonspanel',
	'ACTIVE'	=> 'aktiv',
	'ACTIVE_ERROR'	=> 'Du har valgt et inaktivt brukernavn. Aktiver brukeren og prøv igjen. Hvis problemet vedvarer, må du kontakte en administrator.',
	'ADMINISTRATOR'	=> 'Administrator',
	'ADMINISTRATORS'	=> 'Administratorer',
	'ALLOWED'	=> 'Tillatt',
	'ALL_FILES'	=> 'Alle filer',
	'ALL_FORUMS'	=> 'Alle forum',
	'ALL_MESSAGES'	=> 'Alle meldinger',
	'ALL_POSTS'	=> 'Alle innlegg',
	'ALL_TIMES'	=> 'Tidssone %1$s %2$s',
	'ALL_TOPICS'	=> 'Alle emner',
	'AND'	=> 'og',
	'ARE_WATCHING_FORUM'	=> 'Du abonnerer på dette forumet.',
	'ARE_WATCHING_TOPIC'	=> 'Du abonnerer på dette emnet.',
	'ASCENDING'	=> 'Stigende',
	'ATTACHMENTS'	=> 'Vedlegg',
	'AUTHOR'	=> 'Forfatter',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Filendelsen <strong>%s</strong> er ikke tillatt.',
	'AVATAR_EMPTY_REMOTE_DATA'	=> 'Avataren ble ikke lastet opp fordi den ser ut til å være ugyldig eller skadet.',
	'AVATAR_INVALID_FILENAME'	=> '<strong>%s</strong> er et ugyldig filnavn.',
	'AVATAR_NOT_UPLOADED'	=> 'Avataren kunne ikke lastes opp.',
	'AVATAR_NO_SIZE'	=> 'Fant ikke høyde og bredde på avataren. Du må skrive dem inn manuelt.',
	'AVATAR_PARTIAL_UPLOAD'	=> 'Filen du prøvde å laste opp ble kun delvis opplastet.',
	'AVATAR_PHP_SIZE_NA'	=> 'Avatarens filstørrelse er for stor. Kunne ikke fastslå maksimal tillatt størrelse fastsatt av PHP i php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'	=> 'Avatarens filstørrelse er for stor; maksimal filstørrelse er %d %2$s. Dette er fastsatt i php.ini, og kan ikke endres av phpBB.',
	'AVATAR_URL_INVALID'	=> 'Adressen du skrev inn er ugyldig.',
	'AVATAR_URL_NOT_FOUND'	=> 'Kan ikke finne filen du valgte.',
	'AVATAR_WRONG_FILESIZE'	=> 'Avatarens filstørrelse må være mellom 0 og %1d %2s.',
	'AVATAR_WRONG_SIZE'	=> 'Avataren må være minst %1$d piksler bred og %2$d piksler høy, og maksimalt %3$d piksler bred og %4$d piksler høy. Avataren du forsøker å bruke er &5$d piksler bred og %6$d piksler høy.',
	'BACK_TO_TOP'	=> 'Topp',
	'BACK_TO_PREV'	=> 'Tilbake til forrige side',
	'BBCODE_GUIDE'	=> 'BBkode-guide',
	'BCC'	=> 'BCC',
	'BIRTHDAYS'	=> 'Bursdager',
	'BOARD_BAN_PERM'	=> 'Du har blitt <strong>permanent</strong> utestengt fra dette forumet.<br /><br />%2$sKontakt forumets administrator%3$s for mer informasjon.',
	'BOARD_BAN_REASON'	=> 'Begrunnelse oppgitt for utestengelsen: <strong>%s</strong>',
	'BOARD_BAN_TIME'	=> 'Du er utestengt fra dette forumet inntill %1$s. <br /><br />%2$Kontakt sforumets administrator%3$s for mer informasjon.',
	'BOARD_DISABLE'	=> 'Dette forumet er midlertidig utilgjengelig.',
	'BOARD_UNAVAILABLE'	=> 'Dette forumet er midlertidig utilgjengelig, forsøk igjen senere.',
	'BROWSING_FORUM_GUEST'	=> 'Brukere som leser i dette forumet: %1$s og %2$d gjest',
	'BROWSING_FORUM_GUESTS'	=> 'Brukere som leser i dette forumet: %1$s og %2$d gjester',
	'BYTES'	=> 'Bytes',
	'CANCEL'	=> 'Avbryt',
	'CHANGE'	=> 'Endre',
	'CLICK_VIEW_PRIVMSG'	=> '%sReturner til innboksen%s',
	'CLOSE_WINDOW'	=> 'Lukk vindu',
	'COLOUR_SWATCH'	=> 'Fargevelger',
	'CONFIRM'	=> 'Bekreft',
	'CONFIRM_CODE'	=> 'Bekreftelseskode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Skriv inn koden eksakt slik du ser den på bildet. Om du bruker store eller små bokstaver spiller ingen rolle.',
	'CONFIRM_CODE_WRONG'	=> 'Bekreftelseskoden du skrev inn er feil.',
	'CONGRATULATIONS'	=> 'Gratulerer',
	'CONNECTION_FAILED'	=> 'Tilkobling mislyktes',
	'CONNECTION_SUCCESS'	=> 'Tilkoblingen var vellykket!',
	'COOKIES_DELETED'	=> 'Alle forumets informasjonskapsler er slettet.',
	'CURRENT_TIME'	=> 'Dato/klokkeslett: %s',
	'DAY'	=> 'dag',
	'DAYS'	=> 'dager',
	'DELETE'	=> 'Slett',
	'DELETE_ALL'	=> 'Slett alle',
	'DELETE_COOKIES'	=> 'Slett alle forumets informasjonskapsler',
	'DELETE_MARKED'	=> 'Slett markerte',
	'DELETE_POST'	=> 'Slett innlegg',
	'DELIMITER'	=> 'Separator',
	'DESCENDING'	=> 'Synkende',
	'DISABLED'	=> 'Slått av',
	'DISPLAY'	=> 'Vis',
	'DISPLAY_GUESTS'	=> 'Vis gjester',
	'DISPLAY_MESSAGES'	=> 'Vis meldinger fra forrige',
	'DISPLAY_POSTS'	=> 'Vis innlegg fra forrige',
	'DISPLAY_TOPICS'	=> 'Vis emner fra forrige',
	'DOWNLOADED'	=> 'Nedlastet',
	'DOWNLOADING_FILE'	=> 'Laster ned fil',
	'DOWNLOAD_COUNT'	=> '%d gang',
	'DOWNLOAD_COUNTS'	=> '%d ganger',
	'EDIT_POST'	=> 'Rediger innlegg',
	'EMAIL'	=> 'E-post', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'	=> 'E-postadresse',
	'EMAIL_SMTP_ERROR_RESPONSE'	=> 'Problemer oppstod ved sending av e-post på <strong>linje %s</strong>. Respons: %s',
	'EMPTY_SUBJECT'	=> 'Du må angi en emnetittel når du oppretter et nytt emne.',
	'ENABLED'	=> 'Slått på',
	'ENCLOSURE'	=> 'Bilag',
	'ERR_CHANGING_DIRECTORY'	=> 'Kunne ikke endre mappe.',
	'ERR_CONNECTING_SERVER'	=> 'Feil under tilkoblingen til serveren',
	'ERR_JAB_AUTH'	=> 'Kunne ikke autorisere på Jabber-server.',
	'ERR_JAB_CONNECT'	=> 'Kunne ikke koble til Jabber-server.',
	'ERR_UNABLE_TO_LOGIN'	=> 'Kunne ikke logge inn. Brukernavnet eller passordet er feil.',
	'EXTENSION'	=> 'Filtype',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Filtypen <strong>%s</strong> har blitt deaktivert, og kan derfor ikke lenger vises.',
	'FAQ'	=> 'Hjelp',
	'FAQ_EXPLAIN'	=> 'Spørsmål og svar',
	'FILENAME'	=> 'Filnavn',
	'FILESIZE'	=> 'Filstørrelse',
	'FILE_COMMENT'	=> 'Filkommentar',
	'FILE_NOT_FOUND'	=> 'Den forepurte filen finnes ikke',
	'FIND_USERNAME'	=> 'Finn et medlem',
	'FOLDER'	=> 'Mappe',
	'FORGOT_PASS'	=> 'Jeg har glemt passordet',
	'FORM_INVALID'	=> 'Den innsendte formular var ugyldig. Prøv igjen.',
	'FORUM'	=> 'Forum',
	'FORUMS'	=> 'Forum',
	'FORUMS_MARKED'	=> 'Alle forumene har blitt markert som lest',
	'FORUM_CAT'	=> 'Forumkategori',
	'FORUM_INDEX'	=> 'Forumets hovedside',
	'FORUM_LINK'	=> 'Forumlink',
	'FORUM_LOCATION'	=> 'Forumplassering',
	'FORUM_LOCKED'	=> 'Forumet er stengt',
	'FORUM_RULES'	=> 'Forumregler',
	'FORUM_RULES_LINK'	=> 'Forumets regler',
	'FROM'	=> 'fra',
	'FTP_FSOCK_HOST'	=> 'FTP-adresse',
	'FTP_FSOCK_HOST_EXPLAIN'	=> 'FTP-adressen som brukes til tilkobling til serveren',
	'FTP_FSOCK_PASSWORD'	=> 'FTP-passord',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'FTP-brukernavnets passord',
	'FTP_FSOCK_PORT'	=> 'FTP-port',
	'FTP_FSOCK_PORT_EXPLAIN'	=> 'Porten som brukes til tilkobling til serveren',
	'FTP_FSOCK_ROOT_PATH'	=> 'Sti til phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Stien fra toppen av mappestrukturen til phpBB-forumet',
	'FTP_FSOCK_TIMEOUT'	=> 'FTP-tidsavbrudd',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'	=> 'Antall sekunder systemet vil vente på respons fra serveren',
	'FTP_FSOCK_USERNAME'	=> 'FTP brukernavn',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Brukernavnet som brukes til tilkobling til serveren',
	'FTP_HOST'	=> 'FTP-adresse',
	'FTP_HOST_EXPLAIN'	=> 'FTP-adressen som brukes til tilkobling til siden',
	'FTP_PASSWORD'	=> 'FTP-passord',
	'FTP_PASSWORD_EXPLAIN'	=> 'FTP-brukernavnets passord',
	'FTP_PORT'	=> 'FTP-port',
	'FTP_PORT_EXPLAIN'	=> 'Porten som brukes til tilkobling til serveren',
	'FTP_ROOT_PATH'	=> 'Sti til phpBB',
	'FTP_ROOT_PATH_EXPLAIN'	=> 'Stien fra toppen av mappestrukturen til phpBB-forumet',
	'FTP_TIMEOUT'	=> 'FTP-tidsavbrudd',
	'FTP_TIMEOUT_EXPLAIN'	=> 'Antall sekunder systemet vil vente på svar fra din server',
	'FTP_USERNAME'	=> 'FTP-brukernavn',
	'FTP_USERNAME_EXPLAIN'	=> 'Brukernavnet som brukes for å koble seg til din server',
	'GO'	=> 'OK',
	'GOTO_PAGE'	=> 'Gå til side',
	'GROUP'	=> 'Gruppe',
	'GROUPS'	=> 'Grupper',
	'GROUP_ERR_TYPE'	=> 'Valgt gruppetype kan ikke brukes i dette tilfellet.',
	'GROUP_ERR_USERNAME'	=> 'Du har ikke oppgitt noe gruppenavn.',
	'GROUP_ERR_USER_LONG'	=> 'Gruppenavnet er for langt',
	'GUEST'	=> 'Gjest',
	'GUEST_USERS_ONLINE'	=> 'Det er %d gjester pålogget',
	'GUEST_USERS_TOTAL'	=> '%d gjester',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Det er ingen gjester pålogget',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 gjester',
	'GUEST_USER_ONLINE'	=> 'Det er %d gjest pålogget',
	'GUEST_USER_TOTAL'	=> '%d gjest',
	'G_ADMINISTRATORS'	=> 'Administratorer',
	'G_BOTS'	=> 'Søkeroboter',
	'G_GUESTS'	=> 'Gjester',
	'G_REGISTERED'	=> 'Registrerte brukere',
	'G_REGISTERED_COPPA'	=> 'Registrerte COPPA-brukere',
	'G_GLOBAL_MODERATORS'	=> 'Globale moderatorer',
	'HIDDEN_USERS_ONLINE'	=> '%d skjulte brukere pålogget',
	'HIDDEN_USERS_TOTAL'	=> '%d skjulte og ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> 'ingen skjulte brukere pålogget',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 skjulte og ',
	'HIDDEN_USER_ONLINE'	=> '%d skjult bruker pålogget',
	'HIDDEN_USER_TOTAL'	=> '%d skjult og ',
	'HIDE_GUESTS'	=> 'Skjul gjester',
	'HIDE_ME'	=> 'Ikke vis vanlige brukere at jeg er pålogget',
	'HOURS'	=> 'Timer',
	'HOME'	=> 'Hjem',
	'ICQ_STATUS'	=> 'ICQ-status',
	'IF'	=> 'hvis',
	'IMAGE'	=> 'Bilde',
	'IN'	=> 'i',
	'INDEX'	=> 'Hovedside',
	'INFORMATION'	=> 'Informasjon',
	'INTERESTS'	=> 'Interesser',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ugyldig overvåkningsbestilling',
	'INVALID_EMAIL_LOG'	=> 'Kan <strong>%s</strong> være en ugyldig e-postadresse?',
	'IP'	=> 'IP',
	'JOINED'	=> 'Registrert',
	'JUMP_PAGE'	=> 'Skriv inn sidenummeret du vil gå til',
	'JUMP_TO'	=> 'Gå til forum',
	'JUMP_TO_PAGE'	=> 'Klikk for å hoppe til side…',
	'KB'	=> 'KB',
	'LAST_POST'	=> 'Siste innlegg',
	'LAST_UPDATED'	=> 'Sist oppdatert',
	'LEGEND'	=> 'Fargeforklaring',
	'LOCATION'	=> 'Bosted',
	'LOCK_POST'	=> 'Lås innlegg',
	'LOCK_POST_EXPLAIN'	=> 'Forhindre redigering',
	'LOCK_TOPIC'	=> 'Lås emne',
	'LOGIN'	=> 'Logg inn',
	'LOGIN_CHECK_PM'	=> 'Logg inn for å sjekke dine private meldinger',
	'LOGIN_CONFIRMATION'	=> 'Bekreftelse på innlogging',
	'LOGIN_CONFIRM_EXPLAIN'	=> 'For å forhindre at noen kan forsøke å knekke passordet ved hjelp av gjentatte innloggingsforsøk, kreves det at du i tillegg til brukernavn og passord også skriver inn bekreftelseskoden du kan se i bildet nedenfor. Dette forsikrer oss om at du er et menneske og ikke et dataprogram. Hvis du av en eller annen grunn ikke skulle greie å tyde koden, kan du %sta kontakt med forumets administrator%s.',
	'LOGIN_ERROR_ATTEMPTS'	=> 'For å forhindre at noen kan forsøke å knekke passordet ved hjelp av gjentatte innloggingsforsøk, kreves det etter et visst antall feilaktige innloggingsforsøk at du i tillegg til brukernavn og passord også skriver inn bekreftelseskoden du kan se i bildet nedenfor. Dette forsikrer oss om at du er et menneske og ikke et dataprogram.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Du har ikke blitt godkjent av Apache.',
	'LOGIN_ERROR_PASSWORD'	=> 'Du har skrevet inn feil passord. Vennligst undersøk passordet og prøv igjen. Hvis problemet vedvarer, kan du %sta kontakt med forumets administrator%s.',
	'LOGIN_ERROR_USERNAME'	=> 'Du har skrevet inn feil brukernavn. Vennligst undersøk brukernavnet og prøv igjen. Hvis problemer vedvarer, kan du %sta kontakt med forumets administrator%s.',
	'LOGIN_FORUM'	=> 'For å lese og skrive i dette forumet, må du skrive inn forumets passord.',
	'LOGIN_INFO'	=> 'For å kunne logge deg inn, må du være registrert. Registrering tar kun noen få minutter, og gir deg økte muligheter i forumet. I tillegg kan forumets administrator gi registrerte brukere utvidede rettigheter. Før du logger inn, må du forsikre deg om at du har satt deg inn i forumets bruksbetingelser og regler. Sørg også for å lese spesielle regler for ulike deler av forumet (om disse eksisterer) før du tar forumet i bruk.',
	'LOGIN_VIEWFORUM'	=> 'Du må være innlogget for å ha tilgang til dette forumet.',
	'LOGIN_EXPLAIN_EDIT'	=> 'For å kunne redigere innlegg i dette forumet, må du være registrert og innlogget.',
	'LOGOUT'	=> 'Logg ut',
	'LOGOUT_USER'	=> 'Logg ut (%s)',
	'LOG_ME_IN'	=> 'Logg meg på automatisk hver gang',
	'MARK'	=> 'Marker',
	'MARK_ALL'	=> 'Marker alle',
	'MARK_FORUMS_READ'	=> 'Marker forumene som lest',
	'MB'	=> 'MB',
	'MCP'	=> 'Moderatorkontrollpanel',
	'MEMBERLIST'	=> 'Medlemmer',
	'MEMBERLIST_EXPLAIN'	=> 'Se komplett liste over alle forumets medlemmer',
	'MERGE_TOPIC'	=> 'Slå sammen emner',
	'MESSAGE'	=> 'Melding',
	'MESSAGES'	=> 'Meldinger',
	'MESSAGE_BODY'	=> 'Meldingskropp',
	'MINUTES'	=> 'Minutter',
	'MODERATE'	=> 'Moderer',
	'MODERATOR'	=> 'Moderator',
	'MODERATORS'	=> 'Moderatorer',
	'MONTH'	=> 'Måned',
	'MOVE'	=> 'Flytt',
	'NA'	=> '--',
	'NEWEST_USER'	=> 'Forumets nyeste medlem: <strong>%s</strong>',
	'NEW_MESSAGE'	=> 'Ny melding',
	'NEW_MESSAGES'	=> 'Nye meldinger',
	'NEW_PM'	=> '<strong>%d</strong> ny melding',
	'NEW_PMS'	=> '<strong>%d</strong> nye meldinger',
	'NEW_POST'	=> 'Nytt innlegg',
	'NEW_POSTS'	=> 'Nye innlegg',
	'NEXT'	=> 'Neste',
	'NO'	=> 'Nei',
	'NOT_WATCHING_FORUM'	=> 'Du abonnerer ikke lenger på dette forumet.',
	'NOT_WATCHING_TOPIC'	=> 'Du abonnerer ikke lenger på dette emnet.',
	'NO_ACCESS_ATTACHMENT'	=> 'Du har ikke tilgang til denne filen.',
	'NO_AUTH_ADMIN'	=> 'Du har ikke administratorrettigheter, og har derfor ikke adgang til administrasjonspanelet.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Du må bruke dine egne innloggingsdetaljer når du skal bekrefte innloggingen til administrasjonspanelet.',
	'NO_AUTH_OPERATION'	=> 'Du har ikke rettighetene som er påkrevd for å fullføre denne handlingen.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Kunne ikke koble til SMTP-serveren: %s: %s',
	'NO_BIRTHDAYS'	=> 'Ingen av forumets medlemmer har bursdag i dag',
	'NO_EMAIL_MESSAGE'	=> 'Du har ikke skrevet noen e-post',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Kunne ikke motta e-postserverens responskoder',
	'NO_EMAIL_SUBJECT'	=> 'Du har ikke oppgitt noe emne',
	'NO_FORUM'	=> 'Forumet eksisterer ikke.',
	'NO_FORUMS'	=> 'Inneholder ingen forum.',
	'NO_GROUP'	=> 'Brukergruppen eksisterer ikke.',
	'NO_GROUP_MEMBERS'	=> 'Denne gruppen har ingen medlemmer.',
	'NO_MEMBERS'	=> 'Ingen medlemmer ble funnet for dette søkekriteriet.',
	'NO_MESSAGES'	=> 'Ingen meldinger',
	'NO_NEW_MESSAGES'	=> 'Ingen nye meldinger',
	'NO_NEW_PM'	=> '<strong>0</strong> nye meldinger',
	'NO_NEW_POSTS'	=> 'Ingen nye innlegg',
	'NO_POSTS'	=> 'Ingen innlegg',
	'NO_SUCH_SEARCH_MODULE'	=> 'Det spesifiserte søkesystemet eksisterer ikke.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Ingen støttede godkjenningsmetoder.',
	'NO_TOPIC'	=> 'Emnet du forsøker å nå eksisterer ikke.',
	'NO_TOPIC_FORUM'	=> 'Emnet eller forumet eksisterer ike lenger.',
	'NO_TOPICS'	=> 'Det er ingen emner eller innlegg i dette forumet.',
	'NO_UNREAD_PM'	=> '<strong>0</strong> uleste meldinger',
	'NO_USER'	=> 'Den forespurte brukeren eksisterer ikke.',
	'NO_USERS'	=> 'De forespurte brukerne eksisterer ikke.',
	'OCCUPATION'	=> 'Yrke',
	'OFFLINE'	=> 'Avlogget',
	'ONLINE'	=> 'Pålogget',
	'ONLINE_BUDDIES'	=> 'Påloggede venner',
	'ONLINE_USERS_TOTAL'	=> 'Det er totalt <strong>%d</strong> brukere pålogget: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Det er <strong>0</strong> brukere pålogget: ',
	'ONLINE_USER_TOTAL'	=> 'Det er <strong>%d</strong> bruker i forumet: ',
	'OPTIONS'	=> 'Valg',
	'PAGE_OF'	=> 'Side <strong>%1$d</strong> av <strong>%2$d</strong>',
	'PASSWORD'	=> 'Passord',
	'PIXEL'					=> 'px',
	'PM'	=> 'PM',
	'POSTING_MESSAGE'	=> 'Skriver et innlegg i %s',
	'POST'	=> 'Innlegg',
	'POST_ANNOUNCEMENT'	=> 'Annonsering',
	'POST_STICKY'	=> 'Prioritet',
	'POSTED'	=> 'Skrevet',
	'POSTS'	=> 'Innlegg',
	'POSTS_UNAPPROVED'	=> 'Minst ett innlegg i dette emnet er ikke godkjent ennå',
	'POST_BY_FOE'	=> 'Dette innlegget er skrevet av <strong>%1$s</strong>, som er i din ignoreringsliste, og er derfor skjult. %2$sVis innlegg%3$s.',
	'POST_DAY'	=> '%.2f innlegg per dag',
	'POST_DETAILS'	=> 'Innleggsdetaljer',
	'POST_NEW_TOPIC'	=> 'Opprett et nytt emne',
	'POST_PCT'	=> '%.2f%% av alle brukere',
	'POST_REPORTED'	=> 'Les rapporten',
	'POST_SUBJECT'	=> 'Innleggets emne',
	'POST_TIME'	=> 'Dato skrevet',
	'POST_UNAPPROVED'	=> 'Dette innlegget venter på godkjenning',
	'PREVIEW'	=> 'Forhåndsvis',
	'PREVIOUS'	=> 'Forrige',
	'PRIVACY'	=> 'Personvern',
	'PRIVATE_MESSAGE'	=> 'Privat melding',
	'PRIVATE_MESSAGES'	=> 'Private meldinger',
	'PRIVATE_MESSAGING'	=> 'Privat melding-tjenesten',
	'PROFILE'	=> 'Brukerkontrollpanel',
	'READING_FORUM'	=> 'Leser i %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Leser global annonsering',
	'READING_TOPIC'	=> 'Leser et emne i %s',
	'READ_PROFILE'	=> 'Profil',
	'REASON'	=> 'Begrunnelse',
	'RECORD_ONLINE_USERS'	=> 'Høyest antall samtidige brukere på forumet var <strong>%1$s</strong>. Dette skjedde %2$s',
	'REDIRECTS'	=> 'Antall videresendelser',
	'REGISTER'	=> 'Registrer deg',
	'REGISTERED_USERS'	=> 'Registrerte brukere:',
	'REG_USERS_ONLINE'	=> 'Det er %d registrerte brukere og ',
	'REG_USERS_TOTAL'	=> '%d registrerte, ',
	'REG_USERS_ZERO_ONLINE'	=> 'Det er 0 registrerte brukere og ',
	'REG_USERS_ZERO_TOTAL'	=> '0 registrerte, ',
	'REG_USER_ONLINE'	=> 'Det er %d registrert bruker og ',
	'REG_USER_TOTAL'	=> '%d registrert, ',
	'REMOVE'	=> 'Fjern',
	'REMOVE_INSTALL'	=> 'Vennligst slett, flytt eller endre navn på installasjonsmappen (<strong>install/</strong>).',
	'REPLIES'	=> 'Svar',
	'REPLY_WITH_QUOTE'	=> 'Svar med sitat',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Skriver et innlegg i en global annonsering',
	'REPLYING_MESSAGE'	=> 'Skriver et innlegg i %s',
	'REPORT_BY'	=> 'Rapportert av',
	'REPORT_POST'	=> 'Rapporter dette innlegget',
	'REPORTING_POST'	=> 'Rapporterer et innlegg',
	'RESEND_ACTIVATION'	=> 'Send aktiveringse-posten på nytt',
	'RESET'	=> 'Nullstill',
	'RESTORE_PERMISSIONS'	=> 'Gjennopprett rettigheter',
	'RETURN_INDEX'	=> '%sGå til hovedsiden%s',
	'RETURN_FORUM'	=> '%sGå til det sist besøkte forumet%s',
	'RETURN_PAGE'	=> '%sGå til forrige side%s',
	'RETURN_TOPIC'	=> '%sGå til det sist besøkte emnet%s',
	'RETURN_TO'	=> 'Gå til',
	'RULES_ATTACH_CAN'	=> 'Du <strong>kan</strong> laste opp vedlegg til dette forumet',
	'RULES_ATTACH_CANNOT'	=> 'Du <strong>kan ikke</strong> laste opp vedlegg til dette forumet',
	'RULES_DELETE_CAN'	=> 'Du <strong>kan</strong> slette dine egne innlegg i dette forumet',
	'RULES_DELETE_CANNOT'	=> 'Du <strong>kan ikke</strong> slette dine egne innlegg i dette forumet',
	'RULES_DOWNLOAD_CAN'	=> 'Du <strong>kan</strong> laste ned vedlegg fra dette forumet',
	'RULES_DOWNLOAD_CANNOT'	=> 'Du <strong>kan ikke</strong> laste ned vedlegg fra dette forumet',
	'RULES_EDIT_CAN'	=> 'Du <strong>kan</strong> redigere dine egne innlegg i dette forumet',
	'RULES_EDIT_CANNOT'	=> 'Du <strong>kan ikke</strong> redigere dine egne innlegg i dette forumet',
	'RULES_LOCK_CAN'	=> 'Du <strong>kan</strong> låse dine egne emner i dette forumet',
	'RULES_LOCK_CANNOT'	=> 'Du <strong>kan ikke</strong> låse dine egne emner i dette forumet',
	'RULES_POST_CAN'	=> 'Du <strong>kan</strong> opprette nye emner i dette forumet',
	'RULES_POST_CANNOT'	=> 'Du <strong>kan ikke</strong> opprette nye emner i dette forumet',
	'RULES_REPLY_CAN'	=> 'Du <strong>kan</strong> skrive innlegg i dette forumet',
	'RULES_REPLY_CANNOT'	=> 'Du <strong>kan ikke</strong> skrive innlegg i dette forumet',
	'RULES_VOTE_CAN'	=> 'Du <strong>kan</strong> stemme i dette forumet',
	'RULES_VOTE_CANNOT'	=> 'Du <strong>kan ikke</strong> stemme i dette forumet',
	'SEARCH'	=> 'Søk',
	'SEARCH_ADV'	=> 'Avansert søk',
	'SEARCH_ADV_EXPLAIN'	=> 'Se de avanserte søkevalgene',
	'SEARCH_KEYWORDS'	=> 'Søk etter nøkkelord',
	'SEARCHING_FORUMS'	=> 'Søker i forumene',
	'SEARCH_ACTIVE_TOPICS'	=> 'Se aktive emner',
	'SEARCH_FOR'	=> 'Søk etter',
	'SEARCH_NEW'	=> 'Se nye innlegg',
	'SEARCH_SELF'	=> 'Se dine innlegg',
	'SEARCH_UNANSWERED'	=> 'Se ubesvarte emner',
	'SECONDS'	=> 'Sekunder',
	'SELECT'	=> 'Velg',
	'SELECT_DESTINATION_FORUM'	=> 'Velg destinasjonsforum',
	'SELECT_FORUM'	=> 'Velg et forum',
	'SEND_EMAIL'	=> 'Send en e-post',            // Used for submit buttons
	'SEND_PRIVATE_MESSAGE'	=> 'Send en privat melding',
	'SETTINGS'	=> 'Innstillinger',
	'SIGNATURE'	=> 'Signatur',
	'SKIP'	=> 'Hopp til innhold',
	'SMTP_NO_AUTH_SUPPORT'	=> 'SMTP-serveren støtter ikke bekreftelse',
	'SORRY_AUTH_READ'	=> 'Du har ikke de nødvendige rettigheter for å lese i dette forumet',
	'SORT_BY'	=> 'Sorter etter',
	'SORT_JOINED'	=> 'Registrert',
	'SORT_LOCATION'	=> 'Bosted',
	'SORT_RANK'	=> 'Rang',
	'SORT_TOPIC_TITLE'	=> 'Emnetittel',
	'SORT_USERNAME'	=> 'Brukernavn',
	'SPLIT_TOPIC'	=> 'Splitt emne',
	'SQL_ERROR_OCCURRED'	=> 'En databasefeil forekom under lastingen av siden. Vennligst %sta kontakt med forumets administrator%s hvis dette problemet vedvarer.',
	'STATISTICS'	=> 'Statistikk',
	'START_WATCHING_FORUM'	=> 'Abonner på forumet',
	'START_WATCHING_TOPIC'	=> 'Abonner på emnet',
	'STOP_WATCHING_FORUM'	=> 'Stopp abonnementet på forumet',
	'STOP_WATCHING_TOPIC'	=> 'Stopp abonnementet på emnet',
	'SUBFORUM'	=> 'Underforum',
	'SUBFORUMS'	=> 'Underforum',
	'SUBJECT'	=> 'Emne',
	'SUBMIT'	=> 'OK',
	'TERMS_USE'	=> 'Bruksbetingelser',
	'TEST_CONNECTION'	=> 'Test tilkobling',
	'THE_TEAM'	=> 'Forumledelse',
	'TIME'	=> 'Tid',
	'TOO_LONG_AIM'	=> 'AIM-navnet du skrev inn er for langt.',
	'TOO_LONG_CONFIRM_CODE'	=> 'Bekreftelseskoden du skrev inn er for lang.',
	'TOO_LONG_ICQ'	=> 'ICQ-navnet du skrev inn er for langt.',
	'TOO_LONG_INTERESTS'	=> 'Interesseinformasjonen du skrev inn er for lang.',
	'TOO_LONG_JABBER'	=> 'Jabber-brukernavnet du skrev inn er for langt.',
	'TOO_LONG_LOCATION'	=> 'Bostedet du skrev inn er for langt.',
	'TOO_LONG_MSN'	=> 'Windows Live ID-en du skrev inn er for lang.',
	'TOO_LONG_NEW_PASSWORD'	=> 'Passordet du skrev inn er for langt.',
	'TOO_LONG_OCCUPATION'	=> 'Yrket du skrev inn er for langt.',
	'TOO_LONG_PASSWORD_CONFIRM'	=> 'Passordbekreftelsen du skrev inn er for lang.',
	'TOO_LONG_USER_PASSWORD'	=> 'Passordet du skrev inn er for langt.',
	'TOO_LONG_USERNAME'	=> 'Brukernavnet du skrev inn er for langt.',
	'TOO_LONG_EMAIL'	=> 'E-postadressen du skrev inn er for lang.',
	'TOO_LONG_EMAIL_CONFIRM'	=> 'E-postadressebekreftelsen du skrev inn er for lang.',
	'TOO_LONG_WEBSITE'	=> 'Nettadressen du skrev inn er for lang.',
	'TOO_LONG_YIM'	=> 'Yahoo-brukernavnet du skrev inn er for langt.',
	'TOO_MANY_VOTE_OPTIONS'	=> 'Du har forsøkt å stemme på for mange valg.',
	'TOO_SHORT_AIM'	=> 'AIN-navnet du skrev inn er for kort.',
	'TOO_SHORT_CONFIRM_CODE'	=> 'Bekreftelseskoden du skrev inn er for kort.',
	'TOO_SHORT_ICQ'	=> 'ICQ-nummeret du skrev inn er for kort.',
	'TOO_SHORT_INTERESTS'	=> 'Interesseinformasjonen du skrev inn er for kort.',
	'TOO_SHORT_JABBER'	=> 'Jabber-brukernavnet ditt er for kort.',
	'TOO_SHORT_LOCATION'	=> 'Bostedet du skrev inn er for kort.',
	'TOO_SHORT_MSN'	=> 'MSN-brukernavnet du skrev inn er for kort.',
	'TOO_SHORT_NEW_PASSWORD'	=> 'Passordet du skrev inn er for kort.',
	'TOO_SHORT_OCCUPATION'	=> 'Yrket du skrev inn er for kort.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Passordbekreftelsen du skrev inn er for kort.',
	'TOO_SHORT_USER_PASSWORD'	=> 'Passordet du skrev inn er for kort.',
	'TOO_SHORT_USERNAME'	=> 'Brukernavnet du skrev inn er for kort.',
	'TOO_SHORT_EMAIL'	=> 'Epostadressen du skrev inn er for kort.',
	'TOO_SHORT_EMAIL_CONFIRM'	=> 'Epostadressebekreftelsen du skrev inn er for kort.',
	'TOO_SHORT_WEBSITE'	=> 'Nettadressen du skrev inn er for kort.',
	'TOO_SHORT_YIM'	=> 'Yahoo-brukernavnet du skrev inn er for kort.',
	'TOPIC'	=> 'Emne',
	'TOPICS'	=> 'Emner',
	'TOPIC_ICON'	=> 'Emneikon',
	'TOPIC_LOCKED'	=> 'Dette emnet er stengt; du kan ikke redigere eller legge inn nye innlegg.',
	'TOPIC_MOVED'	=> 'Flyttet emne',
	'TOPIC_REVIEW'	=> 'Emne',
	'TOPIC_TITLE'	=> 'Emnetittel',
	'TOPIC_UNAPPROVED'	=> 'Emnet har ennå ikke blitt godkjent.',
	'TOTAL_ATTACHMENTS'	=> 'Vedlegg',
	'TOTAL_LOG'	=> '1 logg',
	'TOTAL_LOGS'	=> '%d logger',
	'TOTAL_NO_PM'	=> '0 private meldinger totalt',
	'TOTAL_PM'	=> '1 privat melding totalt',
	'TOTAL_PMS'	=> '$d private meldinger totalt',
	'TOTAL_POSTS'	=> 'Antall innlegg',
	'TOTAL_POSTS_OTHER'	=> 'Antall innlegg: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Antall innlegg: <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Emnet er rapportert.',
	'TOTAL_TOPICS_OTHER'	=> 'Antall emner: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Antall emner: <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Antall medlemmer: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Antall medlemmer: <strong>0</strong>',
	'UNKNOWN_BROWSER'	=> 'Ukjent nettleser',
	'UNMARK_ALL'	=> 'Fjern alle markeringer',
	'UNREAD_MESSAGES'	=> 'Uleste meldinger',
	'UNREAD_PM'	=> '<strong>%d</strong> ulest melding',
	'UNREAD_PMS'	=> '<strong>%d</strong> uleste meldinger',
	'UNWATCHED_FORUMS'	=> 'Abonnementet på de valgte forumene er avbrutt.',
	'UNWATCHED_TOPICS'	=> 'Abonnementet på de valgte emnene er avbrutt.',
	'UPDATE'	=> 'Oppdater',
	'UPLOAD_IN_PROGRESS'	=> 'Opplastingen er i gang',
	'URL_REDIRECT'	=> 'Hvis nettleseren ikke støtter meta-videresending, kan du klikke %sher%s for å bli videresendt.',
	'USERGROUPS'	=> 'Grupper',
	'USERNAME'	=> 'Brukernavn',
	'USERNAMES'	=> 'Brukernavn',
	'USER_CANNOT_READ'	=> 'Du kan ikke lese innlegg i dette forumet',
	'USER_POST'	=> '%d innlegg',
	'USER_POSTS'	=> '%d innlegg',
	'USERS'	=> 'Brukere',
	'USE_PERMISSIONS'	=> 'Test ut brukernes rettigheter',
	'VIEWED'	=> 'Lest',
	'VIEWING_FAQ'	=> 'Leser hjelp',
	'VIEWING_MEMBERS'	=> 'Ser på medlemsdetaljer',
	'VIEWING_ONLINE'	=> 'Ser på listen over påloggede brukere',
	'VIEWING_MEMBER_PROFILE'	=> 'Ser på en medlemsprofil',
	'VIEWING_UCP'	=> 'Ser på brukerkontrollpanelet',
	'VIEWS'	=> 'Visninger',
	'VIEW_BOOKMARKS'	=> 'Se bokmerker',
	'VIEW_FORUM_LOGS'	=> 'Se logg',
	'VIEW_LATEST_POST'	=> 'Se siste innlegg',
	'VIEW_NEWEST_POST'	=> 'Se nyeste innlegg',
	'VIEW_NOTES'	=> 'Se brukernotater',
	'VIEW_ONLINE_TIME'	=> 'Denne informasjonen er basert på aktive brukere det siste minuttet.',
	'VIEW_ONLINE_TIMES'	=> 'Denne informasjonen er basert på aktive brukere de siste %d minuttene.',
	'VIEW_TOPIC'	=> 'Se emne',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annonsering: ',
	'VIEW_TOPIC_LOCKED'	=> 'Låst: ',
	'VIEW_TOPIC_LOGS'	=> 'Se på logger',
	'VIEW_TOPIC_MOVED'	=> 'Flyttet: ',
	'VIEW_TOPIC_POLL'	=> 'Avstemning: ',
	'VIEW_TOPIC_STICKY'	=> 'Prioritet: ',
	'WARNINGS'	=> 'Advarsler',
	'WARN_USER'	=> 'Advar brukeren',
	'WELCOME_SUBJECT'	=> 'Velkommen til %s',
	'WEBSITE'	=> 'Nettside',
	'WHOIS'	=> 'Whois',
	'WHO_IS_ONLINE'	=> 'Hvem er i forumet',
	'WRONG_PASSWORD'	=> 'Passordet er ikke gyldig.',
	'WRONG_DATA_ICQ'	=> 'ICQ-nummeret er ikke gyldig.',
	'WRONG_DATA_JABBER'	=> 'Jabber-brukernavnet er ikke gyldig.',
	'WRONG_DATA_LANG'	=> 'Språket du spesifiserte er ikke gyldig.',
	'WRONG_DATA_WEBSITE'	=> 'Nettadressen må være en gyldig URL, inkludert protokollen. Eksempel: http://www.example.com/',
	'YEAR'	=> 'år',
	'YES'	=> 'Ja',
	'YOU_LAST_VISIT'	=> 'Siste besøk var: %s',
	'YOU_NEW_PM'	=> 'En ny privat melding venter på deg i innboksen',
	'YOU_NEW_PMS'	=> 'Nye private meldinger venter på deg i innboksen',
	'YOU_NO_NEW_PM'	=> 'Ingen nye private meldinger',
	
	'AVATAR_DISALLOWED_CONTENT'		=> 'Opplastingen ble avbrutt fordi den opplastede filen var identifisert som en mulig angrepsvektor.',
	'BROWSING_FORUM'		=> 'Brukere som leser i dette forumet: %1$s',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d skjulte og ',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> 'ingen skjulte og ',
	'HIDDEN_USER_TOTAL_AND'			=> '%d skjult og ',
	'KIB'					=> 'KiB',
	'MIB'					=> 'MiB',
	'REG_USERS_TOTAL_AND'		=> '%d registrerte og ',
	'REG_USERS_ZERO_TOTAL_AND'	=> 'ingen registrerte og ',
	'REG_USER_TOTAL_AND'		=> '%d registrert og ',
	
	'G_NEWLY_REGISTERED'		=> 'Nylig registrerte brukere',
	'NO_FEED_ENABLED'			=> 'Feeder er ikke tilgjengelige i dette forumet.',
	'NO_FEED'					=> 'Den forespurte feeden er ikke tilgjengelig.',
	'SEARCH_UNREAD'				=> 'Vis uleste meldinger',
	'SORT_POSTS'				=> 'Innlegg',
	'TOPICS_UNAPPROVED'	=> 'Minst ett emne i dette forumet er ikke godkjent.',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Vi beklager, men du er ikke autorisert til å bruke denne funksjonen. Du har kanskje nettopp registrert deg og må kanskje delta mer for å kunne bruke denne funksjonen.',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Nyheter',
	'FEED_TOPICS_ACTIVE'		=> 'Aktive emner',
	'FEED_TOPICS_NEW'			=> 'Nye emner',

	'datetime'	=> array(
		'TODAY'	=> 'I dag',
		'TOMORROW'	=> 'I morgen',
		'YESTERDAY'	=> 'I går',
		'Sunday'	=> 'Søndag',
		'Monday'	=> 'Mandag',
		'Tuesday'	=> 'Tirsdag',
		'Wednesday'	=> 'Onsdag',
		'Thursday'	=> 'Torsdag',
		'Friday'	=> 'Fredag',
		'Saturday'	=> 'Lørdag',
		'Sun'	=> 'Søn',
		'Mon'	=> 'Man',
		'Tue'	=> 'Tir',
		'Wed'	=> 'Ons',
		'Thu'	=> 'Tor',
		'Fri'	=> 'Fre',
		'Sat'	=> 'Lør',
		'January'	=> 'Januar',
		'February'	=> 'Februar',
		'March'	=> 'Mars',
		'April'	=> 'April',
		'May'	=> 'Mai',
		'June'	=> 'Juni',
		'July'	=> 'Juli',
		'August'	=> 'August',
		'September'	=> 'September',
		'October'	=> 'Oktober',
		'November'	=> 'November',
		'December'	=> 'Desember',
		'Jan'	=> 'Jan',
		'Feb'	=> 'Feb',
		'Mar'	=> 'Mar',
		'Apr'	=> 'Apr',
		'May_short'	=> 'Mai',
		'Jun'	=> 'Jun',
		'Jul'	=> 'Jul',
		'Aug'	=> 'Aug',
		'Sep'	=> 'Sep',
		'Oct'	=> 'Okt',
		'Nov'	=> 'Nov',
		'Dec'	=> 'Des',
	),


	'tz'	=> array(
		'-12'	=> 'UTC - 12 timer',
		'-11'	=> 'UTC - 11 timer',
		'-10'	=> 'UTC - 10 timer',
		'-9.5'	=> 'UTC - 9:30 timer',
		'-9'	=> 'UTC - 9 timer',
		'-8'	=> 'UTC - 8 timer',
		'-7'	=> 'UTC - 7 timer',
		'-6'	=> 'UTC - 6 timer',
		'-5'	=> 'UTC - 5 timer',
		'-4'	=> 'UTC - 4 timer',
		'-3.5'	=> 'UTC - 3:30 timer',
		'-3'	=> 'UTC - 3 timer',
		'-2'	=> 'UTC - 2 timer',
		'-1'	=> 'UTC - 1 time',
		'0'	=> 'UTC',
		'1'	=> 'UTC + 1 time',
		'2'	=> 'UTC + 2 timer',
		'3'	=> 'UTC + 3 timer',
		'3.5'	=> 'UTC + 3:30 timer',
		'4'	=> 'UTC + 4 timer',
		'4.5'	=> 'UTC + 4:30 timer',
		'5'	=> 'UTC + 5 timer',
		'5.5'	=> 'UTC + 5:30 timer',
		'5.75'	=> 'UTC + 5:45 timer',
		'6'	=> 'UTC + 6 timer',
		'6.5'	=> 'UTC + 6:30 timer',
		'7'	=> 'UTC + 7 timer',
		'8'	=> 'UTC + 8 timer',
		'8.75'	=> 'UTC + 8:45 timer',
		'9'	=> 'UTC + 9 timer',
		'9.5'	=> 'UTC + 9:30 timer',
		'10'	=> 'UTC + 10 timer',
		'10.5'	=> 'UTC + 10:30 timer',
		'11'	=> 'UTC + 11 timer',
		'11.5'	=> 'UTC + 11:30 timer',
		'12'	=> 'UTC + 12 timer',
		'12.75'	=> 'UTC + 12:45 timer',
		'13'	=> 'UTC + 13 timer',
		'14'	=> 'UTC + 14 timer',
		'dst'	=> '[ DST ]',
	),


	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12, Y] Baker Island',
		'-11'	=> '[UTC - 11, X] Niue, Samoa',
		'-10'	=> '[UTC - 10, W] Hawai-Aleutian, Cook Island',
		'-9.5'	=> '[UTC - 9:30, V*] Marquesas Islands',
		'-9'	=> '[UTC - 9, V] Alaska, Gambier Island',
		'-8'	=> '[UTC - 8, U] Stillehavet',
		'-7'	=> '[UTC - 7, T] Fjell',
		'-6'	=> '[UTC - 6, S] Sentralt',
		'-5'	=> '[UTC - 5, R] Østlig',
		'-4'	=> '[UTC - 4, Q] Atlanterhavet',
		'-3.5'	=> '[UTC - 3:30, P*] Newfoundland',
		'-3'	=> '[UTC - 3, P] Amasonas, Sentral-Grønland',
		'-2'	=> '[UTC - 2, O] Fernando de Noronha, Sør-Georgia &amp; Sør Sandwich Islands',
		'-1'	=> '[UTC - 1, N] Azorene, Kapp Verde, Øst-Grønland',
		'0'	=> '[UTC, Z] Vest-Europa, Greenwich',
		'1'	=> '[UTC + 1, A] Mellom-Europa, Vest-Afrika',
		'2'	=> '[UTC + 2, B] Øst-Europa , Sentral-Afrikansk',
		'3'	=> '[UTC + 3, C] Moskva, Øst-Afrika',
		'3.5'	=> '[UTC + 3:30, C*] Iran',
		'4'	=> '[UTC + 4, D] Golfstrømmen, Samara',
		'4.5'	=> '[UTC + 4:30, D*] Afghanistan',
		'5'	=> '[UTC + 5, E] Pakistan, Yekaterinburg',
		'5.5'	=> '[UTC + 5:30, E*] India, Sri Lanka',
		'5.75'	=> '[UTC + 5:45, E&Dagger;] Nepal',
		'6'	=> '[UTC + 6, F] Bangladesh, Bhutan, Novosibirsk',
		'6.5'	=> '[UTC + 6:30, F*] Cocos Islands, Myanmar',
		'7'	=> '[UTC + 7, G] Indochina, Krasnoyarsk',
		'8'	=> '[UTC + 8, H] Kinesisk, Den Australske Western, Irkutsk',
		'8.75'	=> '[UTC + 8:45, H&Dagger;] Den Sørøst-Australske Western',
		'9'	=> '[UTC + 9, I] Japan, Korea, Chita',
		'9.5'	=> '[UTC + 9:30, I*] Sentral-Australia',
		'10'	=> '[UTC + 10, K] Øst-Australia, Vladivostok',
		'10.5'	=> '[UTC + 10:30, K*] Lord Howe',
		'11'	=> '[UTC + 11, L] Salomonøyene, Magadan',
		'11.5'	=> '[UTC + 11:30, L*] Norfolk Island',
		'12'	=> '[UTC + 12, M] New Zealand, Fiji, Kamchatka',
		'12.75'	=> '[UTC + 12:45, M&Dagger;] Chatham Islands',
		'13'	=> '[UTC + 13, M*] Tonga, Phoenix Islands',
		'14'	=> '[UTC + 14, M&dagger;] Line Island',
	),


	'dateformats'	=> array(
		'd M Y, H:i'	=> '01 Jan 2007, 13:37',
		'd M Y H:i'	=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'	=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'	=> 'Man Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'	=> 'Januar 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'	=> 'I dag, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'	=> 'I dag, 1:37 pm / Januar 1st, 2007, 1:37 pm',
	),

	'default_dateformat'	=> '|d. F Y| H:i',
	
	'ERR_UNWATCHING'					=> 'Deaktiveringen av abonnementet mislyktes.',
	'ERR_WATCHING'						=> 'Aktiveringen av abonnementet mislyktes.',
	'TOO_LONG'						=> 'Verdien du oppga er for lang.',
	'TOO_SHORT'						=> 'Verdien du oppga er for kort.'
));

?>