/*
 * testvalidate.c - A program for testing validate.
 *
 * To use this program, set the TEST_USER and TEST_PASSWORD
 * constants below.  After making (make test) and running 
 * (./testvalidate) this program, you should see a message 
 * indicating whether or not the combination represents a real user.
 */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

#define VALIDATE_PROGRAM "./validate"
#define TEST_USER "dummy"
#define TEST_PASSWORD "dumbpassword"

main()
{
    int filedes[2];  /* fd's for pipe.  Read from 0, write to 1*/
    int ret, status;
    FILE* fp;

    if (pipe(filedes)!=0) {
        fprintf(stderr,"Unable to open pipe.  Error: %d\n",errno);
        exit(1);
    }

    ret = fork();
    if (ret==-1) {
        fprintf(stderr,"Unable to fork. Error: %d\n",errno);
        exit(1);
    }

    if (ret==0) { /* Child */

        /* Set stdin to filedes[0] */
        dup2(filedes[0],STDIN_FILENO);
        execl( VALIDATE_PROGRAM,
            VALIDATE_PROGRAM,                    
            NULL);

        /* We shouldn't reach this point */
        fprintf(stderr,"Unable to exec. Error: %d\n",errno);
        exit(1);
    }

    /* Parent */

    /* We write to the pipe, then wait for the child to finish. */
    fp = fdopen(filedes[1],"w");
    if (!fp) {
        fprintf(stderr,"Unable to open pipe for writing: %d\n",errno);
        exit(1);
    }

    fprintf(fp, "%s\n",TEST_USER);
    fprintf(fp, "%s\n",TEST_PASSWORD);
    fclose(fp);

    ret = wait(&status);
    if (ret==0 || ret==-1) {
        fprintf(stderr,"Error while waiting for child: %d.\n",errno);
        exit(1);
    }

    if (status!=0)
        fprintf(stderr,"Incorrect authentication\n");
    else
        fprintf(stderr,"Correctly authenticated.\n");

}


