---
title:  "PostgreSQL JDBC Driver 42.0.0 Released"
date:   2017-02-20 00:00:00 +0300
categories:
  - new_release
version: 42.0.0
---
**Notable changes**

### Added
- Replication protocol API was added: [replication API documentation](https://jdbc.postgresql.org//documentation/head/replication.html). [PR 550](https://github.com/pgjdbc/pgjdbc/pull/550)
- java.util.logging is now used for logging: [logging documentation](https://jdbc.postgresql.org//documentation/head/logging.html). [PR 722](https://github.com/pgjdbc/pgjdbc/pull/722)
- Add support for PreparedStatement.setCharacterStream(int, Reader). [ee4c4265](https://github.com/pgjdbc/pgjdbc/commit/ee4c4265aebc1c73a1d1fabac5ba259d1fbfd1e4)

### Changed
- Version bumped to 42.0.0 to avoid version clash with PostgreSQL version and follow a better sematic versioning. [46634923](https://github.com/pgjdbc/pgjdbc/commit/466349236622c6b03bb9cd8d7f517c3ce0586751)
- Ensure executeBatch() can be used with pgbouncer. Previously pgjdbc could use server-prepared statements for batch execution even with prepareThreshold=0. [Issue 742](https://github.com/pgjdbc/pgjdbc/issues/742)
- Error position is displayed when SQL has unterminated literals, comments, etc. [Issue 688](https://github.com/pgjdbc/pgjdbc/issues/688)
- Strict handling of accepted values in getBoolean and setObject(BOOLEAN), now it follows PostgreSQL accepted values, only 1 and 0 for numeric types are acepted (previusly !=0 was true). [PR 732](https://github.com/pgjdbc/pgjdbc/pull/732)
- Return correct versions and name of the driver. [PR 668](https://github.com/pgjdbc/pgjdbc/pull/668)

### Removed
- Support for PostgreSQL versions below 8.2 was dropped. [PR 661](https://github.com/pgjdbc/pgjdbc/pull/661)

### Deprecated
- Deprecated PGPoolingDataSource, instead of this class you should use a fully featured connection pool like HikariCP, vibur-dbcp, commons-dbcp, c3p0, etc. [PR 739](https://github.com/pgjdbc/pgjdbc/pull/739)

### Regressions
- Data truncated in setCharacterStream. Fixed in 42.1.0
- No suitable driver found for jdbc:postgresql when using a DataSource implementation. Fixed in 42.1.0

<br>
You may have noticed the change in the versioning of the driver, you can [read the FAQ](documentation/faq.html#versioning) for more information.

<!--more-->

**Commits by author**

AlexElin (6):

* refactor: use varargs [PR 681](https://github.com/pgjdbc/pgjdbc/pull/681) [50b7fe0f](https://github.com/pgjdbc/pgjdbc/commit/50b7fe0fe901ee24160615bebd4b86603b960b86)
* refactor: make HostChooser implement Iterable [PR 645](https://github.com/pgjdbc/pgjdbc/pull/645) [3d37db78](https://github.com/pgjdbc/pgjdbc/commit/3d37db78ae4a82cab8809bac86e3b55537e91d95)
* refactor: migrate to Junit4 [PR 682](https://github.com/pgjdbc/pgjdbc/pull/682) [f4a067cc](https://github.com/pgjdbc/pgjdbc/commit/f4a067cc5d32dde2698a062d6f9855d50fa3127d)
* refactor: remove deprecated Utils' methods [PR 678](https://github.com/pgjdbc/pgjdbc/pull/678) [0275d40f](https://github.com/pgjdbc/pgjdbc/commit/0275d40f6f2b8b30faef8aed31761e1ff7a0ed90)
* refactor: migrate tests to junit4 [PR 685](https://github.com/pgjdbc/pgjdbc/pull/685) [faab4998](https://github.com/pgjdbc/pgjdbc/commit/faab499853c56f67cb70fb242f75b918452f2a6f)
* refactor: remove checks for jdk version 1.4 (tests) [PR 737](https://github.com/pgjdbc/pgjdbc/pull/737) [ee51dfce](https://github.com/pgjdbc/pgjdbc/commit/ee51dfce99dcd922b66373cd0c69c83bf339dbdb)

Eric McCormack (1):

* fix: accept server version with more than 3 parts [PR 741](https://github.com/pgjdbc/pgjdbc/pull/741) [8437f6c1](https://github.com/pgjdbc/pgjdbc/commit/8437f6c1c76c3560331d75c4332ab50959d57228)

Jordan Lewis (1):

* feat: do not use pg_depend against PostgreSQL 9.0+ [PR 689](https://github.com/pgjdbc/pgjdbc/pull/689) [62e25fba](https://github.com/pgjdbc/pgjdbc/commit/62e25fba70002d7639472c5a1dcd9d1de5b7f872)

Jorge Solorzano (22):

* refactor: remove support for postgresql < 8.2 [PR 661](https://github.com/pgjdbc/pgjdbc/pull/661) [14e64be7](https://github.com/pgjdbc/pgjdbc/commit/14e64be7dc43feaef210e82fcd9b6089e54e5e4f)
* fix: add query to support postgresql 8.2 without t.typarray [PR 699](https://github.com/pgjdbc/pgjdbc/pull/699) [cb3995b5](https://github.com/pgjdbc/pgjdbc/commit/cb3995b5a0311a2f5f7737fdfe83457680305efb)
* test: add CI tests against PostgreSQL 8.3 [PR 710](https://github.com/pgjdbc/pgjdbc/pull/710) [436365b0](https://github.com/pgjdbc/pgjdbc/commit/436365b095d0a276b876433fd00d9bbac72708cc)
* fix: robust castToBoolean for setObject in PreparedStatement [PR 714](https://github.com/pgjdbc/pgjdbc/pull/714) [edc2a14a](https://github.com/pgjdbc/pgjdbc/commit/edc2a14af8837911a48bb322363bb8b70d2b173d)
* refactor: remove unused V2ReplicationProtocol.java [PR 718](https://github.com/pgjdbc/pgjdbc/pull/718) [7881e41e](https://github.com/pgjdbc/pgjdbc/commit/7881e41ea93f3bd6a3f58e85cb4329f77b667db0)
* test: ignore tests that don't apply to Pg8.2 and Pg8.3 [PR 703](https://github.com/pgjdbc/pgjdbc/pull/703) [3bc0951e](https://github.com/pgjdbc/pgjdbc/commit/3bc0951e84ad3b7af746e2dece04b4ea816605e2)
* style: reorder checkstyle in travis [PR 721](https://github.com/pgjdbc/pgjdbc/pull/721) [ba812fb4](https://github.com/pgjdbc/pgjdbc/commit/ba812fb404852b73a304f7ccb068a2030b8604b3)
* refactor: remove charset property not used [PR 709](https://github.com/pgjdbc/pgjdbc/pull/709) [f6fd5a5a](https://github.com/pgjdbc/pgjdbc/commit/f6fd5a5abea1efe9b987825b7874ffd962772197)
* fix: huntbugs on PgDatabaseMetaData, String concatenation in a loop [PR 693](https://github.com/pgjdbc/pgjdbc/pull/693) [3a00ef94](https://github.com/pgjdbc/pgjdbc/commit/3a00ef9436c6b04c472330802a8adb22adaa9b63)
* refactor: fix getDriverVersion, getDriverName and getJDBCMajor/MinorVersion methods [PR 668](https://github.com/pgjdbc/pgjdbc/pull/668) [aa974341](https://github.com/pgjdbc/pgjdbc/commit/aa9743417f18a10a1a7c7a4bc25ad2862155ddc8)
* docs: reword supported versions, include datasources section, compare versions [PR 673](https://github.com/pgjdbc/pgjdbc/pull/673) [b2cdd057](https://github.com/pgjdbc/pgjdbc/commit/b2cdd057664a00928d97290ed7435fcf57f3a360)
* test: fix test replication on PG_HEAD [PR 734](https://github.com/pgjdbc/pgjdbc/pull/734) [3b406a18](https://github.com/pgjdbc/pgjdbc/commit/3b406a18a7c1751aa477e8378ee8cad0a60efd1e)
* refactor: deprecated PGPoolingDataSource [PR 739](https://github.com/pgjdbc/pgjdbc/pull/739) [55e2cd16](https://github.com/pgjdbc/pgjdbc/commit/55e2cd16cc7e30b1370e777d71556aa625bace9f)
* fix: strict handling of getBoolean and setObject with postgres accepted values [PR 732](https://github.com/pgjdbc/pgjdbc/pull/732) [4942f7d1](https://github.com/pgjdbc/pgjdbc/commit/4942f7d1cc812feeeca331878334a3d4058615e4)
* docs: move docs from www/documentation/head [PR 744](https://github.com/pgjdbc/pgjdbc/pull/744) [70e23c45](https://github.com/pgjdbc/pgjdbc/commit/70e23c45c904ebded42ab1b5efc10d66f34ab68c)
* test: fix replication test in Pg10 [PR 746](https://github.com/pgjdbc/pgjdbc/pull/746) [63ed2129](https://github.com/pgjdbc/pgjdbc/commit/63ed2129f7aa4375d009f19c64dc2404e725aabb)
* feat: use java.util.logging [PR 722](https://github.com/pgjdbc/pgjdbc/pull/722) [43e6505e](https://github.com/pgjdbc/pgjdbc/commit/43e6505e3aa16e6acdf08f02f2dd1e3cf131ac3e)
* perf: short circuit Oid.BOOL in getBoolean [PR 745](https://github.com/pgjdbc/pgjdbc/pull/745) [e69e4a1d](https://github.com/pgjdbc/pgjdbc/commit/e69e4a1d5502319bc810e0e4529611ba52ea386c)
* fix: add isLoggable around parameterized logger [PR 752](https://github.com/pgjdbc/pgjdbc/pull/752) [8b50cfe5](https://github.com/pgjdbc/pgjdbc/commit/8b50cfe58c47d19adc0c241488a24037f4a4416f)
* docs: move www repository to pgjdbc/docs [d4e99198](https://github.com/pgjdbc/pgjdbc/commit/d4e99198336bf41fc7f3fe9c0746036d5477601c)
* add syntax highlight to documentation [8c035ade](https://github.com/pgjdbc/pgjdbc/commit/8c035adeb820c8a19e372f0b76a70e511b657cad)
* add more style [9c510e65](https://github.com/pgjdbc/pgjdbc/commit/9c510e65f573354a47b7e94553870231e8dc2935)

Pavel Raiskup (3):

* fix: sync with latest Fedora [PR 637](https://github.com/pgjdbc/pgjdbc/pull/637) [a29ad80b](https://github.com/pgjdbc/pgjdbc/commit/a29ad80bcfdd65d11257f6339eb6bf2512612eed)
* packaging: rpm: update srpm generator [5c3c9239](https://github.com/pgjdbc/pgjdbc/commit/5c3c92392d66608ed7d9d1f96eb5b380e2667cd9)
* packaging: rpm_ci: use curl -L to download rawhide logs [c8125cff](https://github.com/pgjdbc/pgjdbc/commit/c8125cff3ae719675983185d49cd49e6c028d7b7)

Philippe Marschall (3):

* refactor: clean up PgDatabaseMetaData [PR 692](https://github.com/pgjdbc/pgjdbc/pull/692) [d32b077e](https://github.com/pgjdbc/pgjdbc/commit/d32b077e20b2afae9c4c80f704f7c8a26a8b8e11)
* refactor: delete Keyword enum [PR 697](https://github.com/pgjdbc/pgjdbc/pull/697) [677e3c4c](https://github.com/pgjdbc/pgjdbc/commit/677e3c4cf2533ce283a2d444cee6da8a94a4ca82)
* feat: support microsecond resolution for JSR-310 types [PR 691](https://github.com/pgjdbc/pgjdbc/pull/691) [6b3a1efb](https://github.com/pgjdbc/pgjdbc/commit/6b3a1efb36709e570caf0dc71a42a53e89f5a5e0)

Roman Ivanov (2):

* config: move version of checkstyle to property [PR 723](https://github.com/pgjdbc/pgjdbc/pull/723) [9ef7d6f1](https://github.com/pgjdbc/pgjdbc/commit/9ef7d6f1f274a75a14b380c57f4c140b47b25888)
* chore: upgrade checkstyle to 7.4, make checkstyle version configurable via property [PR 725](https://github.com/pgjdbc/pgjdbc/pull/725) [e1a25782](https://github.com/pgjdbc/pgjdbc/commit/e1a2578247684667a51bc34ee53449e4457755df)

Steve Ungerer (1):

* fix: ensure executeBatch() does not use server-side prepared statements when prepareThreshold=0 [PR 690](https://github.com/pgjdbc/pgjdbc/pull/690) [aca26a07](https://github.com/pgjdbc/pgjdbc/commit/aca26a07026e9b289a209799ab28131a33b296dd)

Trygve Laugstøl (1):

* feat: connect the socket only if the socket factory created an unconnected socket [PR 587](https://github.com/pgjdbc/pgjdbc/pull/587) [f75572be](https://github.com/pgjdbc/pgjdbc/commit/f75572beb8b59a7a73f6e1d12d692b483dc04c85)

Vladimir Gordiychuk (4):

* bug: fix not enscaped special symbol that fail build [PR 686](https://github.com/pgjdbc/pgjdbc/pull/686) [b4604cd7](https://github.com/pgjdbc/pgjdbc/commit/b4604cd7de0c297c8b56608642055ed6eb3645e0)
* feat: add replication protocol API [PR 550](https://github.com/pgjdbc/pgjdbc/pull/550) [f48c6bb7](https://github.com/pgjdbc/pgjdbc/commit/f48c6bb7e726479bbf4be4ef95e4c138db5cac96)
* test: fix drop replication slot on 9.4 for tests [PR 696](https://github.com/pgjdbc/pgjdbc/pull/696) [c1c48bd7](https://github.com/pgjdbc/pgjdbc/commit/c1c48bd705f04e8d1b1cb8b998dda0a6893f891d)
* chore: Gather backtrace from core dump on CI [PR 736](https://github.com/pgjdbc/pgjdbc/pull/736) [da5e4ef1](https://github.com/pgjdbc/pgjdbc/commit/da5e4ef1cbc4a5c9f41e9aee8d183560ba679541)

Vladimir Sitnikov (12):

* fedora: add BuildRequires: classloader-leak-test-framework [64b6750c](https://github.com/pgjdbc/pgjdbc/commit/64b6750cbd49ca8a9f0596bed1876132b64c34d4)
* tests: remove Class.forName(..driver..) from test code [c99507b5](https://github.com/pgjdbc/pgjdbc/commit/c99507b5661804b5b1b2340ba747fe553dc37a68)
* test: add CI tests against PostgreSQL 8.2 [PR 659](https://github.com/pgjdbc/pgjdbc/pull/659) [63ee60e2](https://github.com/pgjdbc/pgjdbc/commit/63ee60e2ad93441ff55dab08213cc09815b614e0)
* feat: display error position when SQL has unterminated literals, comments, etc [PR 688](https://github.com/pgjdbc/pgjdbc/pull/688) [8a95d991](https://github.com/pgjdbc/pgjdbc/commit/8a95d991e2032cf0406be8e54e70cfafaad794b5)
* feat: add support for PreparedStatement.setCharacterStream(int, Reader) [PR 671](https://github.com/pgjdbc/pgjdbc/pull/671) [ee4c4265](https://github.com/pgjdbc/pgjdbc/commit/ee4c4265aebc1c73a1d1fabac5ba259d1fbfd1e4)
* chore: update next version to 42.0.0-SNAPSHOT [46634923](https://github.com/pgjdbc/pgjdbc/commit/466349236622c6b03bb9cd8d7f517c3ce0586751)
* refactor: add CallableQueryKey#equals override [401c51a1](https://github.com/pgjdbc/pgjdbc/commit/401c51a15d80d2f24cddbe5cd4b2ca7509a0a765)
* doc: correct wording in readme regarding PostgreSQL versions used in pgjdbc regression testing [60391d75](https://github.com/pgjdbc/pgjdbc/commit/60391d7559d6ee4e579ec2e36d7aa8199a99189d)
* fix: revert ExpressionProperties to Properties in BaseDataSource [989b4d23](https://github.com/pgjdbc/pgjdbc/commit/989b4d235ec6776f31284d15618195cf7f8a7a79)
* fix: correct edge cases for setCharacterStream(int, Reader) [f1190d8c](https://github.com/pgjdbc/pgjdbc/commit/f1190d8c2eb1c506616e2298aabad211ba3bdb0a)
* test: add SharedTimerClassLoaderLeakTest to the regular test suite [b3553276](https://github.com/pgjdbc/pgjdbc/commit/b3553276ad48cbb47cd4849d3a08b7ee61be8ace)
* refactor: wrap more log statements with isLoggable check [07d225ec](https://github.com/pgjdbc/pgjdbc/commit/07d225ec1028d945533d5023702b3865aee54ad6)

bd-infor (1):

* docs: clarify handling of loglevel [PR 711](https://github.com/pgjdbc/pgjdbc/pull/711) [6334bac0](https://github.com/pgjdbc/pgjdbc/commit/6334bac036efaa4a9f2a445f1cbdcc310f4c6263)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[AlexElin](https://github.com/AlexElin)  
[bd-infor](https://github.com/bd-infor)  
[Eric McCormack](https://github.com/ericmack)  
[Jordan Lewis](https://github.com/jordanlewis)  
[Jorge Solorzano](https://github.com/jorsol)  
[Pavel Raiskup](https://github.com/praiskup)  
[Philippe Marschall](https://github.com/marschall)  
[Roman Ivanov](https://github.com/romani)  
[Steve Ungerer](https://github.com/scubasau)  
[Trygve Laugstøl](https://github.com/trygvis)  
[Vladimir Gordiychuk](https://github.com/Gordiychuk)  
[Vladimir Sitnikov](https://github.com/vlsi)  
