/* wchotkey.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2006,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wchotkey.hh"
#include "wcdoubleshortkey.hh"
#include "datei.h"
#include <aguix/util.h>
#include "functionproto.h"
#include "simplelist.hh"
 
WCHotkey::WCHotkey()
{
  name=dupstring("");
  com=new List();
}

WCHotkey::~WCHotkey()
{
  if(name!=NULL) _freesafe(name);
  freecoms(com);
  delete com;
}

WCHotkey *WCHotkey::duplicate() const
{
  WCHotkey *thot=new WCHotkey();
  thot->setName(name);
  thot->setComs(com);
  thot->setDoubleKeys( dkeys );
  return thot;
}

void WCHotkey::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
  } else {
    name=dupstring(nname);
  }
}

char *WCHotkey::getName()
{
  return name;
}

List *WCHotkey::getComs()
{
  return com;
}

void WCHotkey::setComs(List *ncom)
{
  freecoms(com);
  FunctionProto *fp;
  int id=ncom->initEnum();
  fp=(FunctionProto*)ncom->getFirstElement(id);
  while(fp!=NULL) {
    com->addElement(fp->duplicate());
    fp=(FunctionProto*)ncom->getNextElement(id);
  }
  com->closeEnum(id);  
}

void WCHotkey::addCom( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  com->addElement( fp->duplicate() );
}

bool WCHotkey::save(Datei *fh) const
{
  int id;
  WCDoubleShortkey *dk;

  if(fh==NULL) return false;

  id = dkeys->initEnum();

  fh->configPutPairString( "title", name );
  fh->configOpenSection( "shortkeys" );
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    dk->save( fh );
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  fh->configCloseSection(); //shortkeys

  fh->configOpenSection( "commands" );
  id = com->initEnum();
  FunctionProto *f1 = (FunctionProto*)com->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)com->getNextElement( id );
  }
  com->closeEnum( id );
  fh->configCloseSection(); //commands
  return true;
}
