#!/bin/bash

echo "Reading \"tools/VERSION\"..."

KS_BUILD=`date +%Y-%m-%d`
KS_FILE_VERSION=`sed 1!d tools/VERSION`
KS_FULL_VERSION=`sed 2!d tools/VERSION`

echo "Generating \"kshutdown.nsh\"..."

cat > "kshutdown.nsh" <<EOF
# Generated by $0, do not modify!
!define APP_FILE_VERSION "$KS_FILE_VERSION"
!define APP_FULL_VERSION "$KS_FULL_VERSION"
EOF

echo "Generating \"src/version.h\"..."

cat > "src/version.h" <<EOF
// Generated by $0, do not modify!
#ifndef KSHUTDOWN_VERSION_H
#define KSHUTDOWN_VERSION_H

#define KS_BUILD "$KS_BUILD"
#define KS_FILE_VERSION "$KS_FILE_VERSION"
#define KS_FULL_VERSION "$KS_FULL_VERSION"

#endif // KSHUTDOWN_VERSION_H
EOF

echo "File version (used in file names)    : \"$KS_FILE_VERSION\""
echo "Full version (used in User Interface): \"$KS_FULL_VERSION\""
echo "Build date:                          : \"$KS_BUILD\""
