// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package storagegateway

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/private/signer/v4"
)

// AWS Storage Gateway is the service that connects an on-premises software
// appliance with cloud-based storage to provide seamless and secure integration
// between an organization's on-premises IT environment and AWS's storage infrastructure.
// The service enables you to securely upload data to the AWS cloud for cost
// effective backup and rapid disaster recovery.
//
// Use the following links to get started using the AWS Storage Gateway Service
// API Reference:
//
//   AWS Storage Gateway Required Request Headers (http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayHTTPRequestsHeaders.html):
// Describes the required headers that you must send with every POST request
// to AWS Storage Gateway.  Signing Requests (http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewaySigningRequests.html):
// AWS Storage Gateway requires that you authenticate every request you send;
// this topic describes how sign such a request.  Error Responses (http://docs.aws.amazon.com/storagegateway/latest/userguide/APIErrorResponses.html):
// Provides reference information about AWS Storage Gateway errors.  Operations
// in AWS Storage Gateway (http://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPIOperations.html):
// Contains detailed descriptions of all AWS Storage Gateway operations, their
// request parameters, response elements, possible errors, and examples of requests
// and responses.  AWS Storage Gateway Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/index.html?rande.html):
// Provides a list of each of the regions and endpoints available for use with
// AWS Storage Gateway.
//The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
type StorageGateway struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// A ServiceName is the name of the service the client will make API calls to.
const ServiceName = "storagegateway"

// New creates a new instance of the StorageGateway client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a StorageGateway client from just a session.
//     svc := storagegateway.New(mySession)
//
//     // Create a StorageGateway client with additional configuration
//     svc := storagegateway.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *StorageGateway {
	c := p.ClientConfig(ServiceName, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion string) *StorageGateway {
	svc := &StorageGateway{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2013-06-30",
				JSONVersion:   "1.1",
				TargetPrefix:  "StorageGateway_20130630",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBack(v4.Sign)
	svc.Handlers.Build.PushBackNamed(jsonrpc.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(jsonrpc.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(jsonrpc.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(jsonrpc.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a StorageGateway operation and runs any
// custom request initialization.
func (c *StorageGateway) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
