/* worker_lfs.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: worker_lfs.h,v 1.6 2004/10/27 21:10:22 ralf Exp $ */

#ifndef WORKER_LFS_H
#define WORKER_LFS_H

// this is for getting ???64 functions
#ifdef HAVE_EXPLICIT_LFS
#  define _LARGEFILE64_SOURCE 1
  // that are standards. LARGEFILE64 should imply LARGEFILE but...
#  define _LARGEFILE_SOURCE 1
  // check for support
#  include <unistd.h>
#  ifndef _LFS_LARGEFILE
#    undef HAVE_EXPLICIT_LFS
#  endif
#  ifndef _LFS64_LARGEFILE
#    undef HAVE_EXPLICIT_LFS
#  endif
#  ifndef _LFS64_STDIO
#    undef HAVE_EXPLICIT_LFS
#  endif
#endif

/* finally check if sizeof(loff_t) < 8 and undef HAVE_EXPL
   for the case the user set this define but loff_t cannot store
   big values */
#if ( ! defined SIZEOF_LOFF_T ) || ( SIZEOF_LOFF_T < 8 )
#  undef HAVE_EXPLICIT_LFS
#endif

// now some defines for this functions so I can use them transparently

#if defined HAVE_EXPLICIT_LFS
#  define worker_stat(x,y) stat64(x,y)
#  define worker_struct_stat struct stat64
#else
#  define worker_stat(x,y) stat(x,y)
#  define worker_struct_stat struct stat
#endif

#if defined HAVE_EXPLICIT_LFS
#  define worker_lstat(x,y) lstat64(x,y)
#else
#  define worker_lstat(x,y) lstat(x,y)
#endif

#if defined HAVE_EXPLICIT_LFS
#  define worker_open open64
#else
#  define worker_open open
#endif

#define worker_read(x,y,z) read(x,y,z)
#define worker_write(x,y,z) write(x,y,z)
#define worker_close(x) close(x)

#if defined HAVE_EXPLICIT_LFS
#  define worker_fopen(x,y) fopen64(x,y)
#else
#  define worker_fopen(x,y) fopen(x,y)
#endif

#if defined HAVE_EXPLICIT_LFS
#  define worker_fseek(x,y,z) fseeko(x,y,z)
#else
#  define worker_fseek(x,y,z) fseek(x,y,z)
#endif

#define worker_fread(a,b,c,d) fread(a,b,c,d)
#define worker_fwrite(a,b,c,d) fwrite(a,b,c,d)
#define worker_fclose(x) fclose(x)

#if defined HAVE_EXPLICIT_LFS
#  define worker_readdir(x) readdir64(x)
#  define worker_struct_dirent struct dirent64
#else
#  define worker_readdir(x) readdir(x)
#  define worker_struct_dirent struct dirent
#endif

#if defined HAVE_EXPLICIT_LFS
#  define worker_statvfs(x,y) statvfs64(x,y)
#  define worker_struct_statvfs struct statvfs64
#else
#  define worker_statvfs(x,y) statvfs(x,y)
#  if defined HAVE_STATVFS_T
#    define worker_struct_statvfs statvfs_t
#  else
#    define worker_struct_statvfs struct statvfs
#  endif
#endif

// now some final define if we support LFS
// this define doesn't change anything about the support
// but helps me to simplify coding
// at the time of this writing it's only used for the about
// requester
#undef WORKER_LFS_SUPPORTED
#if ( defined SIZEOF_LOFF_T ) && ( SIZEOF_LOFF_T == 8 )
#  if ( defined HAVE_EXPLICIT_LFS ) || ( ( defined SIZEOF_OFF_T ) && ( SIZEOF_OFF_T == 8 ) )
#    define WORKER_LFS_SUPPORTED
#  endif
#endif

#endif
