#!/usr/local/bin/perl
# Create, update or delete a template

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newtmpl_ecannot'});
&ReadParse();
@tmpls = &list_templates();
if (!$in{'new'}) {
	($tmpl) = grep { $_->{'id'} == $in{'id'} } @tmpls;
	}
else {
	$tmpl = { };
	}

if ($in{'delete'}) {
	# Just delete this template
	&delete_template($tmpl);
	&webmin_log("delete", "template", $tmpl->{'name'});
	&redirect("edit_newtmpl.cgi");
	exit;
	}

# Validate and store all inputs
&error_setup($text{'tmpl_err'});
if (!$tmpl->{'standard'}) {
	$in{'name'} || &error($text{'tmpl_ename'});
	$tmpl->{'name'} = $in{'name'};
	}

# Save global ACL
$tmpl->{'gacl'} = $in{'gacl'};
$tmpl->{'gacl_umode'} = $in{'gacl_umode'};
$tmpl->{'gacl_uusers'} = $in{'gacl_uusers'};
$tmpl->{'gacl_ugroups'} = $in{'gacl_ugroups'};
$tmpl->{'gacl_groups'} = $in{'gacl_groups'};
$tmpl->{'gacl_root'} = $in{'gacl_root'};

# Save skeleton directory
$tmpl->{'skel'} = &parse_none_def("skel");
if ($in{"skel_mode"} == 2) {
	-d $in{'skel'} || &error($text{'tmpl_eskel'});
	}

if (!$tmpl->{'standard'}) {
	# Save for-use-by list
	foreach $f ("parent", "sub", "alias", "users") {
		$tmpl->{"for_".$f} = $in{"for_".$f};
		}
	}

if ($config{'web'}) {
	# Save web-related settings
	$old_web_port = $web_port;
	$old_web_sslport = $web_sslport;
	$tmpl->{'web'} = &parse_none_def("web");
	if ($in{"web_mode"} == 2) {
		$err = &check_apache_directives($in{"web"});
		&error($err) if ($err);
		$tmpl->{'web_suexec'} = $in{'suexec'};
		if ($in{'html_dir_def'}) {
			delete($tmpl->{'web_html_dir'});
			}
		else {
			$in{'html_dir'} =~ /^\S+$/ && $in{'html_dir'} !~ /^\// &&
			    $in{'html_dir'} !~ /\.\./ || &error($text{'newweb_ehtml'});
			$tmpl->{'web_html_dir'} = $in{'html_dir'};
			}
		delete($tmpl->{'web_stats_dir'});
		delete($tmpl->{'web_stats_hdir'});
		$smode = $in{'stats_mode'} == 1 ? "stats_dir" :
			 $in{'stats_mode'} == 2 ? "stats_hdir" : undef;
		if ($smode) {
			$in{$smode} =~ /^\S+$/ && $in{$smode} !~ /^\// &&
				$in{$smode} !~ /\.\./ || &error($text{'newweb_estats'});
			$tmpl->{"web_".$smode} = $in{$smode};
			}
		if ($in{'user_def'}) {
			delete($tmpl->{'web_user'});
			}
		else {
			defined(getpwnam($in{'user'})) || &error($text{'newweb_euser'});
			$tmpl->{'web_user'} = $in{'user'};
			}
		$tmpl->{'web_alias'} = $in{'alias_mode'};
		$in{'web_port'} =~ /^\d+$/ && $in{'web_port'} > 0 &&
			$in{'web_port'} < 65536 || &error($text{'newweb_eport'});
		$tmpl->{'web_port'} = $in{'web_port'};
		$in{'web_sslport'} =~ /^\d+$/ && $in{'web_sslport'} > 0 &&
			$in{'web_sslport'} < 65536 ||
				&error($text{'newweb_esslport'});
		$in{'web_port'} != $in{'web_sslport'} ||
				&error($text{'newweb_esslport2'});
		$tmpl->{'web_sslport'} = $in{'web_sslport'};
		}
	}

if ($config{'dns'}) {
	# Save DNS settings
	$tmpl->{'dns'} = &parse_none_def("dns");
	if ($in{"dns_mode"} == 2) {
		$tmpl->{'dns_replace'} = $in{'bind_replace'};
		$tmpl->{'dns_view'} = $in{'view'};

		&require_bind();
		$fakeip = "1.2.3.4";
		$fakedom = "foo.com";
		$recs = &substitute_template(
			join("\n", split(/\t+/, $in{'dns'}))."\n",
			{ 'ip' => $fakeip,
			  'dom' => $fakedom });
		$temp = &tempname();
		open(TEMP, ">$temp");
		print TEMP $recs;
		close(TEMP);
		$bind8::config{'short_names'} = 0;	# force canonicalization
		$bind8::config{'chroot'} = '/';		# turn off chroot for temp path
		@recs = &bind8::read_zone_file($temp, $fakedom);
		unlink($temp);
		foreach $r (@recs) {
			$soa++ if ($r->{'name'} eq $fakedom."." &&
				   $r->{'type'} eq "SOA");
			$ns++ if ($r->{'name'} eq $fakedom."." &&
				  $r->{'type'} eq "NS");
			$dom++ if ($r->{'name'} eq $fakedom."." &&
				   ($r->{'type'} eq "A" || $r->{'type'} eq "MX"));
			$www++ if ($r->{'name'} eq "www.".$fakedom."." &&
				   $r->{'type'} eq "A");
			}

		if ($in{'bind_replace'}) {
			# Make sure an SOA and NS records exist
			$soa == 1 || &error($text{'newdns_esoa'});
			$ns || &error($text{'newdns_ens'});
			$dom || &error($text{'newdns_edom'});
			$www || &error($text{'newdns_ewww'});
			}
		else {
			# Make sure SOA doesn't exist
			$soa && &error($text{'newdns_esoa2'});
			}
		}
	}

if ($config{'ftp'}) {
	# Save FTP settings
	$tmpl->{'ftp'} = &parse_none_def("ftp");
	if ($in{"ftp_mode"} == 2) {
		$err = &check_proftpd_template($in{'ftp'});
		&error($err) if ($err);
		if ($in{'ftp_dir_def'}) {
			delete($tmpl->{'ftp_dir'});
			}
		else {
			$in{'ftp_dir'} =~ /^\S+$/ && $in{'ftp_dir'} !~ /^\// &&
			    $in{'ftp_dir'} !~ /\.\./ || &error($text{'newftp_edir'});
			$tmpl->{'ftp_dir'} = $in{'ftp_dir'};
			}
		}
	}

if ($config{'proxy_pass'} == 2) {
	# Save frame-forwarding settings
	$tmpl->{'frame'} = &parse_none_def("frame");
	}

# Save mail settings
$tmpl->{'mail_on'} = $in{'mail_mode'} == 0 ? "none" :
		     $in{'mail_mode'} == 1 ? "" : "yes";
$in{'mail'} =~ s/\r//g;
$tmpl->{'mail'} = $in{'mail'};
$tmpl->{'mail_subject'} = $in{'subject'};
$tmpl->{'mail_cc'} = $in{'cc'};

# Save new user settings
if ($in{'aliases_mode'} == 0) {
	$tmpl->{'user_aliases'} = "none";
	}
else {
	@aliases = &parse_alias(0, "NEWUSER");
	$tmpl->{'user_aliases'} = join("\t", @aliases);
	}

# Save MySQL-related settings
if ($in{'mysql_mode'} == 1) {
	$tmpl->{'mysql'} = undef;
	}
else {
	$in{'mysql'} =~ /^\S+$/ || &error($text{'tmpl_emysql'});
	$tmpl->{'mysql'} = $in{'mysql'};
	}
if ($in{'mysql_wild_mode'} == 1) {
	$tmpl->{'mysql_wild'} = undef;
	}
else {
	$in{'mysql_wild'} =~ /^\S*$/ || &error($text{'tmpl_emysql_wild'});
	$tmpl->{'mysql_wild'} = $in{'mysql_wild'};
	}
if ($in{'mysql_hosts_mode'} == 0) {
	$tmpl->{'mysql_hosts'} = "none";
	}
elsif ($in{'mysql_hosts_mode'} == 1) {
	$tmpl->{'mysql_hosts'} = undef;
	}
else {
	$in{'mysql_hosts'} =~ /\S/ || &error($text{'tmpl_emysql_hosts'});
	$tmpl->{'mysql_hosts'} = $in{'mysql_hosts'};
	}

# Create or update the template
&save_template($tmpl);
&webmin_log($in{'new'} ? "create" : "modify", "template", $tmpl->{'name'});
&redirect("edit_newtmpl.cgi");

if ($tmpl->{'id'} == 0) {
	# If the web or SSL ports were changed, all existing virtual hosts
	# should be updated with the *old* setting to that we know what port
	# they were created on
	if ($old_web_port != $in{'web_port'} ||
	    $old_web_sslport != $in{'web_sslport'}) {
		foreach $d (&list_domains()) {
			&save_domain($d);
			}
		}
	}

# parse_none_def(name)
sub parse_none_def
{
if ($in{$_[0]."_mode"} == 0) {
	return "none";
	}
elsif ($in{$_[0]."_mode"} == 1) {
	return undef;
	}
else {
	$in{$_[0]} =~ s/\r//g;
	$in{$_[0]} =~ s/\n/\t/g;
	return $in{$_[0]};
	}
}

