//<copyright>
//
// Copyright (c) 1995-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
//
// Name :       pngimage.h
//
// Purpose :    Interface to class PngImage
//
// Created :    01 Sep 95    Bernhard Marschall
//
// $Id: pngimage.h,v 1.4 1996/02/29 12:42:32 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: pngimage.h,v $
// Revision 1.4  1996/02/29 12:42:32  bmarsch
// Always call decodedInterlaced() callback after a pass (also
// in finishDecode())
//


#ifndef harmony_widgets_pngimage_h
#define harmony_widgets_pngimage_h

#include "libwidgets.h"
#include "rimage.h"

class PngImpl;


//<class>
//
// Name:       PngImage
//
// Purpose:    decoding of PNG images
//
//
// Public Interface:
// As in base class RasterImage.
//
//
// Description:
// PngImage implements decoding of PNG (Portable Network Grapics)
// images by using the PNG reference implementation (libpng).
//
//</class>


class PngImage : public RasterImage {
public:
  PngImage(FILE*, const char* fname, Raster*& raster,
           HgRasterCallback* = nil, boolean dither = true);
  virtual ~PngImage();

  virtual void decode(int numrows);
  virtual void finishDecode();
  virtual void abortDecode();
  virtual int not_live() const;

private:
  PngImpl* impl_;
};

#endif
