
// -*-objc-*-

#import "RSSReaderAddWindowDelegate.h"

@implementation RSSReaderAddWindowDelegate


-(void) dealloc
{
  RELEASE(window);
  RELEASE(urlField);
  RELEASE(nameField);
}

// no retains, no releases
-(void) setWindow: (NSWindow*) win
{
  window = win;
}


// no retains, no releases
-(void) setUrlField: (NSTextField*) url
	  nameField: (NSTextField*) name
{
  urlField = url;
  nameField = name;
}


// button delegates
-(void) okayClicked: (id) sender
{
  RSSFeedList* feeds;
  RSSFeed* feed;
  
  NSLog(@"Adding feed %@ with url %@",
	[nameField stringValue], [urlField stringValue] );
  
  feeds = [[NSApp delegate] RSSFeeds];
  
  feed = [ [ RSSFeed alloc ]
	   initWithFetcher:
	     [ [ HTTPFetcher alloc]
	       initWithURL: [urlField stringValue] ] ];
  
  
  if (feed == nil)
    {
      NSLog(@"Error while initializing feed.");
    }
  else if ([feed fetch])
    {
      NSLog(@"Error when getting feed...");
    }
  else
    {
      NSLog(@"adding feed %@ to %@", [feed description], [feeds description]);
      [feeds addFeed: feed];
      NSLog(@"feed added.");
    }
  
  [[NSApp delegate] reloadTable];
  [window close];
}

-(void) cancelClicked: (id) sender
{
  [window close];
}

@end
