// -*-objc-*-

#import <objc/objc.h>
#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "RSSFeed.h"


@interface TableTuple : NSObject
{
  RSSFeed*        feed;
  unsigned int    article; // article id
  unsigned int    time;
  
  NSDate*         date;
  NSString*       dateAsString;
}

-initWithFeed: (RSSFeed*) myFeed
      article: (unsigned int) myArticle
	 time: (unsigned int) myTime;

-feed;
-(unsigned int) article;
-(unsigned int) time;
-dateString;

-(void) dealloc;
@end



@interface RSSFeedList : NSObject <NSCoding>
{
@private
  // NSTableColumns
  id feedCol;
  id headlineCol;
  id dateCol;
  
  id   articleViewer;
  
  // everything we need for the table:
  // an array of RSSFeed x articleId x time
  // tuples.
  NSMutableArray * table;
  
  // a list of known RSS Feeds.
  NSMutableArray * list;
  
  // the current marked feed
  RSSFeed* markedFeed;
  
  // the current marked article
  RSSArticle* markedArticle;
}

-(void) dealloc;

-init;

-initWithFeedCol: (id) feedCol
     headlineCol: (id) headlineCol
	 dateCol: (id) dateCol;

-(void) updateAllFeeds;

-(RSSFeed*) markedFeed;

// NSCoding methods
-(id)initWithCoder: (NSCoder*)coder;
-(void)encodeWithCoder: (NSCoder*)coder;
// end of NSCoding methods

-(void) dumpArray: (NSArray*) a;
-rebuildTable;

-headlineCol: (id) headlineCol;
-feedCol: (id) feedCol;
-dateCol: (id) dateCol;

-(void)setArticleViewer: (id)aArticleViewer;

// NS Table stuff

// must be efficient!
-(int) numberOfRowsInTableView: (NSTableView*)aTableView;


// implementation is optional
/*
-(BOOL) tableView: (NSTableView*) tableView
       acceptDrop: (id <NSDraggingInfo>) info
	      row: (int) row
    dropOperation: (NSTableViewDropOperation) operation;
*/


// is executed when something is clicked
-(BOOL) tableView: (NSTableView*) aTableView
  shouldSelectRow: (int) rowIndex;

// must be efficient!
- (id)              tableView: (NSTableView*) aTableView
    objectValueForTableColumn: (NSTableColumn*) aTableColumn
			  row: (int) rowIndex;


- (void) tableView: (NSTableView*) tableView
    setObjectValue: (id) anObject
    forTableColumn: (NSTableColumn*) aTableColumn
	       row: (int) rowIndex;


// gives back the list of RSS feeds
-(NSMutableArray*) list;

// adds a feed
-(void) addFeed: (RSSFeed*) feed;
-(void) removeFeed: (RSSFeed*) feed;

// view articles
-(void) viewSelected;

@end

