#ifndef _space_h_
#define _space_h_

#include "allegro.h"
#include <vector>

using namespace std;

class HullObject;
class WeaponObject;
class ExplosionClass;
class Section;
class Group;
class SpaceObject{
public:

	SpaceObject( int sx, int sy, double qx, double qy, HullObject * mhull, Group * _group, int plane, int ali );

	//Hitme: calls hull->Inside( x, y, ax, ay )
	virtual bool HitMe( int ax, int ay );

	//Collide: determines if have collided with another object
	virtual bool Collide(SpaceObject * check);

	//Damage: decreases life returns true if 0 or less
	virtual bool Damage( double much );

	//Hurt: returns amount of damage object does when colliding with 
	//another object
	virtual double Hurt();

	//Draw: if plane == g then draw self
	virtual void Draw(BITMAP * less, ExplosionClass ** _expl, int MAX_EXPLR, int g, int offset );

	//Shadow: draw a shadow the same way as the Draw() method
	virtual void Shadow(BITMAP * less, int g, int offset );
	
	//MoveReal: generic algorithm to move coordinates with doubles
	virtual void MoveReal();

	//PowerUp: determines whether or not ship should turn into a powerup or money
	virtual bool powerUp();

	//GiveHull: replace old hull with hnew
	virtual void giveHull( HullObject * hnew );

	virtual bool needSpecial();
	virtual bool acceptSpecial();

	virtual Group * getGroup();
	
	//ammo - array of pointers to bullets
	//fight = array of pointers to ships
	virtual bool MoveMe( vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight, Section * onscreen,DATAFILE * snd);

	//process: changes check according to death of object
	virtual void Died(SpaceObject * check,ExplosionClass ** explr,int ME,DATAFILE * sd );

	//process: returns hull->life
	virtual double getLife();

	//returns alignment
	virtual int Team();

	//return dx and dy respectively
	virtual double getDX();
	virtual double getDY();

	//return accelx and accely respectively
	virtual double getAccelX();
	virtual double getAccelY();

	//process: sets the coordinates to x=ax, y=ay
	void SetCoordXY( int ax, int ay );

	//process: increments objects score
	virtual void IncScore( int j );

	//returns hull->drawlevel
	virtual int lookPlane();

	//process: returns whether or not object can be hit
	virtual bool CanbeHit( SpaceObject * ht );

	//forces object to have no group
	virtual void Independent();
	
	//gives the hull a weapon at slot num
	virtual void giveWeapon( WeaponObject * weap, int num );

	virtual void eraseWeapon( int num );

	virtual void Collided( SpaceObject * who, ExplosionClass ** explr, int M_EX );

	//adds an object to the collide list
	virtual void addCollide( SpaceObject * who );

	//check to see if the object is in the collide list
	virtual bool haveCollide( SpaceObject * who );

	//clears the collide list
	virtual void clearCollide();

	//destructor
	virtual ~SpaceObject();

	//returns an exact copy of this object
	virtual SpaceObject * copy();

	//draws self on the radar
	virtual void Radar( BITMAP * rad );

	virtual void setX( int x );
	virtual void setY( int y );
	virtual void setX( double x );
	virtual void setY( double y );
	virtual void setDX( double x );
	virtual void setDY( double y );
	virtual void setAccelX( double x );
	virtual void setAccelY( double y );
	virtual void setScore( int s );
	virtual void setStrength( int s );
	virtual void setPlane( int p );
	virtual void setAlignment( int a );
	
	virtual HullObject * getHull(); 

	virtual int getX();
	virtual int getY();
	virtual double getVX();
	virtual double getVY();
	virtual int getScore();
	virtual int getStrength();
	virtual int getPlane();
	virtual int getAlignment();

protected:

	int actualx, actualy;	// position in integer format
	double virtualx, virtualy; // position in double format
	double dx, dy; // velocity 
	double accel_x, accel_y; //acceleration
	int score;
	int str;

	int plane;
	int alignment;

	HullObject * hull;
	Group * my_group;

protected:
	vector< SpaceObject * > collide_list;

};

#endif
