__revision__ = "$Id: __init__.py,v 1.2 2002/07/17 22:58:14 jkloth Exp $"

from Ft.Lib.TestSuite import TestMode


class _ServerMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self,self.serverMode,self.default)

    def __call__(self,tester):
        tester.test_data['server-mode'] = self.serverMode
        self.func(tester)


class _PythonServerMode(_ServerMode):
    serverMode = 'Python'
    default = 1

    def _init(self,tester):
        return 1
    
class _ApacheServerMode(_ServerMode):
    serverMode = 'Apache'
    default = 0

    def _init(self,tester):
        tester.warning("Apache Server mode not supported")
        return 0

MODES = [_PythonServerMode(),_ApacheServerMode()]
