import os, tempfile

from Ft.Lib.CommandLine import CommandLineTestUtil
from Ft.Lib.Uri import OsPathToUri
from Ft.Server.Client import Core
from Server.Client.Core import test_helper

import test_prime

FIRST_RAWFILE = '/' + test_prime.BASE_CONTAINER + '/rf1'
FIRST_RAWFILE_ALIAS = '/' + test_prime.BASE_CONTAINER + '/rfa1'
SECOND_RAWFILE = '/' + test_prime.BASE_CONTAINER + '/rf2'


def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_RAWFILE):
            return 0
        tester.compare(RAW2,repo.fetchResource(FIRST_RAWFILE).getContent())
        tester.compare('text/foo',repo.fetchResource(FIRST_RAWFILE).getImt())
        return 1

    finally:
        repo.txRollback()

def val2(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(SECOND_RAWFILE):
            return 0
        tester.compare(RAW2,repo.fetchResource(SECOND_RAWFILE).getContent())
        return 1
    finally:
        repo.txRollback()

def val3(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_RAWFILE):
            return 0
        tester.compare(RAW3,repo.fetchResource(FIRST_RAWFILE).getContent())
        return 1

    finally:
        repo.txRollback()

def Init(repo):
    if repo.hasResource(FIRST_RAWFILE):
        repo.deleteResource(FIRST_RAWFILE)
    if repo.hasResource(FIRST_RAWFILE_ALIAS):
        repo.deleteResource(FIRST_RAWFILE_ALIAS,traverseAliases = 0)

    rf = repo.createRawFile(FIRST_RAWFILE,'text/text',RAW1)
    rf.addAlias(FIRST_RAWFILE_ALIAS)

    if repo.hasResource(SECOND_RAWFILE):
        repo.deleteResource(SECOND_RAWFILE)
    repo.createRawFile(SECOND_RAWFILE,'text/text',RAW1)


def Test(tester):

    tempFiles = []

    test_prime.InitRepo(tester,Init,['4ss','update','rawfile'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    try:

        fileName = tempfile.mktemp()
        f = open(fileName,'w')
        f.write(RAW2)
        f.close()
        fileNameUri = OsPathToUri(fileName)

        fileName2 = tempfile.mktemp()
        f = open(fileName2,'w')
        f.write(RAW3)
        f.close()
        fileNameUri2 = OsPathToUri(fileName2)

        tempFiles.append(fileName)
        tempFiles.append(fileName2)

        cfg = baseConfig.copy()
        cfg['imt'] = 'text/foo'
        tr1 = CommandLineTestUtil.TestRun('Basic Update',
                                          cfg,
                                          [FIRST_RAWFILE,fileNameUri],
                                          validationFunc = val1)

        #Update a raw file from stdin
        tr2 = CommandLineTestUtil.TestRun('STDIN Update',
                                          baseConfig,
                                          [SECOND_RAWFILE,'-'],
                                          validationFunc = val2,
                                          input=RAW2)

        #Update a RF that does not exist
        uri = test_prime.BASE_CONTAINER + '/foo'
        tr3 = CommandLineTestUtil.TestRun('Update Error',
                                          baseConfig,
                                          [uri,fileNameUri],
                                          expected_3%uri)

        tr4 = CommandLineTestUtil.TestRun('Alias Update',
                                          baseConfig,
                                          [FIRST_RAWFILE_ALIAS,fileNameUri2],
                                          validationFunc = val3)


        t = CommandLineTestUtil.Test('4ss update rawfile',[tr1,tr2,tr3,tr4])

        return t.test(tester)
    finally:
        for f in tempFiles:
            os.unlink(f)

import test_create_raw_file
RAW1 = test_create_raw_file.RAW1

RAW2 = """This is a text file with different content"""

RAW3 = """This is a text file with different content then the other different content"""

expected_3 = "Path /%s is unknown\n"

