import os

import os,sys, test_util
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import Database

odl_string = '''
const string TOP_LEVEL = "A String";
module Test {
  const boolean MODULE_LEVEL = true;
  class Student
  {
    attribute string name;
    const short CLASS_LEVEL = 15;
    const float CLASS_LEVEL_FLOAT = 3.14;
    const boolean CLASS_LEVEL_REFERENCE = Test::MODULE_LEVEL;
    const string CLASS_LEVEL_GLOBAL_REFERENCE = ::TOP_LEVEL;
  };

  const boolean TRUE = true;
  const boolean FALSE = false;

  const boolean b1 = true & true;
  const boolean b2 = true & false;
  const boolean b3 = false & true;
  const boolean b4 = false & false;
  const boolean br1 = TRUE & TRUE;
  const boolean br2 = TRUE & FALSE;
  const boolean br3 = FALSE & TRUE;
  const boolean br4 = FALSE & FALSE;


  const boolean bo1 = true | true;
  const boolean bo2 = true | false;
  const boolean bo3 = false | true;
  const boolean bo4 = false | false;
  const boolean bor1 = TRUE | TRUE;
  const boolean bor2 = TRUE | FALSE;
  const boolean bor3 = FALSE | TRUE;
  const boolean bor4 = FALSE | FALSE;


  const boolean bx1 = true ^ true;
  const boolean bx2 = true ^ false;
  const boolean bx3 = false ^ true;
  const boolean bx4 = false ^ false;
  const boolean bxr1 = TRUE ^ TRUE;
  const boolean bxr2 = TRUE ^ FALSE;
  const boolean bxr3 = FALSE ^ TRUE;
  const boolean bxr4 = FALSE ^ FALSE;

  const boolean nt = ~true;
  const boolean nf = ~false;

  const boolean pb1 = ~(true | false);
  const boolean pb2 = (~(true | false) & false);


  const short s1 = 6;
  const short s2 = -6;
  const short s3 = 1;

  const short ssl1 = 6 << 1;
  const short ssl2 = 6 << s3;
  const short ssl3 = s1 << 1;
  const short ssl4 = s1 << s3;

  const short ssr1 = 6 >> 1;
  const short ssr2 = 6 >> s3;
  const short ssr3 = s1 >> 1;
  const short ssr4 = s1 >> s3;

  const short sa1 = 6 + 6;
  const short sa2 = 6 + s1;
  const short sa3 = s1 + 6;
  const short sa4 = s1 + s2;
  const short sa5 = 6 - 6;
  const short sa6 = 6 - s1;
  const short sa7 = s1 - 6;
  const short sa8 = s1 - s2;

  const short sm1 = 6 * 6;
  const short sm2 = 6 * s1;
  const short sm3 = s1 * 6;
  const short sm4 = s1 * s2;
  const short sm5 = 6 / 6;
  const short sm6 = 6 / s1;
  const short sm7 = s1 / 6;
  const short sm8 = s1 / s2;
  const short sm9 = 6 % 6;
  const short sm10 = 6 % s1;
  const short sm11 = s1 % 6;
  const short sm12 = s1 % s2;

  const short su1 = +s1;
  const short su2 = -s1;
  const short su3 = +s2;
  const short su4 = -s2;

  const long l1 = 600;
  const long l2 = -600;
  const long l3 = 1;

  const long lsl1 = 600 << 1;
  const long lsl2 = 600 << l3;
  const long lsl3 = l1 << 1;
  const long lsl4 = l1 << l3;

  const long lsr1 = 600 >> 1;
  const long lsr2 = 600 >> l3;
  const long lsr3 = l1 >> 1;
  const long lsr4 = l1 >> l3;

  const long la1 = 600 + 600;
  const long la2 = 600 + l1;
  const long la3 = l1 + 600;
  const long la4 = l1 + l2;
  const long la5 = 600 - 600;
  const long la6 = 600 - l1;
  const long la7 = l1 - 600;
  const long la8 = l1 - l2;

  const long lm1 = 600 * 600;
  const long lm2 = 600 * l1;
  const long lm3 = l1 * 600;
  const long lm4 = l1 * l2;
  const long lm5 = 600 / 600;
  const long lm6 = 600 / l1;
  const long lm7 = l1 / 600;
  const long lm8 = l1 / l2;
  const long lm9 = 600 % 600;
  const long lm10 = 600 % l1;
  const long lm11 = l1 % 600;
  const long lm12 = l1 % l2;

  const long lu1 = +l1;
  const long lu2 = -l1;
  const long lu3 = +l2;
  const long lu4 = -l2;


  const float f1 = 1.2;
  const float f2 = -1.2;

  const float fa1 = 3.4 + 3.4;
  const float fa2 = 3.4 + f1;
  const float fa3 = f1 + 3.4;
  const float fa4 = f1 + f2;
  const float fa5 = 3.4 - 3.4;
  const float fa6 = 3.4 - f1;
  const float fa7 = f1 - 3.4;
  const float fa8 = f1 - f2;

  const float fm1 = 3.4 * 3.4;
  const float fm2 = 3.4 * f1;
  const float fm3 = f1 * 3.4;
  const float fm4 = f1 * f2;
  const float fm5 = 3.4 / 3.4;
  const float fm6 = 3.4 / f1;
  const float fm7 = f1 / 3.4;
  const float fm8 = f1 / f2;

  const float fu1 = +f1;
  const float fu2 = -f1;
  const float fu3 = +f2;
  const float fu4 = -f2;


  const string st1 = "Hello";
  const string st2 = "World";
  const short stt1 = 2;

  const string sta1 = "Hello" + "World";
  const string sta2 = "Hello" + st2;
  const string sta3 = st1 + "World";
  const string sta4 = st1 + st2;

  const string stm1 = "Hello" * 2;
  const string stm2 = "Hello" * stt1;
  const string stm3 = st1 * 2;
  const string stm4 = st1 * stt1;

};

'''

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        if os.path.exists('ODSGlobalDef.py'):
            os.unlink('ODSGlobalDef.py')
        if os.path.exists('ODSGlobalDef.pyc'):
            os.unlink('ODSGlobalDef.pyc')
        pass

def _Test(tester):

    tester.startGroup("Constants %s Driver" % tester.test_data['driver'])

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import Test
        from Test import Student
        import ODSGlobalDef
        reload(Test)
        reload(Student)
        reload(ODSGlobalDef)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()

    
    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()
        tester.startTest("Test Constant Values")
        tester.compare("A String", ODSGlobalDef.TOP_LEVEL,
                       "Invalid Top Level Constant")
        tester.compare(1, Test.MODULE_LEVEL,
                       "Invalid Module Level Constant")
        tester.compare(15, Student.CLASS_LEVEL,
                       "Invalid Class Level Constant")
        tester.compare(3.14, Student.CLASS_LEVEL_FLOAT,
                       "Invalid Class Level Float Constant")
        tester.compare(Test.MODULE_LEVEL, Student.CLASS_LEVEL_REFERENCE,
                       "Invalid Class Level Reference Constant")
        tester.compare(ODSGlobalDef.TOP_LEVEL, Student.CLASS_LEVEL_GLOBAL_REFERENCE,
                       "Invalid Class Level Global Reference Constant")

        tx.abort()
        tester.testDone()



        tx = db.new()
        tx.begin()
        tester.startTest("Test Boolean Constant Values")

        tester.compare(1, Test.b1)
        tester.compare(0, Test.b2)
        tester.compare(0, Test.b3)
        tester.compare(0, Test.b4)
        tester.compare(1, Test.br1)
        tester.compare(0, Test.br2)
        tester.compare(0, Test.br3)
        tester.compare(0, Test.br4)

        tester.compare(1, Test.bo1)
        tester.compare(1, Test.bo2)
        tester.compare(1, Test.bo3)
        tester.compare(0, Test.bo4)
        tester.compare(1, Test.bor1)
        tester.compare(1, Test.bor2)
        tester.compare(1, Test.bor3)
        tester.compare(0, Test.bor4)

        tester.compare(0, Test.bx1)
        tester.compare(1, Test.bx2)
        tester.compare(1, Test.bx3)
        tester.compare(0, Test.bx4)
        tester.compare(0, Test.bxr1)
        tester.compare(1, Test.bxr2)
        tester.compare(1, Test.bxr3)
        tester.compare(0, Test.bxr4)

        tester.compare(1, Test.nt)
        tester.compare(1, Test.nf)

        tester.compare(1, Test.pb1)
        tester.compare(0, Test.pb2)


        tester.testDone()

        tester.startTest("Short Expressions")
        tester.compare(6, Test.s1)
        tester.compare(-6, Test.s2)
        tester.compare(1, Test.s3)

        tester.compare(12, Test.ssl1)
        tester.compare(12, Test.ssl2)
        tester.compare(12, Test.ssl3)
        tester.compare(12, Test.ssl4)

        tester.compare(3, Test.ssr1)
        tester.compare(3, Test.ssr2)
        tester.compare(3, Test.ssr3)
        tester.compare(3, Test.ssr4)

        tester.compare(12, Test.sa1)
        tester.compare(12, Test.sa2)
        tester.compare(12, Test.sa3)
        tester.compare(0, Test.sa4)
        tester.compare(0, Test.sa5)
        tester.compare(0, Test.sa6)
        tester.compare(0, Test.sa7)
        tester.compare(12, Test.sa8)

        tester.compare(36, Test.sm1)
        tester.compare(36, Test.sm2)
        tester.compare(36, Test.sm3)
        tester.compare(-36, Test.sm4)
        tester.compare(1, Test.sm5)
        tester.compare(1, Test.sm6)
        tester.compare(1, Test.sm7)
        tester.compare(-1, Test.sm8)
        tester.compare(0, Test.sm9)
        tester.compare(0, Test.sm10)
        tester.compare(0, Test.sm11)
        tester.compare(0, Test.sm12)

        tester.compare(6, Test.su1)
        tester.compare(-6, Test.su2)
        tester.compare(6, Test.su3)
        tester.compare(6, Test.su4)

        tester.testDone()


        tester.startTest("Long Expressions")
        tester.compare(600,Test.l1)
        tester.compare(-600,Test.l2)
        tester.compare(1, Test.l3)

        tester.compare(1200, Test.lsl1)
        tester.compare(1200, Test.lsl2)
        tester.compare(1200, Test.lsl3)
        tester.compare(1200, Test.lsl4)

        tester.compare(300, Test.lsr1)
        tester.compare(300, Test.lsr2)
        tester.compare(300, Test.lsr3)
        tester.compare(300, Test.lsr4)

        tester.compare(1200, Test.la1)
        tester.compare(1200, Test.la2)
        tester.compare(1200, Test.la3)
        tester.compare(0, Test.la4)
        tester.compare(0, Test.la5)
        tester.compare(0, Test.la6)
        tester.compare(0, Test.la7)
        tester.compare(1200, Test.la8)

        tester.compare(360000, Test.lm1)
        tester.compare(360000, Test.lm2)
        tester.compare(360000, Test.lm3)
        tester.compare(-360000, Test.lm4)
        tester.compare(1, Test.lm5)
        tester.compare(1, Test.lm6)
        tester.compare(1, Test.lm7)
        tester.compare(-1, Test.lm8)
        tester.compare(0, Test.lm9)
        tester.compare(0, Test.lm10)
        tester.compare(0, Test.lm11)
        tester.compare(0, Test.lm12)

        tester.compare(600, Test.lu1)
        tester.compare(-600, Test.lu2)
        tester.compare(600, Test.lu3)
        tester.compare(600, Test.lu4)

        tester.testDone()


        tester.startTest("Float Expressions")
        tester.compare(1.2,Test.f1)
        tester.compare(-1.2,Test.f2)

        tester.compare(6.8, Test.fa1)
        tester.compare(4.6, Test.fa2)
        tester.compare(4.6, Test.fa3)
        tester.compare(0, Test.fa4)
        tester.compare(0, Test.fa5)
        tester.compare(2.2, Test.fa6)
        tester.compare(-2.2, Test.fa7)
        tester.compare(2.4, Test.fa8)

        tester.compare(11.56, Test.fm1)
        tester.compare(4.08, Test.fm2)
        tester.compare(4.08, Test.fm3)
        tester.compare(-1.44, Test.fm4)
        tester.compare(1, Test.fm5)
        tester.compare(2.83333333333, Test.fm6)
        tester.compare(0.352941176471, Test.fm7)
        tester.compare(-1, Test.fm8)

        tester.compare(1.2, Test.fu1)
        tester.compare(-1.2, Test.fu2)
        tester.compare(1.2, Test.fu3)
        tester.compare(1.2, Test.fu4)

        tester.testDone()


        tester.startTest("Float Expressions")
        tester.compare("Hello",Test.st1)
        tester.compare("World",Test.st2)

        tester.compare("HelloWorld", Test.sta1)
        tester.compare("HelloWorld", Test.sta2)
        tester.compare("HelloWorld", Test.sta3)
        tester.compare("HelloWorld", Test.sta4)

        tester.compare("HelloHello", Test.stm1)
        tester.compare("HelloHello", Test.stm2)
        tester.compare("HelloHello", Test.stm3)
        tester.compare("HelloHello", Test.stm4)
        tester.testDone()

        tx.abort()

    finally:
        db.close()
    tester.groupDone()
    return

