

from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import GlobalCache

import os, string, time
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

class DummyPO:
    _tupleTypes = ((Constants.Types.ROBJECT,),
                   (Constants.Types.ENUMERATION,),
                   (Constants.Types.STRING,),
                   (Constants.Types.STRING,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.SET_COLLECTION,),
                   (Constants.Types.ENUMERATION,),
                   )

    pass

def Test(tester):

    tester.startGroup("Global Cache %s Driver" % tester.test_data['driver'])
    tester.startTest("Init DB")
    mang = Adapters.GetManager()
    adapter = Adapters.GetAdapter()

    gc = GlobalCache.GlobalCache()
    
    if mang.exists(DBNAME):
        mang.reinit(DBNAME,adapter)
    else:
        mang.create(DBNAME)
        mang.init(DBNAME)

    tester.testDone()

    tester.startTest("Add a Repo Object")
    db = mang.connect(DBNAME)
    adapter.begin(db)
    try:
        adapter.newPythonClass(db,DummyPO)
        rid = adapter.newRepositoryObjectId(db,14,DummyPO)
        names = (('_repoId',), ('meta_kind',), ('name',), ('comment',), ('definedIn',), ('collections',), ('dictionaries',), ('specifiers',), ('unions',), ('operations',), ('properties',), ('constants',), ('type_defs',), ('primitive_kind',))
        values = ((rid,),(14,),("Test Type",),("Comment",),(0,),(0,),(0,),(0,),(0,),(0,),(0,),(0,),(0,),(3,))
        adapter.writeRepositoryObject(db,14,rid,DummyPO._tupleTypes,names,values)
    finally:
        adapter.commit(db)

    tester.testDone()

    tester.startTest("Get the Repo Object")
    #We need to pause for a second for machines that are fast,
    #or that don't have a small enough time granularity

    import time
    time.sleep(1)
    db = mang.connect(DBNAME)
    adapter.begin(db)
    try:
        tester.compare(None,gc.getObject(DBNAME,adapter,db,Constants.Types.ROBJECT,rid))
        _klass,data = adapter.getRepositoryObject(db,rid)
        gc.registerObject(DBNAME,Constants.Types.ROBJECT,rid,(_klass,data))
        tester.compare((_klass,data),gc.getObject(DBNAME,adapter,db,Constants.Types.ROBJECT,rid))
    
        tester.testDone()

        tester.startTest("Purge")

        gc.registerObject(DBNAME,Constants.Types.ROBJECT,rid,(_klass,data))
        gc.purge(DBNAME,time.time()-100)
        tester.compare((_klass,data),gc.getObject(DBNAME,adapter,db,Constants.Types.ROBJECT,rid))
        gc.purge(DBNAME,time.time()+1)
        tester.compare(None,gc.getObject(DBNAME,adapter,db,Constants.Types.ROBJECT,rid))
    finally:
        adapter.commit(db)

    tester.testDone()
    tester.groupDone()


