
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Expression
from Ft.Ods.MetaData import Literal
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_operand
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        test_operand.Test(tester,db,Expression.Expression)


        tester.startGroup("Expression Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_primitive_type(tester,db,Expression.Expression,'operator',"+")
        test_metadata_util.test_form_drop(tester,db,Expression.Expression,'the_operands',Literal.Literal,nSided=1)
        tester.groupDone()
    finally:
        db.close()




