<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fcore="http://xmlns.4suite.org/4ss/score"
    xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
    xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
    xmlns:exslt="http://exslt.org/common"
    xmlns:exslt-set="http://exslt.org/sets"
    xmlns:exslt-math="http://exslt.org/math"
    xmlns:exslt-functions="http://exslt.org/functions"
    xmlns:exslt-date-time="http://exslt.org/dates-and-times"
    xmlns:dc="&dc;"
    xmlns:fres="&fres;"
    xmlns:rdf="&rdf;"
    xmlns:f="&f;"
    extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <!--
File:  managerRequestProcessor.xslt

Description:

   4Suite Repository Dashboard
   Template that does most of the work for the manager

Copyright 2003 Fourthought Inc, USA.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->
  <xsl:include href="addForms.xslt"/>
  <xsl:output method="html" indent="yes"/>
  <xsl:template name="processAction">
    <xsl:variable name="emptyContainer"/>
    <xsl:variable name="textAreaSrc" select="fhttp:get-query-args()//textAreaSrc"/>
    <xsl:variable name="inputSrc">
      <xsl:choose>
        <xsl:when test="normalize-space(fhttp:get-query-args()//fileSrc)">
          <xsl:value-of select="fhttp:get-query-args()//fileSrc"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$textAreaSrc"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="parentContainer" select="fhttp:get-query-args()//parentContainer"/>
    <xsl:variable name="localName" select="fhttp:get-query-args()//localName"/>
    <xsl:variable name="docdef" select="fhttp:get-query-args()//docdef"/>
    <xsl:choose>
      <xsl:when test='$action = "changeUser"'>
        <!--Change User-->
        <xsl:variable name="message">
          <xsl:choose>
            <xsl:when test="fhttp:get-query-args()//name != document($managedResourcePath)/fres:User/@userName or normalize-space(fhttp:get-query-args()//new-password)">Modified+<xsl:value-of select="$managedResourcePath"/>
            </xsl:when>
            <xsl:otherwise>No+modification</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="fhttp:get-query-args()//name != document($managedResourcePath)/fres:User/@userName">
          <xsl:choose>
            <xsl:when test="fhttp:get-query-args()//new-password and (fhttp:get-query-args()//new-password = fhttp:get-query-args()//confirm-password)">
              <fcore:x-update path="{$managedResourcePath}">
                <xupdate:modifications version="1.0" xmlns:xupdate="http://www.xmldb.org/xupdate">
                  <xupdate:update select="/fres:User/@userName">
                    <xsl:value-of select="fhttp:get-query-args()//name"/>
                  </xupdate:update>
                  <xupdate:update select="/fres:User/fres:PasswdHash">
                    <xsl:value-of select="f:hash-string(fhttp:get-query-args()//new-password)"/>
                  </xupdate:update>
                </xupdate:modifications>
              </fcore:x-update>
            </xsl:when>
            <xsl:otherwise>
              <fcore:x-update path="{$managedResourcePath}">
                <xupdate:modifications version="1.0" xmlns:xupdate="http://www.xmldb.org/xupdate">
                  <xupdate:update select="/fres:User/@userName">
                    <xsl:value-of select="fhttp:get-query-args()//name"/>
                  </xupdate:update>
                </xupdate:modifications>
              </fcore:x-update>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <xsl:if test="normalize-space(fhttp:get-query-args()//new-password)">
          <xsl:choose>
            <xsl:when test="fhttp:get-query-args()//new-password = fhttp:get-query-args()/confirm-password">
              <fcore:change-password path="{$managedResourcePath}" new-password="{fhttp:get-query-args()//new-password}"/>
            </xsl:when>
            <xsl:otherwise>The passwords didnt match , try again.</xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message={$message}"/>
      </xsl:when>
      <xsl:when test='$action = "changeGroup"'>
        <!--Change Group-->
        <xsl:choose>
          <xsl:when test="fhttp:get-query-args()//submit = 'Add Member'">
            <fcore:add-member path="{$managedResourcePath}" member-path="{fhttp:get-query-args()//newUser}"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="fhttp:get-query-args()/*[starts-with(name(),'delete:')]">
              <xsl:variable name="deleteUri" select="substring-after(name(),'delete:')"/>
              <fcore:remove-member path="{$managedResourcePath}" member-path="{$deleteUri}"/>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
        <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message=Modified+group+{$managedResourcePath}"/>
      </xsl:when>
      <xsl:when test='$action = "addUser"'>
        <!--Add User-->
        <xsl:choose>
          <xsl:when test="fhttp:get-query-args()//new-password = fhttp:get-query-args()/confirm-password">
            <fcore:create-user username="{fhttp:get-query-args()//username}" password="{fhttp:get-query-args()//new-password}" base-path="{$parentContainer}"/>
          </xsl:when>
          <xsl:otherwise>The passwords didnt match , try again.</xsl:otherwise>
        </xsl:choose>
        <fhttp:response-uri uri="/?xslt=/ftss/dashboard/ServerFiles.xslt&amp;type=users&amp;metaContainer=1&amp;dashboard-message=New+user+added"/>
      </xsl:when>
      <xsl:when test='$action = "addGroup"'>
        <!--Add Group-->
        <fcore:create-group path="{fhttp:get-query-args()//groupname}" base-path="{$parentContainer}"/>
        <fhttp:response-uri uri="/?xslt=/ftss/dashboard/ServerFiles.xslt&amp;type=groups&amp;metaContainer=1&amp;dashboard-message=New+group+added"/>
      </xsl:when>
      <xsl:when test='$action = "containerAddOrRemove"'>
        <!--adding or removing a resource-->
        <xsl:choose>
          <xsl:when test="fhttp:get-query-args()//containerManagerSubmit = 'Add Resource'">
            <!-- adding a new resource (need a form)-->
            <xsl:choose>
              <xsl:when test='$newResourceType = "Xml"'>
                <xsl:call-template name="DocumentForms">
                  <xsl:with-param name="type" select='"XML"'/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test='$newResourceType = "Xslt"'>
                <xsl:call-template name="DocumentForms">
                  <xsl:with-param name="type" select='"XSLT"'/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test='$newResourceType = "Container"'>
                <xsl:call-template name="ContainerForm"/>
              </xsl:when>
              <xsl:when test='$newResourceType = "DocDef"'>
                <xsl:call-template name="DocumentForms">
                  <xsl:with-param name="type" select='"DocDef"'/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test='$newResourceType = "RdfDoc"'>
                <xsl:call-template name="DocumentForms">
                  <xsl:with-param name="type" select='"RDF"'/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test='$newResourceType = "File"'>
                <xsl:call-template name="fileForm"/>
              </xsl:when>
              <xsl:when test='$newResourceType = "Urireference"'>
                <xsl:call-template name="urireferenceForm"/>
              </xsl:when>
              <xsl:when test='$newResourceType = "User"'>
                <xsl:call-template name="userForm"/>
              </xsl:when>
              <xsl:when test='$newResourceType = "Group"'>
                <xsl:call-template name="groupForm"/>
              </xsl:when>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <!-- removing a resource -->
            <xsl:variable name="numDeleted" select="count(fhttp:get-query-args()/*[starts-with(name(),'delete:')])"/>
            <xsl:for-each select="fhttp:get-query-args()/*[starts-with(name(),'delete:')]">
              <xsl:variable name="deleteUri" select="substring-after(name(),'delete:')"/>
              <fcore:delete-resource path="{$deleteUri}"/>
            </xsl:for-each>
            <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message=Deleted+{$numDeleted}+resources"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- adding documents -->
      <xsl:when test='$action = "addXSLTDocument"'>
        <fcore:create-document path="{$localName}" base-path="{$parentContainer}" omit-xml-declaration="yes">
          <xsl:value-of disable-output-escaping="yes" select="$inputSrc"/>
        </fcore:create-document>
        <fhttp:response-uri uri="{f:resolve-path(  concat($parentContainer,'/'), $localName )}?dashboard-message=Managing+newly+added+XSLT+Document+{$localName}"/>
      </xsl:when>
      <xsl:when test='$action = "addXMLDocument"'>
        <fcore:create-document path="{$localName}" base-path="{$parentContainer}" docdef="{$docdef}" omit-xml-declaration="yes">
          <xsl:value-of select="$inputSrc" disable-output-escaping="yes"/>
        </fcore:create-document>
        <fhttp:response-uri uri="{f:resolve-path(  concat($parentContainer,'/'), $localName )}?dashboard-message=Managing+newly+added+XML+Document+{$localName}"/>
      </xsl:when>
      <xsl:when test='$action = "addRDFDocument"'>
        <fcore:create-document path="{$localName}" base-path="{$parentContainer}" omit-xml-declaration="yes">
          <xsl:value-of disable-output-escaping="yes" select="$inputSrc"/>
        </fcore:create-document>
        <fhttp:response-uri uri="{f:resolve-path(  concat($parentContainer,'/'), $localName )}?dashboard-message=Managing+newly+added+RDF+Document+{$localName}"/>
      </xsl:when>
      <xsl:when test='$action = "addDocDefDocument"'>
        <fcore:create-document path="{$localName}" base-path="{$parentContainer}" omit-xml-declaration="yes">
          <xsl:value-of disable-output-escaping="yes" select="$inputSrc"/>
        </fcore:create-document>
        <fhttp:response-uri uri="{f:resolve-path(  concat($parentContainer,'/'), $localName )}?dashboard-message=Managing+newly+added+Document+Definition+{$localName}"/>
      </xsl:when>
      <!-- Adding a rawfile-->
      <xsl:when test='$action = "addFile"'>
        <fcore:create-raw-file path="{$localName}" base-path="{$parentContainer}" media-type="{fhttp:get-query-args()//imt}">
          <xsl:value-of select="$inputSrc" disable-output-escaping="yes"/>
        </fcore:create-raw-file>
        <fhttp:response-uri uri="{$parentContainer}?nonXMLPath={f:resolve-path(  concat($parentContainer,'/'), $localName )}&amp;dashboard-message=Managing+newly+added+raw+file+{$localName}"/>
      </xsl:when>
      <!-- Adding a container -->
      <xsl:when test='$action = "addContainer"'>
        <fcore:create-container path="{$localName}" create-parents="yes" base-path="{$parentContainer}"/>
        <fhttp:response-uri uri="{f:resolve-path(  concat($parentContainer,'/'), $localName )}?dashboard-message=Browsing+newly+added+container+{$localName}"/>
      </xsl:when>
      <!--Changing a uri reference-->
      <xsl:when test='$action = "changeUriReferenceFile"'>
        <frdf:remove s="$managedResourcePath" p="'http://schemas.4suite.org/4ss#rawfile.imt'"/>
        <frdf:remove s="$managedResourcePath" p="'http://schemas.4suite.org/4ss#urireferencefile.location'"/>
        <frdf:add s="$managedResourcePath" p="'http://schemas.4suite.org/4ss#rawfile.imt'" o="fhttp:get-query-args()//imt"/>
        <frdf:add s="$managedResourcePath" p="'http://schemas.4suite.org/4ss#urireferencefile.location'" o="fhttp:get-query-args()//referenceuri"/>
        <fhttp:response-uri uri="/?nonXMLPath={$managedResourcePath}&amp;dashboard-message={$managedResourcePath}+was+modified"/>
      </xsl:when>
      <!--Changing a raw file-->
      <xsl:when test='$action = "changeRawFile"'>
        <fcore:set-content path="{$managedResourcePath}" literal-content="yes">
          <xsl:value-of select="$inputSrc" disable-output-escaping="yes"/>
        </fcore:set-content>
        <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message={$managedResourcePath}+was+modified"/>
      </xsl:when>
      <!--Changing a command-->
      <xsl:when test='$action = "changeCommand"'>
        <fcore:set-content path="{$managedResourcePath}">
          <xsl:value-of select="$inputSrc" disable-output-escaping="yes"/>
        </fcore:set-content>
        <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message={$managedResourcePath}+was+modified"/>
      </xsl:when>
      <!--Changing a server-->
      <xsl:when test="$action = 'changeServer'">
        <!-- changing a server -->
        <xsl:variable name="description" select="fhttp:get-query-args()//description"/>
        <xsl:variable name="running" select="fhttp:get-query-args()//running"/>
        <xsl:variable name="module" select="fhttp:get-query-args()//module"/>
        <xsl:variable name="handler" select="fhttp:get-query-args()//handler"/>
        <xsl:variable name="port" select="fhttp:get-query-args()//port"/>
        <xsl:variable name="serverAdmin" select="fhttp:get-query-args()//serverAdmin"/>
        <xsl:variable name="serverName" select="fhttp:get-query-args()//serverName"/>
        <xsl:variable name="logLevel" select="fhttp:get-query-args()//logLevel"/>
        <xsl:choose>
          <xsl:when test="fcore:has-resource($managedResourcePath)">
            <fcore:x-update path="{$managedResourcePath}">
              <xupdate:modifications version="1.0" xmlns:xupdate="http://www.xmldb.org/xupdate">
                <xupdate:update select="/fres:Server/dc:description">
                  <xsl:value-of select="$description"/>
                </xupdate:update>
                <xsl:choose>
                  <xsl:when test="$running = 'yes'">
                    <xupdate:update select="/fres:Server/fres:Status/@running">
                      <xsl:value-of select="1"/>
                    </xupdate:update>
                  </xsl:when>
                  <xsl:otherwise>
                    <xupdate:update select="/fres:Server/fres:Status/@running">
                      <xsl:value-of select="0"/>
                    </xupdate:update>
                  </xsl:otherwise>
                </xsl:choose>
                <xupdate:update select="/fres:Server/fres:Module">
                  <xsl:value-of select="$module"/>
                </xupdate:update>
                <xupdate:update select="/fres:Server/fres:Handler">
                  <xsl:value-of select="$handler"/>
                </xupdate:update>
                <xupdate:update select="/fres:Server/fres:Port">
                  <xsl:value-of select="$port"/>
                </xupdate:update>
                <xupdate:if test="/fres:Server/fres:ServerAdmin">
                  <xupdate:update select="/fres:Server/fres:ServerAdmin">
                    <xsl:value-of select="$serverAdmin"/>
                  </xupdate:update>
                </xupdate:if>
                <xupdate:if test="not(/fres:Server/fres:ServerAdmin)">
                  <xupdate:append select="/fres:Server">
                    <xupdate:element name="fres:ServerAdmin">
                      <xsl:value-of select="$serverAdmin"/>
                    </xupdate:element>
                  </xupdate:append>
                </xupdate:if>
                <xsl:choose>
                  <xsl:when test="normalize-space($serverAdmin)">
                    <xupdate:if test="/fres:Server/fres:ServerAdmin">
                      <xupdate:update select="/fres:Server/fres:ServerAdmin">
                        <xsl:value-of select="$serverAdmin"/>
                      </xupdate:update>
                    </xupdate:if>
                    <xupdate:if test="not(/fres:Server/fres:ServerAdmin)">
                      <xupdate:append select="/fres:Server">
                        <xupdate:element name="fres:ServerAdmin">
                          <xsl:value-of select="$serverAdmin"/>
                        </xupdate:element>
                      </xupdate:append>
                    </xupdate:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xupdate:remove select="/fres:Server/fres:ServerAdmin"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xupdate:update select="/fres:Server/fres:ServerName">
                  <xsl:value-of select="$serverName"/>
                </xupdate:update>
                <xupdate:update select="/fres:Server/fres:LogLevel">
                  <xsl:value-of select="$logLevel"/>
                </xupdate:update>
              </xupdate:modifications>
            </fcore:x-update>
            <fhttp:response-uri uri="{$managedResourcePath}?dashboard-message={$managedResourcePath}+was+modified"/>
          </xsl:when>
          <xsl:otherwise>
            <font color="red">Resource Doesnt Exist</font>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- adding a UriReference -->
      <xsl:when test="$action = 'addUriReference'">
        <fcore:create-uri-reference path="{$localName}" imt="{fhttp:get-query-args()//imt}" base-path="{$parentContainer}" source-uri="{fhttp:get-query-args()//referenceuri}"/>
        <fhttp:response-uri uri="{$parentContainer}?nonXMLPath={f:resolve-path(  concat($parentContainer,'/'), $localName )}&amp;dashboard-message=Managing+newly+added+Uri+reference+{$localName}"/>
      </xsl:when>
      <xsl:when test="$action = 'changeConfig'">
        <!-- changing Dashbaord configuration -->
        <fcore:set-content path="/ftss/dashboard/DashboardConfig.xml">
          <DashboardConfig>
            <tmp>
              <xsl:value-of select="normalize-space(fhttp:get-query-args()//tmp)"/>
            </tmp>
            <gvisExec>
              <xsl:value-of select="fhttp:get-query-args()//gvExec"/>
            </gvisExec>
            <DefaultManager>
              <xsl:value-of select="fhttp:get-query-args()//defaultManager"/>
            </DefaultManager>
            <Icons>
              <xsl:value-of select="fhttp:get-query-args()//showIcons"/>
            </Icons>
            <RotateGraph>
              <xsl:value-of select="fhttp:get-query-args()//rotate"/>
            </RotateGraph>
            <MaxGraphArcs>
              <xsl:value-of select="fhttp:get-query-args()//maxArcs"/>
            </MaxGraphArcs>
          </DashboardConfig>
        </fcore:set-content>
        <fhttp:response-uri uri="/ftss/dashboard/DashboardConfig.xml?action=configForm&amp;dashboard-message=Dashboard+configuration+changed"/>
      </xsl:when>
      <xsl:when test="$action = 'configForm'">
        <!-- Dashboard configuration view -->
        <table>
          <caption>Configure Dashboard (<a href="/ftss/dashboard/DashboardConfig.xml">view</a> configuration XML)</caption>
          <!--
          <tr>
            <th class="grayBar" align="right">Temporary workspace</th>
            <td>
              <xsl:choose>
                <xsl:when test="normalize-space(/DashboardConfig/tmp)">
                  <input type="text" value="{/DashboardConfig/tmp}" name="tmp" size="60"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="text" value="{concat(f:share-path(),'/','Temp')}" name="tmp" size="60"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          -->
          <tr>
            <th class="grayBar" align="right">'dot' Executable directory</th>
            <td>
              <xsl:choose>
                <xsl:when test="normalize-space(/DashboardConfig/gvisExec)">
                  <input size="60" type="text" value="{/DashboardConfig/gvisExec}" name="gvExec"/>
                </xsl:when>
                <xsl:otherwise>
                  <input size="60" type="text" value="{f:bin-path()}" name="gvExec"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <th class="grayBar" align="right">Default Manager (For all XML resources -- except containers)</th>
            <td>
              <select name="defaultManager">
                <xsl:choose>
                  <xsl:when test="/DashboardConfig/DefaultManager =  'Advanced'">
                    <option value="Advanced" selected="1">Advanced</option>
                    <option value="Basic">Basic (Edit XML)</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="Advanced">Advanced</option>
                    <option value="Basic" selected="1">Basic (Edit XML)</option>
                  </xsl:otherwise>
                </xsl:choose>
              </select>
            </td>
          </tr>
          <tr>
            <th class="grayBar" align="right">Display Icons?</th>
            <td>
              <select name="showIcons">
                <xsl:choose>
                  <xsl:when test="/DashboardConfig/Icons =  'Yes'">
                    <option value="Yes" selected="1">Yes</option>
                    <option value="No">No</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="Yes">Yes</option>
                    <option value="No" selected="1">No</option>
                  </xsl:otherwise>
                </xsl:choose>
              </select>
            </td>
          </tr>
          <tr>
            <th class="grayBar" align="right">Rotate RDF Graphs 90 degrees?</th>
            <td>
              <select name="rotate">
                <xsl:choose>
                  <xsl:when test="/DashboardConfig/RotateGraph =  'Yes'">
                    <option value="Yes" selected="1">Yes</option>
                    <option value="No">No</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="Yes">Yes</option>
                    <option value="No" selected="1">No</option>
                  </xsl:otherwise>
                </xsl:choose>
              </select>
            </td>
          </tr>
          <tr>
            <th class="grayBar" align="right">Maximum Graph Arcs</th>
            <td>
              <input size="30" type="text" value="{/DashboardConfig/MaxGraphArcs}" name="maxArcs"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" align="center">
              <input type="hidden" value="changeConfig" name="action"/>
              <input type="submit" value="Change Configuration"/>
            </td>
          </tr>
        </table>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="addResource"/>
</xsl:stylesheet>
