#!/usr/bin/python
########################################################################
#
# File Name:            initOdsDatabase.py
#
# Documentation:        http://docs.4suite.org/4ODS/initOdsDatabase.py.html
#
"""
WWW: http://4suite.org/4DOM         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"

import os, sys

from Ft.Ods.StorageManager import Adapters
from Ft.Ods.Parsers.Odl import Processor

def Init(connectString, odlFile, cpp=0,directory=None):

    file = open(odlFile)

    manager = Adapters.GetManager()
    if manager.exists(connectString):
        manager.destroy(connectString)

    adapter = Adapters.GetAdapter()
    manager.new(connectString, adapter)

    processor = Processor.Processor(connectString,directory=directory)
    processor.run(file)
