#!/usr/bin/python
########################################################################
#
# File Name:            GenerateCollection.py
#
# Documentation:        http://docs.4suite.org/4ODS/ParsedEnumType.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

import os, OdlUtil
from Ft.Ods import Constants, Collections
from Ft.Ods.MetaData import CollectionKind

# File creation algorithms
def GenerateStubs(coll, params,fileName,useName,toSet):
    """File creation algorithms"""


    outFile = open(fileName,'a')

    if coll.collection_kind == CollectionKind.ck_dictionary:
        outFile.write("\n# Begin Generation of Dictionary %s\n\n" % toSet)
    elif coll.collection_kind == CollectionKind.ck_string:
        if type(toSet) == type(()):
            toSet = toSet[1]
        outFile.write("\n# Begin Generation of FixedString %s\n\n" % toSet)
    else:
        outFile.write("\n# Begin Generation of Collection %s\n\n" % toSet)


    outFile.write("from Ft.Ods import Collections\n")
    outFile.write("from Ft.Ods import FixedString\n")
 
    if coll.collection_kind == CollectionKind.ck_dictionary:
        subtype = OdlUtil.NormalizeTypeDefinition(coll.subtype)
        keytype = OdlUtil.NormalizeTypeDefinition(coll.key_type)
        klass = Collections.g_collectionMapping[(coll._4ods_getOdmgType(),keytype._4ods_getOdmgType(),subtype._4ods_getOdmgType())]
        outFile.write("class _%sDictionary(Collections.%s):\n" % (coll.name,klass.__name__))
    elif coll.collection_kind == CollectionKind.ck_string:
        outFile.write("class _%sFixedString(FixedString.FixedString):\n" % (coll.name))
        outFile.write("    max_size = %d\n" % coll.max_size.value())
    else:
        subtype = OdlUtil.NormalizeTypeDefinition(coll.subtype)
        klass = Collections.g_collectionMapping[(0,coll._4ods_getOdmgType(),subtype._4ods_getOdmgType())]
        outFile.write("class _%sCollection(Collections.%s):\n" % (coll.name,klass.__name__))

    outFile.write("    _typeId = %d\n" % coll._4ods_getId())
    outFile.write("    _typeIds = (%d,)\n" % coll._4ods_getId())

    if coll.collection_kind == CollectionKind.ck_dictionary:
        outFile.write("def %s(db):\n" % toSet)
        keytype = OdlUtil.NormalizeTypeDefinition(coll.key_type)
        outFile.write("    return _%sDictionary(db,None,%d,%d,%d,%d,None)" % (coll.name,
                                                                              keytype._4ods_getOdmgType(),
                                                                              keytype._4ods_getId(),
                                                                              subtype._4ods_getOdmgType(),
                                                                              subtype._4ods_getId(),
                                                                              ))
    elif coll.collection_kind == CollectionKind.ck_string:
        outFile.write("def %s(db,value=''):\n" % toSet)
        outFile.write("    return _%sFixedString(db,value)" % (coll.name,
                                                                ))
    else:
        outFile.write("def %s(db):\n" % toSet)
        outFile.write("    return _%sCollection(db,None,%d,%d,None)" % (coll.name,subtype._4ods_getOdmgType(),subtype._4ods_getId()))



    if coll.collection_kind == CollectionKind.ck_dictionary:
        outFile.write("\n# End Generation of Dictionary %s\n\n" % toSet)
    elif coll.collection_kind == CollectionKind.ck_string:
        outFile.write("\n# End Generation of FixedString %s\n\n" % toSet)
        params.literalFiles.append((Constants.Types.FIXEDSTRING,fileName,['_%sFixedString'%coll.name]))

    else:
        outFile.write("\n# End Generation of Collection %s\n\n" % toSet)

    outFile.close()

    return








