import os
from distutils import util
from distutils.core import Command, DEBUG

class InstallLocalState(Command):

    command_name = 'install_localstate'
    user_options = []

    def initialize_options(self):
        self.install_dir = None
        return

    def finalize_options(self):
        self.set_undefined_options('install',
                                   ('install_localstate', 'install_dir'))
        self.localstate_files = self.distribution.localstate_files
        return

    def run(self):
        self.mkpath(self.install_dir)
        for dest, src in self.localstate_files:
            dest = os.path.join(self.install_dir, util.convert_path(dest))
            self.mkpath(dest)
            # If there is no file listed, the user must be
            # trying to create an empty directory.
            if src:
                self.copy_file(util.convert_path(src), dest)
        return

    def get_inputs(self):
        inputs = []
        for dest, src in self.localstate_files:
            inputs.append(util.convert_path(src))
        return inputs

    def get_outputs(self):
        outputs = []
        for dest, src in self.localstate_files:
            dest = os.path.join(self.install_dir, util.convert_path(dest))
            # If there is no file listed, the user must be
            # trying to create an empty directory.
            if src:
                dest = os.path.join(dest, os.path.basename(src))
            else:
                # Mark the entry as being a directory (needed for bdist_inno)
                dest = dest + os.sep
            outputs.append(dest)
        return outputs
