from twisted.trial import unittest
import os, sets

from MailPing import config, fileutil

class TestConfig(unittest.TestCase):
    def setUp(self):
        self.configdir = self.mktemp()
        os.mkdir(self.configdir)

    def testTimeFail(self):
        self.assertRaises(config.NoSuchConfigItem,
                          config.getTime,
                          self.configdir, 'not-exist')

    def testTimeDefault(self):
        class Unique:
            pass
        self.assertEquals(Unique,
                          config.getTime(self.configdir, 'not-exist',
                                         Unique))

    def testTimeOK(self):
        fileutil.writeFile(os.path.join(self.configdir, 'sometimes'),
                           '42\n')
        self.assertEquals(config.getTime(self.configdir, 'sometimes'),
                          42)


    def testEmailFail(self):
        self.assertRaises(config.NoSuchConfigItem,
                          config.getEmail,
                          self.configdir, 'not-exist')

    def testEmailDefault(self):
        class Unique:
            pass
        self.assertEquals(Unique,
                          config.getEmail(self.configdir, 'not-exist',
                                         Unique))

    def testEmailOK(self):
        fileutil.writeFile(os.path.join(self.configdir, 'sometimes'),
                           '42\n')
        self.assertEquals(config.getEmail(self.configdir, 'sometimes'),
                          '42')
