// $Id: NamespacePrefixMap.java,v 1.1 2002/04/25 18:13:08 bill Exp $

package com.jclark.xsl.om;

/**
 * associates Namespaces with prefixes
 */
public interface NamespacePrefixMap 
{
    /**
     *
     */
    NameTable getNameTable();

    /**
     * returns the two-part Name for the given qName
     * @param node -- provided for particularizing any Exception
     */
    Name expandAttributeName(String qName, Node node) throws XSLException;

    /**
     * returns the two-part Name for the given qName
     * @param node -- provided for particularizing any Exception
     */
    Name expandElementTypeName(String qName, Node node) throws XSLException;

    /**
     * record the association of a prefix to a namespace
     */
    NamespacePrefixMap bind(String prefix, String namespace);

    /**
     * identify the given namespace as the default namespace
     */
    NamespacePrefixMap bindDefault(String namespace);

    /**
     * remove the default namespace
     */
    NamespacePrefixMap unbindDefault();

    /**
     * removes the association of a prefix with a namespace
     */
    NamespacePrefixMap unbind(String prefix);

    /**
     * @return the default namespace (which needs no prefix)
     */
    String getDefaultNamespace();

    /**
     * @return the number of bindings in this map
     */
    int getSize();

    /**
     * @return the i'th prefix
     */
    String getPrefix(int i);

    /**
     * @return the i'th namespace
     */
    String getNamespace(int i);

    /**
     * @return the (first??) prefix bound to the given namespace (or null)
     */
    String getPrefix(String namespace);

    /**
     *  @return the namespace bound to the given prefix (or null)
     */
    String getNamespace(String prefix);
}

