#!/usr/bin/ruby
# make.mo - Create mo-files.
# Copyright (C) 2004 Masao Mutoh
# This file is distributed under the same license as Ruby-GetText-Package.

Dir.mkdir("locale") unless FileTest.exist?("locale")
Dir.glob("po/*/*.po") do |file|
  lang, basename = /po\/([\w\.]*)\/(.*)\.po/.match(file).to_a[1,2]
  localedir = "locale/#{lang}"
  Dir.mkdir(localedir) unless FileTest.exist?(localedir)
  localedir += "/LC_MESSAGES"
  Dir.mkdir(localedir) unless FileTest.exist?(localedir)
  cmd = "rmsgfmt po/#{lang}/#{basename}.po -o #{localedir}/#{basename}.mo"
  puts cmd
  system(cmd)
end


