#ifndef MOD_XMLRPC_H_
#define MOD_XMLRPC_H_

enum
{
	DEBUG_NONE = 0,
	DEBUG_ERR,
	DEBUG_WARN,
	DEBUG_INFO,
	DEBUG_TRACE,
};

extern int mod_xmlrpc_debug_lvl;

#define DPRINTF(level, fmt, args...)				\
do {								\
	if (mod_xmlrpc_debug_lvl >= (level)) {			\
		fprintf(stderr, "XMLRPC: " fmt, ##args);	\
		fflush(stderr);					\
	}							\
} while(0)

#define DWRITE(level, str, size)				\
do {								\
	if (mod_xmlrpc_debug_lvl >= (level)) {			\
		fwrite((const void *) (str), size, 1, stderr);	\
		fflush(stderr);					\
	}							\
} while(0)

#endif
