/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: csa_compat.h,v 1.56 2002/02/03 11:13:41 dolecek Exp $ */

#ifndef _CSA_COMPAT_H_
#define _CSA_COMPAT_H_

#include <sys/types.h>
#include <stdio.h>
#include "csa_config.h"

#ifdef _AIX
#ifdef HAVE_STRINGS_H
/* AIX 4.2 needs it for definition of str[n]casecmp() */
/* at least Solaris doesn't like to have it included, so include it on */
/* AIX only */
#include <strings.h>
#endif
#endif /* _AIX */

#ifdef HAVE_ALLOCA_H
/* Linux includes it automatically, but some other systems may not */
#include <alloca.h>
#endif

#ifndef __MSWIN__
#  if defined(__NT__) || defined(_WIN32) || defined(WIN32)
# 	define __MSWIN__	1
#  endif
#endif

/* note we can't rely on symbol ``unix'' to be defined under Un*x-like    */
/* OSes, so just blindly suppose we are on Un*x-like system if we are not */
/* under Windoze */
#ifndef __MSWIN__
#	define CSA_UNIX_LIKE 1
#endif

/* braindead MS VC++ 5.0 doesn't define __STDC__ for some uknown reason */
/* and there are quite a number of side effects if it's defined, so we must */
/* work-around it - die in pain, Microsoft ! */
#if defined(__STDC__) || defined(__cplusplus) || defined(__MSWIN__)
# define __ANSI_C__
#endif

/* function arguments stripping in prototypes for K&R cc */

/* __P is defined in <sys/cdefs.h> on BSD compatible systems */
#ifdef HAVE_SYS_CDEFS_H
#include <sys/cdefs.h>
#endif

#ifndef __P
# ifdef __ANSI_C__
#  define __P(x) x
# else
#  define __P(x) ()
# endif
#endif

/* support for compiling with C++ */
#ifdef __cplusplus
#define __CSA_BEGIN_DECLS	extern "C" {
#define __CSA_END_DECLS		}
#else
#define __CSA_BEGIN_DECLS
#define __CSA_END_DECLS
#endif /* __cplusplus */

/********************************************************************/
/* compilator and environment related bits - missing functions etc. */

#ifdef STAT_MACROS_BROKEN
#  undef S_ISDIR
#  define S_ISDIR(m)      ((m & 0170000) == 0040000)	  /* directory */
#  undef S_ISREG
#  define S_ISREG(m)      ((m & 0170000) == 0100000)      /* regular file */
#endif /* STAT_MACROS_BROKEN */

#ifndef HAVE_MEMCPY
#  define memcpy(d, s, n)	bcopy((s), (d), (n))
#  define memmove(d, s, n) 	bcopy ((s), (d), (n))
#  define memset(s, c, n)	bzero(s, n)
#endif

/* some systems provide strchr()/strrchr() some index()/rindex() - pick */
/* the right one */
#ifndef HAVE_STRCHR
#  define       strchr  index
#  define       strrchr rindex
#endif

__CSA_BEGIN_DECLS
#ifndef HAVE_STRSTR
char * csa_strstr __P((const char*, const char *));
#define strstr	csa_strstr
#endif
#ifndef HAVE_STRERROR
char * csa_strerror __P((int errno));
#define	strerror	csa_strerror
#endif
__CSA_END_DECLS

/******************************************************************/
/*			OS-dependant stuff			  */

#ifdef CSA_UNIX_LIKE

#define CSA_OS_TYPE		"Un*x"

/* gzip identifier for Unix */
#define CSA_OS_CODE		0x03

/* no special OS-specific initialization */
#define CSA_NO_INIT_COMPAT

/* network includes */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/telnet.h>
#include <arpa/inet.h>
#include <netdb.h>
/* undef STATUS (used when compiling with Apache) - <arpa/namser.h> */
/* defines STATUS */
#undef STATUS
#include <arpa/nameser.h> /* for INADDRSZ */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* path separator */
#define CSA_DIRDELIM	'/'

/* stat() is able to work if pathname contains extra slashes */
#define csa_stat	stat

/* alarm() and bind() work correctly */
#define CSA_AVOID_IODEADLOCK
#define CSA_BIND_CONNECTIONS

/* Unix doesn't care about type of device hidden behind descriptor, so     */
/* it's possible to use standard stdio functions for socket descriptor too */
/* #undef CSA_NEED_FAKE_STDIO */

/* socket can be closed just by plain close() under Un*x */
#undef closesocket
#define closesocket	close

#endif /* CSA_UNIX_LIKE */

#ifdef __MSWIN__

#define CSA_OS_TYPE		"MS Windows32"

/* gzip identifier for WIN32 */
#define CSA_OS_CODE		0x0b

/* I do need to load Winsock DLL before I can do any network stuff */
int csa_init_compat();

/* system-dependant includes */
#include <winsock.h>
#include <io.h>
#include <wchar.h>
#include <process.h>
#include <malloc.h>

/* path separator */
#define CSA_DIRDELIM	'\\'

/* MSWIN names are a bit different compared to Unix standards */
#undef strcasecmp
#undef strncasecmp
#define strcasecmp		_stricmp  
#define strncasecmp		_strnicmp   
#define vsnprintf		_vsnprintf
  
/* struct stat is _stat under MS VC++ 5.0 */
#undef stat
#define stat	_stat

/* macros for checking type of file stat(2)ted are not implemented yet (4.0) */
/* under MSLoose */
#undef S_ISREG
#undef S_ISDIR
#define S_ISREG(x)		(x & _S_IFMT)
#define S_ISDIR(x)		(x & _S_IFDIR)

/* it seems EADDRINUSE is not defined anywhere; Winsock's WSAEADDRINUSE */
/* has the same sense */
#define EADDRINUSE		WSAEADDRINUSE

/* alarm() is not implemented under MSWin, as of yet (4.0pl3) */
/* it seems it has not fit into Microsoft definition of what ``POSIX'' */
/* stands for */
/* there is some possibility to implement it using Win32 API's timers */
/* but it's not implemented yet */
#undef CSA_AVOID_IODEADLOCK

/* I didn't manage to bring bind to working; maybe semantics is other */
/* than on Unix and I'm not patient enough to find it */
/* it's okay to not use it; I just heard from friend bind(2)ed connections */
/* are a bit faster (and not tested it) */
#undef CSA_BIND_CONNECTIONS

/* standard stdio functions fail to work when descriptor is socket, so use */
/* my implementation, which is socket-aware */
#if defined(CSA_MUTACE_CGI) || defined(CSA_MUTACE_FASTCGI)
#define CSA_NEED_FAKE_STDIO
#endif

/* there is a bug in MSWin's stat(2) - if the filename ends with extra */
/* (back)slashes, it fails to stat(2) it */
/* so use a small wrapper, who takes the slashes out before calling stat(2) */
int csa_stat __P((const char *, struct stat *));

/* S_IXUSR, S_IXGRP & S_IXOTH are not defined by MS NT's <sys/stat.h>, */
/* so redefine it to something useful */
#define S_IXUSR		_S_IEXEC
#define S_IXGRP		_S_IEXEC
#define S_IXOTH		_S_IEXEC


/* on Windows, it isn't possible just close() socket, closesocket() */
/* has to be used */
/* #define closesocket	closesocket */

/* key under which CSacek stores its configuration */
#define CSA_REGSUBKEY "SOFTWARE\\CSacek"

#ifdef CSA_DEBUG
/* define this for csa_debug_start() and csa_init_compat() */
extern int csa_debug_uniqid;
#endif /* CSA_DEBUG */

#endif /* __MSWIN__ */


#ifdef CSA_MUTACE_ISAPI 

/* we need mutex routines for ISAPI CSacek */

#define CSA_THREADSAFE
#define CSA_MUTEXES
__CSA_BEGIN_DECLS
typedef void csa_mutex;
csa_mutex *csa_create_mutex __P((char *));
void csa_acquire_mutex __P((csa_mutex *));
void csa_release_mutex __P((csa_mutex *));
__CSA_END_DECLS

#endif /* CSA_MUTACE_ISAPI */


#if defined(CSA_MUTACE_APACHE) && defined(__MSWIN__)

/*
 * Under Apache for MS Windows, use Apache's own mutex routines.
 */

#define MULTITHREAD
#include <multithread.h>

#define CSA_THREADSAFE
#define csa_mutex		mutex
#define csa_create_mutex	ap_create_mutex
#define csa_acquire_mutex	ap_acquire_mutex
#define csa_release_mutex	ap_release_mutex

#endif /* APACHE && MSWINDOZE */


#ifdef CSA_THREADSAFE

__CSA_BEGIN_DECLS
#ifdef CSA_DEBUG
extern csa_mutex *csa_debuglog_mutex;
#endif /* CSA_DEBUG */
__CSA_END_DECLS

#else /* !CSA_THREADSAFE */

/* make this go away on systems where we don't need to be thread-safe */
#define csa_create_mutex(x)		(NULL)
#define csa_acquire_mutex(x)		
#define csa_release_mutex(x)

#endif/* CSA_THREADSAFE */


#ifdef CSA_NEED_FAKE_STDIO

typedef struct __csa_iobuf {
	char	*buf;		/* data buffer */
	int	 len;		/* length of buffer */
	int	 index;		/* where read/write data */
	int	 maxindex;	/* last data entry */
} csa_iobuf_t;

typedef struct __csa_FILE {
	int	desc;
	FILE	*FILE;
	short	 issocket;
	short	 flags;
#define CSA_IOEOF	1
#define CSA_IOERR	2
	csa_iobuf_t in_buf;
	csa_iobuf_t out_buf;
#define CSA_BUFLEN	1048
} csa_FILE_t;

#define CSA_SOCK_OP	"s"

__CSA_BEGIN_DECLS
char * csa_fgets __P((char *buf, int size, csa_FILE_t *fd));
int csa_fgetc __P((csa_FILE_t *fd));
size_t csa_fread __P((void *ptr, size_t size, size_t nmemb, csa_FILE_t *fd));
size_t csa_fwrite __P((const void *ptr, size_t size, size_t nmemb, csa_FILE_t *fd));
int csa_feof __P((csa_FILE_t *));
int csa_ferror __P((csa_FILE_t *));
csa_FILE_t * csa_fdopen __P((csa_params_t *p, int desc, const char *mode));
int csa_fprintf __P((csa_FILE_t *fd, char *fmt, ...));
int csa_fflush __P((csa_FILE_t *fd));
int csa_fclose __P((csa_FILE_t *fd));
int csa_set_fio __P((csa_params_t *, csa_FILE_t **, int issock, FILE *, int desc));
__CSA_END_DECLS

/* returns descriptor - for details see fileno(3) */
#define csa_fileno(fd) (fd->desc)

#else /* ! CSA_NEED_FAKE_STDIO */

/* OS doesn't care about type of device hidden under descriptor */
/* standard stdio functions can be used without modification */

#define CSA_SOCK_OP	"w+"

#define csa_fgets		fgets
#define	csa_fgetc		fgetc
#define csa_fputs		fputs
#define csa_fread		fread
#define csa_fwrite		fwrite
#define csa_feof		feof
#define csa_ferror		ferror
#define csa_fdopen(x, y, z)	fdopen((y), (z))
#define csa_fprintf	fprintf 
#define csa_fflush		fflush
#define csa_fclose		fclose

#define csa_FILE_t	FILE
#define csa_set_fio(params, pf, is, F, desc) (*(pf) = (F))

#define csa_fileno	fileno

#endif /* CSA_NEED_FAKE_STDIO */

/* some systems don't define this (Solaris 2.5 for example) */
#ifndef INADDR_NONE
#define INADDR_NONE	-1
#endif

/* some systems don't define this -- Digital Unix 3.2D and MS Windows NT */
/* serving as two shining examples */
#ifndef INADDRSZ
#define INADDRSZ	4
#endif

#if defined(CSA_MUTACE_APACHE) && !defined(CSA_USE_APACHE13_API)
/*
 * define stubs for Apache prior to 1.3, which introduced prefix ap_
 * to all Apache API functions
 */
#define ap_bcreate		bcreate
#define ap_bflush		bflush
#define ap_block_alarms		block_alarms
#define ap_bpushfd		bpushfd
#define ap_clear_pool		clear_pool
#define ap_clear_table		clear_table
#define ap_construct_url	construct_url
#define ap_destroy_pool		destroy_pool
#define ap_get_client_block	get_client_block
#define ap_get_module_config	get_module_config
#define ap_init_alloc		init_alloc
#define ap_log_reason		log_reason
#define ap_make_sub_pool	make_sub_pool
#define ap_make_table		make_table
#define ap_note_cleanups_for_file	note_cleanups_for_file
#define ap_palloc		palloc
#define ap_pcalloc		pcalloc
#define ap_pstrcat		pstrcat
#define ap_pstrdup		pstrdup
#define ap_pstrndup		pstrndup
#define ap_register_cleanup	register_cleanup
#define ap_rwrite		rwrite
#define ap_run_sub_req		run_sub_req
#define ap_send_http_header	send_http_header
#define ap_setup_client_block	setup_client_block
#define ap_should_client_block	should_client_block
#define ap_sub_req_lookup_file	sub_req_lookup_file
#define ap_table_addn(t,k,v)	table_add(t, (char *)k, (char *)v)
#define ap_table_do		table_do
#define ap_table_get		table_get
#define ap_table_set		table_set
#define ap_table_setn		table_set
#define ap_table_unset		table_unset
#define ap_unblock_alarms	unblock_alarms
#endif /* CSA_MUTACE_APACHE && !CSA_USE_APACHE13_API */


#ifndef HTTP_OK
/* following constants were taken directly from Apache 1.2's httpd.h */

/* following few codes are common to Apache 1.1.X+ */
#define HTTP_OK                            200
#define HTTP_MOVED_TEMPORARILY             302
#define HTTP_NOT_MODIFIED                  304
#define HTTP_BAD_REQUEST                   400
#define HTTP_UNAUTHORIZED                  401
#define HTTP_FORBIDDEN                     403
#define HTTP_NOT_FOUND                     404
#define HTTP_INTERNAL_SERVER_ERROR         500
#define HTTP_NOT_IMPLEMENTED               501
#define HTTP_BAD_GATEWAY                   502
#define HTTP_SERVICE_UNAVAILABLE           503

#ifdef CSA_USE_APACHE11_API
/* 301 Moved Permanently is not in Apache 1.1.X - remap it to */
/* 302 Moved Temporarily */
#define HTTP_MOVED_PERMANENTLY		HTTP_MOVED_TEMPORARILY

#else /* !CSA_USE_APACHE11_API */

/* these codes are supported in Apache 1.2.X+ */
#define HTTP_CONTINUE                      100
#define HTTP_SWITCHING_PROTOCOLS           101
#define HTTP_CREATED                       201
#define HTTP_ACCEPTED                      202
#define HTTP_NON_AUTHORITATIVE             203
#define HTTP_NO_CONTENT                    204
#define HTTP_RESET_CONTENT                 205
#define HTTP_PARTIAL_CONTENT               206
#define HTTP_MULTIPLE_CHOICES              300
#define HTTP_MOVED_PERMANENTLY             301
#define HTTP_SEE_OTHER                     303
#define HTTP_USE_PROXY                     305
#define HTTP_PAYMENT_REQUIRED              402
#define HTTP_METHOD_NOT_ALLOWED            405
#define HTTP_NOT_ACCEPTABLE                406
#define HTTP_PROXY_AUTHENTICATION_REQUIRED 407
#define HTTP_REQUEST_TIME_OUT              408
#define HTTP_CONFLICT                      409
#define HTTP_GONE                          410
#define HTTP_LENGTH_REQUIRED               411
#define HTTP_PRECONDITION_FAILED           412
#define HTTP_REQUEST_ENTITY_TOO_LARGE      413
#define HTTP_REQUEST_URI_TOO_LARGE         414
#define HTTP_UNSUPPORTED_MEDIA_TYPE        415
#define HTTP_GATEWAY_TIME_OUT              504
#define HTTP_VERSION_NOT_SUPPORTED         505
#define HTTP_VARIANT_ALSO_VARIES           506

#endif /* CSA_USE_APACHE11_API */

#endif /* !HTTP_OK */

#endif /* _CSA_COMPAT_H_ */
