/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ldapdiff.h"

int ldifbind(LDAP *ld)
{
 struct berval passwd;
 int msgid = 0;
 int rc;

 passwd.bv_val = ldifgetgconf(CONFROOTPW);
 passwd.bv_len = strlen(ldifgetgconf(CONFROOTPW));

 rc = ldap_sasl_bind(ld,
                     ldifgetgconf(CONFROOTDN),
                     LDAP_SASL_SIMPLE,
                     &passwd,
                     NULL,
                     NULL,
                     &msgid);

 printf("bind :%d %d\n",rc,msgid);
                
 return LDAP_SUCCESS;
}
