//LabPlot : FunctionDialog.h

#ifndef FUNCTIONDIALOG_H
#define FUNCTIONDIALOG_H

#include <klineedit.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include "Dialog.h"
#include "Worksheet.h"
#include "GraphListDialog.h"
#include "Graph2D.h"

class FunctionDialog: public Dialog
{
	Q_OBJECT
public:
	FunctionDialog(Worksheet *p, const char *name, ListDialog *l, int item, PType newtype);
public slots:
	int addFunction();	
	void setLabel() { labelle->setText(funle->text()); }
private slots :
	int agree();
	void ok_clicked() { if (!agree()) accept(); }
private:
	class MainWin *mw;
	KLineEdit *funle, *labelle, *xmin, *xmax, *ymin, *ymax, *nx, *ny;
	QCheckBox *reread;
	ListDialog *l;
	int item;
	PType type;
	Graph *graph;			// Graph
};
#endif //FUNCTIONDIALOG_H
