#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>


#include "entity.h"


static void
system_time_get_millisecond (ENode * node, gchar * attr)
{
    GTimeVal t;
    gchar buf[128];

    g_get_current_time (&t);

    g_snprintf (buf, 128, "%ld", t.tv_usec);
    enode_attrib_str (node, attr, buf);
}

static void
system_time_get_second (ENode * node, gchar * attr)
{
    struct tm *tm;
    time_t t;
    gchar buf[128];

    time (&t);
    tm = localtime (&t);

    g_snprintf (buf, 128, "%d", tm->tm_sec);
    enode_attrib_str (node, attr, buf);
}

static void
system_time_get_minute (ENode * node, gchar * attr)
{
    struct tm *tm;
    time_t t;
    gchar buf[128];

    time (&t);
    tm = localtime (&t);

    g_snprintf (buf, 128, "%d", tm->tm_min);
    enode_attrib_str (node, attr, buf);
}

static void
system_time_get_hour (ENode * node, gchar * attr)
{
    struct tm *tm;
    time_t t;
    gchar buf[128];

    time (&t);
    tm = localtime (&t);

    g_snprintf (buf, 128, "%d", tm->tm_hour);
    enode_attrib_str (node, attr, buf);
}

static GDate *
get_current_date (void)
{

    GDate *date;
    date = g_date_new ();

    g_date_set_time (date, time (NULL));
    return date;
}

static void
get_day (ENode * node, gchar * attr)
{
    gchar buf[128];
    GDate *date;

    date = get_current_date ();

    g_snprintf (buf, 128, "%d", (int) (date->day));
    enode_attrib_str (node, attr, buf);
}

static void
get_weekday (ENode * node, gchar * attr)
{
    gchar buf[128];
    GDate *date;

    date = get_current_date ();

    g_snprintf (buf, 128, "%d", (int) g_date_weekday (date));
    enode_attrib_str (node, attr, buf);
}

static void
get_month (ENode * node, gchar * attr)
{
    gchar buf[128];
    GDate *date;

    date = get_current_date ();

    g_snprintf (buf, 128, "%d", (int) (date->month));
    enode_attrib_str (node, attr, buf);
}

static void
get_year (ENode * node, gchar * attr)
{
    gchar buf[128];
    GDate *date;

    date = get_current_date ();

    g_snprintf (buf, 128, "%d", (int) (date->year));
    enode_attrib_str (node, attr, buf);
}

static void
get_leapyear (ENode * node, gchar * attr)
{
    GDate *date;

    date = get_current_date ();

    if (g_date_is_leap_year (date->year)) {
	enode_attrib_str (node, attr, "true");
    } else {
	enode_attrib_str (node, attr, "false");
    }
}

static void
get_cur_time (ENode * node, gchar * attr)
{
    struct tm *tm;
    time_t t;
    gchar buf[128];
    char *default_format = { "%r" };

    gchar *format = enode_attrib_str (node, "time-format", NULL);

    time (&t);
    tm = localtime (&t);

    if (format) {
	strftime ((char *) buf, 128, format, tm);
    } else {
	strftime ((char *) buf, 128, default_format, tm);
    }

    enode_attrib_str (node, attr, buf);
}

void
system_time_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->tag = "system-time";
    element->description = "Get system time information.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "milliseconds";
    e_attr->description = "Current millisecond.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = system_time_get_millisecond;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "seconds";
    e_attr->description = "Current second.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = system_time_get_second;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "minutes";
    e_attr->description = "Current minute.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = system_time_get_minute;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "hour";
    e_attr->description = "Current hour.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = system_time_get_hour;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "day";
    e_attr->description = "Current day.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = get_day;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "month";
    e_attr->description = "Current month.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = get_month;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "year";
    e_attr->description = "Current year.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = get_year;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "weekday";
    e_attr->description = "Current weekday (monday being the first day).";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = get_weekday;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "leapyear";
    e_attr->description = "Is current year a leapyear.";
    e_attr->value_desc = "boolean";
    e_attr->get_attr_func = get_leapyear;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "curtime";
    e_attr->description = "current time as specified by time-format.  Default"
	"is hours:minutes:seconds";
    e_attr->value_desc = "string";
    e_attr->get_attr_func = get_cur_time;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "time-format";
    e_attr->description = "Formatting string for curtime. See the strftime"
	" man page for details.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

}
