
/* implementation of tree construction functions */

#include "node.h"

#include "nodecode.h"

#include "attrpredef.h"

#include "visitmap.h"

#include "treeact.h"

#ifdef MONITOR
#include "attr_mon_dapto.h"
#endif

#include <stdlib.h>

#define _USE_OBSTACK 1

/* use of obstack: */

#if _USE_OBSTACK

#include "obstack.h"
static struct obstack TreeSpace;
static void *_TreeBase;

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	return obstack_alloc(&TreeSpace, size);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	return (char *)(obstack_alloc(&TreeSpace, size));
}
#endif

void InitTree()
{
	obstack_init(&TreeSpace);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

void FreeTree()
{
	obstack_free(&TreeSpace, _TreeBase);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

#else

#include <stdio.h>

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	void *retval = malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	char *retval = (char *) malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#endif

void InitTree() { }

void FreeTree() { }

#endif

#ifdef MONITOR
#define _SETCOORD(node) \
        node->_coord = _coordref ? *_coordref : NoCoord;
#define _COPYCOORD(node) \
        node->_coord = _currn->_desc1->_coord;
#else
#define _SETCOORD(node)
#define _COPYCOORD(node)
#endif
#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkCon (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkCon (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBCon)) return (_currn);
return(NULLNODEPTR);
}/* MkCon */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConProd (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConProd (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConProd)) return (_currn);
return(NULLNODEPTR);
}/* MkConProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConLHS (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConLHS (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConLHS)) return (_currn);
if (IsSymb (_currn, SYMBConIdent)) return (MkpConLHS(_coordref, _currn));
return(NULLNODEPTR);
}/* MkConLHS */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConAlt (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConAlt (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConAlt)) return (_currn);
return(NULLNODEPTR);
}/* MkConAlt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConElement (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConElement (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConElement)) return (_currn);
if (IsSymb (_currn, SYMBConText)) return (MkpConTextElt(_coordref, _currn));
if (IsSymb (_currn, SYMBConIdent)) return (MkpConIdnElt(_coordref, _currn));
return(NULLNODEPTR);
}/* MkConElement */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConIdent (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConIdent (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConIdent)) return (_currn);
return(NULLNODEPTR);
}/* MkConIdent */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConText (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConText (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConText)) return (_currn);
return(NULLNODEPTR);
}/* MkConText */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbs (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbs (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbs)) return (_currn);
return(NULLNODEPTR);
}/* MkAbs */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsProd (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsProd (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsProd)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsSignature (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsSignature (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsSignature)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsSignature */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsLHS (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsLHS (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsLHS)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsLHS */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsElements (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsElements (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsElements)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsElements */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsElement (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsElement (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsElement)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsElement */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsAlts (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsAlts (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsAlts)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsAlts */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAbsAlt (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAbsAlt (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAbsAlt)) return (_currn);
return(NULLNODEPTR);
}/* MkAbsAlt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkBottomUpRule (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkBottomUpRule (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBBottomUpRule)) return (_currn);
return(NULLNODEPTR);
}/* MkBottomUpRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMap (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMap (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMap)) return (_currn);
return(NULLNODEPTR);
}/* MkMap */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapSymbol (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapSymbol (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapSymbol)) return (_currn);
return(NULLNODEPTR);
}/* MkMapSymbol */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapRule (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapRule (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapRule)) return (_currn);
return(NULLNODEPTR);
}/* MkMapRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapChains (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapChains (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapChains)) return (_currn);
return(NULLNODEPTR);
}/* MkMapChains */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapMember (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapMember (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapMember)) return (_currn);
return(NULLNODEPTR);
}/* MkMapMember */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapMembers (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapMembers (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapMembers)) return (_currn);
return(NULLNODEPTR);
}/* MkMapMembers */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapProd (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapProd (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapProd)) return (_currn);
return(NULLNODEPTR);
}/* MkMapProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapReorder (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapReorder (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapReorder)) return (_currn);
return(NULLNODEPTR);
}/* MkMapReorder */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapLHS (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapLHS (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapLHS)) return (_currn);
return(NULLNODEPTR);
}/* MkMapLHS */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapDelim (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapDelim (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapDelim)) return (_currn);
return(NULLNODEPTR);
}/* MkMapDelim */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapAlt (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapAlt (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapAlt)) return (_currn);
return(NULLNODEPTR);
}/* MkMapAlt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapElement (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapElement (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapElement)) return (_currn);
return(NULLNODEPTR);
}/* MkMapElement */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapReorderAlt (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapReorderAlt (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapReorderAlt)) return (_currn);
return(NULLNODEPTR);
}/* MkMapReorderAlt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapPosition (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapPosition (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapPosition)) return (_currn);
return(NULLNODEPTR);
}/* MkMapPosition */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkMapText (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkMapText (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBMapText)) return (_currn);
return(NULLNODEPTR);
}/* MkMapText */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSource (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSource (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSource)) return (_currn);
if (IsSymb (_currn, SYMBCon)) return (Mkrule_008(_coordref, _currn));
if (IsSymb (_currn, SYMBAbs)) return (Mkrule_004(_coordref, _currn));
if (IsSymb (_currn, SYMBMap)) return (Mkrule_002(_coordref, _currn));
if (IsSymb (_currn, SYMBBottomUpRules)) return (Mkrule_001(_coordref, _currn));
return(NULLNODEPTR);
}/* MkSource */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkBottomUpRules (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkBottomUpRules (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBBottomUpRules)) return (_currn);
return(NULLNODEPTR);
}/* MkBottomUpRules */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkG15 (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkG15 (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBG15)) return (_currn);
return(NULLNODEPTR);
}/* MkG15 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConProd (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR MkpConProd (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPpConProd _currn;
#ifdef __cplusplus
_currn = new _TPpConProd;
#else
_currn = (_TPPpConProd) TreeNodeAlloc (sizeof (struct _TPpConProd));
#endif
_currn->_prod = RULEpConProd;
_currn->_desc1 = (_TSPConLHS) MkConLHS (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConProd: root of subtree no. 1 can not be made a ConLHS node ", 0, _coordref);
_currn->_desc2 = (_TSPConAlt) MkConAlt (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE pConProd: root of subtree no. 2 can not be made a ConAlt node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConProd;
return ( (NODEPTR) _currn);
}/* MkpConProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConLHS (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConLHS (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConLHS _currn;
#ifdef __cplusplus
_currn = new _TPpConLHS;
#else
_currn = (_TPPpConLHS) TreeNodeAlloc (sizeof (struct _TPpConLHS));
#endif
_currn->_prod = RULEpConLHS;
_currn->_desc1 = (_TSPConIdent) MkConIdent (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConLHS: root of subtree no. 1 can not be made a ConIdent node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_pConLHS;
return ( (NODEPTR) _currn);
}/* MkpConLHS */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConIdnElt (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConIdnElt (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConIdnElt _currn;
#ifdef __cplusplus
_currn = new _TPpConIdnElt;
#else
_currn = (_TPPpConIdnElt) TreeNodeAlloc (sizeof (struct _TPpConIdnElt));
#endif
_currn->_prod = RULEpConIdnElt;
_currn->_desc1 = (_TSPConIdent) MkConIdent (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConIdnElt: root of subtree no. 1 can not be made a ConIdent node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_pConIdnElt;
return ( (NODEPTR) _currn);
}/* MkpConIdnElt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConTextElt (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConTextElt (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConTextElt _currn;
#ifdef __cplusplus
_currn = new _TPpConTextElt;
#else
_currn = (_TPPpConTextElt) TreeNodeAlloc (sizeof (struct _TPpConTextElt));
#endif
_currn->_prod = RULEpConTextElt;
_currn->_desc1 = (_TSPConText) MkConText (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConTextElt: root of subtree no. 1 can not be made a ConText node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_pConTextElt;
return ( (NODEPTR) _currn);
}/* MkpConTextElt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConActionElt (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConActionElt (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConActionElt _currn;
#ifdef __cplusplus
_currn = new _TPpConActionElt;
#else
_currn = (_TPPpConActionElt) TreeNodeAlloc (sizeof (struct _TPpConActionElt));
#endif
_currn->_prod = RULEpConActionElt;
_currn->_desc1 = (_TSPConText) MkConText (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConActionElt: root of subtree no. 1 can not be made a ConText node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConActionElt;
return ( (NODEPTR) _currn);
}/* MkpConActionElt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConAtModIdn (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConAtModIdn (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConAtModIdn _currn;
#ifdef __cplusplus
_currn = new _TPpConAtModIdn;
#else
_currn = (_TPPpConAtModIdn) TreeNodeAlloc (sizeof (struct _TPpConAtModIdn));
#endif
_currn->_prod = RULEpConAtModIdn;
_currn->_desc1 = (_TSPConIdent) MkConIdent (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConAtModIdn: root of subtree no. 1 can not be made a ConIdent node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConAtModIdn;
return ( (NODEPTR) _currn);
}/* MkpConAtModIdn */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConAtModTxt (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConAtModTxt (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConAtModTxt _currn;
#ifdef __cplusplus
_currn = new _TPpConAtModTxt;
#else
_currn = (_TPPpConAtModTxt) TreeNodeAlloc (sizeof (struct _TPpConAtModTxt));
#endif
_currn->_prod = RULEpConAtModTxt;
_currn->_desc1 = (_TSPConText) MkConText (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConAtModTxt: root of subtree no. 1 can not be made a ConText node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConAtModTxt;
return ( (NODEPTR) _currn);
}/* MkpConAtModTxt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConDollarModIdn (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConDollarModIdn (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConDollarModIdn _currn;
#ifdef __cplusplus
_currn = new _TPpConDollarModIdn;
#else
_currn = (_TPPpConDollarModIdn) TreeNodeAlloc (sizeof (struct _TPpConDollarModIdn));
#endif
_currn->_prod = RULEpConDollarModIdn;
_currn->_desc1 = (_TSPConIdent) MkConIdent (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConDollarModIdn: root of subtree no. 1 can not be made a ConIdent node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConDollarModIdn;
return ( (NODEPTR) _currn);
}/* MkpConDollarModIdn */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConDollarModTxt (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpConDollarModTxt (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpConDollarModTxt _currn;
#ifdef __cplusplus
_currn = new _TPpConDollarModTxt;
#else
_currn = (_TPPpConDollarModTxt) TreeNodeAlloc (sizeof (struct _TPpConDollarModTxt));
#endif
_currn->_prod = RULEpConDollarModTxt;
_currn->_desc1 = (_TSPConText) MkConText (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pConDollarModTxt: root of subtree no. 1 can not be made a ConText node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pConDollarModTxt;
return ( (NODEPTR) _currn);
}/* MkpConDollarModTxt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConIdent (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpConIdent (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpConIdent _currn;
#ifdef __cplusplus
_currn = new _TPpConIdent;
#else
_currn = (_TPPpConIdent) TreeNodeAlloc (sizeof (struct _TPpConIdent));
#endif
_currn->_prod = RULEpConIdent;
_SETCOORD(_currn)
_TERMACT_pConIdent;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpConIdent */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpConText (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpConText (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpConText _currn;
#ifdef __cplusplus
_currn = new _TPpConText;
#else
_currn = (_TPPpConText) TreeNodeAlloc (sizeof (struct _TPpConText));
#endif
_currn->_prod = RULEpConText;
_SETCOORD(_currn)
_TERMACT_pConText;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Text", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpConText */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsProd (POSITION *_coordref, int _TERM1, NODEPTR _desc1)
#else
NODEPTR MkpAbsProd (_coordref, _TERM1,_desc1)
	POSITION *_coordref;
	int _TERM1;
	NODEPTR _desc1;
#endif
{	_TPPpAbsProd _currn;
#ifdef __cplusplus
_currn = new _TPpAbsProd;
#else
_currn = (_TPPpAbsProd) TreeNodeAlloc (sizeof (struct _TPpAbsProd));
#endif
_currn->_prod = RULEpAbsProd;
_currn->_desc1 = (_TSPAbsSignature) MkAbsSignature (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsProd: root of subtree no. 1 can not be made a AbsSignature node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pAbsProd;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsLHS (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpAbsLHS (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpAbsLHS _currn;
#ifdef __cplusplus
_currn = new _TPpAbsLHS;
#else
_currn = (_TPPpAbsLHS) TreeNodeAlloc (sizeof (struct _TPpAbsLHS));
#endif
_currn->_prod = RULEpAbsLHS;
_SETCOORD(_currn)
_TERMACT_pAbsLHS;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsLHS */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsEmptyRule (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpAbsEmptyRule (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpAbsEmptyRule _currn;
#ifdef __cplusplus
_currn = new _TPpAbsEmptyRule;
#else
_currn = (_TPPpAbsEmptyRule) TreeNodeAlloc (sizeof (struct _TPpAbsEmptyRule));
#endif
_currn->_prod = RULEpAbsEmptyRule;
_currn->_desc1 = (_TSPAbsLHS) MkAbsLHS (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsEmptyRule: root of subtree no. 1 can not be made a AbsLHS node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pAbsEmptyRule;
return ( (NODEPTR) _currn);
}/* MkpAbsEmptyRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsRule (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR MkpAbsRule (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPpAbsRule _currn;
#ifdef __cplusplus
_currn = new _TPpAbsRule;
#else
_currn = (_TPPpAbsRule) TreeNodeAlloc (sizeof (struct _TPpAbsRule));
#endif
_currn->_prod = RULEpAbsRule;
_currn->_desc1 = (_TSPAbsLHS) MkAbsLHS (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsRule: root of subtree no. 1 can not be made a AbsLHS node ", 0, _coordref);
_currn->_desc2 = (_TSPAbsElements) MkAbsElements (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsRule: root of subtree no. 2 can not be made a AbsElements node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pAbsRule;
return ( (NODEPTR) _currn);
}/* MkpAbsRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsEltIdn (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpAbsEltIdn (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpAbsEltIdn _currn;
#ifdef __cplusplus
_currn = new _TPpAbsEltIdn;
#else
_currn = (_TPPpAbsEltIdn) TreeNodeAlloc (sizeof (struct _TPpAbsEltIdn));
#endif
_currn->_prod = RULEpAbsEltIdn;
_SETCOORD(_currn)
_TERMACT_pAbsEltIdn;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsEltIdn */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsEltTxt (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpAbsEltTxt (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpAbsEltTxt _currn;
#ifdef __cplusplus
_currn = new _TPpAbsEltTxt;
#else
_currn = (_TPPpAbsEltTxt) TreeNodeAlloc (sizeof (struct _TPpAbsEltTxt));
#endif
_currn->_prod = RULEpAbsEltTxt;
_SETCOORD(_currn)
_TERMACT_pAbsEltTxt;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Text", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsEltTxt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsEltGen (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpAbsEltGen (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpAbsEltGen _currn;
#ifdef __cplusplus
_currn = new _TPpAbsEltGen;
#else
_currn = (_TPPpAbsEltGen) TreeNodeAlloc (sizeof (struct _TPpAbsEltGen));
#endif
_currn->_prod = RULEpAbsEltGen;
_SETCOORD(_currn)
_TERMACT_pAbsEltGen;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsEltGen */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsListof (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR MkpAbsListof (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPpAbsListof _currn;
#ifdef __cplusplus
_currn = new _TPpAbsListof;
#else
_currn = (_TPPpAbsListof) TreeNodeAlloc (sizeof (struct _TPpAbsListof));
#endif
_currn->_prod = RULEpAbsListof;
_currn->_desc1 = (_TSPAbsLHS) MkAbsLHS (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsListof: root of subtree no. 1 can not be made a AbsLHS node ", 0, _coordref);
_currn->_desc2 = (_TSPAbsAlts) MkAbsAlts (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE pAbsListof: root of subtree no. 2 can not be made a AbsAlts node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pAbsListof;
return ( (NODEPTR) _currn);
}/* MkpAbsListof */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpAbsAltIdn (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpAbsAltIdn (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpAbsAltIdn _currn;
#ifdef __cplusplus
_currn = new _TPpAbsAltIdn;
#else
_currn = (_TPPpAbsAltIdn) TreeNodeAlloc (sizeof (struct _TPpAbsAltIdn));
#endif
_currn->_prod = RULEpAbsAltIdn;
_SETCOORD(_currn)
_TERMACT_pAbsAltIdn;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpAbsAltIdn */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapSymbol (POSITION *_coordref, int _TERM1, NODEPTR _desc1)
#else
NODEPTR MkpMapSymbol (_coordref, _TERM1,_desc1)
	POSITION *_coordref;
	int _TERM1;
	NODEPTR _desc1;
#endif
{	_TPPpMapSymbol _currn;
#ifdef __cplusplus
_currn = new _TPpMapSymbol;
#else
_currn = (_TPPpMapSymbol) TreeNodeAlloc (sizeof (struct _TPpMapSymbol));
#endif
_currn->_prod = RULEpMapSymbol;
_currn->_desc1 = (_TSPMapMembers) MkMapMembers (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapSymbol: root of subtree no. 1 can not be made a MapMembers node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pMapSymbol;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpMapSymbol */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapProdReorder (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR MkpMapProdReorder (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPpMapProdReorder _currn;
#ifdef __cplusplus
_currn = new _TPpMapProdReorder;
#else
_currn = (_TPPpMapProdReorder) TreeNodeAlloc (sizeof (struct _TPpMapProdReorder));
#endif
_currn->_prod = RULEpMapProdReorder;
_currn->_desc1 = (_TSPMapProd) MkMapProd (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapProdReorder: root of subtree no. 1 can not be made a MapProd node ", 0, _coordref);
_currn->_desc2 = (_TSPMapReorder) MkMapReorder (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapProdReorder: root of subtree no. 2 can not be made a MapReorder node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pMapProdReorder;
return ( (NODEPTR) _currn);
}/* MkpMapProdReorder */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapProd (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR MkpMapProd (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPpMapProd _currn;
#ifdef __cplusplus
_currn = new _TPpMapProd;
#else
_currn = (_TPPpMapProd) TreeNodeAlloc (sizeof (struct _TPpMapProd));
#endif
_currn->_prod = RULEpMapProd;
_currn->_desc1 = (_TSPMapLHS) MkMapLHS (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapProd: root of subtree no. 1 can not be made a MapLHS node ", 0, _coordref);
_currn->_desc2 = (_TSPMapDelim) MkMapDelim (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapProd: root of subtree no. 2 can not be made a MapDelim node ", 0, _coordref);
_currn->_desc3 = (_TSPMapAlt) MkMapAlt (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapProd: root of subtree no. 3 can not be made a MapAlt node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pMapProd;
return ( (NODEPTR) _currn);
}/* MkpMapProd */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapIdnElt (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpMapIdnElt (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpMapIdnElt _currn;
#ifdef __cplusplus
_currn = new _TPpMapIdnElt;
#else
_currn = (_TPPpMapIdnElt) TreeNodeAlloc (sizeof (struct _TPpMapIdnElt));
#endif
_currn->_prod = RULEpMapIdnElt;
_SETCOORD(_currn)
_TERMACT_pMapIdnElt;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpMapIdnElt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapTextElt (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpMapTextElt (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpMapTextElt _currn;
#ifdef __cplusplus
_currn = new _TPpMapTextElt;
#else
_currn = (_TPPpMapTextElt) TreeNodeAlloc (sizeof (struct _TPpMapTextElt));
#endif
_currn->_prod = RULEpMapTextElt;
_SETCOORD(_currn)
_TERMACT_pMapTextElt;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Text", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpMapTextElt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapReorder (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR MkpMapReorder (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPpMapReorder _currn;
#ifdef __cplusplus
_currn = new _TPpMapReorder;
#else
_currn = (_TPPpMapReorder) TreeNodeAlloc (sizeof (struct _TPpMapReorder));
#endif
_currn->_prod = RULEpMapReorder;
_currn->_desc1 = (_TSPMapReorderAlt) MkMapReorderAlt (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE pMapReorder: root of subtree no. 1 can not be made a MapReorderAlt node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_pMapReorder;
return ( (NODEPTR) _currn);
}/* MkpMapReorder */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapPosition (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpMapPosition (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpMapPosition _currn;
#ifdef __cplusplus
_currn = new _TPpMapPosition;
#else
_currn = (_TPPpMapPosition) TreeNodeAlloc (sizeof (struct _TPpMapPosition));
#endif
_currn->_prod = RULEpMapPosition;
_SETCOORD(_currn)
_TERMACT_pMapPosition;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Integer", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpMapPosition */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpMapText (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpMapText (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpMapText _currn;
#ifdef __cplusplus
_currn = new _TPpMapText;
#else
_currn = (_TPPpMapText) TreeNodeAlloc (sizeof (struct _TPpMapText));
#endif
_currn->_prod = RULEpMapText;
_SETCOORD(_currn)
_TERMACT_pMapText;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Text", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpMapText */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_000 (POSITION *_coordref)
#else
NODEPTR Mkrule_000 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_000 _currn;
#ifdef __cplusplus
_currn = new _TPrule_000;
#else
_currn = (_TPPrule_000) TreeNodeAlloc (sizeof (struct _TPrule_000));
#endif
_currn->_prod = RULErule_000;
_SETCOORD(_currn)
_TERMACT_rule_000;
return ( (NODEPTR) _currn);
}/* Mkrule_000 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_001 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_001 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_001 _currn;
#ifdef __cplusplus
_currn = new _TPrule_001;
#else
_currn = (_TPPrule_001) TreeNodeAlloc (sizeof (struct _TPrule_001));
#endif
_currn->_prod = RULErule_001;
_currn->_desc1 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 1 can not be made a BottomUpRules node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_001;
return ( (NODEPTR) _currn);
}/* Mkrule_001 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_002 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_002 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_002 _currn;
#ifdef __cplusplus
_currn = new _TPrule_002;
#else
_currn = (_TPPrule_002) TreeNodeAlloc (sizeof (struct _TPrule_002));
#endif
_currn->_prod = RULErule_002;
_currn->_desc1 = (_TSPMap) MkMap (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_002: root of subtree no. 1 can not be made a Map node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_002;
return ( (NODEPTR) _currn);
}/* Mkrule_002 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_003 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_003 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_003 _currn;
#ifdef __cplusplus
_currn = new _TPrule_003;
#else
_currn = (_TPPrule_003) TreeNodeAlloc (sizeof (struct _TPrule_003));
#endif
_currn->_prod = RULErule_003;
_currn->_desc1 = (_TSPMap) MkMap (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_003: root of subtree no. 1 can not be made a Map node ", 0, _coordref);
_currn->_desc2 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_003: root of subtree no. 2 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_003;
return ( (NODEPTR) _currn);
}/* Mkrule_003 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_004 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_004 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_004 _currn;
#ifdef __cplusplus
_currn = new _TPrule_004;
#else
_currn = (_TPPrule_004) TreeNodeAlloc (sizeof (struct _TPrule_004));
#endif
_currn->_prod = RULErule_004;
_currn->_desc1 = (_TSPAbs) MkAbs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_004: root of subtree no. 1 can not be made a Abs node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_004;
return ( (NODEPTR) _currn);
}/* Mkrule_004 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_005 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_005 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_005 _currn;
#ifdef __cplusplus
_currn = new _TPrule_005;
#else
_currn = (_TPPrule_005) TreeNodeAlloc (sizeof (struct _TPrule_005));
#endif
_currn->_prod = RULErule_005;
_currn->_desc1 = (_TSPAbs) MkAbs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_005: root of subtree no. 1 can not be made a Abs node ", 0, _coordref);
_currn->_desc2 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_005: root of subtree no. 2 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_005;
return ( (NODEPTR) _currn);
}/* Mkrule_005 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_006 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_006 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_006 _currn;
#ifdef __cplusplus
_currn = new _TPrule_006;
#else
_currn = (_TPPrule_006) TreeNodeAlloc (sizeof (struct _TPrule_006));
#endif
_currn->_prod = RULErule_006;
_currn->_desc1 = (_TSPAbs) MkAbs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_006: root of subtree no. 1 can not be made a Abs node ", 0, _coordref);
_currn->_desc2 = (_TSPMap) MkMap (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_006: root of subtree no. 2 can not be made a Map node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_006;
return ( (NODEPTR) _currn);
}/* Mkrule_006 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_007 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_007 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_007 _currn;
#ifdef __cplusplus
_currn = new _TPrule_007;
#else
_currn = (_TPPrule_007) TreeNodeAlloc (sizeof (struct _TPrule_007));
#endif
_currn->_prod = RULErule_007;
_currn->_desc1 = (_TSPAbs) MkAbs (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_007: root of subtree no. 1 can not be made a Abs node ", 0, _coordref);
_currn->_desc2 = (_TSPMap) MkMap (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_007: root of subtree no. 2 can not be made a Map node ", 0, _coordref);
_currn->_desc3 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_007: root of subtree no. 3 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_007;
return ( (NODEPTR) _currn);
}/* Mkrule_007 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_008 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_008 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_008 _currn;
#ifdef __cplusplus
_currn = new _TPrule_008;
#else
_currn = (_TPPrule_008) TreeNodeAlloc (sizeof (struct _TPrule_008));
#endif
_currn->_prod = RULErule_008;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_008: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_008;
return ( (NODEPTR) _currn);
}/* Mkrule_008 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_009 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_009 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_009 _currn;
#ifdef __cplusplus
_currn = new _TPrule_009;
#else
_currn = (_TPPrule_009) TreeNodeAlloc (sizeof (struct _TPrule_009));
#endif
_currn->_prod = RULErule_009;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_009: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_009: root of subtree no. 2 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_009;
return ( (NODEPTR) _currn);
}/* Mkrule_009 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_010 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_010 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_010 _currn;
#ifdef __cplusplus
_currn = new _TPrule_010;
#else
_currn = (_TPPrule_010) TreeNodeAlloc (sizeof (struct _TPrule_010));
#endif
_currn->_prod = RULErule_010;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_010: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPMap) MkMap (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_010: root of subtree no. 2 can not be made a Map node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_010;
return ( (NODEPTR) _currn);
}/* Mkrule_010 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_011 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_011 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_011 _currn;
#ifdef __cplusplus
_currn = new _TPrule_011;
#else
_currn = (_TPPrule_011) TreeNodeAlloc (sizeof (struct _TPrule_011));
#endif
_currn->_prod = RULErule_011;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_011: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPMap) MkMap (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_011: root of subtree no. 2 can not be made a Map node ", 0, _coordref);
_currn->_desc3 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_011: root of subtree no. 3 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_011;
return ( (NODEPTR) _currn);
}/* Mkrule_011 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_012 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_012 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_012 _currn;
#ifdef __cplusplus
_currn = new _TPrule_012;
#else
_currn = (_TPPrule_012) TreeNodeAlloc (sizeof (struct _TPrule_012));
#endif
_currn->_prod = RULErule_012;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_012: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPAbs) MkAbs (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_012: root of subtree no. 2 can not be made a Abs node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_012;
return ( (NODEPTR) _currn);
}/* Mkrule_012 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_013 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_013 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_013 _currn;
#ifdef __cplusplus
_currn = new _TPrule_013;
#else
_currn = (_TPPrule_013) TreeNodeAlloc (sizeof (struct _TPrule_013));
#endif
_currn->_prod = RULErule_013;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPAbs) MkAbs (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 2 can not be made a Abs node ", 0, _coordref);
_currn->_desc3 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 3 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_013;
return ( (NODEPTR) _currn);
}/* Mkrule_013 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_014 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_014 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_014 _currn;
#ifdef __cplusplus
_currn = new _TPrule_014;
#else
_currn = (_TPPrule_014) TreeNodeAlloc (sizeof (struct _TPrule_014));
#endif
_currn->_prod = RULErule_014;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_014: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPAbs) MkAbs (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_014: root of subtree no. 2 can not be made a Abs node ", 0, _coordref);
_currn->_desc3 = (_TSPMap) MkMap (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_014: root of subtree no. 3 can not be made a Map node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_014;
return ( (NODEPTR) _currn);
}/* Mkrule_014 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_015 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3, NODEPTR _desc4)
#else
NODEPTR Mkrule_015 (_coordref,_desc1,_desc2,_desc3,_desc4)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
	NODEPTR _desc4;
#endif
{	_TPPrule_015 _currn;
#ifdef __cplusplus
_currn = new _TPrule_015;
#else
_currn = (_TPPrule_015) TreeNodeAlloc (sizeof (struct _TPrule_015));
#endif
_currn->_prod = RULErule_015;
_currn->_desc1 = (_TSPCon) MkCon (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_015: root of subtree no. 1 can not be made a Con node ", 0, _coordref);
_currn->_desc2 = (_TSPAbs) MkAbs (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_015: root of subtree no. 2 can not be made a Abs node ", 0, _coordref);
_currn->_desc3 = (_TSPMap) MkMap (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_015: root of subtree no. 3 can not be made a Map node ", 0, _coordref);
_currn->_desc4 = (_TSPBottomUpRules) MkBottomUpRules (_coordref, _desc4);	
if (((NODEPTR)_currn->_desc4) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_015: root of subtree no. 4 can not be made a BottomUpRules node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_015;
return ( (NODEPTR) _currn);
}/* Mkrule_015 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_016 (POSITION *_coordref)
#else
NODEPTR Mkrule_016 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_016 _currn;
#ifdef __cplusplus
_currn = new _TPrule_016;
#else
_currn = (_TPPrule_016) TreeNodeAlloc (sizeof (struct _TPrule_016));
#endif
_currn->_prod = RULErule_016;
_SETCOORD(_currn)
_TERMACT_rule_016;
return ( (NODEPTR) _currn);
}/* Mkrule_016 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_017 (POSITION *_coordref)
#else
NODEPTR Mkrule_017 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_017 _currn;
#ifdef __cplusplus
_currn = new _TPrule_017;
#else
_currn = (_TPPrule_017) TreeNodeAlloc (sizeof (struct _TPrule_017));
#endif
_currn->_prod = RULErule_017;
_SETCOORD(_currn)
_TERMACT_rule_017;
return ( (NODEPTR) _currn);
}/* Mkrule_017 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_018 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_018 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_018 _currn;
#ifdef __cplusplus
_currn = new _TPrule_018;
#else
_currn = (_TPPrule_018) TreeNodeAlloc (sizeof (struct _TPrule_018));
#endif
_currn->_prod = RULErule_018;
_currn->_desc1 = (_TSPG15) MkG15 (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_018: root of subtree no. 1 can not be made a G15 node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_018;
return ( (NODEPTR) _currn);
}/* Mkrule_018 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_019 (POSITION *_coordref)
#else
NODEPTR Mkrule_019 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_019 _currn;
#ifdef __cplusplus
_currn = new _TPrule_019;
#else
_currn = (_TPPrule_019) TreeNodeAlloc (sizeof (struct _TPrule_019));
#endif
_currn->_prod = RULErule_019;
_SETCOORD(_currn)
_TERMACT_rule_019;
return ( (NODEPTR) _currn);
}/* Mkrule_019 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_020 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_020 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_020 _currn;
#ifdef __cplusplus
_currn = new _TPrule_020;
#else
_currn = (_TPPrule_020) TreeNodeAlloc (sizeof (struct _TPrule_020));
#endif
_currn->_prod = RULErule_020;
_currn->_desc1 = (_TSPG15) MkG15 (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_020: root of subtree no. 1 can not be made a G15 node ", 0, _coordref);
_currn->_desc2 = (_TSPBottomUpRule) MkBottomUpRule (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_020: root of subtree no. 2 can not be made a BottomUpRule node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_020;
return ( (NODEPTR) _currn);
}/* Mkrule_020 */

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkConProdrule_1 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkConProdrule_1 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_ConProdrule_1 _new;
#ifdef __cplusplus
	_new = new _TPLST_ConProdrule_1;
#else
	_new = (_TPPLST_ConProdrule_1) TreeNodeAlloc (sizeof (struct _TPLST_ConProdrule_1));
#endif
	_new->_prod = RULELST_ConProdrule_1;
	_new->_desc1 = (_TSPConProd)elem;
	_new->_desc2 = (_TSPLST_Con)_new;
	{_TPPLST_ConProdrule_1 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_ConProdrule_1;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_1 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_1 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBConProd)) 
		return _MkConProdrule_1 (_coordref, MkConProd (_coordref, t));
	message (DEADLY, "a rule_1 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_1 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_1 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_Con)
	l =_Elemrule_1 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_Con)
	r = _Elemrule_1 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_1)r)->_desc2);
((_TPPLST_0rule_1)r)->_desc2 = ((_TPPLST_0rule_1)l)->_desc2;
((_TPPLST_0rule_1)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_1 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_1 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_1 root;
	_TPPLST_0rule_1 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_1)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_Con)
		t = _Elemrule_1 (_coordref, t);
	remain = (_TPPLST_0rule_1)(((_TPPLST_0rule_1) t)->_desc2);
	((_TPPLST_0rule_1) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_1;
#else
list = (_TPPLST_0rule_1) TreeNodeAlloc (sizeof (struct _TPLST_0rule_1));
#endif
list->_prod = RULELST_0rule_1;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_1)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_ConProdrule_1)
	{_TPPLST_ConProdrule_1 _currn = _currn;
	 _TERMACT_LST_ConProdrule_1;
	} this code has been moved to _Elemrule_1*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_1;
#else
root = (_TPPrule_1) TreeNodeAlloc (sizeof (struct _TPrule_1));
#endif
root->_prod = RULErule_1;
root->_desc1 = (_TSPLST_Con)list;
{ _TPPrule_1 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_1;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkConElementrule_2 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkConElementrule_2 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_ConElementrule_2 _new;
#ifdef __cplusplus
	_new = new _TPLST_ConElementrule_2;
#else
	_new = (_TPPLST_ConElementrule_2) TreeNodeAlloc (sizeof (struct _TPLST_ConElementrule_2));
#endif
	_new->_prod = RULELST_ConElementrule_2;
	_new->_desc1 = (_TSPConElement)elem;
	_new->_desc2 = (_TSPLST_ConAlt)_new;
	{_TPPLST_ConElementrule_2 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_ConElementrule_2;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_2 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_2 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBConText)) 
		return _MkConElementrule_2 (_coordref, MkConElement (_coordref, t));
	if (IsSymb (t, SYMBConElement)) 
		return _MkConElementrule_2 (_coordref, MkConElement (_coordref, t));
	if (IsSymb (t, SYMBConIdent)) 
		return _MkConElementrule_2 (_coordref, MkConElement (_coordref, t));
	message (DEADLY, "a rule_2 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_2 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_2 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_ConAlt)
	l =_Elemrule_2 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_ConAlt)
	r = _Elemrule_2 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_2)r)->_desc2);
((_TPPLST_0rule_2)r)->_desc2 = ((_TPPLST_0rule_2)l)->_desc2;
((_TPPLST_0rule_2)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_2 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_2 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_2 root;
	_TPPLST_0rule_2 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_2)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_ConAlt)
		t = _Elemrule_2 (_coordref, t);
	remain = (_TPPLST_0rule_2)(((_TPPLST_0rule_2) t)->_desc2);
	((_TPPLST_0rule_2) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_2;
#else
list = (_TPPLST_0rule_2) TreeNodeAlloc (sizeof (struct _TPLST_0rule_2));
#endif
list->_prod = RULELST_0rule_2;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_2)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_ConElementrule_2)
	{_TPPLST_ConElementrule_2 _currn = _currn;
	 _TERMACT_LST_ConElementrule_2;
	} this code has been moved to _Elemrule_2*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_2;
#else
root = (_TPPrule_2) TreeNodeAlloc (sizeof (struct _TPrule_2));
#endif
root->_prod = RULErule_2;
root->_desc1 = (_TSPLST_ConAlt)list;
{ _TPPrule_2 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_2;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkAbsProdrule_3 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkAbsProdrule_3 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_AbsProdrule_3 _new;
#ifdef __cplusplus
	_new = new _TPLST_AbsProdrule_3;
#else
	_new = (_TPPLST_AbsProdrule_3) TreeNodeAlloc (sizeof (struct _TPLST_AbsProdrule_3));
#endif
	_new->_prod = RULELST_AbsProdrule_3;
	_new->_desc1 = (_TSPAbsProd)elem;
	_new->_desc2 = (_TSPLST_Abs)_new;
	{_TPPLST_AbsProdrule_3 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_AbsProdrule_3;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_3 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_3 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBAbsProd)) 
		return _MkAbsProdrule_3 (_coordref, MkAbsProd (_coordref, t));
	message (DEADLY, "a rule_3 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_3 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_3 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_Abs)
	l =_Elemrule_3 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_Abs)
	r = _Elemrule_3 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_3)r)->_desc2);
((_TPPLST_0rule_3)r)->_desc2 = ((_TPPLST_0rule_3)l)->_desc2;
((_TPPLST_0rule_3)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_3 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_3 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_3 root;
	_TPPLST_0rule_3 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_3)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_Abs)
		t = _Elemrule_3 (_coordref, t);
	remain = (_TPPLST_0rule_3)(((_TPPLST_0rule_3) t)->_desc2);
	((_TPPLST_0rule_3) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_3;
#else
list = (_TPPLST_0rule_3) TreeNodeAlloc (sizeof (struct _TPLST_0rule_3));
#endif
list->_prod = RULELST_0rule_3;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_3)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_AbsProdrule_3)
	{_TPPLST_AbsProdrule_3 _currn = _currn;
	 _TERMACT_LST_AbsProdrule_3;
	} this code has been moved to _Elemrule_3*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_3;
#else
root = (_TPPrule_3) TreeNodeAlloc (sizeof (struct _TPrule_3));
#endif
root->_prod = RULErule_3;
root->_desc1 = (_TSPLST_Abs)list;
{ _TPPrule_3 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_3;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkAbsElementrule_4 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkAbsElementrule_4 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_AbsElementrule_4 _new;
#ifdef __cplusplus
	_new = new _TPLST_AbsElementrule_4;
#else
	_new = (_TPPLST_AbsElementrule_4) TreeNodeAlloc (sizeof (struct _TPLST_AbsElementrule_4));
#endif
	_new->_prod = RULELST_AbsElementrule_4;
	_new->_desc1 = (_TSPAbsElement)elem;
	_new->_desc2 = (_TSPLST_AbsElements)_new;
	{_TPPLST_AbsElementrule_4 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_AbsElementrule_4;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_4 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_4 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBAbsElement)) 
		return _MkAbsElementrule_4 (_coordref, MkAbsElement (_coordref, t));
	message (DEADLY, "a rule_4 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_4 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_4 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_AbsElements)
	l =_Elemrule_4 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_AbsElements)
	r = _Elemrule_4 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_4)r)->_desc2);
((_TPPLST_0rule_4)r)->_desc2 = ((_TPPLST_0rule_4)l)->_desc2;
((_TPPLST_0rule_4)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_4 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_4 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_4 root;
	_TPPLST_0rule_4 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_4)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_AbsElements)
		t = _Elemrule_4 (_coordref, t);
	remain = (_TPPLST_0rule_4)(((_TPPLST_0rule_4) t)->_desc2);
	((_TPPLST_0rule_4) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_4;
#else
list = (_TPPLST_0rule_4) TreeNodeAlloc (sizeof (struct _TPLST_0rule_4));
#endif
list->_prod = RULELST_0rule_4;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_4)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_AbsElementrule_4)
	{_TPPLST_AbsElementrule_4 _currn = _currn;
	 _TERMACT_LST_AbsElementrule_4;
	} this code has been moved to _Elemrule_4*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_4;
#else
root = (_TPPrule_4) TreeNodeAlloc (sizeof (struct _TPrule_4));
#endif
root->_prod = RULErule_4;
root->_desc1 = (_TSPLST_AbsElements)list;
{ _TPPrule_4 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_4;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkAbsAltrule_5 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkAbsAltrule_5 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_AbsAltrule_5 _new;
#ifdef __cplusplus
	_new = new _TPLST_AbsAltrule_5;
#else
	_new = (_TPPLST_AbsAltrule_5) TreeNodeAlloc (sizeof (struct _TPLST_AbsAltrule_5));
#endif
	_new->_prod = RULELST_AbsAltrule_5;
	_new->_desc1 = (_TSPAbsAlt)elem;
	_new->_desc2 = (_TSPLST_AbsAlts)_new;
	{_TPPLST_AbsAltrule_5 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_AbsAltrule_5;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_5 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_5 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBAbsAlt)) 
		return _MkAbsAltrule_5 (_coordref, MkAbsAlt (_coordref, t));
	message (DEADLY, "a rule_5 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_5 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_5 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_AbsAlts)
	l =_Elemrule_5 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_AbsAlts)
	r = _Elemrule_5 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_5)r)->_desc2);
((_TPPLST_0rule_5)r)->_desc2 = ((_TPPLST_0rule_5)l)->_desc2;
((_TPPLST_0rule_5)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_5 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_5 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_5 root;
	_TPPLST_0rule_5 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_5)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_AbsAlts)
		t = _Elemrule_5 (_coordref, t);
	remain = (_TPPLST_0rule_5)(((_TPPLST_0rule_5) t)->_desc2);
	((_TPPLST_0rule_5) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_5;
#else
list = (_TPPLST_0rule_5) TreeNodeAlloc (sizeof (struct _TPLST_0rule_5));
#endif
list->_prod = RULELST_0rule_5;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_5)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_AbsAltrule_5)
	{_TPPLST_AbsAltrule_5 _currn = _currn;
	 _TERMACT_LST_AbsAltrule_5;
	} this code has been moved to _Elemrule_5*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_5;
#else
root = (_TPPrule_5) TreeNodeAlloc (sizeof (struct _TPrule_5));
#endif
root->_prod = RULErule_5;
root->_desc1 = (_TSPLST_AbsAlts)list;
{ _TPPrule_5 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_5;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_6 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_6 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_6 _currn;
#ifdef __cplusplus
_currn = new _TPrule_6;
#else
_currn = (_TPPrule_6) TreeNodeAlloc (sizeof (struct _TPrule_6));
#endif
_currn->_prod = RULErule_6;
_SETCOORD(_currn)
_TERMACT_rule_6;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_6 */

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapChainsrule_7 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapChainsrule_7 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapChainsrule_7 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapChainsrule_7;
#else
	_new = (_TPPLST_MapChainsrule_7) TreeNodeAlloc (sizeof (struct _TPLST_MapChainsrule_7));
#endif
	_new->_prod = RULELST_MapChainsrule_7;
	_new->_desc1 = (_TSPMapChains)elem;
	_new->_desc2 = (_TSPLST_Map)_new;
	{_TPPLST_MapChainsrule_7 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapChainsrule_7;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapRulerule_7 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapRulerule_7 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapRulerule_7 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapRulerule_7;
#else
	_new = (_TPPLST_MapRulerule_7) TreeNodeAlloc (sizeof (struct _TPLST_MapRulerule_7));
#endif
	_new->_prod = RULELST_MapRulerule_7;
	_new->_desc1 = (_TSPMapRule)elem;
	_new->_desc2 = (_TSPLST_Map)_new;
	{_TPPLST_MapRulerule_7 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapRulerule_7;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapSymbolrule_7 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapSymbolrule_7 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapSymbolrule_7 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapSymbolrule_7;
#else
	_new = (_TPPLST_MapSymbolrule_7) TreeNodeAlloc (sizeof (struct _TPLST_MapSymbolrule_7));
#endif
	_new->_prod = RULELST_MapSymbolrule_7;
	_new->_desc1 = (_TSPMapSymbol)elem;
	_new->_desc2 = (_TSPLST_Map)_new;
	{_TPPLST_MapSymbolrule_7 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapSymbolrule_7;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_7 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_7 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBMapChains)) 
		return _MkMapChainsrule_7 (_coordref, MkMapChains (_coordref, t));
	if (IsSymb (t, SYMBMapRule)) 
		return _MkMapRulerule_7 (_coordref, MkMapRule (_coordref, t));
	if (IsSymb (t, SYMBMapSymbol)) 
		return _MkMapSymbolrule_7 (_coordref, MkMapSymbol (_coordref, t));
	message (DEADLY, "a rule_7 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_7 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_7 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_Map)
	l =_Elemrule_7 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_Map)
	r = _Elemrule_7 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_7)r)->_desc2);
((_TPPLST_0rule_7)r)->_desc2 = ((_TPPLST_0rule_7)l)->_desc2;
((_TPPLST_0rule_7)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_7 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_7 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_7 root;
	_TPPLST_0rule_7 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_7)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_Map)
		t = _Elemrule_7 (_coordref, t);
	remain = (_TPPLST_0rule_7)(((_TPPLST_0rule_7) t)->_desc2);
	((_TPPLST_0rule_7) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_7;
#else
list = (_TPPLST_0rule_7) TreeNodeAlloc (sizeof (struct _TPLST_0rule_7));
#endif
list->_prod = RULELST_0rule_7;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_7)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_MapChainsrule_7)
	{_TPPLST_MapChainsrule_7 _currn = _currn;
	 _TERMACT_LST_MapChainsrule_7;
	} this code has been moved to _Elemrule_7*/
	/*if (_currn->_prod == RULELST_MapRulerule_7)
	{_TPPLST_MapRulerule_7 _currn = _currn;
	 _TERMACT_LST_MapRulerule_7;
	} this code has been moved to _Elemrule_7*/
	/*if (_currn->_prod == RULELST_MapSymbolrule_7)
	{_TPPLST_MapSymbolrule_7 _currn = _currn;
	 _TERMACT_LST_MapSymbolrule_7;
	} this code has been moved to _Elemrule_7*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_7;
#else
root = (_TPPrule_7) TreeNodeAlloc (sizeof (struct _TPrule_7));
#endif
root->_prod = RULErule_7;
root->_desc1 = (_TSPLST_Map)list;
{ _TPPrule_7 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_7;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_8 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_8 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_8 _currn;
#ifdef __cplusplus
_currn = new _TPrule_8;
#else
_currn = (_TPPrule_8) TreeNodeAlloc (sizeof (struct _TPrule_8));
#endif
_currn->_prod = RULErule_8;
_SETCOORD(_currn)
_TERMACT_rule_8;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_8 */

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapMemberrule_9 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapMemberrule_9 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapMemberrule_9 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapMemberrule_9;
#else
	_new = (_TPPLST_MapMemberrule_9) TreeNodeAlloc (sizeof (struct _TPLST_MapMemberrule_9));
#endif
	_new->_prod = RULELST_MapMemberrule_9;
	_new->_desc1 = (_TSPMapMember)elem;
	_new->_desc2 = (_TSPLST_MapMembers)_new;
	{_TPPLST_MapMemberrule_9 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapMemberrule_9;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_9 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_9 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBMapMember)) 
		return _MkMapMemberrule_9 (_coordref, MkMapMember (_coordref, t));
	message (DEADLY, "a rule_9 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_9 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_9 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_MapMembers)
	l =_Elemrule_9 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_MapMembers)
	r = _Elemrule_9 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_9)r)->_desc2);
((_TPPLST_0rule_9)r)->_desc2 = ((_TPPLST_0rule_9)l)->_desc2;
((_TPPLST_0rule_9)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_9 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_9 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_9 root;
	_TPPLST_0rule_9 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_9)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_MapMembers)
		t = _Elemrule_9 (_coordref, t);
	remain = (_TPPLST_0rule_9)(((_TPPLST_0rule_9) t)->_desc2);
	((_TPPLST_0rule_9) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_9;
#else
list = (_TPPLST_0rule_9) TreeNodeAlloc (sizeof (struct _TPLST_0rule_9));
#endif
list->_prod = RULELST_0rule_9;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_9)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_MapMemberrule_9)
	{_TPPLST_MapMemberrule_9 _currn = _currn;
	 _TERMACT_LST_MapMemberrule_9;
	} this code has been moved to _Elemrule_9*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_9;
#else
root = (_TPPrule_9) TreeNodeAlloc (sizeof (struct _TPrule_9));
#endif
root->_prod = RULErule_9;
root->_desc1 = (_TSPLST_MapMembers)list;
{ _TPPrule_9 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_9;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_10 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_10 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_10 _currn;
#ifdef __cplusplus
_currn = new _TPrule_10;
#else
_currn = (_TPPrule_10) TreeNodeAlloc (sizeof (struct _TPrule_10));
#endif
_currn->_prod = RULErule_10;
_SETCOORD(_currn)
_TERMACT_rule_10;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_10 */

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapElementrule_11 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapElementrule_11 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapElementrule_11 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapElementrule_11;
#else
	_new = (_TPPLST_MapElementrule_11) TreeNodeAlloc (sizeof (struct _TPLST_MapElementrule_11));
#endif
	_new->_prod = RULELST_MapElementrule_11;
	_new->_desc1 = (_TSPMapElement)elem;
	_new->_desc2 = (_TSPLST_MapAlt)_new;
	{_TPPLST_MapElementrule_11 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapElementrule_11;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_11 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_11 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBMapElement)) 
		return _MkMapElementrule_11 (_coordref, MkMapElement (_coordref, t));
	message (DEADLY, "a rule_11 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_11 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_11 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_MapAlt)
	l =_Elemrule_11 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_MapAlt)
	r = _Elemrule_11 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_11)r)->_desc2);
((_TPPLST_0rule_11)r)->_desc2 = ((_TPPLST_0rule_11)l)->_desc2;
((_TPPLST_0rule_11)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_11 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_11 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_11 root;
	_TPPLST_0rule_11 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_11)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_MapAlt)
		t = _Elemrule_11 (_coordref, t);
	remain = (_TPPLST_0rule_11)(((_TPPLST_0rule_11) t)->_desc2);
	((_TPPLST_0rule_11) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_11;
#else
list = (_TPPLST_0rule_11) TreeNodeAlloc (sizeof (struct _TPLST_0rule_11));
#endif
list->_prod = RULELST_0rule_11;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_11)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_MapElementrule_11)
	{_TPPLST_MapElementrule_11 _currn = _currn;
	 _TERMACT_LST_MapElementrule_11;
	} this code has been moved to _Elemrule_11*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_11;
#else
root = (_TPPrule_11) TreeNodeAlloc (sizeof (struct _TPrule_11));
#endif
root->_prod = RULErule_11;
root->_desc1 = (_TSPLST_MapAlt)list;
{ _TPPrule_11 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_11;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapTextrule_12 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapTextrule_12 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapTextrule_12 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapTextrule_12;
#else
	_new = (_TPPLST_MapTextrule_12) TreeNodeAlloc (sizeof (struct _TPLST_MapTextrule_12));
#endif
	_new->_prod = RULELST_MapTextrule_12;
	_new->_desc1 = (_TSPMapText)elem;
	_new->_desc2 = (_TSPLST_MapReorderAlt)_new;
	{_TPPLST_MapTextrule_12 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapTextrule_12;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _MkMapPositionrule_12 (POSITION *_coordref, NODEPTR elem)
#else
static NODEPTR _MkMapPositionrule_12 (_coordref, elem)
	POSITION *_coordref; NODEPTR elem;
#endif
{
	_TPPLST_MapPositionrule_12 _new;
#ifdef __cplusplus
	_new = new _TPLST_MapPositionrule_12;
#else
	_new = (_TPPLST_MapPositionrule_12) TreeNodeAlloc (sizeof (struct _TPLST_MapPositionrule_12));
#endif
	_new->_prod = RULELST_MapPositionrule_12;
	_new->_desc1 = (_TSPMapPosition)elem;
	_new->_desc2 = (_TSPLST_MapReorderAlt)_new;
	{_TPPLST_MapPositionrule_12 _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_MapPositionrule_12;
	}
	return (NODEPTR)_new;
}

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemrule_12 (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemrule_12 (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* coerces t to a list element and returns a single circular list */
{	NODEPTR elem;
	/* check first without then with coercion: */
	if (IsSymb (t, SYMBMapText)) 
		return _MkMapTextrule_12 (_coordref, MkMapText (_coordref, t));
	if (IsSymb (t, SYMBMapPosition)) 
		return _MkMapPositionrule_12 (_coordref, MkMapPosition (_coordref, t));
	message (DEADLY, "a rule_12 list element node can not be generated ",
		0, _coordref);
	return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2rule_12 (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2rule_12 (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_MapReorderAlt)
	l =_Elemrule_12 (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_MapReorderAlt)
	r = _Elemrule_12 (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0rule_12)r)->_desc2);
((_TPPLST_0rule_12)r)->_desc2 = ((_TPPLST_0rule_12)l)->_desc2;
((_TPPLST_0rule_12)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_12 (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mkrule_12 (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPrule_12 root;
	_TPPLST_0rule_12 list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0rule_12)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_MapReorderAlt)
		t = _Elemrule_12 (_coordref, t);
	remain = (_TPPLST_0rule_12)(((_TPPLST_0rule_12) t)->_desc2);
	((_TPPLST_0rule_12) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0rule_12;
#else
list = (_TPPLST_0rule_12) TreeNodeAlloc (sizeof (struct _TPLST_0rule_12));
#endif
list->_prod = RULELST_0rule_12;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0rule_12)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_MapTextrule_12)
	{_TPPLST_MapTextrule_12 _currn = _currn;
	 _TERMACT_LST_MapTextrule_12;
	} this code has been moved to _Elemrule_12*/
	/*if (_currn->_prod == RULELST_MapPositionrule_12)
	{_TPPLST_MapPositionrule_12 _currn = _currn;
	 _TERMACT_LST_MapPositionrule_12;
	} this code has been moved to _Elemrule_12*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPrule_12;
#else
root = (_TPPrule_12) TreeNodeAlloc (sizeof (struct _TPrule_12));
#endif
root->_prod = RULErule_12;
root->_desc1 = (_TSPLST_MapReorderAlt)list;
{ _TPPrule_12 _currn = root;
  _SETCOORD(_currn)
  _TERMACT_rule_12;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_13 (POSITION *_coordref)
#else
NODEPTR Mkrule_13 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_13 _currn;
#ifdef __cplusplus
_currn = new _TPrule_13;
#else
_currn = (_TPPrule_13) TreeNodeAlloc (sizeof (struct _TPrule_13));
#endif
_currn->_prod = RULErule_13;
_SETCOORD(_currn)
_TERMACT_rule_13;
return ( (NODEPTR) _currn);
}/* Mkrule_13 */
