/* $Id: Names.c,v 1.3 1999/08/06 09:59:26 cogito Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Names.h"
#include "err.h"
#include "idn.h"
#include "csm.h"

/* default value of string attribute in LIGA interface */
#define NoString       ""

/* access to csm module */
#define GetStringRef(s) (strng[s])

char * CatStrings (s1, s2)
        char    *s1, *s2;
{       int     strid;
        obstack_strgrow(Csm_obstk, s1);
        CsmStrPtr = (char *)obstack_strcpy(Csm_obstk, s2);
        strid=stostr(CsmStrPtr, strlen(s1)+strlen(s2));
        return (strng[strid]);

} /* CatStrings */

static int	idtoken = 4;

int NewId (name) char *name;
{ int newid;
  mkidn(name, strlen (name), &idtoken, &newid);
  return newid;
}

static int idcnt = 0;

int NewCntId (prefix) char *prefix;
/* generates a name of the form "prefix"<idcnt> */
{ char suffix[40];
  char *newstr;
  int  newid;

  sprintf (suffix, "%d", idcnt++);
  newstr = CatStrings (prefix, suffix);
  mkidn(newstr, strlen (newstr), &idtoken, &newid);
  return newid;
}

int NumToIdn (id, num)
	int	id, num;
{	int	newid;
	char	*newstr;
	char	suffix[40];

/* generates names of the form "attrname_RuleAttr_prodnumber" */
sprintf (suffix, "_RuleAttr_%d", num);
newstr = CatStrings (GetStringRef (id), suffix);
mkidn(newstr, strlen (newstr), &idtoken, &newid);
return (newid);
}/*NumToIdn*/

int NewRuleId (kind, rule, elem)
	int kind, rule, elem;
{	int	newid;
	char	*newstr;

if (kind == 0) {
	newstr = CatStrings ("LST_0", GetStringRef (rule));
} else if (kind == 1) {
	newstr = CatStrings ("LST_", GetStringRef (elem));
	newstr = CatStrings (newstr, GetStringRef (rule));
} else {
	newstr = CatStrings ("LST_2", GetStringRef (rule));
}
mkidn (newstr, strlen (newstr), &idtoken, &newid);
return (newid);
}/*NewRuleId*/

int MakeListId (id)
	int	id;
{	int	newid;
	char	*newstr;

newstr = CatStrings ("LST_", GetStringRef (id));
mkidn (newstr, strlen (newstr), &idtoken, &newid);
return (newid);
}/*MakeListId*/
