;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/walk.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Tue Sep 16 12:12:08 2003 (serrano)                */
;*    Copyright   :  1995-2003 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The `C generation' pass.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Engine/pass.sch"
	    "Ast/unit.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    engine_configure
	    module_module
	    module_library
	    type_type
	    ast_var
	    ast_node
	    ast_occur
	    ast_build
	    object_class
	    bdb_emit
	    prof_emit
	    backend_c_emit
	    backend_c_prototype
	    backend_c_main
	    backend_c_init
	    cgen_cop
	    cgen_cgen
	    backend_backend)
   (export  (ast+initializers::pair-nil ::pair-nil)))

;*---------------------------------------------------------------------*/
;*    cvm-compile-functions ::cgen ...                                 */
;*---------------------------------------------------------------------*/
(define-method (cvm-compile-functions me::cgen)
   (for-each cgen-function (cvm-functions me)))

;*---------------------------------------------------------------------*/
;*    ast+initializers ...                                             */
;*    -------------------------------------------------------------    */
;*    This function builds the complete list of global variables. That */
;*    is, the user global variables plus the globals that implement    */
;*    the module initialization (e.g. module-initialization,           */
;*    cnst-initialization, ...).                                       */
;*---------------------------------------------------------------------*/
(define (ast+initializers::pair-nil globals::pair-nil)
   (let* ((lib-unit (library-finalizer))
	  (lib-init (if (unit? lib-unit)
			(let ((vars (build-ast-sans-remove (list lib-unit))))
			   (for-each (lambda (g)
					(occur-node-in!
					 (sfun-body (global-value g))
					 g))
				     vars)
			   vars)
			'()))
	  (mod-init (get-module-init))
	  (globals  (cons mod-init
			  (if (and (or *main* (memq *pass* '(ld distrib)))
				   (not (eq? *main* 'imported)))
			      (cons (make-bigloo-main)
				    (append lib-init globals))
			      (append lib-init globals)))))
      globals))

