/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.CommunicationException;
import com.sap.dbtech.rte.comm.ConnectPacket;
import com.sap.dbtech.rte.comm.CserverPacketLayout;
import com.sap.dbtech.rte.comm.DbPacketLayout;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.RteSocketPacket;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;

public class SocketComm
extends JdbcCommunication {
    private static int counter = 0;
    private Socket socket;
    private InputStream instream;
    private OutputStream outstream;
    private int senderRef;
    private int receiverRef;
    private int maxSendLen;
    private int remoteSwapping;
    private String host;
    private int port;
    private String dbname;
    private PacketLayout packetLayout;
    private boolean dbSession;
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String string, String string2) throws RTEException {
            return SocketComm.connectDB(string, string2);
        }
    };
    public static final int controlPacketSize_C = 16384;

    private SocketComm(String string) throws RTEException {
        int n = string.indexOf(":");
        if (n == -1) {
            this.host = string;
            this.port = 7210;
        } else {
            this.host = string.substring(0, n);
            try {
                this.port = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RTEException(MessageTranslator.translate("error.unknown.host", string, numberFormatException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])));
            }
        }
        this.openSocket();
    }

    private void buildRTEHeader(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(0, 0);
        structuredBytes.putInt1(3, 4);
        structuredBytes.putInt1(n, 5);
        structuredBytes.putInt1(0, 6);
        structuredBytes.putInt1(0, 7);
        structuredBytes.putInt4(this.senderRef, 8);
        structuredBytes.putInt4(this.receiverRef, 12);
        structuredBytes.putInt2(0, 16);
        structuredBytes.putInt2(0, 18);
        structuredBytes.putInt4(this.maxSendLen, 20);
    }

    public void cancel() throws SQLException {
        try {
            DbPacketLayout dbPacketLayout = new DbPacketLayout();
            SocketComm socketComm = new SocketComm(this.host + ":" + this.port);
            StructuredBytes structuredBytes = SocketComm.createRawPacket(296);
            this.buildRTEHeader(structuredBytes, 65);
            structuredBytes.putInt4(this.senderRef, 12);
            ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), this.dbname, dbPacketLayout);
            connectPacket.close();
            socketComm.sendData(structuredBytes, connectPacket.length());
            socketComm.closeSocket();
        }
        catch (RTEException rTEException) {
            throw new SQLException(rTEException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                Object var3_2 = null;
                this.socket = null;
            }
            Object var3_1 = null;
            this.socket = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.socket = null;
            throw throwable;
        }
    }

    public static SocketComm connectAdmin(String string, String string2, String string3, String string4) throws RTEException {
        CserverPacketLayout cserverPacketLayout = new CserverPacketLayout();
        SocketComm socketComm = new SocketComm(string);
        socketComm.sendAdminConnect(string2, string3, string4, cserverPacketLayout);
        socketComm.receiveConnect();
        socketComm.packetLayout = cserverPacketLayout;
        return socketComm;
    }

    public static SocketComm connectDB(String string, String string2) throws RTEException {
        DbPacketLayout dbPacketLayout = SocketComm.doInfoRequest(string, string2);
        SocketComm socketComm = new SocketComm(string);
        socketComm.dbSession = true;
        socketComm.dbname = string2;
        socketComm.packetLayout = socketComm.dbConnectExchange(string2, dbPacketLayout);
        return socketComm;
    }

    private static StructuredBytes createRawPacket(int n) {
        return new StructuredBytes(n + 24);
    }

    private PacketLayout dbConnectExchange(String string, PacketLayout packetLayout) throws RTEException {
        this.sendDbConnect(string, packetLayout);
        StructuredBytes structuredBytes = this.receiveConnect();
        packetLayout = SocketComm.getPacketLayoutFromReply(structuredBytes, true);
        return packetLayout;
    }

    private static DbPacketLayout doInfoRequest(String string, String string2) throws RTEException {
        DbPacketLayout dbPacketLayout = new DbPacketLayout();
        SocketComm socketComm = new SocketComm(string);
        StructuredBytes structuredBytes = SocketComm.createRawPacket(296);
        socketComm.buildRTEHeader(structuredBytes, 51);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string2, dbPacketLayout);
        connectPacket.close();
        socketComm.sendData(structuredBytes, connectPacket.length());
        StructuredBytes structuredBytes2 = socketComm.receiveConnect();
        int n = structuredBytes2.getInt2(16);
        if (n != 0) {
            socketComm.release();
            throw new CommunicationException(n);
        }
        socketComm.release();
        DbPacketLayout dbPacketLayout2 = SocketComm.getPacketLayoutFromReply(structuredBytes2, false);
        return dbPacketLayout2;
    }

    private static DbPacketLayout getPacketLayoutFromReply(StructuredBytes structuredBytes, boolean bl) {
        int n = structuredBytes.getInt4(36);
        int n2 = structuredBytes.getInt4(44);
        int n3 = structuredBytes.getInt4(40);
        int n4 = bl ? structuredBytes.getInt4(32) : n3;
        DbPacketLayout dbPacketLayout = new DbPacketLayout(n, n4, n2, n3);
        return dbPacketLayout;
    }

    private static void dumpRteHeader(StructuredMem structuredMem, PrintStream printStream) {
        printStream.println("RTE Header");
        printStream.print("ActSendLen: ");
        printStream.println(structuredMem.getInt4(0));
        printStream.print("ProtocolID: ");
        printStream.println(structuredMem.getInt1(4));
        printStream.print("MessClass: ");
        printStream.println(structuredMem.getInt1(5));
        printStream.print("RTEFlags: ");
        printStream.println(structuredMem.getInt1(6));
        printStream.print("ResidualPackets: ");
        printStream.println(structuredMem.getInt1(7));
        printStream.print("SenderRef: ");
        printStream.println(structuredMem.getInt4(8));
        printStream.print("ReceiverRef: ");
        printStream.println(structuredMem.getInt4(12));
        printStream.print("RTEReturnCode: ");
        printStream.println(structuredMem.getInt2(16));
        printStream.print("Filler: ");
        printStream.println(structuredMem.getInt2(18));
        printStream.print("MaxSendLen: ");
        printStream.println(structuredMem.getInt4(20));
    }

    protected void finalize() throws Throwable {
        if (this.socket != null) {
            this.release();
        }
        super.finalize();
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket rteSocketPacket = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
        return rteSocketPacket;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    private int lookupPort() {
        return this.port;
    }

    private void openSocket() throws RTEException {
        try {
            this.socket = new Socket(this.host, this.lookupPort());
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, unknownHostException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13]);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, iOException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public StructuredMem receive() throws RTEException {
        return this.receiveData();
    }

    private StructuredBytes receiveConnect() throws RTEException {
        StructuredBytes structuredBytes;
        int n = 320;
        byte[] byArray = new byte[n];
        try {
            int n2 = this.instream.read(byArray, 0, n);
            if (n2 < 24) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8]);
            }
            this.remoteSwapping = byArray[25];
            structuredBytes = this.replyMem(byArray);
            int n3 = structuredBytes.getInt4(0);
            if (n3 != n2) {
                throw new RTEException(MessageTranslator.translate("error.connectreply.garbled"), RteC.CommunicationErrorCodeMap_C[8]);
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[1]);
        }
        this.senderRef = structuredBytes.getInt4(8);
        int n4 = structuredBytes.getInt2(16);
        if (n4 != 0) {
            throw new RTEException(RteC.getCommunicationError(n4), RteC.getCommunicationErrorMapCode(n4));
        }
        return structuredBytes;
    }

    private StructuredMem receiveData() throws RTEException {
        boolean bl = true;
        byte[] byArray = new byte[24];
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = null;
        StructuredBytes structuredBytes = null;
        StructuredBytes structuredBytes2 = null;
        try {
            InputStream inputStream = this.instream;
            while (bl || n2 < n) {
                int n3;
                int n4 = inputStream.read(byArray, 0, 24);
                if (n4 != 24) {
                    RTEException rTEException = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    throw rTEException;
                }
                if (bl) {
                    structuredBytes = this.replyMem(byArray);
                    bl = false;
                    int n5 = structuredBytes.getInt2(16);
                    if (n5 != 0) {
                        throw new CommunicationException(n5);
                    }
                    n = structuredBytes.getInt4(20) - n4;
                    byArray2 = new byte[n];
                    structuredBytes2 = new StructuredBytes(byArray2);
                }
                if ((n3 = structuredBytes.getInt4(0) - n4) >= 0 && n2 + n3 > byArray2.length) {
                    // empty if block
                }
                while (n3 > 0) {
                    int n6;
                    try {
                        n6 = inputStream.read(byArray2, n2, n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate("error.chunkoverflow", Integer.toString(n3), Integer.toString(n2), Integer.toString(byArray2.length)));
                    }
                    if (n6 < 0) {
                        throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    }
                    n2 += n6;
                    n3 -= n6;
                }
            }
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", iOException.getMessage()), RteC.CommunicationErrorCodeMap_C[8]);
        }
        if (Tracer.isOn(9)) {
            Tracer.traceObject("REPLY:", structuredBytes2);
        }
        return structuredBytes2;
    }

    public void reconnect() throws RTEException {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            this.socket = null;
        }
        this.openSocket();
        if (!this.dbSession) {
            throw new RTEException(MessageTranslator.translate("error.admin.reconnect"), RteC.CommunicationErrorCodeMap_C[3]);
        }
        this.dbConnectExchange(this.dbname, this.packetLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block5: {
            try {
                try {
                    StructuredBytes structuredBytes = SocketComm.createRawPacket(0);
                    this.buildRTEHeader(structuredBytes, 66);
                    this.sendData(structuredBytes, 0);
                    this.socket.close();
                }
                catch (IOException iOException) {
                    Object var4_4 = null;
                    this.socket = null;
                    break block5;
                }
                catch (RTEException rTEException) {
                    Object var4_5 = null;
                    this.socket = null;
                }
                Object var4_3 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    private StructuredBytes replyMem(byte[] byArray) throws RTEException {
        StructuredBytes structuredBytes;
        switch (this.remoteSwapping) {
            case 1: {
                structuredBytes = new StructuredBytes(byArray);
                break;
            }
            case 2: {
                structuredBytes = new FullswapMem(byArray);
                break;
            }
            default: {
                throw new RTEException(MessageTranslator.translate("error.invalid.swapping"), -708);
            }
        }
        return structuredBytes;
    }

    public void request(StructuredMem structuredMem, int n) throws RTEException {
        if (Tracer.isOn(9)) {
            Tracer.traceObject("REQUEST:", structuredMem, n + 24);
        }
        StructuredBytes structuredBytes = ((RteSocketPacket)structuredMem).rteHeader;
        this.buildRTEHeader(structuredBytes, 63);
        this.sendData(structuredBytes, n);
    }

    private void sendAdminConnect(String string, String string2, String string3, PacketLayout packetLayout) throws RTEException {
        StructuredBytes structuredBytes = SocketComm.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 91);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout);
        connectPacket.addConnectString(string2, 100);
        connectPacket.addConnectString(string3, 112);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    private void sendData(StructuredBytes structuredBytes, int n) throws RTEException {
        OutputStream outputStream;
        this.setActSendLen(structuredBytes, n);
        try {
            if (this.outstream == null) {
                this.outstream = this.socket.getOutputStream();
            }
            outputStream = this.outstream;
        }
        catch (IOException iOException) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7]);
        }
        try {
            outputStream.write(structuredBytes.bytes(), 0, n + 24);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.send.write"), RteC.CommunicationErrorCodeMap_C[7]);
        }
    }

    private void sendDbConnect(String string, PacketLayout packetLayout) throws RTEException {
        StructuredBytes structuredBytes = SocketComm.createRawPacket(packetLayout.maxDataLength());
        this.buildRTEHeader(structuredBytes, 61);
        ConnectPacket connectPacket = new ConnectPacket(structuredBytes.bytes(), string, packetLayout);
        connectPacket.close();
        this.sendData(structuredBytes, connectPacket.length());
    }

    private void setActSendLen(StructuredBytes structuredBytes, int n) {
        structuredBytes.putInt4(n += 24, 0);
        structuredBytes.putInt4(n, 20);
    }

    public static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static SocketComm sqlaconnect(String string, String string2) throws RTEException {
        return null;
    }

    public StructuredMem sqlareceive() throws RTEException {
        return this.receive();
    }

    public void sqlarelease() throws RTEException {
        this.release();
    }

    public void sqlarequest(StructuredMem structuredMem, int n) throws RTEException {
        this.request(structuredMem, n);
    }

    public static SocketComm sqlxconnect(String string, String string2, String string3, String string4) throws RTEException {
        SocketComm socketComm = SocketComm.connectAdmin(string, string2, string3, string4);
        return socketComm;
    }

    public String toString() {
        String string = super.toString() + " on " + this.socket;
        return string;
    }
}

