/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import java.io.IOException;
import java.io.Reader;

public class ReaderFilter
extends Reader {
    private int maxlength;
    private Reader ips;
    private int readlength = 0;

    public ReaderFilter(Reader reader, int n) {
        this.maxlength = n;
        this.ips = reader;
    }

    public int read() throws IOException {
        if (this.maxlength <= this.readlength++) {
            return -1;
        }
        return this.ips.read();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readlength >= this.maxlength) {
            return -1;
        }
        if (this.readlength + n2 > this.maxlength) {
            n2 = this.maxlength - this.readlength;
        }
        if (n2 <= 0) {
            return 0;
        }
        n2 = this.ips.read(cArray, n, n2);
        this.readlength += n2;
        return n2;
    }

    public void close() throws IOException {
        this.ips.close();
    }
}

