/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.math;

public final class HackersDelight {
    public static final int SIGN_BIT_MASK_I = Integer.MIN_VALUE;
    public static final long SIGN_BIT_MASK_L = Long.MIN_VALUE;
    public static final long BUT_SIGN_BIT_MASK_L = Long.MAX_VALUE;
    public static final long EXPONENT_BITS_MASK = 0x7FF0000000000000L;
    public static final long BUT_EXPONENT_BIT_MASK = -9218868437227405313L;

    public static boolean isPowOf2(int x) {
        return x != 0 && HackersDelight.isPowOf2Fast(x);
    }

    public static boolean isPowOf2Fast(int x) {
        return (x-- & x) == 0;
    }

    public static long flp2(long x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x - (x >>> 1);
    }

    public static double halfOf(double x) {
        if (x == 0.0) {
            return x;
        }
        long bits = HackersDelight.toBits(x);
        long signAndFraction = bits & 0x800FFFFFFFFFFFFFL;
        long exponent = bits & 0x7FF0000000000000L;
        exponent >>= 52;
        --exponent;
        return HackersDelight.fromBits(signAndFraction | (exponent <<= 52));
    }

    public static long toBits(double x) {
        return Double.doubleToRawLongBits(x);
    }

    public static double fromBits(long doubleBits) {
        return Double.longBitsToDouble(doubleBits);
    }

    public static int abs(int x) {
        int mask = x >> 31;
        assert (x < 0 && mask == -1 || x >= 0 && mask == 0);
        return (x ^ mask) - mask;
    }

    public static long abs(long x) {
        long mask = x >> 63;
        assert (x < 0L && mask == -1L || x >= 0L && mask == 0L);
        return (x ^ mask) - mask;
    }

    public static double abs(double x) {
        return HackersDelight.fromBits(HackersDelight.toBits(x) & Long.MAX_VALUE);
    }

    public static int floorIntP(double a) {
        return (int)a;
    }

    public static int floorIntN(double a) {
        int d = (int)a;
        return (double)d == a ? d : --d;
    }

    public static int floorInt(double a) {
        int d = (int)a;
        return a < 0.0 && (double)d != a ? --d : d;
    }

    public static long floorLongP(double a) {
        return (long)a;
    }

    public static long floorLongN(double a) {
        long d = (long)a;
        return (double)d == a ? d : (d = d - 1L);
    }

    public static long floorLong(double a) {
        long d = (long)a;
        return a < 0.0 && (double)d != a ? (d = d - 1L) : d;
    }

    public static int doz(int x, int y) {
        return (x -= y) & ~(x >> 31);
    }

    public static long doz(long x, long y) {
        return (x -= y) & (x >> 31 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int min(int x, int y) {
        return x - HackersDelight.doz(x, y);
    }

    public static long min(long x, long y) {
        return x - HackersDelight.doz(x, y);
    }

    public static int max(int x, int y) {
        return y + HackersDelight.doz(x, y);
    }

    public static long max(long x, long y) {
        return y + HackersDelight.doz(x, y);
    }

    public static int nlz(int x) {
        int y = -(x >> 16);
        int m = y >> 16 & 0x10;
        int n = 16 - m;
        y = (x >>>= m) - 256;
        m = y >> 16 & 8;
        n += m;
        y = (x <<= m) - 4096;
        m = y >> 16 & 4;
        n += m;
        y = (x <<= m) - 16384;
        m = y >> 16 & 2;
        n += m;
        y = (x <<= m) >> 14;
        m = y & ~(y >> 1);
        return n - m + 2;
    }

    public static void main(String[] args) {
        double d = -0.0;
        System.out.println(0);
        System.out.println(d);
        System.out.println(HackersDelight.halfOf(-0.0));
        System.out.println("----------------");
        System.out.println(HackersDelight.halfOf(0.0));
        System.out.println("----------------");
        System.out.println(HackersDelight.halfOf(-2.0));
        System.out.println("----------------");
        System.out.println(HackersDelight.halfOf(-458.25));
    }
}

