/*
 * Decompiled with CFR 0.152.
 */
package com.gsamokovarov.bindex;

import com.gsamokovarov.bindex.BindingBuilder;
import com.gsamokovarov.bindex.ThreadContextInternals;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.runtime.Binding;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CurrentBindingsIterator
implements Iterator<Binding> {
    private Frame[] frameStack;
    private int frameIndex;
    private DynamicScope[] scopeStack;
    private int scopeIndex;
    private BacktraceElement[] backtrace;
    private int backtraceIndex;

    CurrentBindingsIterator(ThreadContext threadContext) {
        ThreadContextInternals threadContextInternals = new ThreadContextInternals(threadContext);
        this.frameStack = threadContextInternals.getFrameStack();
        this.frameIndex = threadContextInternals.getFrameIndex();
        this.scopeStack = threadContextInternals.getScopeStack();
        this.scopeIndex = threadContextInternals.getScopeIndex();
        this.backtrace = threadContextInternals.getBacktrace();
        this.backtraceIndex = threadContextInternals.getBacktraceIndex();
    }

    @Override
    public boolean hasNext() {
        return this.frameIndex >= 0 && this.scopeIndex >= 0 && this.backtraceIndex >= 0;
    }

    @Override
    public Binding next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Frame frame = this.frameStack[this.frameIndex--];
        DynamicScope dynamicScope = this.scopeStack[this.scopeIndex--];
        BacktraceElement backtraceElement = this.backtrace[this.backtraceIndex--];
        return BindingBuilder.build(frame, dynamicScope, backtraceElement);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

