#pragma once

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_ReadData.hxx>
#include <StdObjMgt_WriteData.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Standard_GUID.hxx>

// module includes
#include <StdObjMgt_Attribute.hxx>
#include <StdObjMgt_MapOfInstantiators.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <StdObjMgt_ReadData.hxx>
#include <StdObjMgt_SharedObject.hxx>
#include <StdObjMgt_TransientPersistentMap.hxx>
#include <StdObjMgt_WriteData.hxx>

// user-defined pre
#include "OCP_specific.inc"

// Class template handling functions

template <typename Transient>
void preregister_template_StdObjMgt_Attribute(py::object &m, const char *name){
    py::class_<StdObjMgt_Attribute<Transient> , opencascade::handle<StdObjMgt_Attribute<Transient>> , Standard_Transient >(m,name,R"#(Root class for a temporary persistent object corresponding to an attribute.)#");
}

template <typename Transient>
void register_template_StdObjMgt_Attribute(py::object &m, const char *name){
    static_cast<py::class_<StdObjMgt_Attribute<Transient> , opencascade::handle<StdObjMgt_Attribute<Transient>> , Standard_Transient >>(m.attr(name))
    ;
};


// user-defined post

