### Reflection traits

### Legacy jsoncons::json_type_traits

[json_type_traits](json_type_traits/json_type_traits.md) defines a compile time template based interface for conversion between a `basic_json` value
and a value of some other type. 

See [Eigen::Matrix example](json_type_traits/Eigen-Matrix-example.md) for an example of specializing `json_type_traits` for an [Eigen matrix class](https://eigen.tuxfamily.org/dox-devel/group__TutorialMatrixClass.html).

Note that in typical cases traits can be generated by the convenience macros described below.

### jsoncons::reflect::json_conv_traits

jsoncons 1.4.0 introduces new trait definitions, [json_conv_traits](reflect/json_conv_traits.md), that support
non-throwing conversions and [uses-allocator construction](https://en.cppreference.com/w/cpp/memory/uses_allocator.html). 

See [Eigen::Matrix example](reflect/Eigen-Matrix-example.md) for an example of specializing `json_conv_traits` for an [Eigen matrix class](https://eigen.tuxfamily.org/dox-devel/group__TutorialMatrixClass.html).

See [User-allocator construction example](reflect/uses-allocator-construction-example.md) for an example that illustrates uses-allocator construction for types with `json_conv_traits` defined. 

For backwards compatability, `json_conv_traits` defaults to `json_type_traits` if a type conversion is undefined.  

### Convenience macros

jsoncons includes some [convenience macros](reflect/reflect-traits-gen.md) for generating reflection traits classes.
Until 1.4.0, these macros generated [json_type_traits](json_type_traits/json_type_traits.md) class templates. Since 1.4.0, they
generate [json_conv_traits](reflect/json_conv_traits.md) class templates, as well as some additional traits that support streaming.


