#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER1="mailto:resource-car-porsche911@example.com"
USER2="mailto:resource-car-fiat500@example.com"
SENDER="mailto:paul.boddie@example.com"
QUOTA=cars
OTHER_QUOTA=rooms

# Test quota enforcement where no limits apply, with resources first attempting
# to schedule reservations before checking a quota applying to both resources.

# The result should be a scheduling attempt with the first resource succeeding,
# but another with the second resource being declined due to a lack of quota.
# An adjustment to the quota then permits the successful reservation of the
# second resource. The first reservation is then cancelled.

# Quota-wide free/busy validation is then enabled, and the reservation of the
# second resource is replayed to allow the journal to maintain the free/busy
# details of the organiser. Now, when an attempt is made to reserve the first
# resource at the same time once again, this fails because the journal now knows
# that the organiser is occupied during the period in question. Moving the
# reservation of the first resource leads to a successful booking.

# Meanwhile, raising the quota once again and attempting to reserve both
# resources using a separate event leads to only one resource being booked due
# to a lack of quota.

mkdir -p "$PREFS/$USER1"
echo 'Europe/Oslo' > "$PREFS/$USER1/TZID"
echo 'share' > "$PREFS/$USER1/freebusy_sharing"
cat > "$PREFS/$USER1/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

mkdir -p "$PREFS/$USER2"
echo 'Europe/Oslo' > "$PREFS/$USER2/TZID"
echo 'share' > "$PREFS/$USER2/freebusy_sharing"
cat > "$PREFS/$USER2/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT1H
EOF
cat <<EOF | "$SET_QUOTA_LIMITS" "$OTHER_QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT1H
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-car.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out0s.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
|  tee out1f.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
|  tee out1e.tmp \
|  grep -q "event21@example.com" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule another event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-conflict.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out1s.tmp \
|  grep -q "^20141126T153000Z${TAB}20141126T163000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-conflict.txt" 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141126T153000Z${TAB}20141126T163000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is not confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out2e.tmp

   grep -q "event21@example.com" "out2e.tmp" \
&& ! grep -q "event22@example.com" "out2e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Increase the quota.

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT2H
EOF

# Attempt to schedule the event again.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-conflict.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out2s.tmp \
|  grep -q "^20141126T153000Z${TAB}20141126T163000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-conflict.txt" 2>> $ERROR \
| tee out3r.tmp \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out3.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
|  tee out3f.tmp \
|  grep -q "^20141126T153000Z${TAB}20141126T163000Z" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out3e.tmp

   grep -q "event21@example.com" "out3e.tmp" \
&& grep -q "event22@example.com" "out3e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Cancel the first event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-car.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out3s.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-car.txt" 2>> $ERROR \
| tee out4r.tmp \
| "$SHOWMAIL" \
> out4.tmp

   ! grep -q 'METHOD:REPLY' out4.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out4f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is retracted).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out4e.tmp

   ! grep -q "event21@example.com" "out4e.tmp" \
&& grep -q "event22@example.com" "out4e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Add collective scheduling tests.

cat > "$PREFS/$USER1/scheduling_function" <<EOF
schedule_in_freebusy
schedule_across_quota $QUOTA
check_quota $QUOTA
EOF

cat > "$PREFS/$USER2/scheduling_function" <<EOF
schedule_in_freebusy
schedule_across_quota $QUOTA
check_quota $QUOTA
EOF

# Remind the resource about the second event.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-conflict.txt" 2>> $ERROR \
| tee out5r.tmp \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out5.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
|  tee out5f.tmp \
|  grep -q "^20141126T153000Z${TAB}20141126T163000Z" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is still confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out5e.tmp

   ! grep -q "event21@example.com" "out5e.tmp" \
&& grep -q "event22@example.com" "out5e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule the first event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out5s.tmp \
|  grep -q "^20141126T150000Z${TAB}20141126T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car.txt" 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out6f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is still retracted and not newly confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out6e.tmp

   ! grep -q "event21@example.com" "out6e.tmp" \
&& grep -q "event22@example.com" "out6e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule the first event moved earlier.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-moved.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out6s.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out6s.tmp" \
&& grep -q "^20141126T143000Z${TAB}20141126T153000Z" "out6s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-moved.txt" 2>> $ERROR \
| tee out7r.tmp \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out7.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
|  tee out7f.tmp \
|  grep -q "^20141126T143000Z${TAB}20141126T153000Z" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is newly confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out7e.tmp

   grep -q "event21@example.com" "out7e.tmp" \
&& grep -q "event22@example.com" "out7e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Increase the quota.

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT3H
EOF

# Attempt to schedule an event involving both resources.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out7s.tmp \
|  grep -q "^20141127T150000Z${TAB}20141127T160000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to both resources.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars.txt" 2>> $ERROR \
| tee out8r.tmp \
| "$SHOWMAIL" \
> out8.tmp

# Since the email module used by showmail.py cannot stop after reading a single
# message, the second message is obtained.

  "$SHOWMAIL" 1 < out8r.tmp \
>> out8.tmp

   grep -q 'METHOD:REPLY' out8.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out8.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out8.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out8f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out8f2.tmp

   ( grep -q "^20141127T150000Z${TAB}20141127T160000Z" "out8f.tmp" \
     && ! grep -q "^20141127T150000Z${TAB}20141127T160000Z" "out8f2.tmp" ) \
|| ( ! grep -q "^20141127T150000Z${TAB}20141127T160000Z" "out8f.tmp" \
     && grep -q "^20141127T150000Z${TAB}20141127T160000Z" "out8f2.tmp" ) \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed, but only for one resource).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
|  tee out8e.tmp \
|  grep -q "event23@example.com" \
&& echo "Success" \
|| echo "Failed"
