/*!

\if MANPAGES
\page dcmgpdir Create a general purpose DICOMDIR
\else
\page dcmgpdir dcmgpdir: Create a general purpose DICOMDIR
\endif

\section dcmgpdir_synopsis SYNOPSIS

\verbatim
dcmgpdir [options] [dcmfile-in...]
\endverbatim

\section dcmgpdir_description DESCRIPTION

The \b dcmgpdir utility creates a \e DICOMDIR file from the specified
referenced DICOM files according to the DICOM Part 11 Media Storage
Application Profiles.

Currently, the following profiles are supported:

\li General Purpose CD-R Interchange (STD-GEN-CD)
\li General Purpose Interchange on DVD-RAM Media (STD-GEN-DVD-RAM)

\b dcmmkdir is an extended version of this tool which also supports other
Media Storage Application Profiles than the general purpose one (e.g. the
cardio profiles require the use of icon images).

\section dcmgpdir_parameters PARAMETERS

\verbatim
dcmfile-in  referenced DICOM file (or directory to be scanned)
\endverbatim

\section dcmgpdir_options OPTIONS

\subsection dcmgpdir_general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

        --arguments
          print expanded command line arguments

  -q    --quiet
          quiet mode, print no warnings and errors

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information

  -ll   --log-level  [l]evel: string constant
          (fatal, error, warn, info, debug, trace)
          use level l for the logger

  -lc   --log-config  [f]ilename: string
          use config file f for the logger
\endverbatim

\subsection dcmgpdir_input_options input options
\verbatim
DICOMDIR identifiers:

  +F    --fileset-id  [i]d: string
          use specific file-set ID
          (default: DCMTK_MEDIA_DEMO, "" for none)

  +R    --descriptor  [f]ilename: string
          add a file-set descriptor file ID
          (e.g. README, default: no descriptor)

  +C    --char-set  [c]harset: string
          add a specific character set for descriptor
          (default: "ISO_IR 100" if descriptor present)

reading:

  +id   --input-directory  [d]irectory: string
          read referenced DICOM files from directory d
          (default for --recurse: current directory)

  -m    --keep-filenames
          expect filenames to be in DICOM format (default)

  +m    --map-filenames
          map to DICOM filenames (lowercase->uppercase,
          and remove trailing period)

  -r    --no-recurse
          do not recurse within directories (default)

  +r    --recurse
          recurse within filesystem directories

  +p    --pattern  [p]attern: string (only with --recurse)
          pattern for filename matching (wildcards)

          # possibly not available on all systems
\endverbatim

\subsection dcmgpdir_processing_options processing options
\verbatim
consistency check:

  -W    --no-consistency-check
          do not check files for consistency

  +W    --warn-inconsist-files
          warn about inconsistent files (default)

  -a    --abort-inconsist-file
          abort on first inconsistent file

type 1 attributes:

  -I    --strict
          exit with error if DICOMDIR type 1 attributes
          are missing in DICOM file (default)

  +I    --invent
          invent DICOMDIR type 1 attributes if missing in DICOM file

  +Ipi  --invent-patient-id
          invent new PatientID in case of inconsistent
          PatientName attributes

other checks:

  +Nrs  --allow-retired-sop
          allow retired SOP classes defined in previous editions
          of the DICOM standard

  -Nxc  --no-xfer-check
          do not reject images with non-standard transfer syntax
          (just warn)
\endverbatim

\subsection dcmgpdir_output_options output options
\verbatim
DICOMDIR file:

  +D    --output-file  [f]ilename: string
          generate specific DICOMDIR file
          (default: DICOMDIR in current directory)

writing:

  -A    --replace
          replace existing DICOMDIR (default)

  +A    --append
          append to existing DICOMDIR

  +U    --update
          update existing DICOMDIR

  -w    --discard
          do not write out DICOMDIR

backup:

        --create-backup
          create a backup of existing DICOMDIR (default)

  -nb   --no-backup
          do not create a backup of existing DICOMDIR

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

group length encoding:

  -g    --group-length-remove
          write without group length elements (default)

  +g    --group-length-create
          write with group length elements

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths
\endverbatim

\section dcmgpdir_notes NOTES

All files specified on the command line (or discovered by recursively examining
the contents of directories with the \e +r option) are first evaluated for
their compatibility with the General Purpose CD-R Image Interchange Profile
(Supplement 19).  Only appropriate files encoded using the Explicit VR Little
Endian Uncompressed Transfer Syntax will be accepted.  Files having invalid
filenames will be rejected (the rules can be relaxed via the \e +m option).
Files missing required attributes will be rejected (the \e +I option can relax
this behavior).

A \e DICOMDIR file will only be constructed if all files have passed initial
tests.

The \b dcmgpdir utility also allows one to append new entries to and to update
existing entries in a \e DICOMDIR file.  Using option \e +A new entries are
only appended to the DICOMDIR, i.e. existing records like the ones for PATIENT
information are not updated.  Using option \e +U also existing records are
updated according to the information found in the referenced DICOM files.
Please note that this update process might be slower than just appending new
entries.  However, it makes sure that additional information that is required
for the selected application profile is also added to existing records.

\subsection dcmgpdir_scanning_directories Scanning Directories

Adding files from directories is possible by using option \e --recurse.  If no
further command line parameters are given, the directory specified by option
\e --input-directory (default: current directory) is scanned for files.  If
parameters are given, they can either specify a file or directory name; the
input directory is always prepended.  If the files in the provided directories
should be selected according to a specific name pattern (e.g. using wildcard
matching), option \e --pattern has to be used.  Please note that this file
pattern only applies to the files within the scanned directories, and, if any
other patterns are specified on the command line outside the
\e --input-directory option (e.g. in order to select further files), these do
not apply to the specified directories.

\section dcmgpdir_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section dcmgpdir_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section dcmgpdir_environment ENVIRONMENT

The \b dcmgpdir utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section dcmgpdir_see_also SEE ALSO

<b>dcmmkdir</b>(1)

\section dcmgpdir_copyright COPYRIGHT

Copyright (C) 1996-2022 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
