// https://www.utf8-chartable.de/unicode-utf8-table.pl
#define _c(cp, wysiwyg, hex) utft{csubstr{#cp}, csubstr{wysiwyg}, UINT32_C(0x##hex), csubstr{"0x" #hex}}
_c(U+0000, "\0", 00),
_c(U+0001, "", 01),
_c(U+0002, "", 02),
_c(U+0003, "", 03),
_c(U+0004, "", 04),
_c(U+0005, "", 05),
_c(U+0006, "", 06),
_c(U+0007, "", 07),
_c(U+0008, "\b", 08),
_c(U+0009, "\t", 09),
_c(U+000A, "\n", 0a),
_c(U+000B, "", 0b),
_c(U+000C, "", 0c),
_c(U+000D, "\r", 0d),
_c(U+000E, "", 0e),
_c(U+000F, "", 0f),
_c(U+0010, "", 10),
_c(U+0011, "", 11),
_c(U+0012, "", 12),
_c(U+0013, "", 13),
_c(U+0014, "", 14),
_c(U+0015, "", 15),
_c(U+0016, "", 16),
_c(U+0017, "", 17),
_c(U+0018, "", 18),
_c(U+0019, "", 19),
_c(U+001A, "", 1a),
_c(U+001B, "", 1b),
_c(U+001C, "", 1c),
_c(U+001D, "", 1d),
_c(U+001E, "", 1e),
_c(U+001F, "", 1f),
_c(U+0020, " ", 20),
_c(U+0021, "!", 21),
_c(U+0022, "\"", 22),
_c(U+0023, "#", 23),
_c(U+0024, "$", 24),
_c(U+0025, "%", 25),
_c(U+0026, "&", 26),
_c(U+0027, "'", 27),
_c(U+0028, "(", 28),
_c(U+0029, ")", 29),
_c(U+002A, "*", 2a),
_c(U+002B, "+", 2b),
_c(U+002C, ",", 2c),
_c(U+002D, "-", 2d),
_c(U+002E, ".", 2e),
_c(U+002F, "/", 2f),
_c(U+0030, "0", 30),
_c(U+0031, "1", 31),
_c(U+0032, "2", 32),
_c(U+0033, "3", 33),
_c(U+0034, "4", 34),
_c(U+0035, "5", 35),
_c(U+0036, "6", 36),
_c(U+0037, "7", 37),
_c(U+0038, "8", 38),
_c(U+0039, "9", 39),
_c(U+003A, ":", 3a),
_c(U+003B, ";", 3b),
_c(U+003C, "<", 3c),
_c(U+003D, "=", 3d),
_c(U+003E, ">", 3e),
_c(U+003F, "?", 3f),
_c(U+0040, "@", 40),
_c(U+0041, "A", 41),
_c(U+0042, "B", 42),
_c(U+0043, "C", 43),
_c(U+0044, "D", 44),
_c(U+0045, "E", 45),
_c(U+0046, "F", 46),
_c(U+0047, "G", 47),
_c(U+0048, "H", 48),
_c(U+0049, "I", 49),
_c(U+004A, "J", 4a),
_c(U+004B, "K", 4b),
_c(U+004C, "L", 4c),
_c(U+004D, "M", 4d),
_c(U+004E, "N", 4e),
_c(U+004F, "O", 4f),
_c(U+0050, "P", 50),
_c(U+0051, "Q", 51),
_c(U+0052, "R", 52),
_c(U+0053, "S", 53),
_c(U+0054, "T", 54),
_c(U+0055, "U", 55),
_c(U+0056, "V", 56),
_c(U+0057, "W", 57),
_c(U+0058, "X", 58),
_c(U+0059, "Y", 59),
_c(U+005A, "Z", 5a),
_c(U+005B, "[", 5b),
_c(U+005C, "\\", 5c),
_c(U+005D, "]", 5d),
_c(U+005E, "^", 5e),
_c(U+005F, "_", 5f),
_c(U+0060, "`", 60),
_c(U+0061, "a", 61),
_c(U+0062, "b", 62),
_c(U+0063, "c", 63),
_c(U+0064, "d", 64),
_c(U+0065, "e", 65),
_c(U+0066, "f", 66),
_c(U+0067, "g", 67),
_c(U+0068, "h", 68),
_c(U+0069, "i", 69),
_c(U+006A, "j", 6a),
_c(U+006B, "k", 6b),
_c(U+006C, "l", 6c),
_c(U+006D, "m", 6d),
_c(U+006E, "n", 6e),
_c(U+006F, "o", 6f),
_c(U+0070, "p", 70),
_c(U+0071, "q", 71),
_c(U+0072, "r", 72),
_c(U+0073, "s", 73),
_c(U+0074, "t", 74),
_c(U+0075, "u", 75),
_c(U+0076, "v", 76),
_c(U+0077, "w", 77),
_c(U+0078, "x", 78),
_c(U+0079, "y", 79),
_c(U+007A, "z", 7a),
_c(U+007B,  "", 7b),
_c(U+007C, "|", 7c),
_c(U+007D, "}", 7d),
_c(U+007E, "~", 7e),
_c(U+007F,  "", 7f), // del
_c(U+0080, "", c280),
_c(U+0081, "", c281),
_c(U+0082, "", c282),
_c(U+0083, "", c283),
_c(U+0084, "", c284),
_c(U+0085, "", c285),
_c(U+0086, "", c286),
_c(U+0087, "", c287),
_c(U+0088, "", c288),
_c(U+0089, "", c289),
_c(U+008A, "", c28a),
_c(U+008B, "", c28b),
_c(U+008C, "", c28c),
_c(U+008D, "", c28d),
_c(U+008E, "", c28e),
_c(U+008F, "", c28f),
_c(U+0090, "", c290),
_c(U+0091, "", c291),
_c(U+0092, "", c292),
_c(U+0093, "", c293),
_c(U+0094, "", c294),
_c(U+0095, "", c295),
_c(U+0096, "", c296),
_c(U+0097, "", c297),
_c(U+0098, "", c298),
_c(U+0099, "", c299),
_c(U+009A, "", c29a),
_c(U+009B, "", c29b),
_c(U+009C, "", c29c),
_c(U+009D, "", c29d),
_c(U+009E, "", c29e),
_c(U+009F, "", c29f),
_c(U+00A0, "", c2a0),
_c(U+00A1, "¡", c2a1),
_c(U+00A2, "¢", c2a2),
_c(U+00A3, "£", c2a3),
_c(U+00A4, "¤", c2a4),
_c(U+00A5, "¥", c2a5),
_c(U+00A6, "¦", c2a6),
_c(U+00A7, "§", c2a7),
_c(U+00A8, "¨", c2a8),
_c(U+00A9, "©", c2a9),
_c(U+00AA, "ª", c2aa),
_c(U+00AB, "«", c2ab),
_c(U+00AC, "¬", c2ac),
_c(U+00AD, "­", c2ad),
_c(U+00AE, "®", c2ae),
_c(U+00AF, "¯", c2af),
_c(U+00B0, "°", c2b0),
_c(U+00B1, "±", c2b1),
_c(U+00B2, "²", c2b2),
_c(U+00B3, "³", c2b3),
_c(U+00B4, "´", c2b4),
_c(U+00B5, "µ", c2b5),
_c(U+00B6, "¶", c2b6),
_c(U+00B7, "·", c2b7),
_c(U+00B8, "¸", c2b8),
_c(U+00B9, "¹", c2b9),
_c(U+00BA, "º", c2ba),
_c(U+00BB, "»", c2bb),
_c(U+00BC, "¼", c2bc),
_c(U+00BD, "½", c2bd),
_c(U+00BE, "¾", c2be),
_c(U+00BF, "¿", c2bf),
_c(U+00C0, "À", c380),
_c(U+00C1, "Á", c381),
_c(U+00C2, "Â", c382),
_c(U+00C3, "Ã", c383),
_c(U+00C4, "Ä", c384),
_c(U+00C5, "Å", c385),
_c(U+00C6, "Æ", c386),
_c(U+00C7, "Ç", c387),
_c(U+00C8, "È", c388),
_c(U+00C9, "É", c389),
_c(U+00CA, "Ê", c38a),
_c(U+00CB, "Ë", c38b),
_c(U+00CC, "Ì", c38c),
_c(U+00CD, "Í", c38d),
_c(U+00CE, "Î", c38e),
_c(U+00CF, "Ï", c38f),
_c(U+00D0, "Ð", c390),
_c(U+00D1, "Ñ", c391),
_c(U+00D2, "Ò", c392),
_c(U+00D3, "Ó", c393),
_c(U+00D4, "Ô", c394),
_c(U+00D5, "Õ", c395),
_c(U+00D6, "Ö", c396),
_c(U+00D7, "×", c397),
_c(U+00D8, "Ø", c398),
_c(U+00D9, "Ù", c399),
_c(U+00DA, "Ú", c39a),
_c(U+00DB, "Û", c39b),
_c(U+00DC, "Ü", c39c),
_c(U+00DD, "Ý", c39d),
_c(U+00DE, "Þ", c39e),
_c(U+00DF, "ß", c39f),
_c(U+00E0, "à", c3a0),
_c(U+00E1, "á", c3a1),
_c(U+00E2, "â", c3a2),
_c(U+00E3, "ã", c3a3),
_c(U+00E4, "ä", c3a4),
_c(U+00E5, "å", c3a5),
_c(U+00E6, "æ", c3a6),
_c(U+00E7, "ç", c3a7),
_c(U+00E8, "è", c3a8),
_c(U+00E9, "é", c3a9),
_c(U+00EA, "ê", c3aa),
_c(U+00EB, "ë", c3ab),
_c(U+00EC, "ì", c3ac),
_c(U+00ED, "í", c3ad),
_c(U+00EE, "î", c3ae),
_c(U+00EF, "ï", c3af),
_c(U+00F0, "ð", c3b0),
_c(U+00F1, "ñ", c3b1),
_c(U+00F2, "ò", c3b2),
_c(U+00F3, "ó", c3b3),
_c(U+00F4, "ô", c3b4),
_c(U+00F5, "õ", c3b5),
_c(U+00F6, "ö", c3b6),
_c(U+00F7, "÷", c3b7),
_c(U+00F8, "ø", c3b8),
_c(U+00F9, "ù", c3b9),
_c(U+00FA, "ú", c3ba),
_c(U+00FB, "û", c3bb),
_c(U+00FC, "ü", c3bc),
_c(U+00FD, "ý", c3bd),
_c(U+00FE, "þ", c3be),
_c(U+00FF, "ÿ", c3bf),
_c(U+0100, "Ā", c480),
_c(U+0101, "ā", c481),
_c(U+0102, "Ă", c482),
_c(U+0103, "ă", c483),
_c(U+0104, "Ą", c484),
_c(U+0105, "ą", c485),
_c(U+0106, "Ć", c486),
_c(U+0107, "ć", c487),
_c(U+0108, "Ĉ", c488),
_c(U+0109, "ĉ", c489),
_c(U+010A, "Ċ", c48a),
_c(U+010B, "ċ", c48b),
_c(U+010C, "Č", c48c),
_c(U+010D, "č", c48d),
_c(U+010E, "Ď", c48e),
_c(U+010F, "ď", c48f),
_c(U+0110, "Đ", c490),
_c(U+0111, "đ", c491),
_c(U+0112, "Ē", c492),
_c(U+0113, "ē", c493),
_c(U+0114, "Ĕ", c494),
_c(U+0115, "ĕ", c495),
_c(U+0116, "Ė", c496),
_c(U+0117, "ė", c497),
_c(U+0118, "Ę", c498),
_c(U+0119, "ę", c499),
_c(U+011A, "Ě", c49a),
_c(U+011B, "ě", c49b),
_c(U+011C, "Ĝ", c49c),
_c(U+011D, "ĝ", c49d),
_c(U+011E, "Ğ", c49e),
_c(U+011F, "ğ", c49f),
_c(U+0120, "Ġ", c4a0),
_c(U+0121, "ġ", c4a1),
_c(U+0122, "Ģ", c4a2),
_c(U+0123, "ģ", c4a3),
_c(U+0124, "Ĥ", c4a4),
_c(U+0125, "ĥ", c4a5),
_c(U+0126, "Ħ", c4a6),
_c(U+0127, "ħ", c4a7),
_c(U+0128, "Ĩ", c4a8),
_c(U+0129, "ĩ", c4a9),
_c(U+012A, "Ī", c4aa),
_c(U+012B, "ī", c4ab),
_c(U+012C, "Ĭ", c4ac),
_c(U+012D, "ĭ", c4ad),
_c(U+012E, "Į", c4ae),
_c(U+012F, "į", c4af),
_c(U+0130, "İ", c4b0),
_c(U+0131, "ı", c4b1),
_c(U+0132, "Ĳ", c4b2),
_c(U+0133, "ĳ", c4b3),
_c(U+0134, "Ĵ", c4b4),
_c(U+0135, "ĵ", c4b5),
_c(U+0136, "Ķ", c4b6),
_c(U+0137, "ķ", c4b7),
_c(U+0138, "ĸ", c4b8),
_c(U+0139, "Ĺ", c4b9),
_c(U+013A, "ĺ", c4ba),
_c(U+013B, "Ļ", c4bb),
_c(U+013C, "ļ", c4bc),
_c(U+013D, "Ľ", c4bd),
_c(U+013E, "ľ", c4be),
_c(U+013F, "Ŀ", c4bf),
_c(U+0140, "ŀ", c580),
_c(U+0141, "Ł", c581),
_c(U+0142, "ł", c582),
_c(U+0143, "Ń", c583),
_c(U+0144, "ń", c584),
_c(U+0145, "Ņ", c585),
_c(U+0146, "ņ", c586),
_c(U+0147, "Ň", c587),
_c(U+0148, "ň", c588),
_c(U+0149, "ŉ", c589),
_c(U+014A, "Ŋ", c58a),
_c(U+014B, "ŋ", c58b),
_c(U+014C, "Ō", c58c),
_c(U+014D, "ō", c58d),
_c(U+014E, "Ŏ", c58e),
_c(U+014F, "ŏ", c58f),
_c(U+0150, "Ő", c590),
_c(U+0151, "ő", c591),
_c(U+0152, "Œ", c592),
_c(U+0153, "œ", c593),
_c(U+0154, "Ŕ", c594),
_c(U+0155, "ŕ", c595),
_c(U+0156, "Ŗ", c596),
_c(U+0157, "ŗ", c597),
_c(U+0158, "Ř", c598),
_c(U+0159, "ř", c599),
_c(U+015A, "Ś", c59a),
_c(U+015B, "ś", c59b),
_c(U+015C, "Ŝ", c59c),
_c(U+015D, "ŝ", c59d),
_c(U+015E, "Ş", c59e),
_c(U+015F, "ş", c59f),
_c(U+0160, "Š", c5a0),
_c(U+0161, "š", c5a1),
_c(U+0162, "Ţ", c5a2),
_c(U+0163, "ţ", c5a3),
_c(U+0164, "Ť", c5a4),
_c(U+0165, "ť", c5a5),
_c(U+0166, "Ŧ", c5a6),
_c(U+0167, "ŧ", c5a7),
_c(U+0168, "Ũ", c5a8),
_c(U+0169, "ũ", c5a9),
_c(U+016A, "Ū", c5aa),
_c(U+016B, "ū", c5ab),
_c(U+016C, "Ŭ", c5ac),
_c(U+016D, "ŭ", c5ad),
_c(U+016E, "Ů", c5ae),
_c(U+016F, "ů", c5af),
_c(U+0170, "Ű", c5b0),
_c(U+0171, "ű", c5b1),
_c(U+0172, "Ų", c5b2),
_c(U+0173, "ų", c5b3),
_c(U+0174, "Ŵ", c5b4),
_c(U+0175, "ŵ", c5b5),
_c(U+0176, "Ŷ", c5b6),
_c(U+0177, "ŷ", c5b7),
_c(U+0178, "Ÿ", c5b8),
_c(U+0179, "Ź", c5b9),
_c(U+017A, "ź", c5ba),
_c(U+017B, "Ż", c5bb),
_c(U+017C, "ż", c5bc),
_c(U+017D, "Ž", c5bd),
_c(U+017E, "ž", c5be),
_c(U+017F, "ſ", c5bf),
_c(U+0180, "ƀ", c680),
_c(U+0181, "Ɓ", c681),
_c(U+0182, "Ƃ", c682),
_c(U+0183, "ƃ", c683),
_c(U+0184, "Ƅ", c684),
_c(U+0185, "ƅ", c685),
_c(U+0186, "Ɔ", c686),
_c(U+0187, "Ƈ", c687),
_c(U+0188, "ƈ", c688),
_c(U+0189, "Ɖ", c689),
_c(U+018A, "Ɗ", c68a),
_c(U+018B, "Ƌ", c68b),
_c(U+018C, "ƌ", c68c),
_c(U+018D, "ƍ", c68d),
_c(U+018E, "Ǝ", c68e),
_c(U+018F, "Ə", c68f),
_c(U+0190, "Ɛ", c690),
_c(U+0191, "Ƒ", c691),
_c(U+0192, "ƒ", c692),
_c(U+0193, "Ɠ", c693),
_c(U+0194, "Ɣ", c694),
_c(U+0195, "ƕ", c695),
_c(U+0196, "Ɩ", c696),
_c(U+0197, "Ɨ", c697),
_c(U+0198, "Ƙ", c698),
_c(U+0199, "ƙ", c699),
_c(U+019A, "ƚ", c69a),
_c(U+019B, "ƛ", c69b),
_c(U+019C, "Ɯ", c69c),
_c(U+019D, "Ɲ", c69d),
_c(U+019E, "ƞ", c69e),
_c(U+019F, "Ɵ", c69f),
_c(U+01A0, "Ơ", c6a0),
_c(U+01A1, "ơ", c6a1),
_c(U+01A2, "Ƣ", c6a2),
_c(U+01A3, "ƣ", c6a3),
_c(U+01A4, "Ƥ", c6a4),
_c(U+01A5, "ƥ", c6a5),
_c(U+01A6, "Ʀ", c6a6),
_c(U+01A7, "Ƨ", c6a7),
_c(U+01A8, "ƨ", c6a8),
_c(U+01A9, "Ʃ", c6a9),
_c(U+01AA, "ƪ", c6aa),
_c(U+01AB, "ƫ", c6ab),
_c(U+01AC, "Ƭ", c6ac),
_c(U+01AD, "ƭ", c6ad),
_c(U+01AE, "Ʈ", c6ae),
_c(U+01AF, "Ư", c6af),
_c(U+01B0, "ư", c6b0),
_c(U+01B1, "Ʊ", c6b1),
_c(U+01B2, "Ʋ", c6b2),
_c(U+01B3, "Ƴ", c6b3),
_c(U+01B4, "ƴ", c6b4),
_c(U+01B5, "Ƶ", c6b5),
_c(U+01B6, "ƶ", c6b6),
_c(U+01B7, "Ʒ", c6b7),
_c(U+01B8, "Ƹ", c6b8),
_c(U+01B9, "ƹ", c6b9),
_c(U+01BA, "ƺ", c6ba),
_c(U+01BB, "ƻ", c6bb),
_c(U+01BC, "Ƽ", c6bc),
_c(U+01BD, "ƽ", c6bd),
_c(U+01BE, "ƾ", c6be),
_c(U+01BF, "ƿ", c6bf),
_c(U+01C0, "ǀ", c780),
_c(U+01C1, "ǁ", c781),
_c(U+01C2, "ǂ", c782),
_c(U+01C3, "ǃ", c783),
_c(U+01C4, "Ǆ", c784),
_c(U+01C5, "ǅ", c785),
_c(U+01C6, "ǆ", c786),
_c(U+01C7, "Ǉ", c787),
_c(U+01C8, "ǈ", c788),
_c(U+01C9, "ǉ", c789),
_c(U+01CA, "Ǌ", c78a),
_c(U+01CB, "ǋ", c78b),
_c(U+01CC, "ǌ", c78c),
_c(U+01CD, "Ǎ", c78d),
_c(U+01CE, "ǎ", c78e),
_c(U+01CF, "Ǐ", c78f),
_c(U+01D0, "ǐ", c790),
_c(U+01D1, "Ǒ", c791),
_c(U+01D2, "ǒ", c792),
_c(U+01D3, "Ǔ", c793),
_c(U+01D4, "ǔ", c794),
_c(U+01D5, "Ǖ", c795),
_c(U+01D6, "ǖ", c796),
_c(U+01D7, "Ǘ", c797),
_c(U+01D8, "ǘ", c798),
_c(U+01D9, "Ǚ", c799),
_c(U+01DA, "ǚ", c79a),
_c(U+01DB, "Ǜ", c79b),
_c(U+01DC, "ǜ", c79c),
_c(U+01DD, "ǝ", c79d),
_c(U+01DE, "Ǟ", c79e),
_c(U+01DF, "ǟ", c79f),
_c(U+01E0, "Ǡ", c7a0),
_c(U+01E1, "ǡ", c7a1),
_c(U+01E2, "Ǣ", c7a2),
_c(U+01E3, "ǣ", c7a3),
_c(U+01E4, "Ǥ", c7a4),
_c(U+01E5, "ǥ", c7a5),
_c(U+01E6, "Ǧ", c7a6),
_c(U+01E7, "ǧ", c7a7),
_c(U+01E8, "Ǩ", c7a8),
_c(U+01E9, "ǩ", c7a9),
_c(U+01EA, "Ǫ", c7aa),
_c(U+01EB, "ǫ", c7ab),
_c(U+01EC, "Ǭ", c7ac),
_c(U+01ED, "ǭ", c7ad),
_c(U+01EE, "Ǯ", c7ae),
_c(U+01EF, "ǯ", c7af),
_c(U+01F0, "ǰ", c7b0),
_c(U+01F1, "Ǳ", c7b1),
_c(U+01F2, "ǲ", c7b2),
_c(U+01F3, "ǳ", c7b3),
_c(U+01F4, "Ǵ", c7b4),
_c(U+01F5, "ǵ", c7b5),
_c(U+01F6, "Ƕ", c7b6),
_c(U+01F7, "Ƿ", c7b7),
_c(U+01F8, "Ǹ", c7b8),
_c(U+01F9, "ǹ", c7b9),
_c(U+01FA, "Ǻ", c7ba),
_c(U+01FB, "ǻ", c7bb),
_c(U+01FC, "Ǽ", c7bc),
_c(U+01FD, "ǽ", c7bd),
_c(U+01FE, "Ǿ", c7be),
_c(U+01FF, "ǿ", c7bf),
_c(U+0200, "Ȁ", c880),
_c(U+0201, "ȁ", c881),
_c(U+0202, "Ȃ", c882),
_c(U+0203, "ȃ", c883),
_c(U+0204, "Ȅ", c884),
_c(U+0205, "ȅ", c885),
_c(U+0206, "Ȇ", c886),
_c(U+0207, "ȇ", c887),
_c(U+0208, "Ȉ", c888),
_c(U+0209, "ȉ", c889),
_c(U+020A, "Ȋ", c88a),
_c(U+020B, "ȋ", c88b),
_c(U+020C, "Ȍ", c88c),
_c(U+020D, "ȍ", c88d),
_c(U+020E, "Ȏ", c88e),
_c(U+020F, "ȏ", c88f),
_c(U+0210, "Ȑ", c890),
_c(U+0211, "ȑ", c891),
_c(U+0212, "Ȓ", c892),
_c(U+0213, "ȓ", c893),
_c(U+0214, "Ȕ", c894),
_c(U+0215, "ȕ", c895),
_c(U+0216, "Ȗ", c896),
_c(U+0217, "ȗ", c897),
_c(U+0218, "Ș", c898),
_c(U+0219, "ș", c899),
_c(U+021A, "Ț", c89a),
_c(U+021B, "ț", c89b),
_c(U+021C, "Ȝ", c89c),
_c(U+021D, "ȝ", c89d),
_c(U+021E, "Ȟ", c89e),
_c(U+021F, "ȟ", c89f),
_c(U+0220, "Ƞ", c8a0),
_c(U+0221, "ȡ", c8a1),
_c(U+0222, "Ȣ", c8a2),
_c(U+0223, "ȣ", c8a3),
_c(U+0224, "Ȥ", c8a4),
_c(U+0225, "ȥ", c8a5),
_c(U+0226, "Ȧ", c8a6),
_c(U+0227, "ȧ", c8a7),
_c(U+0228, "Ȩ", c8a8),
_c(U+0229, "ȩ", c8a9),
_c(U+022A, "Ȫ", c8aa),
_c(U+022B, "ȫ", c8ab),
_c(U+022C, "Ȭ", c8ac),
_c(U+022D, "ȭ", c8ad),
_c(U+022E, "Ȯ", c8ae),
_c(U+022F, "ȯ", c8af),
_c(U+0230, "Ȱ", c8b0),
_c(U+0231, "ȱ", c8b1),
_c(U+0232, "Ȳ", c8b2),
_c(U+0233, "ȳ", c8b3),
_c(U+0234, "ȴ", c8b4),
_c(U+0235, "ȵ", c8b5),
_c(U+0236, "ȶ", c8b6),
_c(U+0237, "ȷ", c8b7),
_c(U+0238, "ȸ", c8b8),
_c(U+0239, "ȹ", c8b9),
_c(U+023A, "Ⱥ", c8ba),
_c(U+023B, "Ȼ", c8bb),
_c(U+023C, "ȼ", c8bc),
_c(U+023D, "Ƚ", c8bd),
_c(U+023E, "Ⱦ", c8be),
_c(U+023F, "ȿ", c8bf),
_c(U+0240, "ɀ", c980),
_c(U+0241, "Ɂ", c981),
_c(U+0242, "ɂ", c982),
_c(U+0243, "Ƀ", c983),
_c(U+0244, "Ʉ", c984),
_c(U+0245, "Ʌ", c985),
_c(U+0246, "Ɇ", c986),
_c(U+0247, "ɇ", c987),
_c(U+0248, "Ɉ", c988),
_c(U+0249, "ɉ", c989),
_c(U+024A, "Ɋ", c98a),
_c(U+024B, "ɋ", c98b),
_c(U+024C, "Ɍ", c98c),
_c(U+024D, "ɍ", c98d),
_c(U+024E, "Ɏ", c98e),
_c(U+024F, "ɏ", c98f),
_c(U+0250, "ɐ", c990),
_c(U+0251, "ɑ", c991),
_c(U+0252, "ɒ", c992),
_c(U+0253, "ɓ", c993),
_c(U+0254, "ɔ", c994),
_c(U+0255, "ɕ", c995),
_c(U+0256, "ɖ", c996),
_c(U+0257, "ɗ", c997),
_c(U+0258, "ɘ", c998),
_c(U+0259, "ə", c999),
_c(U+025A, "ɚ", c99a),
_c(U+025B, "ɛ", c99b),
_c(U+025C, "ɜ", c99c),
_c(U+025D, "ɝ", c99d),
_c(U+025E, "ɞ", c99e),
_c(U+025F, "ɟ", c99f),
_c(U+0260, "ɠ", c9a0),
_c(U+0261, "ɡ", c9a1),
_c(U+0262, "ɢ", c9a2),
_c(U+0263, "ɣ", c9a3),
_c(U+0264, "ɤ", c9a4),
_c(U+0265, "ɥ", c9a5),
_c(U+0266, "ɦ", c9a6),
_c(U+0267, "ɧ", c9a7),
_c(U+0268, "ɨ", c9a8),
_c(U+0269, "ɩ", c9a9),
_c(U+026A, "ɪ", c9aa),
_c(U+026B, "ɫ", c9ab),
_c(U+026C, "ɬ", c9ac),
_c(U+026D, "ɭ", c9ad),
_c(U+026E, "ɮ", c9ae),
_c(U+026F, "ɯ", c9af),
_c(U+0270, "ɰ", c9b0),
_c(U+0271, "ɱ", c9b1),
_c(U+0272, "ɲ", c9b2),
_c(U+0273, "ɳ", c9b3),
_c(U+0274, "ɴ", c9b4),
_c(U+0275, "ɵ", c9b5),
_c(U+0276, "ɶ", c9b6),
_c(U+0277, "ɷ", c9b7),
_c(U+0278, "ɸ", c9b8),
_c(U+0279, "ɹ", c9b9),
_c(U+027A, "ɺ", c9ba),
_c(U+027B, "ɻ", c9bb),
_c(U+027C, "ɼ", c9bc),
_c(U+027D, "ɽ", c9bd),
_c(U+027E, "ɾ", c9be),
_c(U+027F, "ɿ", c9bf),
_c(U+0280, "ʀ", ca80),
_c(U+0281, "ʁ", ca81),
_c(U+0282, "ʂ", ca82),
_c(U+0283, "ʃ", ca83),
_c(U+0284, "ʄ", ca84),
_c(U+0285, "ʅ", ca85),
_c(U+0286, "ʆ", ca86),
_c(U+0287, "ʇ", ca87),
_c(U+0288, "ʈ", ca88),
_c(U+0289, "ʉ", ca89),
_c(U+028A, "ʊ", ca8a),
_c(U+028B, "ʋ", ca8b),
_c(U+028C, "ʌ", ca8c),
_c(U+028D, "ʍ", ca8d),
_c(U+028E, "ʎ", ca8e),
_c(U+028F, "ʏ", ca8f),
_c(U+0290, "ʐ", ca90),
_c(U+0291, "ʑ", ca91),
_c(U+0292, "ʒ", ca92),
_c(U+0293, "ʓ", ca93),
_c(U+0294, "ʔ", ca94),
_c(U+0295, "ʕ", ca95),
_c(U+0296, "ʖ", ca96),
_c(U+0297, "ʗ", ca97),
_c(U+0298, "ʘ", ca98),
_c(U+0299, "ʙ", ca99),
_c(U+029A, "ʚ", ca9a),
_c(U+029B, "ʛ", ca9b),
_c(U+029C, "ʜ", ca9c),
_c(U+029D, "ʝ", ca9d),
_c(U+029E, "ʞ", ca9e),
_c(U+029F, "ʟ", ca9f),
_c(U+02A0, "ʠ", caa0),
_c(U+02A1, "ʡ", caa1),
_c(U+02A2, "ʢ", caa2),
_c(U+02A3, "ʣ", caa3),
_c(U+02A4, "ʤ", caa4),
_c(U+02A5, "ʥ", caa5),
_c(U+02A6, "ʦ", caa6),
_c(U+02A7, "ʧ", caa7),
_c(U+02A8, "ʨ", caa8),
_c(U+02A9, "ʩ", caa9),
_c(U+02AA, "ʪ", caaa),
_c(U+02AB, "ʫ", caab),
_c(U+02AC, "ʬ", caac),
_c(U+02AD, "ʭ", caad),
_c(U+02AE, "ʮ", caae),
_c(U+02AF, "ʯ", caaf),
_c(U+02B0, "ʰ", cab0),
_c(U+02B1, "ʱ", cab1),
_c(U+02B2, "ʲ", cab2),
_c(U+02B3, "ʳ", cab3),
_c(U+02B4, "ʴ", cab4),
_c(U+02B5, "ʵ", cab5),
_c(U+02B6, "ʶ", cab6),
_c(U+02B7, "ʷ", cab7),
_c(U+02B8, "ʸ", cab8),
_c(U+02B9, "ʹ", cab9),
_c(U+02BA, "ʺ", caba),
_c(U+02BB, "ʻ", cabb),
_c(U+02BC, "ʼ", cabc),
_c(U+02BD, "ʽ", cabd),
_c(U+02BE, "ʾ", cabe),
_c(U+02BF, "ʿ", cabf),
_c(U+02C0, "ˀ", cb80),
_c(U+02C1, "ˁ", cb81),
_c(U+02C2, "˂", cb82),
_c(U+02C3, "˃", cb83),
_c(U+02C4, "˄", cb84),
_c(U+02C5, "˅", cb85),
_c(U+02C6, "ˆ", cb86),
_c(U+02C7, "ˇ", cb87),
_c(U+02C8, "ˈ", cb88),
_c(U+02C9, "ˉ", cb89),
_c(U+02CA, "ˊ", cb8a),
_c(U+02CB, "ˋ", cb8b),
_c(U+02CC, "ˌ", cb8c),
_c(U+02CD, "ˍ", cb8d),
_c(U+02CE, "ˎ", cb8e),
_c(U+02CF, "ˏ", cb8f),
_c(U+02D0, "ː", cb90),
_c(U+02D1, "ˑ", cb91),
_c(U+02D2, "˒", cb92),
_c(U+02D3, "˓", cb93),
_c(U+02D4, "˔", cb94),
_c(U+02D5, "˕", cb95),
_c(U+02D6, "˖", cb96),
_c(U+02D7, "˗", cb97),
_c(U+02D8, "˘", cb98),
_c(U+02D9, "˙", cb99),
_c(U+02DA, "˚", cb9a),
_c(U+02DB, "˛", cb9b),
_c(U+02DC, "˜", cb9c),
_c(U+02DD, "˝", cb9d),
_c(U+02DE, "˞", cb9e),
_c(U+02DF, "˟", cb9f),
_c(U+02E0, "ˠ", cba0),
_c(U+02E1, "ˡ", cba1),
_c(U+02E2, "ˢ", cba2),
_c(U+02E3, "ˣ", cba3),
_c(U+02E4, "ˤ", cba4),
_c(U+02E5, "˥", cba5),
_c(U+02E6, "˦", cba6),
_c(U+02E7, "˧", cba7),
_c(U+02E8, "˨", cba8),
_c(U+02E9, "˩", cba9),
_c(U+02EA, "˪", cbaa),
_c(U+02EB, "˫", cbab),
_c(U+02EC, "ˬ", cbac),
_c(U+02ED, "˭", cbad),
_c(U+02EE, "ˮ", cbae),
_c(U+02EF, "˯", cbaf),
_c(U+02F0, "˰", cbb0),
_c(U+02F1, "˱", cbb1),
_c(U+02F2, "˲", cbb2),
_c(U+02F3, "˳", cbb3),
_c(U+02F4, "˴", cbb4),
_c(U+02F5, "˵", cbb5),
_c(U+02F6, "˶", cbb6),
_c(U+02F7, "˷", cbb7),
_c(U+02F8, "˸", cbb8),
_c(U+02F9, "˹", cbb9),
_c(U+02FA, "˺", cbba),
_c(U+02FB, "˻", cbbb),
_c(U+02FC, "˼", cbbc),
_c(U+02FD, "˽", cbbd),
_c(U+02FE, "˾", cbbe),
//_c(U+02FF, "˿", cbbf),
//_c(U+0300, ̀"̀	", cc80),
//_c(U+0301, ́" ", cc81),
//_c(U+0302, ̂" ", cc82),
//_c(U+0303, ̃" ", cc83),
//_c(U+0304, ̄" ", cc84),
//_c(U+0305, "̅" , cc85),
//_c(U+0306, ̆" ", cc86),
//_c(U+0307, ̇" ", cc87),
//_c(U+0308, ̈" ", cc88),
//_c(U+0309, ̉" ", cc89),
//_c(U+030A, ̊" ", cc8a),
//_c(U+030B, ̋" ", cc8b),
//_c(U+030C, ̌" ", cc8c),
//_c(U+030D, "̍" , cc8d),
//_c(U+030E, "̎" , cc8e),
//_c(U+030F, ̏" ", cc8f),
//_c(U+0310, "̐" , cc90),
//_c(U+0311, ̑" ", cc91),
//_c(U+0312, ̒" ", cc92),
//_c(U+0313, "̓" , cc93),
//_c(U+0314, "̔" , cc94),
//_c(U+0315, "̕" , cc95),
//_c(U+0316, "̖" , cc96),
//_c(U+0317, "̗" , cc97),
//_c(U+0318, "̘" , cc98),
//_c(U+0319, "̙" , cc99),
//_c(U+031A, "̚" , cc9a),
//_c(U+031B, ̛" ", cc9b),
//_c(U+031C, "̜" , cc9c),
//_c(U+031D, "̝" , cc9d),
//_c(U+031E, "̞" , cc9e),
_c(U+031F, "̟" , cc9f),
_c(U+0320, "̠" , cca0),
_c(U+0321, "̡" , cca1),
_c(U+0322, "̢" , cca2),
//_c(U+0323, ̣" ", cca3),
//_c(U+0324, ̤" ", cca4),
_c(U+0325, "̥" , cca5),
//_c(U+0326, ̦" ", cca6),
//_c(U+0327, ̧" ", cca7),
//_c(U+0328, ̨" ", cca8),
//_c(U+0329, "̩" , cca9),
_c(U+032A, "̪" , ccaa),
_c(U+032B, "̫" , ccab),
_c(U+032C, "̬" , ccac),
_c(U+032D, "̭" , ccad),
//_c(U+032E, ̮" ", ccae),
_c(U+032F, "̯" , ccaf),
_c(U+0330, "̰" , ccb0),
//_c(U+0331, ̱" ", ccb1),
_c(U+0332, "̲" , ccb2),
_c(U+0333, "̳" , ccb3),
_c(U+0334, "̴" , ccb4),
//_c(U+0335, ̵" ", ccb5),
//_c(U+0336, ̶" ", ccb6),
_c(U+0337, "̷" , ccb7),
_c(U+0338, "̸" , ccb8),
_c(U+0339, "̹" , ccb9),
_c(U+033A, "̺" , ccba),
_c(U+033B, "̻" , ccbb),
_c(U+033C, "̼" , ccbc),
_c(U+033D, "̽" , ccbd),
_c(U+033E, "̾" , ccbe),
_c(U+033F, "̿" , ccbf),
_c(U+0340, "̀" , cd80),
_c(U+0341, "́" , cd81),
_c(U+0342, "͂" , cd82),
_c(U+0343, "̓" , cd83),
_c(U+0344, "̈́" , cd84),
_c(U+0345, "ͅ" , cd85),
_c(U+0346, "͆" , cd86),
_c(U+0347, "͇" , cd87),
_c(U+0348, "͈" , cd88),
_c(U+0349, "͉" , cd89),
_c(U+034A, "͊" , cd8a),
_c(U+034B, "͋" , cd8b),
_c(U+034C, "͌" , cd8c),
_c(U+034D, "͍" , cd8d),
_c(U+034E, "͎" , cd8e),
_c(U+034F, "͏" , cd8f),
_c(U+0350, "͐" , cd90),
_c(U+0351, "͑" , cd91),
_c(U+0352, "͒" , cd92),
_c(U+0353, "͓" , cd93),
_c(U+0354, "͔" , cd94),
_c(U+0355, "͕" , cd95),
_c(U+0356, "͖" , cd96),
_c(U+0357, "͗" , cd97),
_c(U+0358, "͘" , cd98),
_c(U+0359, "͙" , cd99),
_c(U+035A, "͚" , cd9a),
_c(U+035B, "͛" , cd9b),
_c(U+035C, "͜" , cd9c),
_c(U+035D, "͝" , cd9d),
_c(U+035E, "͞" , cd9e),
_c(U+035F, "͟" , cd9f),
_c(U+0360, "͠" , cda0),
_c(U+0361, "͡" , cda1),
_c(U+0362, "͢" , cda2),
_c(U+0363, "ͣ" , cda3),
_c(U+0364, "ͤ" , cda4),
_c(U+0365, "ͥ" , cda5),
_c(U+0366, "ͦ" , cda6),
_c(U+0367, "ͧ" , cda7),
_c(U+0368, "ͨ" , cda8),
_c(U+0369, "ͩ" , cda9),
_c(U+036A, "ͪ" , cdaa),
_c(U+036B, "ͫ" , cdab),
_c(U+036C, "ͬ" , cdac),
_c(U+036D, "ͭ" , cdad),
_c(U+036E, "ͮ" , cdae),
_c(U+036F, "ͯ" , cdaf),
_c(U+0370, "Ͱ", cdb0),
_c(U+0371, "ͱ", cdb1),
_c(U+0372, "Ͳ", cdb2),
_c(U+0373, "ͳ", cdb3),
_c(U+0374, "ʹ", cdb4),
_c(U+0375, "͵", cdb5),
_c(U+0376, "Ͷ", cdb6),
_c(U+0377, "ͷ", cdb7),
_c(U+0378, "͸", cdb8),
_c(U+0379, "͹", cdb9),
_c(U+037A, "ͺ", cdba),
_c(U+037B, "ͻ", cdbb),
_c(U+037C, "ͼ", cdbc),
_c(U+037D, "ͽ", cdbd),
_c(U+037E, ";", cdbe),
_c(U+037F, "Ϳ", cdbf),
_c(U+0380, "΀", ce80),
_c(U+0381, "΁", ce81),
_c(U+0382, "΂", ce82),
_c(U+0383, "΃", ce83),
_c(U+0384, "΄", ce84),
_c(U+0385, "΅", ce85),
_c(U+0386, "Ά", ce86),
_c(U+0387, "·", ce87),
_c(U+0388, "Έ", ce88),
_c(U+0389, "Ή", ce89),
_c(U+038A, "Ί", ce8a),
_c(U+038B, "΋", ce8b),
_c(U+038C, "Ό", ce8c),
_c(U+038D, "΍", ce8d),
_c(U+038E, "Ύ", ce8e),
_c(U+038F, "Ώ", ce8f),
_c(U+0390, "ΐ", ce90),
_c(U+0391, "Α", ce91),
_c(U+0392, "Β", ce92),
_c(U+0393, "Γ", ce93),
_c(U+0394, "Δ", ce94),
_c(U+0395, "Ε", ce95),
_c(U+0396, "Ζ", ce96),
_c(U+0397, "Η", ce97),
_c(U+0398, "Θ", ce98),
_c(U+0399, "Ι", ce99),
_c(U+039A, "Κ", ce9a),
_c(U+039B, "Λ", ce9b),
_c(U+039C, "Μ", ce9c),
_c(U+039D, "Ν", ce9d),
_c(U+039E, "Ξ", ce9e),
_c(U+039F, "Ο", ce9f),
_c(U+03A0, "Π", cea0),
_c(U+03A1, "Ρ", cea1),
_c(U+03A2, "΢", cea2),
_c(U+03A3, "Σ", cea3),
_c(U+03A4, "Τ", cea4),
_c(U+03A5, "Υ", cea5),
_c(U+03A6, "Φ", cea6),
_c(U+03A7, "Χ", cea7),
_c(U+03A8, "Ψ", cea8),
_c(U+03A9, "Ω", cea9),
_c(U+03AA, "Ϊ", ceaa),
_c(U+03AB, "Ϋ", ceab),
_c(U+03AC, "ά", ceac),
_c(U+03AD, "έ", cead),
_c(U+03AE, "ή", ceae),
_c(U+03AF, "ί", ceaf),
_c(U+03B0, "ΰ", ceb0),
_c(U+03B1, "α", ceb1),
_c(U+03B2, "β", ceb2),
_c(U+03B3, "γ", ceb3),
_c(U+03B4, "δ", ceb4),
_c(U+03B5, "ε", ceb5),
_c(U+03B6, "ζ", ceb6),
_c(U+03B7, "η", ceb7),
_c(U+03B8, "θ", ceb8),
_c(U+03B9, "ι", ceb9),
_c(U+03BA, "κ", ceba),
_c(U+03BB, "λ", cebb),
_c(U+03BC, "μ", cebc),
_c(U+03BD, "ν", cebd),
_c(U+03BE, "ξ", cebe),
_c(U+03BF, "ο", cebf),
_c(U+03C0, "π", cf80),
_c(U+03C1, "ρ", cf81),
_c(U+03C2, "ς", cf82),
_c(U+03C3, "σ", cf83),
_c(U+03C4, "τ", cf84),
_c(U+03C5, "υ", cf85),
_c(U+03C6, "φ", cf86),
_c(U+03C7, "χ", cf87),
_c(U+03C8, "ψ", cf88),
_c(U+03C9, "ω", cf89),
_c(U+03CA, "ϊ", cf8a),
_c(U+03CB, "ϋ", cf8b),
_c(U+03CC, "ό", cf8c),
_c(U+03CD, "ύ", cf8d),
_c(U+03CE, "ώ", cf8e),
_c(U+03CF, "Ϗ", cf8f),
_c(U+03D0, "ϐ", cf90),
_c(U+03D1, "ϑ", cf91),
_c(U+03D2, "ϒ", cf92),
_c(U+03D3, "ϓ", cf93),
_c(U+03D4, "ϔ", cf94),
_c(U+03D5, "ϕ", cf95),
_c(U+03D6, "ϖ", cf96),
_c(U+03D7, "ϗ", cf97),
_c(U+03D8, "Ϙ", cf98),
_c(U+03D9, "ϙ", cf99),
_c(U+03DA, "Ϛ", cf9a),
_c(U+03DB, "ϛ", cf9b),
_c(U+03DC, "Ϝ", cf9c),
_c(U+03DD, "ϝ", cf9d),
_c(U+03DE, "Ϟ", cf9e),
_c(U+03DF, "ϟ", cf9f),
_c(U+03E0, "Ϡ", cfa0),
_c(U+03E1, "ϡ", cfa1),
_c(U+03E2, "Ϣ", cfa2),
_c(U+03E3, "ϣ", cfa3),
_c(U+03E4, "Ϥ", cfa4),
_c(U+03E5, "ϥ", cfa5),
_c(U+03E6, "Ϧ", cfa6),
_c(U+03E7, "ϧ", cfa7),
_c(U+03E8, "Ϩ", cfa8),
_c(U+03E9, "ϩ", cfa9),
_c(U+03EA, "Ϫ", cfaa),
_c(U+03EB, "ϫ", cfab),
_c(U+03EC, "Ϭ", cfac),
_c(U+03ED, "ϭ", cfad),
_c(U+03EE, "Ϯ", cfae),
_c(U+03EF, "ϯ", cfaf),
_c(U+03F0, "ϰ", cfb0),
_c(U+03F1, "ϱ", cfb1),
_c(U+03F2, "ϲ", cfb2),
_c(U+03F3, "ϳ", cfb3),
_c(U+03F4, "ϴ", cfb4),
_c(U+03F5, "ϵ", cfb5),
_c(U+03F6, "϶", cfb6),
_c(U+03F7, "Ϸ", cfb7),
_c(U+03F8, "ϸ", cfb8),
_c(U+03F9, "Ϲ", cfb9),
_c(U+03FA, "Ϻ", cfba),
_c(U+03FB, "ϻ", cfbb),
_c(U+03FC, "ϼ", cfbc),
_c(U+03FD, "Ͻ", cfbd),
_c(U+03FE, "Ͼ", cfbe),
_c(U+03FF, "Ͽ", cfbf),
_c(U+0400, "Ѐ", d080),
_c(U+0401, "Ё", d081),
_c(U+0402, "Ђ", d082),
_c(U+0403, "Ѓ", d083),
_c(U+0404, "Є", d084),
_c(U+0405, "Ѕ", d085),
_c(U+0406, "І", d086),
_c(U+0407, "Ї", d087),
_c(U+0408, "Ј", d088),
_c(U+0409, "Љ", d089),
_c(U+040A, "Њ", d08a),
_c(U+040B, "Ћ", d08b),
_c(U+040C, "Ќ", d08c),
_c(U+040D, "Ѝ", d08d),
_c(U+040E, "Ў", d08e),
_c(U+040F, "Џ", d08f),
_c(U+0410, "А", d090),
_c(U+0411, "Б", d091),
_c(U+0412, "В", d092),
_c(U+0413, "Г", d093),
_c(U+0414, "Д", d094),
_c(U+0415, "Е", d095),
_c(U+0416, "Ж", d096),
_c(U+0417, "З", d097),
_c(U+0418, "И", d098),
_c(U+0419, "Й", d099),
_c(U+041A, "К", d09a),
_c(U+041B, "Л", d09b),
_c(U+041C, "М", d09c),
_c(U+041D, "Н", d09d),
_c(U+041E, "О", d09e),
_c(U+041F, "П", d09f),
_c(U+0420, "Р", d0a0),
_c(U+0421, "С", d0a1),
_c(U+0422, "Т", d0a2),
_c(U+0423, "У", d0a3),
_c(U+0424, "Ф", d0a4),
_c(U+0425, "Х", d0a5),
_c(U+0426, "Ц", d0a6),
_c(U+0427, "Ч", d0a7),
_c(U+0428, "Ш", d0a8),
_c(U+0429, "Щ", d0a9),
_c(U+042A, "Ъ", d0aa),
_c(U+042B, "Ы", d0ab),
_c(U+042C, "Ь", d0ac),
_c(U+042D, "Э", d0ad),
_c(U+042E, "Ю", d0ae),
_c(U+042F, "Я", d0af),
_c(U+0430, "а", d0b0),
_c(U+0431, "б", d0b1),
_c(U+0432, "в", d0b2),
_c(U+0433, "г", d0b3),
_c(U+0434, "д", d0b4),
_c(U+0435, "е", d0b5),
_c(U+0436, "ж", d0b6),
_c(U+0437, "з", d0b7),
_c(U+0438, "и", d0b8),
_c(U+0439, "й", d0b9),
_c(U+043A, "к", d0ba),
_c(U+043B, "л", d0bb),
_c(U+043C, "м", d0bc),
_c(U+043D, "н", d0bd),
_c(U+043E, "о", d0be),
_c(U+043F, "п", d0bf),
_c(U+0440, "р", d180),
_c(U+0441, "с", d181),
_c(U+0442, "т", d182),
_c(U+0443, "у", d183),
_c(U+0444, "ф", d184),
_c(U+0445, "х", d185),
_c(U+0446, "ц", d186),
_c(U+0447, "ч", d187),
_c(U+0448, "ш", d188),
_c(U+0449, "щ", d189),
_c(U+044A, "ъ", d18a),
_c(U+044B, "ы", d18b),
_c(U+044C, "ь", d18c),
_c(U+044D, "э", d18d),
_c(U+044E, "ю", d18e),
_c(U+044F, "я", d18f),
_c(U+0450, "ѐ", d190),
_c(U+0451, "ё", d191),
_c(U+0452, "ђ", d192),
_c(U+0453, "ѓ", d193),
_c(U+0454, "є", d194),
_c(U+0455, "ѕ", d195),
_c(U+0456, "і", d196),
_c(U+0457, "ї", d197),
_c(U+0458, "ј", d198),
_c(U+0459, "љ", d199),
_c(U+045A, "њ", d19a),
_c(U+045B, "ћ", d19b),
_c(U+045C, "ќ", d19c),
_c(U+045D, "ѝ", d19d),
_c(U+045E, "ў", d19e),
_c(U+045F, "џ", d19f),
_c(U+0460, "Ѡ", d1a0),
_c(U+0461, "ѡ", d1a1),
_c(U+0462, "Ѣ", d1a2),
_c(U+0463, "ѣ", d1a3),
_c(U+0464, "Ѥ", d1a4),
_c(U+0465, "ѥ", d1a5),
_c(U+0466, "Ѧ", d1a6),
_c(U+0467, "ѧ", d1a7),
_c(U+0468, "Ѩ", d1a8),
_c(U+0469, "ѩ", d1a9),
_c(U+046A, "Ѫ", d1aa),
_c(U+046B, "ѫ", d1ab),
_c(U+046C, "Ѭ", d1ac),
_c(U+046D, "ѭ", d1ad),
_c(U+046E, "Ѯ", d1ae),
_c(U+046F, "ѯ", d1af),
_c(U+0470, "Ѱ", d1b0),
_c(U+0471, "ѱ", d1b1),
_c(U+0472, "Ѳ", d1b2),
_c(U+0473, "ѳ", d1b3),
_c(U+0474, "Ѵ", d1b4),
_c(U+0475, "ѵ", d1b5),
_c(U+0476, "Ѷ", d1b6),
_c(U+0477, "ѷ", d1b7),
_c(U+0478, "Ѹ", d1b8),
_c(U+0479, "ѹ", d1b9),
_c(U+047A, "Ѻ", d1ba),
_c(U+047B, "ѻ", d1bb),
_c(U+047C, "Ѽ", d1bc),
_c(U+047D, "ѽ", d1bd),
_c(U+047E, "Ѿ", d1be),
_c(U+047F, "ѿ", d1bf),
_c(U+20A0, "₠", e282a0),
_c(U+20A1, "₡", e282a1),
_c(U+20A2, "₢", e282a2),
_c(U+20A3, "₣", e282a3),
_c(U+20A4, "₤", e282a4),
_c(U+20A5, "₥", e282a5),
_c(U+20A6, "₦", e282a6),
_c(U+20A7, "₧", e282a7),
_c(U+20A8, "₨", e282a8),
_c(U+20A9, "₩", e282a9),
_c(U+20AA, "₪", e282aa),
_c(U+20AB, "₫", e282ab),
_c(U+20AC, "€", e282ac),
_c(U+20AD, "₭", e282ad),
_c(U+20AE, "₮", e282ae),
_c(U+20AF, "₯", e282af),
_c(U+20B0, "₰", e282b0),
_c(U+20B1, "₱", e282b1),
_c(U+20B2, "₲", e282b2),
_c(U+20B3, "₳", e282b3),
_c(U+20B4, "₴", e282b4),
_c(U+20B5, "₵", e282b5),
_c(U+20B6, "₶", e282b6),
_c(U+20B7, "₷", e282b7),
_c(U+20B8, "₸", e282b8),
_c(U+20B9, "₹", e282b9),
_c(U+20BA, "₺", e282ba),
_c(U+20BB, "₻", e282bb),
_c(U+20BC, "₼", e282bc),
_c(U+20BD, "₽", e282bd),
_c(U+20BE, "₾", e282be),
_c(U+20BF, "₿", e282bf),
_c(U+20C0, "⃀", e28380),
_c(U+20C1, "⃁", e28381),
_c(U+20C2, "⃂", e28382),
_c(U+20C3, "⃃", e28383),
_c(U+20C4, "⃄", e28384),
_c(U+20C5, "⃅", e28385),
_c(U+20C6, "⃆", e28386),
_c(U+20C7, "⃇", e28387),
_c(U+20C8, "⃈", e28388),
_c(U+20C9, "⃉", e28389),
_c(U+20CA, "⃊", e2838a),
_c(U+20CB, "⃋", e2838b),
_c(U+20CC, "⃌", e2838c),
_c(U+20CD, "⃍", e2838d),
_c(U+20CE, "⃎", e2838e),
_c(U+20CF, "⃏", e2838f),
_c(U+20D0, "⃐", e28390),
_c(U+20D1, "⃑", e28391),
_c(U+20D2, "⃒", e28392),
_c(U+20D3, "⃓", e28393),
_c(U+20D4, "⃔", e28394),
_c(U+20D5, "⃕", e28395),
_c(U+20D6, "⃖", e28396),
_c(U+20D7, "⃗", e28397),
_c(U+20D8, "⃘", e28398),
_c(U+20D9, "⃙", e28399),
_c(U+20DA, "⃚", e2839a),
_c(U+20DB, "⃛", e2839b),
_c(U+20DC, "⃜", e2839c),
_c(U+20DD, "⃝", e2839d),
_c(U+20DE, "⃞", e2839e),
_c(U+20DF, "⃟", e2839f),
_c(U+20E0, "⃠", e283a0),
_c(U+20E1, "⃡", e283a1),
_c(U+20E2, "⃢", e283a2),
_c(U+20E3, "⃣", e283a3),
_c(U+20E4, "⃤", e283a4),
_c(U+20E5, "⃥", e283a5),
_c(U+20E6, "⃦", e283a6),
_c(U+20E7, "⃧", e283a7),
_c(U+20E8, "⃨", e283a8),
_c(U+20E9, "⃩", e283a9),
_c(U+20EA, "⃪", e283aa),
_c(U+20EB, "⃫", e283ab),
_c(U+20EC, "⃬", e283ac),
_c(U+20ED, "⃭", e283ad),
_c(U+20EE, "⃮", e283ae),
_c(U+20EF, "⃯", e283af),
_c(U+20F0, "⃰", e283b0),
_c(U+20F1, "⃱", e283b1),
_c(U+20F2, "⃲", e283b2),
_c(U+20F3, "⃳", e283b3),
_c(U+20F4, "⃴", e283b4),
_c(U+20F5, "⃵", e283b5),
_c(U+20F6, "⃶", e283b6),
_c(U+20F7, "⃷", e283b7),
_c(U+20F8, "⃸", e283b8),
_c(U+20F9, "⃹", e283b9),
_c(U+20FA, "⃺", e283ba),
_c(U+20FB, "⃻", e283bb),
_c(U+20FC, "⃼", e283bc),
_c(U+20FD, "⃽", e283bd),
_c(U+20FE, "⃾", e283be),
_c(U+20FF, "⃿", e283bf),
_c(U+2100, "℀", e28480),
_c(U+2101, "℁", e28481),
_c(U+2102, "ℂ", e28482),
_c(U+2103, "℃", e28483),
_c(U+2104, "℄", e28484),
_c(U+2105, "℅", e28485),
_c(U+2106, "℆", e28486),
_c(U+2107, "ℇ", e28487),
_c(U+2108, "℈", e28488),
_c(U+2109, "℉", e28489),
_c(U+210A, "ℊ", e2848a),
_c(U+210B, "ℋ", e2848b),
_c(U+210C, "ℌ", e2848c),
_c(U+210D, "ℍ", e2848d),
_c(U+210E, "ℎ", e2848e),
_c(U+210F, "ℏ", e2848f),
_c(U+2110, "ℐ", e28490),
_c(U+2111, "ℑ", e28491),
_c(U+2112, "ℒ", e28492),
_c(U+2113, "ℓ", e28493),
_c(U+2114, "℔", e28494),
_c(U+2115, "ℕ", e28495),
_c(U+2116, "№", e28496),
_c(U+2117, "℗", e28497),
_c(U+2118, "℘", e28498),
_c(U+2119, "ℙ", e28499),
_c(U+211A, "ℚ", e2849a),
_c(U+211B, "ℛ", e2849b),
_c(U+211C, "ℜ", e2849c),
_c(U+211D, "ℝ", e2849d),
_c(U+211E, "℞", e2849e),
_c(U+211F, "℟", e2849f),
_c(U+2120, "℠", e284a0),
_c(U+2121, "℡", e284a1),
_c(U+2122, "™", e284a2),
_c(U+2123, "℣", e284a3),
_c(U+2124, "ℤ", e284a4),
_c(U+2125, "℥", e284a5),
_c(U+2126, "Ω", e284a6),
_c(U+2127, "℧", e284a7),
_c(U+2128, "ℨ", e284a8),
_c(U+2129, "℩", e284a9),
_c(U+212A, "K", e284aa),
_c(U+212B, "Å", e284ab),
_c(U+212C, "ℬ", e284ac),
_c(U+212D, "ℭ", e284ad),
_c(U+212E, "℮", e284ae),
_c(U+212F, "ℯ", e284af),
_c(U+2130, "ℰ", e284b0),
_c(U+2131, "ℱ", e284b1),
_c(U+2132, "Ⅎ", e284b2),
_c(U+2133, "ℳ", e284b3),
_c(U+2134, "ℴ", e284b4),
_c(U+2135, "ℵ", e284b5),
_c(U+2136, "ℶ", e284b6),
_c(U+2137, "ℷ", e284b7),
_c(U+2138, "ℸ", e284b8),
_c(U+2139, "ℹ", e284b9),
_c(U+213A, "℺", e284ba),
_c(U+213B, "℻", e284bb),
_c(U+213C, "ℼ", e284bc),
_c(U+213D, "ℽ", e284bd),
_c(U+213E, "ℾ", e284be),
_c(U+213F, "ℿ", e284bf),
_c(U+2140, "⅀", e28580),
_c(U+2141, "⅁", e28581),
_c(U+2142, "⅂", e28582),
_c(U+2143, "⅃", e28583),
_c(U+2144, "⅄", e28584),
_c(U+2145, "ⅅ", e28585),
_c(U+2146, "ⅆ", e28586),
_c(U+2147, "ⅇ", e28587),
_c(U+2148, "ⅈ", e28588),
_c(U+2149, "ⅉ", e28589),
_c(U+214A, "⅊", e2858a),
_c(U+214B, "⅋", e2858b),
_c(U+214C, "⅌", e2858c),
_c(U+214D, "⅍", e2858d),
_c(U+214E, "ⅎ", e2858e),
_c(U+214F, "⅏", e2858f),
_c(U+2150, "⅐", e28590),
_c(U+2151, "⅑", e28591),
_c(U+2152, "⅒", e28592),
_c(U+2153, "⅓", e28593),
_c(U+2154, "⅔", e28594),
_c(U+2155, "⅕", e28595),
_c(U+2156, "⅖", e28596),
_c(U+2157, "⅗", e28597),
_c(U+2158, "⅘", e28598),
_c(U+2159, "⅙", e28599),
_c(U+215A, "⅚", e2859a),
_c(U+215B, "⅛", e2859b),
_c(U+215C, "⅜", e2859c),
_c(U+215D, "⅝", e2859d),
_c(U+215E, "⅞", e2859e),
_c(U+215F, "⅟", e2859f),
_c(U+2160, "Ⅰ", e285a0),
_c(U+2161, "Ⅱ", e285a1),
_c(U+2162, "Ⅲ", e285a2),
_c(U+2163, "Ⅳ", e285a3),
_c(U+2164, "Ⅴ", e285a4),
_c(U+2165, "Ⅵ", e285a5),
_c(U+2166, "Ⅶ", e285a6),
_c(U+2167, "Ⅷ", e285a7),
_c(U+2168, "Ⅸ", e285a8),
_c(U+2169, "Ⅹ", e285a9),
_c(U+216A, "Ⅺ", e285aa),
_c(U+216B, "Ⅻ", e285ab),
_c(U+216C, "Ⅼ", e285ac),
_c(U+216D, "Ⅽ", e285ad),
_c(U+216E, "Ⅾ", e285ae),
_c(U+216F, "Ⅿ", e285af),
_c(U+2170, "ⅰ", e285b0),
_c(U+2171, "ⅱ", e285b1),
_c(U+2172, "ⅲ", e285b2),
_c(U+2173, "ⅳ", e285b3),
_c(U+2174, "ⅴ", e285b4),
_c(U+2175, "ⅵ", e285b5),
_c(U+2176, "ⅶ", e285b6),
_c(U+2177, "ⅷ", e285b7),
_c(U+2178, "ⅸ", e285b8),
_c(U+2179, "ⅹ", e285b9),
_c(U+217A, "ⅺ", e285ba),
_c(U+217B, "ⅻ", e285bb),
_c(U+217C, "ⅼ", e285bc),
_c(U+217D, "ⅽ", e285bd),
_c(U+217E, "ⅾ", e285be),
_c(U+217F, "ⅿ", e285bf),
_c(U+2180, "ↀ", e28680),
_c(U+2181, "ↁ", e28681),
_c(U+2182, "ↂ", e28682),
_c(U+2183, "Ↄ", e28683),
_c(U+2184, "ↄ", e28684),
_c(U+2185, "ↅ", e28685),
_c(U+2186, "ↆ", e28686),
_c(U+2187, "ↇ", e28687),
_c(U+2188, "ↈ", e28688),
_c(U+2189, "↉", e28689),
_c(U+218A, "↊", e2868a),
_c(U+218B, "↋", e2868b),
_c(U+218C, "↌", e2868c),
_c(U+218D, "↍", e2868d),
_c(U+218E, "↎", e2868e),
_c(U+218F, "↏", e2868f),
_c(U+2190, "←", e28690),
_c(U+2191, "↑", e28691),
_c(U+2192, "→", e28692),
_c(U+2193, "↓", e28693),
_c(U+2194, "↔", e28694),
_c(U+2195, "↕", e28695),
_c(U+2196, "↖", e28696),
_c(U+2197, "↗", e28697),
_c(U+2198, "↘", e28698),
_c(U+2199, "↙", e28699),
_c(U+219A, "↚", e2869a),
_c(U+219B, "↛", e2869b),
_c(U+219C, "↜", e2869c),
_c(U+219D, "↝", e2869d),
_c(U+219E, "↞", e2869e),
_c(U+219F, "↟", e2869f),
_c(U+21A0, "↠", e286a0),
_c(U+21A1, "↡", e286a1),
_c(U+21A2, "↢", e286a2),
_c(U+21A3, "↣", e286a3),
_c(U+21A4, "↤", e286a4),
_c(U+21A5, "↥", e286a5),
_c(U+21A6, "↦", e286a6),
_c(U+21A7, "↧", e286a7),
_c(U+21A8, "↨", e286a8),
_c(U+21A9, "↩", e286a9),
_c(U+21AA, "↪", e286aa),
_c(U+21AB, "↫", e286ab),
_c(U+21AC, "↬", e286ac),
_c(U+21AD, "↭", e286ad),
_c(U+21AE, "↮", e286ae),
_c(U+21AF, "↯", e286af),
_c(U+21B0, "↰", e286b0),
_c(U+21B1, "↱", e286b1),
_c(U+21B2, "↲", e286b2),
_c(U+21B3, "↳", e286b3),
_c(U+21B4, "↴", e286b4),
_c(U+21B5, "↵", e286b5),
_c(U+21B6, "↶", e286b6),
_c(U+21B7, "↷", e286b7),
_c(U+21B8, "↸", e286b8),
_c(U+21B9, "↹", e286b9),
_c(U+21BA, "↺", e286ba),
_c(U+21BB, "↻", e286bb),
_c(U+21BC, "↼", e286bc),
_c(U+21BD, "↽", e286bd),
_c(U+21BE, "↾", e286be),
_c(U+21BF, "↿", e286bf),
_c(U+21C0, "⇀", e28780),
_c(U+21C1, "⇁", e28781),
_c(U+21C2, "⇂", e28782),
_c(U+21C3, "⇃", e28783),
_c(U+21C4, "⇄", e28784),
_c(U+21C5, "⇅", e28785),
_c(U+21C6, "⇆", e28786),
_c(U+21C7, "⇇", e28787),
_c(U+21C8, "⇈", e28788),
_c(U+21C9, "⇉", e28789),
_c(U+21CA, "⇊", e2878a),
_c(U+21CB, "⇋", e2878b),
_c(U+21CC, "⇌", e2878c),
_c(U+21CD, "⇍", e2878d),
_c(U+21CE, "⇎", e2878e),
_c(U+21CF, "⇏", e2878f),
_c(U+21D0, "⇐", e28790),
_c(U+21D1, "⇑", e28791),
_c(U+21D2, "⇒", e28792),
_c(U+21D3, "⇓", e28793),
_c(U+21D4, "⇔", e28794),
_c(U+21D5, "⇕", e28795),
_c(U+21D6, "⇖", e28796),
_c(U+21D7, "⇗", e28797),
_c(U+21D8, "⇘", e28798),
_c(U+21D9, "⇙", e28799),
_c(U+21DA, "⇚", e2879a),
_c(U+21DB, "⇛", e2879b),
_c(U+21DC, "⇜", e2879c),
_c(U+21DD, "⇝", e2879d),
_c(U+21DE, "⇞", e2879e),
_c(U+21DF, "⇟", e2879f),
_c(U+21E0, "⇠", e287a0),
_c(U+21E1, "⇡", e287a1),
_c(U+21E2, "⇢", e287a2),
_c(U+21E3, "⇣", e287a3),
_c(U+21E4, "⇤", e287a4),
_c(U+21E5, "⇥", e287a5),
_c(U+21E6, "⇦", e287a6),
_c(U+21E7, "⇧", e287a7),
_c(U+21E8, "⇨", e287a8),
_c(U+21E9, "⇩", e287a9),
_c(U+21EA, "⇪", e287aa),
_c(U+21EB, "⇫", e287ab),
_c(U+21EC, "⇬", e287ac),
_c(U+21ED, "⇭", e287ad),
_c(U+21EE, "⇮", e287ae),
_c(U+21EF, "⇯", e287af),
_c(U+21F0, "⇰", e287b0),
_c(U+21F1, "⇱", e287b1),
_c(U+21F2, "⇲", e287b2),
_c(U+21F3, "⇳", e287b3),
_c(U+21F4, "⇴", e287b4),
_c(U+21F5, "⇵", e287b5),
_c(U+21F6, "⇶", e287b6),
_c(U+21F7, "⇷", e287b7),
_c(U+21F8, "⇸", e287b8),
_c(U+21F9, "⇹", e287b9),
_c(U+21FA, "⇺", e287ba),
_c(U+21FB, "⇻", e287bb),
_c(U+21FC, "⇼", e287bc),
_c(U+21FD, "⇽", e287bd),
_c(U+21FE, "⇾", e287be),
_c(U+21FF, "⇿", e287bf),
_c(U+2200, "∀", e28880),
_c(U+2201, "∁", e28881),
_c(U+2202, "∂", e28882),
_c(U+2203, "∃", e28883),
_c(U+2204, "∄", e28884),
_c(U+2205, "∅", e28885),
_c(U+2206, "∆", e28886),
_c(U+2207, "∇", e28887),
_c(U+2208, "∈", e28888),
_c(U+2209, "∉", e28889),
_c(U+220A, "∊", e2888a),
_c(U+220B, "∋", e2888b),
_c(U+220C, "∌", e2888c),
_c(U+220D, "∍", e2888d),
_c(U+220E, "∎", e2888e),
_c(U+220F, "∏", e2888f),
_c(U+2210, "∐", e28890),
_c(U+2211, "∑", e28891),
_c(U+2212, "−", e28892),
_c(U+2213, "∓", e28893),
_c(U+2214, "∔", e28894),
_c(U+2215, "∕", e28895),
_c(U+2216, "∖", e28896),
_c(U+2217, "∗", e28897),
_c(U+2218, "∘", e28898),
_c(U+2219, "∙", e28899),
_c(U+221A, "√", e2889a),
_c(U+221B, "∛", e2889b),
_c(U+221C, "∜", e2889c),
_c(U+221D, "∝", e2889d),
_c(U+221E, "∞", e2889e),
_c(U+221F, "∟", e2889f),
_c(U+2220, "∠", e288a0),
_c(U+2221, "∡", e288a1),
_c(U+2222, "∢", e288a2),
_c(U+2223, "∣", e288a3),
_c(U+2224, "∤", e288a4),
_c(U+2225, "∥", e288a5),
_c(U+2226, "∦", e288a6),
_c(U+2227, "∧", e288a7),
_c(U+2228, "∨", e288a8),
_c(U+2229, "∩", e288a9),
_c(U+222A, "∪", e288aa),
_c(U+222B, "∫", e288ab),
_c(U+222C, "∬", e288ac),
_c(U+222D, "∭", e288ad),
_c(U+222E, "∮", e288ae),
_c(U+222F, "∯", e288af),
_c(U+2230, "∰", e288b0),
_c(U+2231, "∱", e288b1),
_c(U+2232, "∲", e288b2),
_c(U+2233, "∳", e288b3),
_c(U+2234, "∴", e288b4),
_c(U+2235, "∵", e288b5),
_c(U+2236, "∶", e288b6),
_c(U+2237, "∷", e288b7),
_c(U+2238, "∸", e288b8),
_c(U+2239, "∹", e288b9),
_c(U+223A, "∺", e288ba),
_c(U+223B, "∻", e288bb),
_c(U+223C, "∼", e288bc),
_c(U+223D, "∽", e288bd),
_c(U+223E, "∾", e288be),
_c(U+223F, "∿", e288bf),
_c(U+2240, "≀", e28980),
_c(U+2241, "≁", e28981),
_c(U+2242, "≂", e28982),
_c(U+2243, "≃", e28983),
_c(U+2244, "≄", e28984),
_c(U+2245, "≅", e28985),
_c(U+2246, "≆", e28986),
_c(U+2247, "≇", e28987),
_c(U+2248, "≈", e28988),
_c(U+2249, "≉", e28989),
_c(U+224A, "≊", e2898a),
_c(U+224B, "≋", e2898b),
_c(U+224C, "≌", e2898c),
_c(U+224D, "≍", e2898d),
_c(U+224E, "≎", e2898e),
_c(U+224F, "≏", e2898f),
_c(U+2250, "≐", e28990),
_c(U+2251, "≑", e28991),
_c(U+2252, "≒", e28992),
_c(U+2253, "≓", e28993),
_c(U+2254, "≔", e28994),
_c(U+2255, "≕", e28995),
_c(U+2256, "≖", e28996),
_c(U+2257, "≗", e28997),
_c(U+2258, "≘", e28998),
_c(U+2259, "≙", e28999),
_c(U+225A, "≚", e2899a),
_c(U+225B, "≛", e2899b),
_c(U+225C, "≜", e2899c),
_c(U+225D, "≝", e2899d),
_c(U+225E, "≞", e2899e),
_c(U+225F, "≟", e2899f),
_c(U+2260, "≠", e289a0),
_c(U+2261, "≡", e289a1),
_c(U+2262, "≢", e289a2),
_c(U+2263, "≣", e289a3),
_c(U+2264, "≤", e289a4),
_c(U+2265, "≥", e289a5),
_c(U+2266, "≦", e289a6),
_c(U+2267, "≧", e289a7),
_c(U+2268, "≨", e289a8),
_c(U+2269, "≩", e289a9),
_c(U+226A, "≪", e289aa),
_c(U+226B, "≫", e289ab),
_c(U+226C, "≬", e289ac),
_c(U+226D, "≭", e289ad),
_c(U+226E, "≮", e289ae),
_c(U+226F, "≯", e289af),
_c(U+2270, "≰", e289b0),
_c(U+2271, "≱", e289b1),
_c(U+2272, "≲", e289b2),
_c(U+2273, "≳", e289b3),
_c(U+2274, "≴", e289b4),
_c(U+2275, "≵", e289b5),
_c(U+2276, "≶", e289b6),
_c(U+2277, "≷", e289b7),
_c(U+2278, "≸", e289b8),
_c(U+2279, "≹", e289b9),
_c(U+227A, "≺", e289ba),
_c(U+227B, "≻", e289bb),
_c(U+227C, "≼", e289bc),
_c(U+227D, "≽", e289bd),
_c(U+227E, "≾", e289be),
_c(U+227F, "≿", e289bf),
_c(U+2280, "⊀", e28a80),
_c(U+2281, "⊁", e28a81),
_c(U+2282, "⊂", e28a82),
_c(U+2283, "⊃", e28a83),
_c(U+2284, "⊄", e28a84),
_c(U+2285, "⊅", e28a85),
_c(U+2286, "⊆", e28a86),
_c(U+2287, "⊇", e28a87),
_c(U+2288, "⊈", e28a88),
_c(U+2289, "⊉", e28a89),
_c(U+228A, "⊊", e28a8a),
_c(U+228B, "⊋", e28a8b),
_c(U+228C, "⊌", e28a8c),
_c(U+228D, "⊍", e28a8d),
_c(U+228E, "⊎", e28a8e),
_c(U+228F, "⊏", e28a8f),
_c(U+2290, "⊐", e28a90),
_c(U+2291, "⊑", e28a91),
_c(U+2292, "⊒", e28a92),
_c(U+2293, "⊓", e28a93),
_c(U+2294, "⊔", e28a94),
_c(U+2295, "⊕", e28a95),
_c(U+2296, "⊖", e28a96),
_c(U+2297, "⊗", e28a97),
_c(U+2298, "⊘", e28a98),
_c(U+2299, "⊙", e28a99),
_c(U+229A, "⊚", e28a9a),
_c(U+229B, "⊛", e28a9b),
_c(U+229C, "⊜", e28a9c),
_c(U+229D, "⊝", e28a9d),
_c(U+229E, "⊞", e28a9e),
_c(U+229F, "⊟", e28a9f),
_c(U+22A0, "⊠", e28aa0),
_c(U+22A1, "⊡", e28aa1),
_c(U+22A2, "⊢", e28aa2),
_c(U+22A3, "⊣", e28aa3),
_c(U+22A4, "⊤", e28aa4),
_c(U+22A5, "⊥", e28aa5),
_c(U+22A6, "⊦", e28aa6),
_c(U+22A7, "⊧", e28aa7),
_c(U+22A8, "⊨", e28aa8),
_c(U+22A9, "⊩", e28aa9),
_c(U+22AA, "⊪", e28aaa),
_c(U+22AB, "⊫", e28aab),
_c(U+22AC, "⊬", e28aac),
_c(U+22AD, "⊭", e28aad),
_c(U+22AE, "⊮", e28aae),
_c(U+22AF, "⊯", e28aaf),
_c(U+22B0, "⊰", e28ab0),
_c(U+22B1, "⊱", e28ab1),
_c(U+22B2, "⊲", e28ab2),
_c(U+22B3, "⊳", e28ab3),
_c(U+22B4, "⊴", e28ab4),
_c(U+22B5, "⊵", e28ab5),
_c(U+22B6, "⊶", e28ab6),
_c(U+22B7, "⊷", e28ab7),
_c(U+22B8, "⊸", e28ab8),
_c(U+22B9, "⊹", e28ab9),
_c(U+22BA, "⊺", e28aba),
_c(U+22BB, "⊻", e28abb),
_c(U+22BC, "⊼", e28abc),
_c(U+22BD, "⊽", e28abd),
_c(U+22BE, "⊾", e28abe),
_c(U+22BF, "⊿", e28abf),
_c(U+22C0, "⋀", e28b80),
_c(U+22C1, "⋁", e28b81),
_c(U+22C2, "⋂", e28b82),
_c(U+22C3, "⋃", e28b83),
_c(U+22C4, "⋄", e28b84),
_c(U+22C5, "⋅", e28b85),
_c(U+22C6, "⋆", e28b86),
_c(U+22C7, "⋇", e28b87),
_c(U+22C8, "⋈", e28b88),
_c(U+22C9, "⋉", e28b89),
_c(U+22CA, "⋊", e28b8a),
_c(U+22CB, "⋋", e28b8b),
_c(U+22CC, "⋌", e28b8c),
_c(U+22CD, "⋍", e28b8d),
_c(U+22CE, "⋎", e28b8e),
_c(U+22CF, "⋏", e28b8f),
_c(U+22D0, "⋐", e28b90),
_c(U+22D1, "⋑", e28b91),
_c(U+22D2, "⋒", e28b92),
_c(U+22D3, "⋓", e28b93),
_c(U+22D4, "⋔", e28b94),
_c(U+22D5, "⋕", e28b95),
_c(U+22D6, "⋖", e28b96),
_c(U+22D7, "⋗", e28b97),
_c(U+22D8, "⋘", e28b98),
_c(U+22D9, "⋙", e28b99),
_c(U+22DA, "⋚", e28b9a),
_c(U+22DB, "⋛", e28b9b),
_c(U+22DC, "⋜", e28b9c),
_c(U+22DD, "⋝", e28b9d),
_c(U+22DE, "⋞", e28b9e),
_c(U+22DF, "⋟", e28b9f),
_c(U+22E0, "⋠", e28ba0),
_c(U+22E1, "⋡", e28ba1),
_c(U+22E2, "⋢", e28ba2),
_c(U+22E3, "⋣", e28ba3),
_c(U+22E4, "⋤", e28ba4),
_c(U+22E5, "⋥", e28ba5),
_c(U+22E6, "⋦", e28ba6),
_c(U+22E7, "⋧", e28ba7),
_c(U+22E8, "⋨", e28ba8),
_c(U+22E9, "⋩", e28ba9),
_c(U+22EA, "⋪", e28baa),
_c(U+22EB, "⋫", e28bab),
_c(U+22EC, "⋬", e28bac),
_c(U+22ED, "⋭", e28bad),
_c(U+22EE, "⋮", e28bae),
_c(U+22EF, "⋯", e28baf),
_c(U+22F0, "⋰", e28bb0),
_c(U+22F1, "⋱", e28bb1),
_c(U+22F2, "⋲", e28bb2),
_c(U+22F3, "⋳", e28bb3),
_c(U+22F4, "⋴", e28bb4),
_c(U+22F5, "⋵", e28bb5),
_c(U+22F6, "⋶", e28bb6),
_c(U+22F7, "⋷", e28bb7),
_c(U+22F8, "⋸", e28bb8),
_c(U+22F9, "⋹", e28bb9),
_c(U+22FA, "⋺", e28bba),
_c(U+22FB, "⋻", e28bbb),
_c(U+22FC, "⋼", e28bbc),
_c(U+22FD, "⋽", e28bbd),
_c(U+22FE, "⋾", e28bbe),
_c(U+22FF, "⋿", e28bbf),
_c(U+2300, "⌀", e28c80),
_c(U+2301, "⌁", e28c81),
_c(U+2302, "⌂", e28c82),
_c(U+2303, "⌃", e28c83),
_c(U+2304, "⌄", e28c84),
_c(U+2305, "⌅", e28c85),
_c(U+2306, "⌆", e28c86),
_c(U+2307, "⌇", e28c87),
_c(U+2308, "⌈", e28c88),
_c(U+2309, "⌉", e28c89),
_c(U+230A, "⌊", e28c8a),
_c(U+230B, "⌋", e28c8b),
_c(U+230C, "⌌", e28c8c),
_c(U+230D, "⌍", e28c8d),
_c(U+230E, "⌎", e28c8e),
_c(U+230F, "⌏", e28c8f),
_c(U+2310, "⌐", e28c90),
_c(U+2311, "⌑", e28c91),
_c(U+2312, "⌒", e28c92),
_c(U+2313, "⌓", e28c93),
_c(U+2314, "⌔", e28c94),
_c(U+2315, "⌕", e28c95),
_c(U+2316, "⌖", e28c96),
_c(U+2317, "⌗", e28c97),
_c(U+2318, "⌘", e28c98),
_c(U+2319, "⌙", e28c99),
_c(U+231A, "⌚", e28c9a),
_c(U+231B, "⌛", e28c9b),
_c(U+231C, "⌜", e28c9c),
_c(U+231D, "⌝", e28c9d),
_c(U+231E, "⌞", e28c9e),
_c(U+231F, "⌟", e28c9f),
_c(U+2320, "⌠", e28ca0),
_c(U+2321, "⌡", e28ca1),
_c(U+2322, "⌢", e28ca2),
_c(U+2323, "⌣", e28ca3),
_c(U+2324, "⌤", e28ca4),
_c(U+2325, "⌥", e28ca5),
_c(U+2326, "⌦", e28ca6),
_c(U+2327, "⌧", e28ca7),
_c(U+2328, "⌨", e28ca8),
_c(U+2329, "〈", e28ca9),
_c(U+232A, "〉", e28caa),
_c(U+232B, "⌫", e28cab),
_c(U+232C, "⌬", e28cac),
_c(U+232D, "⌭", e28cad),
_c(U+232E, "⌮", e28cae),
_c(U+232F, "⌯", e28caf),
_c(U+2330, "⌰", e28cb0),
_c(U+2331, "⌱", e28cb1),
_c(U+2332, "⌲", e28cb2),
_c(U+2333, "⌳", e28cb3),
_c(U+2334, "⌴", e28cb4),
_c(U+2335, "⌵", e28cb5),
_c(U+2336, "⌶", e28cb6),
_c(U+2337, "⌷", e28cb7),
_c(U+2338, "⌸", e28cb8),
_c(U+2339, "⌹", e28cb9),
_c(U+233A, "⌺", e28cba),
_c(U+233B, "⌻", e28cbb),
_c(U+233C, "⌼", e28cbc),
_c(U+233D, "⌽", e28cbd),
_c(U+233E, "⌾", e28cbe),
_c(U+233F, "⌿", e28cbf),
_c(U+2340, "⍀", e28d80),
_c(U+2341, "⍁", e28d81),
_c(U+2342, "⍂", e28d82),
_c(U+2343, "⍃", e28d83),
_c(U+2344, "⍄", e28d84),
_c(U+2345, "⍅", e28d85),
_c(U+2346, "⍆", e28d86),
_c(U+2347, "⍇", e28d87),
_c(U+2348, "⍈", e28d88),
_c(U+2349, "⍉", e28d89),
_c(U+234A, "⍊", e28d8a),
_c(U+234B, "⍋", e28d8b),
_c(U+234C, "⍌", e28d8c),
_c(U+234D, "⍍", e28d8d),
_c(U+234E, "⍎", e28d8e),
_c(U+234F, "⍏", e28d8f),
_c(U+2350, "⍐", e28d90),
_c(U+2351, "⍑", e28d91),
_c(U+2352, "⍒", e28d92),
_c(U+2353, "⍓", e28d93),
_c(U+2354, "⍔", e28d94),
_c(U+2355, "⍕", e28d95),
_c(U+2356, "⍖", e28d96),
_c(U+2357, "⍗", e28d97),
_c(U+2358, "⍘", e28d98),
_c(U+2359, "⍙", e28d99),
_c(U+235A, "⍚", e28d9a),
_c(U+235B, "⍛", e28d9b),
_c(U+235C, "⍜", e28d9c),
_c(U+235D, "⍝", e28d9d),
_c(U+235E, "⍞", e28d9e),
_c(U+235F, "⍟", e28d9f),
_c(U+2360, "⍠", e28da0),
_c(U+2361, "⍡", e28da1),
_c(U+2362, "⍢", e28da2),
_c(U+2363, "⍣", e28da3),
_c(U+2364, "⍤", e28da4),
_c(U+2365, "⍥", e28da5),
_c(U+2366, "⍦", e28da6),
_c(U+2367, "⍧", e28da7),
_c(U+2368, "⍨", e28da8),
_c(U+2369, "⍩", e28da9),
_c(U+236A, "⍪", e28daa),
_c(U+236B, "⍫", e28dab),
_c(U+236C, "⍬", e28dac),
_c(U+236D, "⍭", e28dad),
_c(U+236E, "⍮", e28dae),
_c(U+236F, "⍯", e28daf),
_c(U+2370, "⍰", e28db0),
_c(U+2371, "⍱", e28db1),
_c(U+2372, "⍲", e28db2),
_c(U+2373, "⍳", e28db3),
_c(U+2374, "⍴", e28db4),
_c(U+2375, "⍵", e28db5),
_c(U+2376, "⍶", e28db6),
_c(U+2377, "⍷", e28db7),
_c(U+2378, "⍸", e28db8),
_c(U+2379, "⍹", e28db9),
_c(U+237A, "⍺", e28dba),
_c(U+237B, "⍻", e28dbb),
_c(U+237C, "⍼", e28dbc),
_c(U+237D, "⍽", e28dbd),
_c(U+237E, "⍾", e28dbe),
_c(U+237F, "⍿", e28dbf),
_c(U+2380, "⎀", e28e80),
_c(U+2381, "⎁", e28e81),
_c(U+2382, "⎂", e28e82),
_c(U+2383, "⎃", e28e83),
_c(U+2384, "⎄", e28e84),
_c(U+2385, "⎅", e28e85),
_c(U+2386, "⎆", e28e86),
_c(U+2387, "⎇", e28e87),
_c(U+2388, "⎈", e28e88),
_c(U+2389, "⎉", e28e89),
_c(U+238A, "⎊", e28e8a),
_c(U+238B, "⎋", e28e8b),
_c(U+238C, "⎌", e28e8c),
_c(U+238D, "⎍", e28e8d),
_c(U+238E, "⎎", e28e8e),
_c(U+238F, "⎏", e28e8f),
_c(U+2390, "⎐", e28e90),
_c(U+2391, "⎑", e28e91),
_c(U+2392, "⎒", e28e92),
_c(U+2393, "⎓", e28e93),
_c(U+2394, "⎔", e28e94),
_c(U+2395, "⎕", e28e95),
_c(U+2396, "⎖", e28e96),
_c(U+2397, "⎗", e28e97),
_c(U+2398, "⎘", e28e98),
_c(U+2399, "⎙", e28e99),
_c(U+239A, "⎚", e28e9a),
_c(U+239B, "⎛", e28e9b),
_c(U+239C, "⎜", e28e9c),
_c(U+239D, "⎝", e28e9d),
_c(U+239E, "⎞", e28e9e),
_c(U+239F, "⎟", e28e9f),
_c(U+23A0, "⎠", e28ea0),
_c(U+23A1, "⎡", e28ea1),
_c(U+23A2, "⎢", e28ea2),
_c(U+23A3, "⎣", e28ea3),
_c(U+23A4, "⎤", e28ea4),
_c(U+23A5, "⎥", e28ea5),
_c(U+23A6, "⎦", e28ea6),
_c(U+23A7, "⎧", e28ea7),
_c(U+23A8, "⎨", e28ea8),
_c(U+23A9, "⎩", e28ea9),
_c(U+23AA, "⎪", e28eaa),
_c(U+23AB, "⎫", e28eab),
_c(U+23AC, "⎬", e28eac),
_c(U+23AD, "⎭", e28ead),
_c(U+23AE, "⎮", e28eae),
_c(U+23AF, "⎯", e28eaf),
_c(U+23B0, "⎰", e28eb0),
_c(U+23B1, "⎱", e28eb1),
_c(U+23B2, "⎲", e28eb2),
_c(U+23B3, "⎳", e28eb3),
_c(U+23B4, "⎴", e28eb4),
_c(U+23B5, "⎵", e28eb5),
_c(U+23B6, "⎶", e28eb6),
_c(U+23B7, "⎷", e28eb7),
_c(U+23B8, "⎸", e28eb8),
_c(U+23B9, "⎹", e28eb9),
_c(U+23BA, "⎺", e28eba),
_c(U+23BB, "⎻", e28ebb),
_c(U+23BC, "⎼", e28ebc),
_c(U+23BD, "⎽", e28ebd),
_c(U+23BE, "⎾", e28ebe),
_c(U+23BF, "⎿", e28ebf),
_c(U+23C0, "⏀", e28f80),
_c(U+23C1, "⏁", e28f81),
_c(U+23C2, "⏂", e28f82),
_c(U+23C3, "⏃", e28f83),
_c(U+23C4, "⏄", e28f84),
_c(U+23C5, "⏅", e28f85),
_c(U+23C6, "⏆", e28f86),
_c(U+23C7, "⏇", e28f87),
_c(U+23C8, "⏈", e28f88),
_c(U+23C9, "⏉", e28f89),
_c(U+23CA, "⏊", e28f8a),
_c(U+23CB, "⏋", e28f8b),
_c(U+23CC, "⏌", e28f8c),
_c(U+23CD, "⏍", e28f8d),
_c(U+23CE, "⏎", e28f8e),
_c(U+23CF, "⏏", e28f8f),
_c(U+23D0, "⏐", e28f90),
_c(U+23D1, "⏑", e28f91),
_c(U+23D2, "⏒", e28f92),
_c(U+23D3, "⏓", e28f93),
_c(U+23D4, "⏔", e28f94),
_c(U+23D5, "⏕", e28f95),
_c(U+23D6, "⏖", e28f96),
_c(U+23D7, "⏗", e28f97),
_c(U+23D8, "⏘", e28f98),
_c(U+23D9, "⏙", e28f99),
_c(U+23DA, "⏚", e28f9a),
_c(U+23DB, "⏛", e28f9b),
_c(U+23DC, "⏜", e28f9c),
_c(U+23DD, "⏝", e28f9d),
_c(U+23DE, "⏞", e28f9e),
_c(U+23DF, "⏟", e28f9f),
_c(U+23E0, "⏠", e28fa0),
_c(U+23E1, "⏡", e28fa1),
_c(U+23E2, "⏢", e28fa2),
_c(U+23E3, "⏣", e28fa3),
_c(U+23E4, "⏤", e28fa4),
_c(U+23E5, "⏥", e28fa5),
_c(U+23E6, "⏦", e28fa6),
_c(U+23E7, "⏧", e28fa7),
_c(U+23E8, "⏨", e28fa8),
_c(U+23E9, "⏩", e28fa9),
_c(U+23EA, "⏪", e28faa),
_c(U+23EB, "⏫", e28fab),
_c(U+23EC, "⏬", e28fac),
_c(U+23ED, "⏭", e28fad),
_c(U+23EE, "⏮", e28fae),
_c(U+23EF, "⏯", e28faf),
_c(U+23F0, "⏰", e28fb0),
_c(U+23F1, "⏱", e28fb1),
_c(U+23F2, "⏲", e28fb2),
_c(U+23F3, "⏳", e28fb3),
_c(U+23F4, "⏴", e28fb4),
_c(U+23F5, "⏵", e28fb5),
_c(U+23F6, "⏶", e28fb6),
_c(U+23F7, "⏷", e28fb7),
_c(U+23F8, "⏸", e28fb8),
_c(U+23F9, "⏹", e28fb9),
_c(U+23FA, "⏺", e28fba),
_c(U+23FB, "⏻", e28fbb),
_c(U+23FC, "⏼", e28fbc),
_c(U+23FD, "⏽", e28fbd),
_c(U+23FE, "⏾", e28fbe),
_c(U+23FF, "⏿", e28fbf),
_c(U+2400, "␀", e29080),
_c(U+2401, "␁", e29081),
_c(U+2402, "␂", e29082),
_c(U+2403, "␃", e29083),
_c(U+2404, "␄", e29084),
_c(U+2405, "␅", e29085),
_c(U+2406, "␆", e29086),
_c(U+2407, "␇", e29087),
_c(U+2408, "␈", e29088),
_c(U+2409, "␉", e29089),
_c(U+240A, "␊", e2908a),
_c(U+240B, "␋", e2908b),
_c(U+240C, "␌", e2908c),
_c(U+240D, "␍", e2908d),
_c(U+240E, "␎", e2908e),
_c(U+240F, "␏", e2908f),
_c(U+2410, "␐", e29090),
_c(U+2411, "␑", e29091),
_c(U+2412, "␒", e29092),
_c(U+2413, "␓", e29093),
_c(U+2414, "␔", e29094),
_c(U+2415, "␕", e29095),
_c(U+2416, "␖", e29096),
_c(U+2417, "␗", e29097),
_c(U+2418, "␘", e29098),
_c(U+2419, "␙", e29099),
_c(U+241A, "␚", e2909a),
_c(U+241B, "␛", e2909b),
_c(U+241C, "␜", e2909c),
_c(U+241D, "␝", e2909d),
_c(U+241E, "␞", e2909e),
_c(U+241F, "␟", e2909f),
_c(U+2420, "␠", e290a0),
_c(U+2421, "␡", e290a1),
_c(U+2422, "␢", e290a2),
_c(U+2423, "␣", e290a3),
_c(U+2424, "␤", e290a4),
_c(U+2425, "␥", e290a5),
_c(U+2426, "␦", e290a6),
_c(U+2427, "␧", e290a7),
_c(U+2428, "␨", e290a8),
_c(U+2429, "␩", e290a9),
_c(U+242A, "␪", e290aa),
_c(U+242B, "␫", e290ab),
_c(U+242C, "␬", e290ac),
_c(U+242D, "␭", e290ad),
_c(U+242E, "␮", e290ae),
_c(U+242F, "␯", e290af),
_c(U+2430, "␰", e290b0),
_c(U+2431, "␱", e290b1),
_c(U+2432, "␲", e290b2),
_c(U+2433, "␳", e290b3),
_c(U+2434, "␴", e290b4),
_c(U+2435, "␵", e290b5),
_c(U+2436, "␶", e290b6),
_c(U+2437, "␷", e290b7),
_c(U+2438, "␸", e290b8),
_c(U+2439, "␹", e290b9),
_c(U+243A, "␺", e290ba),
_c(U+243B, "␻", e290bb),
_c(U+243C, "␼", e290bc),
_c(U+243D, "␽", e290bd),
_c(U+243E, "␾", e290be),
_c(U+243F, "␿", e290bf),
_c(U+2440, "⑀", e29180),
_c(U+2441, "⑁", e29181),
_c(U+2442, "⑂", e29182),
_c(U+2443, "⑃", e29183),
_c(U+2444, "⑄", e29184),
_c(U+2445, "⑅", e29185),
_c(U+2446, "⑆", e29186),
_c(U+2447, "⑇", e29187),
_c(U+2448, "⑈", e29188),
_c(U+2449, "⑉", e29189),
_c(U+244A, "⑊", e2918a),
_c(U+244B, "⑋", e2918b),
_c(U+244C, "⑌", e2918c),
_c(U+244D, "⑍", e2918d),
_c(U+244E, "⑎", e2918e),
_c(U+244F, "⑏", e2918f),
_c(U+2450, "⑐", e29190),
_c(U+2451, "⑑", e29191),
_c(U+2452, "⑒", e29192),
_c(U+2453, "⑓", e29193),
_c(U+2454, "⑔", e29194),
_c(U+2455, "⑕", e29195),
_c(U+2456, "⑖", e29196),
_c(U+2457, "⑗", e29197),
_c(U+2458, "⑘", e29198),
_c(U+2459, "⑙", e29199),
_c(U+245A, "⑚", e2919a),
_c(U+245B, "⑛", e2919b),
_c(U+245C, "⑜", e2919c),
_c(U+245D, "⑝", e2919d),
_c(U+245E, "⑞", e2919e),
_c(U+245F, "⑟", e2919f),
_c(U+2460, "①", e291a0),
_c(U+2461, "②", e291a1),
_c(U+2462, "③", e291a2),
_c(U+2463, "④", e291a3),
_c(U+2464, "⑤", e291a4),
_c(U+2465, "⑥", e291a5),
_c(U+2466, "⑦", e291a6),
_c(U+2467, "⑧", e291a7),
_c(U+2468, "⑨", e291a8),
_c(U+2469, "⑩", e291a9),
_c(U+246A, "⑪", e291aa),
_c(U+246B, "⑫", e291ab),
_c(U+246C, "⑬", e291ac),
_c(U+246D, "⑭", e291ad),
_c(U+246E, "⑮", e291ae),
_c(U+246F, "⑯", e291af),
_c(U+2470, "⑰", e291b0),
_c(U+2471, "⑱", e291b1),
_c(U+2472, "⑲", e291b2),
_c(U+2473, "⑳", e291b3),
_c(U+2474, "⑴", e291b4),
_c(U+2475, "⑵", e291b5),
_c(U+2476, "⑶", e291b6),
_c(U+2477, "⑷", e291b7),
_c(U+2478, "⑸", e291b8),
_c(U+2479, "⑹", e291b9),
_c(U+247A, "⑺", e291ba),
_c(U+247B, "⑻", e291bb),
_c(U+247C, "⑼", e291bc),
_c(U+247D, "⑽", e291bd),
_c(U+247E, "⑾", e291be),
_c(U+247F, "⑿", e291bf),
_c(U+2480, "⒀", e29280),
_c(U+2481, "⒁", e29281),
_c(U+2482, "⒂", e29282),
_c(U+2483, "⒃", e29283),
_c(U+2484, "⒄", e29284),
_c(U+2485, "⒅", e29285),
_c(U+2486, "⒆", e29286),
_c(U+2487, "⒇", e29287),
_c(U+2488, "⒈", e29288),
_c(U+2489, "⒉", e29289),
_c(U+248A, "⒊", e2928a),
_c(U+248B, "⒋", e2928b),
_c(U+248C, "⒌", e2928c),
_c(U+248D, "⒍", e2928d),
_c(U+248E, "⒎", e2928e),
_c(U+248F, "⒏", e2928f),
_c(U+2490, "⒐", e29290),
_c(U+2491, "⒑", e29291),
_c(U+2492, "⒒", e29292),
_c(U+2493, "⒓", e29293),
_c(U+2494, "⒔", e29294),
_c(U+2495, "⒕", e29295),
_c(U+2496, "⒖", e29296),
_c(U+2497, "⒗", e29297),
_c(U+2498, "⒘", e29298),
_c(U+2499, "⒙", e29299),
_c(U+249A, "⒚", e2929a),
_c(U+249B, "⒛", e2929b),
_c(U+249C, "⒜", e2929c),
_c(U+249D, "⒝", e2929d),
_c(U+249E, "⒞", e2929e),
_c(U+249F, "⒟", e2929f),
_c(U+2601, "☁", e29881),
_c(U+2602, "☂", e29882),
_c(U+2603, "☃", e29883),
_c(U+2604, "☄", e29884),
_c(U+2605, "★", e29885),
_c(U+2606, "☆", e29886),
_c(U+2607, "☇", e29887),
_c(U+2608, "☈", e29888),
_c(U+2609, "☉", e29889),
_c(U+260A, "☊", e2988a),
_c(U+260B, "☋", e2988b),
_c(U+260C, "☌", e2988c),
_c(U+260D, "☍", e2988d),
_c(U+260E, "☎", e2988e),
_c(U+260F, "☏", e2988f),
_c(U+2610, "☐", e29890),
_c(U+2611, "☑", e29891),
_c(U+2612, "☒", e29892),
_c(U+2613, "☓", e29893),
_c(U+2614, "☔", e29894),
_c(U+2615, "☕", e29895),
_c(U+2616, "☖", e29896),
_c(U+2617, "☗", e29897),
_c(U+2618, "☘", e29898),
_c(U+2619, "☙", e29899),
_c(U+261A, "☚", e2989a),
_c(U+261B, "☛", e2989b),
_c(U+261C, "☜", e2989c),
_c(U+261D, "☝", e2989d),
_c(U+261E, "☞", e2989e),
_c(U+261F, "☟", e2989f),
_c(U+2620, "☠", e298a0),
_c(U+2621, "☡", e298a1),
_c(U+2622, "☢", e298a2),
_c(U+2623, "☣", e298a3),
_c(U+2624, "☤", e298a4),
_c(U+2625, "☥", e298a5),
_c(U+2626, "☦", e298a6),
_c(U+2627, "☧", e298a7),
_c(U+2628, "☨", e298a8),
_c(U+2629, "☩", e298a9),
_c(U+262A, "☪", e298aa),
_c(U+262B, "☫", e298ab),
_c(U+262C, "☬", e298ac),
_c(U+262D, "☭", e298ad),
_c(U+262E, "☮", e298ae),
_c(U+262F, "☯", e298af),
_c(U+2630, "☰", e298b0),
_c(U+2631, "☱", e298b1),
_c(U+2632, "☲", e298b2),
_c(U+2633, "☳", e298b3),
_c(U+2634, "☴", e298b4),
_c(U+2635, "☵", e298b5),
_c(U+2636, "☶", e298b6),
_c(U+2637, "☷", e298b7),
_c(U+2638, "☸", e298b8),
_c(U+2639, "☹", e298b9),
_c(U+263A, "☺", e298ba),
_c(U+263B, "☻", e298bb),
_c(U+263C, "☼", e298bc),
_c(U+263D, "☽", e298bd),
_c(U+263E, "☾", e298be),
_c(U+263F, "☿", e298bf),
_c(U+2640, "♀", e29980),
_c(U+2641, "♁", e29981),
_c(U+2642, "♂", e29982),
_c(U+2643, "♃", e29983),
_c(U+2644, "♄", e29984),
_c(U+2645, "♅", e29985),
_c(U+2646, "♆", e29986),
_c(U+2647, "♇", e29987),
_c(U+2648, "♈", e29988),
_c(U+2649, "♉", e29989),
_c(U+264A, "♊", e2998a),
_c(U+264B, "♋", e2998b),
_c(U+264C, "♌", e2998c),
_c(U+264D, "♍", e2998d),
_c(U+264E, "♎", e2998e),
_c(U+264F, "♏", e2998f),
_c(U+2650, "♐", e29990),
_c(U+2651, "♑", e29991),
_c(U+2652, "♒", e29992),
_c(U+2653, "♓", e29993),
_c(U+2654, "♔", e29994),
_c(U+2655, "♕", e29995),
_c(U+2656, "♖", e29996),
_c(U+2657, "♗", e29997),
_c(U+2658, "♘", e29998),
_c(U+2659, "♙", e29999),
_c(U+265A, "♚", e2999a),
_c(U+265B, "♛", e2999b),
_c(U+265C, "♜", e2999c),
_c(U+265D, "♝", e2999d),
_c(U+265E, "♞", e2999e),
_c(U+265F, "♟", e2999f),
_c(U+2660, "♠", e299a0),
_c(U+2661, "♡", e299a1),
_c(U+2662, "♢", e299a2),
_c(U+2663, "♣", e299a3),
_c(U+2664, "♤", e299a4),
_c(U+2665, "♥", e299a5),
_c(U+2666, "♦", e299a6),
_c(U+2667, "♧", e299a7),
_c(U+2668, "♨", e299a8),
_c(U+2669, "♩", e299a9),
_c(U+266A, "♪", e299aa),
_c(U+266B, "♫", e299ab),
_c(U+266C, "♬", e299ac),
_c(U+266D, "♭", e299ad),
_c(U+266E, "♮", e299ae),
_c(U+266F, "♯", e299af),
_c(U+2670, "♰", e299b0),
_c(U+2671, "♱", e299b1),
_c(U+2672, "♲", e299b2),
_c(U+2673, "♳", e299b3),
_c(U+2674, "♴", e299b4),
_c(U+2675, "♵", e299b5),
_c(U+2676, "♶", e299b6),
_c(U+2677, "♷", e299b7),
_c(U+2678, "♸", e299b8),
_c(U+2679, "♹", e299b9),
_c(U+267A, "♺", e299ba),
_c(U+267B, "♻", e299bb),
_c(U+267C, "♼", e299bc),
_c(U+267D, "♽", e299bd),
_c(U+267E, "♾", e299be),
_c(U+267F, "♿", e299bf),
_c(U+2680, "⚀", e29a80),
_c(U+2681, "⚁", e29a81),
_c(U+2682, "⚂", e29a82),
_c(U+2683, "⚃", e29a83),
_c(U+2684, "⚄", e29a84),
_c(U+2685, "⚅", e29a85),
_c(U+2686, "⚆", e29a86),
_c(U+2687, "⚇", e29a87),
_c(U+2688, "⚈", e29a88),
_c(U+2689, "⚉", e29a89),
_c(U+268A, "⚊", e29a8a),
_c(U+268B, "⚋", e29a8b),
_c(U+268C, "⚌", e29a8c),
_c(U+268D, "⚍", e29a8d),
_c(U+268E, "⚎", e29a8e),
_c(U+268F, "⚏", e29a8f),
_c(U+2690, "⚐", e29a90),
_c(U+2691, "⚑", e29a91),
_c(U+2692, "⚒", e29a92),
_c(U+2693, "⚓", e29a93),
_c(U+2694, "⚔", e29a94),
_c(U+2695, "⚕", e29a95),
_c(U+2696, "⚖", e29a96),
_c(U+2697, "⚗", e29a97),
_c(U+2698, "⚘", e29a98),
_c(U+2699, "⚙", e29a99),
_c(U+269A, "⚚", e29a9a),
_c(U+269B, "⚛", e29a9b),
_c(U+269C, "⚜", e29a9c),
_c(U+269D, "⚝", e29a9d),
_c(U+269E, "⚞", e29a9e),
_c(U+269F, "⚟", e29a9f),
_c(U+26A0, "⚠", e29aa0),
_c(U+26A1, "⚡", e29aa1),
_c(U+26A2, "⚢", e29aa2),
_c(U+26A3, "⚣", e29aa3),
_c(U+26A4, "⚤", e29aa4),
_c(U+26A5, "⚥", e29aa5),
_c(U+26A6, "⚦", e29aa6),
_c(U+26A7, "⚧", e29aa7),
_c(U+26A8, "⚨", e29aa8),
_c(U+26A9, "⚩", e29aa9),
_c(U+26AA, "⚪", e29aaa),
_c(U+26AB, "⚫", e29aab),
_c(U+26AC, "⚬", e29aac),
_c(U+26AD, "⚭", e29aad),
_c(U+26AE, "⚮", e29aae),
_c(U+26AF, "⚯", e29aaf),
_c(U+26B0, "⚰", e29ab0),
_c(U+26B1, "⚱", e29ab1),
_c(U+26B2, "⚲", e29ab2),
_c(U+26B3, "⚳", e29ab3),
_c(U+26B4, "⚴", e29ab4),
_c(U+26B5, "⚵", e29ab5),
_c(U+26B6, "⚶", e29ab6),
_c(U+26B7, "⚷", e29ab7),
_c(U+26B8, "⚸", e29ab8),
_c(U+26B9, "⚹", e29ab9),
_c(U+26BA, "⚺", e29aba),
_c(U+26BB, "⚻", e29abb),
_c(U+26BC, "⚼", e29abc),
_c(U+26BD, "⚽", e29abd),
_c(U+26BE, "⚾", e29abe),
_c(U+26BF, "⚿", e29abf),
_c(U+26C0, "⛀", e29b80),
_c(U+26C1, "⛁", e29b81),
_c(U+26C2, "⛂", e29b82),
_c(U+26C3, "⛃", e29b83),
_c(U+26C4, "⛄", e29b84),
_c(U+26C5, "⛅", e29b85),
_c(U+26C6, "⛆", e29b86),
_c(U+26C7, "⛇", e29b87),
_c(U+26C8, "⛈", e29b88),
_c(U+26C9, "⛉", e29b89),
_c(U+26CA, "⛊", e29b8a),
_c(U+26CB, "⛋", e29b8b),
_c(U+26CC, "⛌", e29b8c),
_c(U+26CD, "⛍", e29b8d),
_c(U+26CE, "⛎", e29b8e),
_c(U+26CF, "⛏", e29b8f),
_c(U+26D0, "⛐", e29b90),
_c(U+26D1, "⛑", e29b91),
_c(U+26D2, "⛒", e29b92),
_c(U+26D3, "⛓", e29b93),
_c(U+26D4, "⛔", e29b94),
_c(U+26D5, "⛕", e29b95),
_c(U+26D6, "⛖", e29b96),
_c(U+26D7, "⛗", e29b97),
_c(U+26D8, "⛘", e29b98),
_c(U+26D9, "⛙", e29b99),
_c(U+26DA, "⛚", e29b9a),
_c(U+26DB, "⛛", e29b9b),
_c(U+26DC, "⛜", e29b9c),
_c(U+26DD, "⛝", e29b9d),
_c(U+26DE, "⛞", e29b9e),
_c(U+26DF, "⛟", e29b9f),
_c(U+26E0, "⛠", e29ba0),
_c(U+26E1, "⛡", e29ba1),
_c(U+26E2, "⛢", e29ba2),
_c(U+26E3, "⛣", e29ba3),
_c(U+26E4, "⛤", e29ba4),
_c(U+26E5, "⛥", e29ba5),
_c(U+26E6, "⛦", e29ba6),
_c(U+26E7, "⛧", e29ba7),
_c(U+26E8, "⛨", e29ba8),
_c(U+26E9, "⛩", e29ba9),
_c(U+26EA, "⛪", e29baa),
_c(U+26EB, "⛫", e29bab),
_c(U+26EC, "⛬", e29bac),
_c(U+26ED, "⛭", e29bad),
_c(U+26EE, "⛮", e29bae),
_c(U+26EF, "⛯", e29baf),
_c(U+26F0, "⛰", e29bb0),
_c(U+26F1, "⛱", e29bb1),
_c(U+26F2, "⛲", e29bb2),
_c(U+26F3, "⛳", e29bb3),
_c(U+26F4, "⛴", e29bb4),
_c(U+26F5, "⛵", e29bb5),
_c(U+26F6, "⛶", e29bb6),
_c(U+26F7, "⛷", e29bb7),
_c(U+26F8, "⛸", e29bb8),
_c(U+26F9, "⛹", e29bb9),
_c(U+26FA, "⛺", e29bba),
_c(U+26FB, "⛻", e29bbb),
_c(U+26FC, "⛼", e29bbc),
_c(U+26FD, "⛽", e29bbd),
_c(U+26FE, "⛾", e29bbe),
_c(U+26FF, "⛿", e29bbf),
_c(U+2700, "✀", e29c80),
_c(U+2701, "✁", e29c81),
_c(U+2702, "✂", e29c82),
_c(U+2703, "✃", e29c83),
_c(U+2704, "✄", e29c84),
_c(U+2705, "✅", e29c85),
_c(U+2706, "✆", e29c86),
_c(U+2707, "✇", e29c87),
_c(U+2708, "✈", e29c88),
_c(U+2709, "✉", e29c89),
_c(U+270A, "✊", e29c8a),
_c(U+270B, "✋", e29c8b),
_c(U+270C, "✌", e29c8c),
_c(U+270D, "✍", e29c8d),
_c(U+270E, "✎", e29c8e),
_c(U+270F, "✏", e29c8f),
_c(U+2710, "✐", e29c90),
_c(U+2711, "✑", e29c91),
_c(U+2712, "✒", e29c92),
_c(U+2713, "✓", e29c93),
_c(U+2714, "✔", e29c94),
_c(U+2715, "✕", e29c95),
_c(U+2716, "✖", e29c96),
_c(U+2717, "✗", e29c97),
_c(U+2718, "✘", e29c98),
_c(U+2719, "✙", e29c99),
_c(U+271A, "✚", e29c9a),
_c(U+271B, "✛", e29c9b),
_c(U+271C, "✜", e29c9c),
_c(U+271D, "✝", e29c9d),
_c(U+271E, "✞", e29c9e),
_c(U+271F, "✟", e29c9f),
_c(U+2720, "✠", e29ca0),
_c(U+2721, "✡", e29ca1),
_c(U+2722, "✢", e29ca2),
_c(U+2723, "✣", e29ca3),
_c(U+2724, "✤", e29ca4),
_c(U+2725, "✥", e29ca5),
_c(U+2726, "✦", e29ca6),
_c(U+2727, "✧", e29ca7),
_c(U+2728, "✨", e29ca8),
_c(U+2729, "✩", e29ca9),
_c(U+272A, "✪", e29caa),
_c(U+272B, "✫", e29cab),
_c(U+272C, "✬", e29cac),
_c(U+272D, "✭", e29cad),
_c(U+272E, "✮", e29cae),
_c(U+272F, "✯", e29caf),
_c(U+2730, "✰", e29cb0),
_c(U+2731, "✱", e29cb1),
_c(U+2732, "✲", e29cb2),
_c(U+2733, "✳", e29cb3),
_c(U+2734, "✴", e29cb4),
_c(U+2735, "✵", e29cb5),
_c(U+2736, "✶", e29cb6),
_c(U+2737, "✷", e29cb7),
_c(U+2738, "✸", e29cb8),
_c(U+2739, "✹", e29cb9),
_c(U+273A, "✺", e29cba),
_c(U+273B, "✻", e29cbb),
_c(U+273C, "✼", e29cbc),
_c(U+273D, "✽", e29cbd),
_c(U+273E, "✾", e29cbe),
_c(U+273F, "✿", e29cbf),
_c(U+2740, "❀", e29d80),
_c(U+2741, "❁", e29d81),
_c(U+2742, "❂", e29d82),
_c(U+2743, "❃", e29d83),
_c(U+2744, "❄", e29d84),
_c(U+2745, "❅", e29d85),
_c(U+2746, "❆", e29d86),
_c(U+2747, "❇", e29d87),
_c(U+2748, "❈", e29d88),
_c(U+2749, "❉", e29d89),
_c(U+274A, "❊", e29d8a),
_c(U+274B, "❋", e29d8b),
_c(U+274C, "❌", e29d8c),
_c(U+274D, "❍", e29d8d),
_c(U+274E, "❎", e29d8e),
_c(U+274F, "❏", e29d8f),
_c(U+2750, "❐", e29d90),
_c(U+2751, "❑", e29d91),
_c(U+2752, "❒", e29d92),
_c(U+2753, "❓", e29d93),
_c(U+2754, "❔", e29d94),
_c(U+2755, "❕", e29d95),
_c(U+2756, "❖", e29d96),
_c(U+2757, "❗", e29d97),
_c(U+2758, "❘", e29d98),
_c(U+2759, "❙", e29d99),
_c(U+275A, "❚", e29d9a),
_c(U+275B, "❛", e29d9b),
_c(U+275C, "❜", e29d9c),
_c(U+275D, "❝", e29d9d),
_c(U+275E, "❞", e29d9e),
_c(U+275F, "❟", e29d9f),
_c(U+2760, "❠", e29da0),
_c(U+2761, "❡", e29da1),
_c(U+2762, "❢", e29da2),
_c(U+2763, "❣", e29da3),
_c(U+2764, "❤", e29da4),
_c(U+2765, "❥", e29da5),
_c(U+2766, "❦", e29da6),
_c(U+2767, "❧", e29da7),
_c(U+2768, "❨", e29da8),
_c(U+2769, "❩", e29da9),
_c(U+276A, "❪", e29daa),
_c(U+276B, "❫", e29dab),
_c(U+276C, "❬", e29dac),
_c(U+276D, "❭", e29dad),
_c(U+276E, "❮", e29dae),
_c(U+276F, "❯", e29daf),
_c(U+2770, "❰", e29db0),
_c(U+2771, "❱", e29db1),
_c(U+2772, "❲", e29db2),
_c(U+2773, "❳", e29db3),
_c(U+2774, "❴", e29db4),
_c(U+2775, "❵", e29db5),
_c(U+2776, "❶", e29db6),
_c(U+2777, "❷", e29db7),
_c(U+2778, "❸", e29db8),
_c(U+2779, "❹", e29db9),
_c(U+277A, "❺", e29dba),
_c(U+277B, "❻", e29dbb),
_c(U+277C, "❼", e29dbc),
_c(U+277D, "❽", e29dbd),
_c(U+277E, "❾", e29dbe),
_c(U+277F, "❿", e29dbf),
_c(U+2780, "➀", e29e80),
_c(U+2781, "➁", e29e81),
_c(U+2782, "➂", e29e82),
_c(U+2783, "➃", e29e83),
_c(U+2784, "➄", e29e84),
_c(U+2785, "➅", e29e85),
_c(U+2786, "➆", e29e86),
_c(U+2787, "➇", e29e87),
_c(U+2788, "➈", e29e88),
_c(U+2789, "➉", e29e89),
_c(U+278A, "➊", e29e8a),
_c(U+278B, "➋", e29e8b),
_c(U+278C, "➌", e29e8c),
_c(U+278D, "➍", e29e8d),
_c(U+278E, "➎", e29e8e),
_c(U+278F, "➏", e29e8f),
_c(U+2790, "➐", e29e90),
_c(U+2791, "➑", e29e91),
_c(U+2792, "➒", e29e92),
_c(U+2793, "➓", e29e93),
_c(U+2794, "➔", e29e94),
_c(U+2795, "➕", e29e95),
_c(U+2796, "➖", e29e96),
_c(U+2797, "➗", e29e97),
_c(U+2798, "➘", e29e98),
_c(U+2799, "➙", e29e99),
_c(U+279A, "➚", e29e9a),
_c(U+279B, "➛", e29e9b),
_c(U+279C, "➜", e29e9c),
_c(U+279D, "➝", e29e9d),
_c(U+279E, "➞", e29e9e),
_c(U+279F, "➟", e29e9f),
_c(U+27A0, "➠", e29ea0),
_c(U+27A1, "➡", e29ea1),
_c(U+27A2, "➢", e29ea2),
_c(U+27A3, "➣", e29ea3),
_c(U+27A4, "➤", e29ea4),
_c(U+27A5, "➥", e29ea5),
_c(U+27A6, "➦", e29ea6),
_c(U+27A7, "➧", e29ea7),
_c(U+27A8, "➨", e29ea8),
_c(U+27A9, "➩", e29ea9),
_c(U+27AA, "➪", e29eaa),
_c(U+27AB, "➫", e29eab),
_c(U+27AC, "➬", e29eac),
_c(U+27AD, "➭", e29ead),
_c(U+27AE, "➮", e29eae),
_c(U+27AF, "➯", e29eaf),
_c(U+27B0, "➰", e29eb0),
_c(U+27B1, "➱", e29eb1),
_c(U+27B2, "➲", e29eb2),
_c(U+27B3, "➳", e29eb3),
_c(U+27B4, "➴", e29eb4),
_c(U+27B5, "➵", e29eb5),
_c(U+27B6, "➶", e29eb6),
_c(U+27B7, "➷", e29eb7),
_c(U+27B8, "➸", e29eb8),
_c(U+27B9, "➹", e29eb9),
_c(U+27BA, "➺", e29eba),
_c(U+27BB, "➻", e29ebb),
_c(U+27BC, "➼", e29ebc),
_c(U+27BD, "➽", e29ebd),
_c(U+27BE, "➾", e29ebe),
_c(U+27BF, "➿", e29ebf),
_c(U+27C0, "⟀", e29f80),
_c(U+27C1, "⟁", e29f81),
_c(U+27C2, "⟂", e29f82),
_c(U+27C3, "⟃", e29f83),
_c(U+27C4, "⟄", e29f84),
_c(U+27C5, "⟅", e29f85),
_c(U+27C6, "⟆", e29f86),
_c(U+27C7, "⟇", e29f87),
_c(U+27C8, "⟈", e29f88),
_c(U+27C9, "⟉", e29f89),
_c(U+27CA, "⟊", e29f8a),
_c(U+27CB, "⟋", e29f8b),
_c(U+27CC, "⟌", e29f8c),
_c(U+27CD, "⟍", e29f8d),
_c(U+27CE, "⟎", e29f8e),
_c(U+27CF, "⟏", e29f8f),
_c(U+27D0, "⟐", e29f90),
_c(U+27D1, "⟑", e29f91),
_c(U+27D2, "⟒", e29f92),
_c(U+27D3, "⟓", e29f93),
_c(U+27D4, "⟔", e29f94),
_c(U+27D5, "⟕", e29f95),
_c(U+27D6, "⟖", e29f96),
_c(U+27D7, "⟗", e29f97),
_c(U+27D8, "⟘", e29f98),
_c(U+27D9, "⟙", e29f99),
_c(U+27DA, "⟚", e29f9a),
_c(U+27DB, "⟛", e29f9b),
_c(U+27DC, "⟜", e29f9c),
_c(U+27DD, "⟝", e29f9d),
_c(U+27DE, "⟞", e29f9e),
_c(U+27DF, "⟟", e29f9f),
_c(U+27E0, "⟠", e29fa0),
_c(U+27E1, "⟡", e29fa1),
_c(U+27E2, "⟢", e29fa2),
_c(U+27E3, "⟣", e29fa3),
_c(U+27E4, "⟤", e29fa4),
_c(U+27E5, "⟥", e29fa5),
_c(U+27E6, "⟦", e29fa6),
_c(U+27E7, "⟧", e29fa7),
_c(U+27E8, "⟨", e29fa8),
_c(U+27E9, "⟩", e29fa9),
_c(U+27EA, "⟪", e29faa),
_c(U+27EB, "⟫", e29fab),
_c(U+27EC, "⟬", e29fac),
_c(U+27ED, "⟭", e29fad),
_c(U+27EE, "⟮", e29fae),
_c(U+27EF, "⟯", e29faf),
_c(U+27F0, "⟰", e29fb0),
_c(U+27F1, "⟱", e29fb1),
_c(U+27F2, "⟲", e29fb2),
_c(U+27F3, "⟳", e29fb3),
_c(U+27F4, "⟴", e29fb4),
_c(U+27F5, "⟵", e29fb5),
_c(U+27F6, "⟶", e29fb6),
_c(U+27F7, "⟷", e29fb7),
_c(U+27F8, "⟸", e29fb8),
_c(U+27F9, "⟹", e29fb9),
_c(U+27FA, "⟺", e29fba),
_c(U+27FB, "⟻", e29fbb),
_c(U+27FC, "⟼", e29fbc),
_c(U+27FD, "⟽", e29fbd),
_c(U+27FE, "⟾", e29fbe),
_c(U+27FF, "⟿", e29fbf),
_c(U+2800, "⠀", e2a080),
_c(U+2801, "⠁", e2a081),
_c(U+2802, "⠂", e2a082),
_c(U+2803, "⠃", e2a083),
_c(U+2804, "⠄", e2a084),
_c(U+2805, "⠅", e2a085),
_c(U+2806, "⠆", e2a086),
_c(U+2807, "⠇", e2a087),
_c(U+2808, "⠈", e2a088),
_c(U+2809, "⠉", e2a089),
_c(U+280A, "⠊", e2a08a),
_c(U+280B, "⠋", e2a08b),
_c(U+280C, "⠌", e2a08c),
_c(U+280D, "⠍", e2a08d),
_c(U+280E, "⠎", e2a08e),
_c(U+280F, "⠏", e2a08f),
_c(U+2810, "⠐", e2a090),
_c(U+2811, "⠑", e2a091),
_c(U+2812, "⠒", e2a092),
_c(U+2813, "⠓", e2a093),
_c(U+2814, "⠔", e2a094),
_c(U+2815, "⠕", e2a095),
_c(U+2816, "⠖", e2a096),
_c(U+2817, "⠗", e2a097),
_c(U+2818, "⠘", e2a098),
_c(U+2819, "⠙", e2a099),
_c(U+281A, "⠚", e2a09a),
_c(U+281B, "⠛", e2a09b),
_c(U+281C, "⠜", e2a09c),
_c(U+281D, "⠝", e2a09d),
_c(U+281E, "⠞", e2a09e),
_c(U+281F, "⠟", e2a09f),
_c(U+2820, "⠠", e2a0a0),
_c(U+2821, "⠡", e2a0a1),
_c(U+2822, "⠢", e2a0a2),
_c(U+2823, "⠣", e2a0a3),
_c(U+2824, "⠤", e2a0a4),
_c(U+2825, "⠥", e2a0a5),
_c(U+2826, "⠦", e2a0a6),
_c(U+2827, "⠧", e2a0a7),
_c(U+2828, "⠨", e2a0a8),
_c(U+2829, "⠩", e2a0a9),
_c(U+282A, "⠪", e2a0aa),
_c(U+282B, "⠫", e2a0ab),
_c(U+282C, "⠬", e2a0ac),
_c(U+282D, "⠭", e2a0ad),
_c(U+282E, "⠮", e2a0ae),
_c(U+282F, "⠯", e2a0af),
_c(U+2830, "⠰", e2a0b0),
_c(U+2831, "⠱", e2a0b1),
_c(U+2832, "⠲", e2a0b2),
_c(U+2833, "⠳", e2a0b3),
_c(U+2834, "⠴", e2a0b4),
_c(U+2835, "⠵", e2a0b5),
_c(U+2836, "⠶", e2a0b6),
_c(U+2837, "⠷", e2a0b7),
_c(U+2838, "⠸", e2a0b8),
_c(U+2839, "⠹", e2a0b9),
_c(U+283A, "⠺", e2a0ba),
_c(U+283B, "⠻", e2a0bb),
_c(U+283C, "⠼", e2a0bc),
_c(U+283D, "⠽", e2a0bd),
_c(U+283E, "⠾", e2a0be),
_c(U+283F, "⠿", e2a0bf),
_c(U+2840, "⡀", e2a180),
_c(U+2841, "⡁", e2a181),
_c(U+2842, "⡂", e2a182),
_c(U+2843, "⡃", e2a183),
_c(U+2844, "⡄", e2a184),
_c(U+2845, "⡅", e2a185),
_c(U+2846, "⡆", e2a186),
_c(U+2847, "⡇", e2a187),
_c(U+2848, "⡈", e2a188),
_c(U+2849, "⡉", e2a189),
_c(U+284A, "⡊", e2a18a),
_c(U+284B, "⡋", e2a18b),
_c(U+284C, "⡌", e2a18c),
_c(U+284D, "⡍", e2a18d),
_c(U+284E, "⡎", e2a18e),
_c(U+284F, "⡏", e2a18f),
_c(U+2850, "⡐", e2a190),
_c(U+2851, "⡑", e2a191),
_c(U+2852, "⡒", e2a192),
_c(U+2853, "⡓", e2a193),
_c(U+2854, "⡔", e2a194),
_c(U+2855, "⡕", e2a195),
_c(U+2856, "⡖", e2a196),
_c(U+2857, "⡗", e2a197),
_c(U+2858, "⡘", e2a198),
_c(U+2859, "⡙", e2a199),
_c(U+285A, "⡚", e2a19a),
_c(U+285B, "⡛", e2a19b),
_c(U+285C, "⡜", e2a19c),
_c(U+285D, "⡝", e2a19d),
_c(U+285E, "⡞", e2a19e),
_c(U+285F, "⡟", e2a19f),
_c(U+2860, "⡠", e2a1a0),
_c(U+2861, "⡡", e2a1a1),
_c(U+2862, "⡢", e2a1a2),
_c(U+2863, "⡣", e2a1a3),
_c(U+2864, "⡤", e2a1a4),
_c(U+2865, "⡥", e2a1a5),
_c(U+2866, "⡦", e2a1a6),
_c(U+2867, "⡧", e2a1a7),
_c(U+2868, "⡨", e2a1a8),
_c(U+2869, "⡩", e2a1a9),
_c(U+286A, "⡪", e2a1aa),
_c(U+286B, "⡫", e2a1ab),
_c(U+286C, "⡬", e2a1ac),
_c(U+286D, "⡭", e2a1ad),
_c(U+286E, "⡮", e2a1ae),
_c(U+286F, "⡯", e2a1af),
_c(U+2870, "⡰", e2a1b0),
_c(U+2871, "⡱", e2a1b1),
_c(U+2872, "⡲", e2a1b2),
_c(U+2873, "⡳", e2a1b3),
_c(U+2874, "⡴", e2a1b4),
_c(U+2875, "⡵", e2a1b5),
_c(U+2876, "⡶", e2a1b6),
_c(U+2877, "⡷", e2a1b7),
_c(U+2878, "⡸", e2a1b8),
_c(U+2879, "⡹", e2a1b9),
_c(U+287A, "⡺", e2a1ba),
_c(U+287B, "⡻", e2a1bb),
_c(U+287C, "⡼", e2a1bc),
_c(U+287D, "⡽", e2a1bd),
_c(U+287E, "⡾", e2a1be),
_c(U+287F, "⡿", e2a1bf),
_c(U+2880, "⢀", e2a280),
_c(U+2881, "⢁", e2a281),
_c(U+2882, "⢂", e2a282),
_c(U+2883, "⢃", e2a283),
_c(U+2884, "⢄", e2a284),
_c(U+2885, "⢅", e2a285),
_c(U+2886, "⢆", e2a286),
_c(U+2887, "⢇", e2a287),
_c(U+2888, "⢈", e2a288),
_c(U+2889, "⢉", e2a289),
_c(U+288A, "⢊", e2a28a),
_c(U+288B, "⢋", e2a28b),
_c(U+288C, "⢌", e2a28c),
_c(U+288D, "⢍", e2a28d),
_c(U+288E, "⢎", e2a28e),
_c(U+288F, "⢏", e2a28f),
_c(U+2890, "⢐", e2a290),
_c(U+2891, "⢑", e2a291),
_c(U+2892, "⢒", e2a292),
_c(U+2893, "⢓", e2a293),
_c(U+2894, "⢔", e2a294),
_c(U+2895, "⢕", e2a295),
_c(U+2896, "⢖", e2a296),
_c(U+2897, "⢗", e2a297),
_c(U+2898, "⢘", e2a298),
_c(U+2899, "⢙", e2a299),
_c(U+289A, "⢚", e2a29a),
_c(U+289B, "⢛", e2a29b),
_c(U+289C, "⢜", e2a29c),
_c(U+289D, "⢝", e2a29d),
_c(U+289E, "⢞", e2a29e),
_c(U+289F, "⢟", e2a29f),
_c(U+28A0, "⢠", e2a2a0),
_c(U+28A1, "⢡", e2a2a1),
_c(U+28A2, "⢢", e2a2a2),
_c(U+28A3, "⢣", e2a2a3),
_c(U+28A4, "⢤", e2a2a4),
_c(U+28A5, "⢥", e2a2a5),
_c(U+28A6, "⢦", e2a2a6),
_c(U+28A7, "⢧", e2a2a7),
_c(U+28A8, "⢨", e2a2a8),
_c(U+28A9, "⢩", e2a2a9),
_c(U+28AA, "⢪", e2a2aa),
_c(U+28AB, "⢫", e2a2ab),
_c(U+28AC, "⢬", e2a2ac),
_c(U+28AD, "⢭", e2a2ad),
_c(U+28AE, "⢮", e2a2ae),
_c(U+28AF, "⢯", e2a2af),
_c(U+28B0, "⢰", e2a2b0),
_c(U+28B1, "⢱", e2a2b1),
_c(U+28B2, "⢲", e2a2b2),
_c(U+28B3, "⢳", e2a2b3),
_c(U+28B4, "⢴", e2a2b4),
_c(U+28B5, "⢵", e2a2b5),
_c(U+28B6, "⢶", e2a2b6),
_c(U+28B7, "⢷", e2a2b7),
_c(U+28B8, "⢸", e2a2b8),
_c(U+28B9, "⢹", e2a2b9),
_c(U+28BA, "⢺", e2a2ba),
_c(U+28BB, "⢻", e2a2bb),
_c(U+28BC, "⢼", e2a2bc),
_c(U+28BD, "⢽", e2a2bd),
_c(U+28BE, "⢾", e2a2be),
_c(U+28BF, "⢿", e2a2bf),
_c(U+28C0, "⣀", e2a380),
_c(U+28C1, "⣁", e2a381),
_c(U+28C2, "⣂", e2a382),
_c(U+28C3, "⣃", e2a383),
_c(U+28C4, "⣄", e2a384),
_c(U+28C5, "⣅", e2a385),
_c(U+28C6, "⣆", e2a386),
_c(U+28C7, "⣇", e2a387),
_c(U+28C8, "⣈", e2a388),
_c(U+28C9, "⣉", e2a389),
_c(U+28CA, "⣊", e2a38a),
_c(U+28CB, "⣋", e2a38b),
_c(U+28CC, "⣌", e2a38c),
_c(U+28CD, "⣍", e2a38d),
_c(U+28CE, "⣎", e2a38e),
_c(U+28CF, "⣏", e2a38f),
_c(U+28D0, "⣐", e2a390),
_c(U+28D1, "⣑", e2a391),
_c(U+28D2, "⣒", e2a392),
_c(U+28D3, "⣓", e2a393),
_c(U+28D4, "⣔", e2a394),
_c(U+28D5, "⣕", e2a395),
_c(U+28D6, "⣖", e2a396),
_c(U+28D7, "⣗", e2a397),
_c(U+28D8, "⣘", e2a398),
_c(U+28D9, "⣙", e2a399),
_c(U+28DA, "⣚", e2a39a),
_c(U+28DB, "⣛", e2a39b),
_c(U+28DC, "⣜", e2a39c),
_c(U+28DD, "⣝", e2a39d),
_c(U+28DE, "⣞", e2a39e),
_c(U+28DF, "⣟", e2a39f),
_c(U+28E0, "⣠", e2a3a0),
_c(U+28E1, "⣡", e2a3a1),
_c(U+28E2, "⣢", e2a3a2),
_c(U+28E3, "⣣", e2a3a3),
_c(U+28E4, "⣤", e2a3a4),
_c(U+28E5, "⣥", e2a3a5),
_c(U+28E6, "⣦", e2a3a6),
_c(U+28E7, "⣧", e2a3a7),
_c(U+28E8, "⣨", e2a3a8),
_c(U+28E9, "⣩", e2a3a9),
_c(U+28EA, "⣪", e2a3aa),
_c(U+28EB, "⣫", e2a3ab),
_c(U+28EC, "⣬", e2a3ac),
_c(U+28ED, "⣭", e2a3ad),
_c(U+28EE, "⣮", e2a3ae),
_c(U+28EF, "⣯", e2a3af),
_c(U+28F0, "⣰", e2a3b0),
_c(U+28F1, "⣱", e2a3b1),
_c(U+28F2, "⣲", e2a3b2),
_c(U+28F3, "⣳", e2a3b3),
_c(U+28F4, "⣴", e2a3b4),
_c(U+28F5, "⣵", e2a3b5),
_c(U+28F6, "⣶", e2a3b6),
_c(U+28F7, "⣷", e2a3b7),
_c(U+28F8, "⣸", e2a3b8),
_c(U+28F9, "⣹", e2a3b9),
_c(U+28FA, "⣺", e2a3ba),
_c(U+28FB, "⣻", e2a3bb),
_c(U+28FC, "⣼", e2a3bc),
_c(U+28FD, "⣽", e2a3bd),
_c(U+28FE, "⣾", e2a3be),
_c(U+28FF, "⣿", e2a3bf),
_c(U+2900, "⤀", e2a480),
_c(U+2901, "⤁", e2a481),
_c(U+2902, "⤂", e2a482),
_c(U+2903, "⤃", e2a483),
_c(U+2904, "⤄", e2a484),
_c(U+2905, "⤅", e2a485),
_c(U+2906, "⤆", e2a486),
_c(U+2907, "⤇", e2a487),
_c(U+2908, "⤈", e2a488),
_c(U+2909, "⤉", e2a489),
_c(U+290A, "⤊", e2a48a),
_c(U+290B, "⤋", e2a48b),
_c(U+290C, "⤌", e2a48c),
_c(U+290D, "⤍", e2a48d),
_c(U+290E, "⤎", e2a48e),
_c(U+290F, "⤏", e2a48f),
_c(U+2910, "⤐", e2a490),
_c(U+2911, "⤑", e2a491),
_c(U+2912, "⤒", e2a492),
_c(U+2913, "⤓", e2a493),
_c(U+2914, "⤔", e2a494),
_c(U+2915, "⤕", e2a495),
_c(U+2916, "⤖", e2a496),
_c(U+2917, "⤗", e2a497),
_c(U+2918, "⤘", e2a498),
_c(U+2919, "⤙", e2a499),
_c(U+291A, "⤚", e2a49a),
_c(U+291B, "⤛", e2a49b),
_c(U+291C, "⤜", e2a49c),
_c(U+291D, "⤝", e2a49d),
_c(U+291E, "⤞", e2a49e),
_c(U+291F, "⤟", e2a49f),
_c(U+2920, "⤠", e2a4a0),
_c(U+2921, "⤡", e2a4a1),
_c(U+2922, "⤢", e2a4a2),
_c(U+2923, "⤣", e2a4a3),
_c(U+2924, "⤤", e2a4a4),
_c(U+2925, "⤥", e2a4a5),
_c(U+2926, "⤦", e2a4a6),
_c(U+2927, "⤧", e2a4a7),
_c(U+2928, "⤨", e2a4a8),
_c(U+2929, "⤩", e2a4a9),
_c(U+292A, "⤪", e2a4aa),
_c(U+292B, "⤫", e2a4ab),
_c(U+292C, "⤬", e2a4ac),
_c(U+292D, "⤭", e2a4ad),
_c(U+292E, "⤮", e2a4ae),
_c(U+292F, "⤯", e2a4af),
_c(U+2930, "⤰", e2a4b0),
_c(U+2931, "⤱", e2a4b1),
_c(U+2932, "⤲", e2a4b2),
_c(U+2933, "⤳", e2a4b3),
_c(U+2934, "⤴", e2a4b4),
_c(U+2935, "⤵", e2a4b5),
_c(U+2936, "⤶", e2a4b6),
_c(U+2937, "⤷", e2a4b7),
_c(U+2938, "⤸", e2a4b8),
_c(U+2939, "⤹", e2a4b9),
_c(U+293A, "⤺", e2a4ba),
_c(U+293B, "⤻", e2a4bb),
_c(U+293C, "⤼", e2a4bc),
_c(U+293D, "⤽", e2a4bd),
_c(U+293E, "⤾", e2a4be),
_c(U+293F, "⤿", e2a4bf),
_c(U+2940, "⥀", e2a580),
_c(U+2941, "⥁", e2a581),
_c(U+2942, "⥂", e2a582),
_c(U+2943, "⥃", e2a583),
_c(U+2944, "⥄", e2a584),
_c(U+2945, "⥅", e2a585),
_c(U+2946, "⥆", e2a586),
_c(U+2947, "⥇", e2a587),
_c(U+2948, "⥈", e2a588),
_c(U+2949, "⥉", e2a589),
_c(U+294A, "⥊", e2a58a),
_c(U+294B, "⥋", e2a58b),
_c(U+294C, "⥌", e2a58c),
_c(U+294D, "⥍", e2a58d),
_c(U+294E, "⥎", e2a58e),
_c(U+294F, "⥏", e2a58f),
_c(U+2950, "⥐", e2a590),
_c(U+2951, "⥑", e2a591),
_c(U+2952, "⥒", e2a592),
_c(U+2953, "⥓", e2a593),
_c(U+2954, "⥔", e2a594),
_c(U+2955, "⥕", e2a595),
_c(U+2956, "⥖", e2a596),
_c(U+2957, "⥗", e2a597),
_c(U+2958, "⥘", e2a598),
_c(U+2959, "⥙", e2a599),
_c(U+295A, "⥚", e2a59a),
_c(U+295B, "⥛", e2a59b),
_c(U+295C, "⥜", e2a59c),
_c(U+295D, "⥝", e2a59d),
_c(U+295E, "⥞", e2a59e),
_c(U+295F, "⥟", e2a59f),
_c(U+2960, "⥠", e2a5a0),
_c(U+2961, "⥡", e2a5a1),
_c(U+2962, "⥢", e2a5a2),
_c(U+2963, "⥣", e2a5a3),
_c(U+2964, "⥤", e2a5a4),
_c(U+2965, "⥥", e2a5a5),
_c(U+2966, "⥦", e2a5a6),
_c(U+2967, "⥧", e2a5a7),
_c(U+2968, "⥨", e2a5a8),
_c(U+2969, "⥩", e2a5a9),
_c(U+296A, "⥪", e2a5aa),
_c(U+296B, "⥫", e2a5ab),
_c(U+296C, "⥬", e2a5ac),
_c(U+296D, "⥭", e2a5ad),
_c(U+296E, "⥮", e2a5ae),
_c(U+296F, "⥯", e2a5af),
_c(U+2970, "⥰", e2a5b0),
_c(U+2971, "⥱", e2a5b1),
_c(U+2972, "⥲", e2a5b2),
_c(U+2973, "⥳", e2a5b3),
_c(U+2974, "⥴", e2a5b4),
_c(U+2975, "⥵", e2a5b5),
_c(U+2976, "⥶", e2a5b6),
_c(U+2977, "⥷", e2a5b7),
_c(U+2978, "⥸", e2a5b8),
_c(U+2979, "⥹", e2a5b9),
_c(U+297A, "⥺", e2a5ba),
_c(U+297B, "⥻", e2a5bb),
_c(U+297C, "⥼", e2a5bc),
_c(U+297D, "⥽", e2a5bd),
_c(U+297E, "⥾", e2a5be),
_c(U+297F, "⥿", e2a5bf),
_c(U+2980, "⦀", e2a680),
_c(U+2981, "⦁", e2a681),
_c(U+2982, "⦂", e2a682),
_c(U+2983, "⦃", e2a683),
_c(U+2984, "⦄", e2a684),
_c(U+2985, "⦅", e2a685),
_c(U+2986, "⦆", e2a686),
_c(U+2987, "⦇", e2a687),
_c(U+2988, "⦈", e2a688),
_c(U+2989, "⦉", e2a689),
_c(U+298A, "⦊", e2a68a),
_c(U+298B, "⦋", e2a68b),
_c(U+298C, "⦌", e2a68c),
_c(U+298D, "⦍", e2a68d),
_c(U+298E, "⦎", e2a68e),
_c(U+298F, "⦏", e2a68f),
_c(U+2990, "⦐", e2a690),
_c(U+2991, "⦑", e2a691),
_c(U+2992, "⦒", e2a692),
_c(U+2993, "⦓", e2a693),
_c(U+2994, "⦔", e2a694),
_c(U+2995, "⦕", e2a695),
_c(U+2996, "⦖", e2a696),
_c(U+2997, "⦗", e2a697),
_c(U+2998, "⦘", e2a698),
_c(U+2999, "⦙", e2a699),
_c(U+299A, "⦚", e2a69a),
_c(U+299B, "⦛", e2a69b),
_c(U+299C, "⦜", e2a69c),
_c(U+299D, "⦝", e2a69d),
_c(U+299E, "⦞", e2a69e),
_c(U+299F, "⦟", e2a69f),
_c(U+29A0, "⦠", e2a6a0),
_c(U+29A1, "⦡", e2a6a1),
_c(U+29A2, "⦢", e2a6a2),
_c(U+29A3, "⦣", e2a6a3),
_c(U+29A4, "⦤", e2a6a4),
_c(U+29A5, "⦥", e2a6a5),
_c(U+29A6, "⦦", e2a6a6),
_c(U+29A7, "⦧", e2a6a7),
_c(U+29A8, "⦨", e2a6a8),
_c(U+29A9, "⦩", e2a6a9),
_c(U+29AA, "⦪", e2a6aa),
_c(U+29AB, "⦫", e2a6ab),
_c(U+29AC, "⦬", e2a6ac),
_c(U+29AD, "⦭", e2a6ad),
_c(U+29AE, "⦮", e2a6ae),
_c(U+29AF, "⦯", e2a6af),
_c(U+29B0, "⦰", e2a6b0),
_c(U+29B1, "⦱", e2a6b1),
_c(U+29B2, "⦲", e2a6b2),
_c(U+29B3, "⦳", e2a6b3),
_c(U+29B4, "⦴", e2a6b4),
_c(U+29B5, "⦵", e2a6b5),
_c(U+29B6, "⦶", e2a6b6),
_c(U+29B7, "⦷", e2a6b7),
_c(U+29B8, "⦸", e2a6b8),
_c(U+29B9, "⦹", e2a6b9),
_c(U+29BA, "⦺", e2a6ba),
_c(U+29BB, "⦻", e2a6bb),
_c(U+29BC, "⦼", e2a6bc),
_c(U+29BD, "⦽", e2a6bd),
_c(U+29BE, "⦾", e2a6be),
_c(U+29BF, "⦿", e2a6bf),
_c(U+29C0, "⧀", e2a780),
_c(U+29C1, "⧁", e2a781),
_c(U+29C2, "⧂", e2a782),
_c(U+29C3, "⧃", e2a783),
_c(U+29C4, "⧄", e2a784),
_c(U+29C5, "⧅", e2a785),
_c(U+29C6, "⧆", e2a786),
_c(U+29C7, "⧇", e2a787),
_c(U+29C8, "⧈", e2a788),
_c(U+29C9, "⧉", e2a789),
_c(U+29CA, "⧊", e2a78a),
_c(U+29CB, "⧋", e2a78b),
_c(U+29CC, "⧌", e2a78c),
_c(U+29CD, "⧍", e2a78d),
_c(U+29CE, "⧎", e2a78e),
_c(U+29CF, "⧏", e2a78f),
_c(U+29D0, "⧐", e2a790),
_c(U+29D1, "⧑", e2a791),
_c(U+29D2, "⧒", e2a792),
_c(U+29D3, "⧓", e2a793),
_c(U+29D4, "⧔", e2a794),
_c(U+29D5, "⧕", e2a795),
_c(U+29D6, "⧖", e2a796),
_c(U+29D7, "⧗", e2a797),
_c(U+29D8, "⧘", e2a798),
_c(U+29D9, "⧙", e2a799),
_c(U+29DA, "⧚", e2a79a),
_c(U+29DB, "⧛", e2a79b),
_c(U+29DC, "⧜", e2a79c),
_c(U+29DD, "⧝", e2a79d),
_c(U+29DE, "⧞", e2a79e),
_c(U+29DF, "⧟", e2a79f),
_c(U+29E0, "⧠", e2a7a0),
_c(U+29E1, "⧡", e2a7a1),
_c(U+29E2, "⧢", e2a7a2),
_c(U+29E3, "⧣", e2a7a3),
_c(U+29E4, "⧤", e2a7a4),
_c(U+29E5, "⧥", e2a7a5),
_c(U+29E6, "⧦", e2a7a6),
_c(U+29E7, "⧧", e2a7a7),
_c(U+29E8, "⧨", e2a7a8),
_c(U+29E9, "⧩", e2a7a9),
_c(U+29EA, "⧪", e2a7aa),
_c(U+29EB, "⧫", e2a7ab),
_c(U+29EC, "⧬", e2a7ac),
_c(U+29ED, "⧭", e2a7ad),
_c(U+29EE, "⧮", e2a7ae),
_c(U+29EF, "⧯", e2a7af),
_c(U+29F0, "⧰", e2a7b0),
_c(U+29F1, "⧱", e2a7b1),
_c(U+29F2, "⧲", e2a7b2),
_c(U+29F3, "⧳", e2a7b3),
_c(U+29F4, "⧴", e2a7b4),
_c(U+29F5, "⧵", e2a7b5),
_c(U+29F6, "⧶", e2a7b6),
_c(U+29F7, "⧷", e2a7b7),
_c(U+29F8, "⧸", e2a7b8),
_c(U+29F9, "⧹", e2a7b9),
_c(U+29FA, "⧺", e2a7ba),
_c(U+29FB, "⧻", e2a7bb),
_c(U+29FC, "⧼", e2a7bc),
_c(U+29FD, "⧽", e2a7bd),
_c(U+29FE, "⧾", e2a7be),
_c(U+29FF, "⧿", e2a7bf),
_c(U+1D100, "𝄀", f09d8480),
_c(U+1D101, "𝄁", f09d8481),
_c(U+1D102, "𝄂", f09d8482),
_c(U+1D103, "𝄃", f09d8483),
_c(U+1D104, "𝄄", f09d8484),
_c(U+1D105, "𝄅", f09d8485),
_c(U+1D106, "𝄆", f09d8486),
_c(U+1D107, "𝄇", f09d8487),
_c(U+1D108, "𝄈", f09d8488),
_c(U+1D109, "𝄉", f09d8489),
_c(U+1D10A, "𝄊", f09d848a),
_c(U+1D10B, "𝄋", f09d848b),
_c(U+1D10C, "𝄌", f09d848c),
_c(U+1D10D, "𝄍", f09d848d),
_c(U+1D10E, "𝄎", f09d848e),
_c(U+1D10F, "𝄏", f09d848f),
_c(U+1D110, "𝄐", f09d8490),
_c(U+1D111, "𝄑", f09d8491),
_c(U+1D112, "𝄒", f09d8492),
_c(U+1D113, "𝄓", f09d8493),
_c(U+1D114, "𝄔", f09d8494),
_c(U+1D115, "𝄕", f09d8495),
_c(U+1D116, "𝄖", f09d8496),
_c(U+1D117, "𝄗", f09d8497),
_c(U+1D118, "𝄘", f09d8498),
_c(U+1D119, "𝄙", f09d8499),
_c(U+1D11A, "𝄚", f09d849a),
_c(U+1D11B, "𝄛", f09d849b),
_c(U+1D11C, "𝄜", f09d849c),
_c(U+1D11D, "𝄝", f09d849d),
_c(U+1D11E, "𝄞", f09d849e),
_c(U+1D11F, "𝄟", f09d849f),
_c(U+1D120, "𝄠", f09d84a0),
_c(U+1D121, "𝄡", f09d84a1),
_c(U+1D122, "𝄢", f09d84a2),
_c(U+1D123, "𝄣", f09d84a3),
_c(U+1D124, "𝄤", f09d84a4),
_c(U+1D125, "𝄥", f09d84a5),
_c(U+1D126, "𝄦", f09d84a6),
_c(U+1D127, "𝄧", f09d84a7),
_c(U+1D128, "𝄨", f09d84a8),
_c(U+1D129, "𝄩", f09d84a9),
_c(U+1D12A, "𝄪", f09d84aa),
_c(U+1D12B, "𝄫", f09d84ab),
_c(U+1D12C, "𝄬", f09d84ac),
_c(U+1D12D, "𝄭", f09d84ad),
_c(U+1D12E, "𝄮", f09d84ae),
_c(U+1D12F, "𝄯", f09d84af),
_c(U+1D130, "𝄰", f09d84b0),
_c(U+1D131, "𝄱", f09d84b1),
_c(U+1D132, "𝄲", f09d84b2),
_c(U+1D133, "𝄳", f09d84b3),
_c(U+1D134, "𝄴", f09d84b4),
_c(U+1D135, "𝄵", f09d84b5),
_c(U+1D136, "𝄶", f09d84b6),
_c(U+1D137, "𝄷", f09d84b7),
_c(U+1D138, "𝄸", f09d84b8),
_c(U+1D139, "𝄹", f09d84b9),
_c(U+1D13A, "𝄺", f09d84ba),
_c(U+1D13B, "𝄻", f09d84bb),
_c(U+1D13C, "𝄼", f09d84bc),
_c(U+1D13D, "𝄽", f09d84bd),
_c(U+1D13E, "𝄾", f09d84be),
_c(U+1D13F, "𝄿", f09d84bf),
_c(U+1D140, "𝅀", f09d8580),
_c(U+1D141, "𝅁", f09d8581),
_c(U+1D142, "𝅂", f09d8582),
_c(U+1D143, "𝅃", f09d8583),
_c(U+1D144, "𝅄", f09d8584),
_c(U+1D145, "𝅅", f09d8585),
_c(U+1D146, "𝅆", f09d8586),
_c(U+1D147, "𝅇", f09d8587),
_c(U+1D148, "𝅈", f09d8588),
_c(U+1D149, "𝅉", f09d8589),
_c(U+1D14A, "𝅊", f09d858a),
_c(U+1D14B, "𝅋", f09d858b),
_c(U+1D14C, "𝅌", f09d858c),
_c(U+1D14D, "𝅍", f09d858d),
_c(U+1D14E, "𝅎", f09d858e),
_c(U+1D14F, "𝅏", f09d858f),
_c(U+1D150, "𝅐", f09d8590),
_c(U+1D151, "𝅑", f09d8591),
_c(U+1D152, "𝅒", f09d8592),
_c(U+1D153, "𝅓", f09d8593),
_c(U+1D154, "𝅔", f09d8594),
_c(U+1D155, "𝅕", f09d8595),
_c(U+1D156, "𝅖", f09d8596),
_c(U+1D157, "𝅗", f09d8597),
_c(U+1D158, "𝅘", f09d8598),
_c(U+1D159, "𝅙", f09d8599),
_c(U+1D15A, "𝅚", f09d859a),
_c(U+1D15B, "𝅛", f09d859b),
_c(U+1D15C, "𝅜", f09d859c),
_c(U+1D15D, "𝅝", f09d859d),
_c(U+1D15E, "𝅗𝅥", f09d859e),
_c(U+1D15F, "𝅘𝅥", f09d859f),
_c(U+1D160, "𝅘𝅥𝅮", f09d85a0),
_c(U+1D161, "𝅘𝅥𝅯", f09d85a1),
_c(U+1D162, "𝅘𝅥𝅰", f09d85a2),
_c(U+1D163, "𝅘𝅥𝅱", f09d85a3),
_c(U+1D164, "𝅘𝅥𝅲", f09d85a4),
_c(U+1D165, "𝅥", f09d85a5),
_c(U+1D166, "𝅦", f09d85a6),
_c(U+1D167, "𝅧", f09d85a7),
_c(U+1D168, "𝅨", f09d85a8),
_c(U+1D169, "𝅩", f09d85a9),
_c(U+1D16A, "𝅪", f09d85aa),
_c(U+1D16B, "𝅫", f09d85ab),
_c(U+1D16C, "𝅬", f09d85ac),
_c(U+1D16D, "𝅭", f09d85ad),
_c(U+1D16E, "𝅮", f09d85ae),
_c(U+1D16F, "𝅯", f09d85af),
_c(U+1D170, "𝅰", f09d85b0),
_c(U+1D171, "𝅱", f09d85b1),
_c(U+1D172, "𝅲", f09d85b2),
_c(U+1D173, "𝅳", f09d85b3),
_c(U+1D174, "𝅴", f09d85b4),
_c(U+1D175, "𝅵", f09d85b5),
_c(U+1D176, "𝅶", f09d85b6),
_c(U+1D177, "𝅷", f09d85b7),
_c(U+1D178, "𝅸", f09d85b8),
_c(U+1D179, "𝅹", f09d85b9),
_c(U+1D17A, "𝅺", f09d85ba),
_c(U+1D17B, "𝅻", f09d85bb),
_c(U+1D17C, "𝅼", f09d85bc),
_c(U+1D17D, "𝅽", f09d85bd),
_c(U+1D17E, "𝅾", f09d85be),
_c(U+1D17F, "𝅿", f09d85bf),
_c(U+1D180, "𝆀", f09d8680),
_c(U+1D181, "𝆁", f09d8681),
_c(U+1D182, "𝆂", f09d8682),
_c(U+1D183, "𝆃", f09d8683),
_c(U+1D184, "𝆄", f09d8684),
_c(U+1D185, "𝆅", f09d8685),
_c(U+1D186, "𝆆", f09d8686),
_c(U+1D187, "𝆇", f09d8687),
_c(U+1D188, "𝆈", f09d8688),
_c(U+1D189, "𝆉", f09d8689),
_c(U+1D18A, "𝆊", f09d868a),
_c(U+1D18B, "𝆋", f09d868b),
_c(U+1D18C, "𝆌", f09d868c),
_c(U+1D18D, "𝆍", f09d868d),
_c(U+1D18E, "𝆎", f09d868e),
_c(U+1D18F, "𝆏", f09d868f),
_c(U+1D190, "𝆐", f09d8690),
_c(U+1D191, "𝆑", f09d8691),
_c(U+1D192, "𝆒", f09d8692),
_c(U+1D193, "𝆓", f09d8693),
_c(U+1D194, "𝆔", f09d8694),
_c(U+1D195, "𝆕", f09d8695),
_c(U+1D196, "𝆖", f09d8696),
_c(U+1D197, "𝆗", f09d8697),
_c(U+1D198, "𝆘", f09d8698),
_c(U+1D199, "𝆙", f09d8699),
_c(U+1D19A, "𝆚", f09d869a),
_c(U+1D19B, "𝆛", f09d869b),
_c(U+1D19C, "𝆜", f09d869c),
_c(U+1D19D, "𝆝", f09d869d),
_c(U+1D19E, "𝆞", f09d869e),
_c(U+1D19F, "𝆟", f09d869f),
_c(U+1D1A0, "𝆠", f09d86a0),
_c(U+1D1A1, "𝆡", f09d86a1),
_c(U+1D1A2, "𝆢", f09d86a2),
_c(U+1D1A3, "𝆣", f09d86a3),
_c(U+1D1A4, "𝆤", f09d86a4),
_c(U+1D1A5, "𝆥", f09d86a5),
_c(U+1D1A6, "𝆦", f09d86a6),
_c(U+1D1A7, "𝆧", f09d86a7),
_c(U+1D1A8, "𝆨", f09d86a8),
_c(U+1D1A9, "𝆩", f09d86a9),
_c(U+1D1AA, "𝆪", f09d86aa),
_c(U+1D1AB, "𝆫", f09d86ab),
_c(U+1D1AC, "𝆬", f09d86ac),
_c(U+1D1AD, "𝆭", f09d86ad),
_c(U+1D1AE, "𝆮", f09d86ae),
_c(U+1D1AF, "𝆯", f09d86af),
_c(U+1D1B0, "𝆰", f09d86b0),
_c(U+1D1B1, "𝆱", f09d86b1),
_c(U+1D1B2, "𝆲", f09d86b2),
_c(U+1D1B3, "𝆳", f09d86b3),
_c(U+1D1B4, "𝆴", f09d86b4),
_c(U+1D1B5, "𝆵", f09d86b5),
_c(U+1D1B6, "𝆶", f09d86b6),
_c(U+1D1B7, "𝆷", f09d86b7),
_c(U+1D1B8, "𝆸", f09d86b8),
_c(U+1D1B9, "𝆹", f09d86b9),
_c(U+1D1BA, "𝆺", f09d86ba),
_c(U+1D1BB, "𝆹𝅥", f09d86bb),
_c(U+1D1BC, "𝆺𝅥", f09d86bc),
_c(U+1D1BD, "𝆹𝅥𝅮", f09d86bd),
_c(U+1D1BE, "𝆺𝅥𝅮", f09d86be),
_c(U+1D1BF, "𝆹𝅥𝅯", f09d86bf),
_c(U+1D1C0, "𝆺𝅥𝅯", f09d8780),
_c(U+1D1C1, "𝇁", f09d8781),
_c(U+1D1C2, "𝇂", f09d8782),
_c(U+1D1C3, "𝇃", f09d8783),
_c(U+1D1C4, "𝇄", f09d8784),
_c(U+1D1C5, "𝇅", f09d8785),
_c(U+1D1C6, "𝇆", f09d8786),
_c(U+1D1C7, "𝇇", f09d8787),
_c(U+1D1C8, "𝇈", f09d8788),
_c(U+1D1C9, "𝇉", f09d8789),
_c(U+1D1CA, "𝇊", f09d878a),
_c(U+1D1CB, "𝇋", f09d878b),
_c(U+1D1CC, "𝇌", f09d878c),
_c(U+1D1CD, "𝇍", f09d878d),
_c(U+1D1CE, "𝇎", f09d878e),
_c(U+1D1CF, "𝇏", f09d878f),
_c(U+1D1D0, "𝇐", f09d8790),
_c(U+1D1D1, "𝇑", f09d8791),
_c(U+1D1D2, "𝇒", f09d8792),
_c(U+1D1D3, "𝇓", f09d8793),
_c(U+1D1D4, "𝇔", f09d8794),
_c(U+1D1D5, "𝇕", f09d8795),
_c(U+1D1D6, "𝇖", f09d8796),
_c(U+1D1D7, "𝇗", f09d8797),
_c(U+1D1D8, "𝇘", f09d8798),
_c(U+1D1D9, "𝇙", f09d8799),
_c(U+1D1DA, "𝇚", f09d879a),
_c(U+1D1DB, "𝇛", f09d879b),
_c(U+1D1DC, "𝇜", f09d879c),
_c(U+1D1DD, "𝇝", f09d879d),
_c(U+1D1DE, "𝇞", f09d879e),
_c(U+1D1DF, "𝇟", f09d879f),
_c(U+1D1E0, "𝇠", f09d87a0),
_c(U+1D1E1, "𝇡", f09d87a1),
_c(U+1D1E2, "𝇢", f09d87a2),
_c(U+1D1E3, "𝇣", f09d87a3),
_c(U+1D1E4, "𝇤", f09d87a4),
_c(U+1D1E5, "𝇥", f09d87a5),
_c(U+1D1E6, "𝇦", f09d87a6),
_c(U+1D1E7, "𝇧", f09d87a7),
_c(U+1D1E8, "𝇨", f09d87a8),
_c(U+1D1E9, "𝇩", f09d87a9),
_c(U+1D1EA, "𝇪", f09d87aa),
_c(U+1D1EB, "𝇫", f09d87ab),
_c(U+1D1EC, "𝇬", f09d87ac),
_c(U+1D1ED, "𝇭", f09d87ad),
_c(U+1D1EE, "𝇮", f09d87ae),
_c(U+1D1EF, "𝇯", f09d87af),
_c(U+1D1F0, "𝇰", f09d87b0),
_c(U+1D1F1, "𝇱", f09d87b1),
_c(U+1D1F2, "𝇲", f09d87b2),
_c(U+1D1F3, "𝇳", f09d87b3),
_c(U+1D1F4, "𝇴", f09d87b4),
_c(U+1D1F5, "𝇵", f09d87b5),
_c(U+1D1F6, "𝇶", f09d87b6),
_c(U+1D1F7, "𝇷", f09d87b7),
_c(U+1D1F8, "𝇸", f09d87b8),
_c(U+1D1F9, "𝇹", f09d87b9),
_c(U+1D1FA, "𝇺", f09d87ba),
_c(U+1D1FB, "𝇻", f09d87bb),
_c(U+1D1FC, "𝇼", f09d87bc),
_c(U+1D1FD, "𝇽", f09d87bd),
_c(U+1D1FE, "𝇾", f09d87be),
_c(U+1D1FF, "𝇿", f09d87bf),
_c(U+1D200, "𝈀", f09d8880),
_c(U+1D201, "𝈁", f09d8881),
_c(U+1D202, "𝈂", f09d8882),
_c(U+1D203, "𝈃", f09d8883),
_c(U+1D204, "𝈄", f09d8884),
_c(U+1D205, "𝈅", f09d8885),
_c(U+1D206, "𝈆", f09d8886),
_c(U+1D207, "𝈇", f09d8887),
_c(U+1D208, "𝈈", f09d8888),
_c(U+1D209, "𝈉", f09d8889),
_c(U+1D20A, "𝈊", f09d888a),
_c(U+1D20B, "𝈋", f09d888b),
_c(U+1D20C, "𝈌", f09d888c),
_c(U+1D20D, "𝈍", f09d888d),
_c(U+1D20E, "𝈎", f09d888e),
_c(U+1D20F, "𝈏", f09d888f),
_c(U+1D210, "𝈐", f09d8890),
_c(U+1D211, "𝈑", f09d8891),
_c(U+1D212, "𝈒", f09d8892),
_c(U+1D213, "𝈓", f09d8893),
_c(U+1D214, "𝈔", f09d8894),
_c(U+1D215, "𝈕", f09d8895),
_c(U+1D216, "𝈖", f09d8896),
_c(U+1D217, "𝈗", f09d8897),
_c(U+1D218, "𝈘", f09d8898),
_c(U+1D219, "𝈙", f09d8899),
_c(U+1D21A, "𝈚", f09d889a),
_c(U+1D21B, "𝈛", f09d889b),
_c(U+1D21C, "𝈜", f09d889c),
_c(U+1D21D, "𝈝", f09d889d),
_c(U+1D21E, "𝈞", f09d889e),
_c(U+1D21F, "𝈟", f09d889f),
_c(U+1D220, "𝈠", f09d88a0),
_c(U+1D221, "𝈡", f09d88a1),
_c(U+1D222, "𝈢", f09d88a2),
_c(U+1D223, "𝈣", f09d88a3),
_c(U+1D224, "𝈤", f09d88a4),
_c(U+1D225, "𝈥", f09d88a5),
_c(U+1D226, "𝈦", f09d88a6),
_c(U+1D227, "𝈧", f09d88a7),
_c(U+1D228, "𝈨", f09d88a8),
_c(U+1D229, "𝈩", f09d88a9),
_c(U+1D22A, "𝈪", f09d88aa),
_c(U+1D22B, "𝈫", f09d88ab),
_c(U+1D22C, "𝈬", f09d88ac),
_c(U+1D22D, "𝈭", f09d88ad),
_c(U+1D22E, "𝈮", f09d88ae),
_c(U+1D22F, "𝈯", f09d88af),
_c(U+1D230, "𝈰", f09d88b0),
_c(U+1D231, "𝈱", f09d88b1),
_c(U+1D232, "𝈲", f09d88b2),
_c(U+1D233, "𝈳", f09d88b3),
_c(U+1D234, "𝈴", f09d88b4),
_c(U+1D235, "𝈵", f09d88b5),
_c(U+1D236, "𝈶", f09d88b6),
_c(U+1D237, "𝈷", f09d88b7),
_c(U+1D238, "𝈸", f09d88b8),
_c(U+1D239, "𝈹", f09d88b9),
_c(U+1D23A, "𝈺", f09d88ba),
_c(U+1D23B, "𝈻", f09d88bb),
_c(U+1D23C, "𝈼", f09d88bc),
_c(U+1D23D, "𝈽", f09d88bd),
_c(U+1D23E, "𝈾", f09d88be),
_c(U+1D23F, "𝈿", f09d88bf),
_c(U+1D240, "𝉀", f09d8980),
_c(U+1D241, "𝉁", f09d8981),
_c(U+1D242, "𝉂", f09d8982),
_c(U+1D243, "𝉃", f09d8983),
_c(U+1D244, "𝉄", f09d8984),
_c(U+1D245, "𝉅", f09d8985),
_c(U+1D246, "𝉆", f09d8986),
_c(U+1D247, "𝉇", f09d8987),
_c(U+1D248, "𝉈", f09d8988),
_c(U+1D249, "𝉉", f09d8989),
_c(U+1D24A, "𝉊", f09d898a),
_c(U+1D24B, "𝉋", f09d898b),
_c(U+1D24C, "𝉌", f09d898c),
_c(U+1D24D, "𝉍", f09d898d),
_c(U+1D24E, "𝉎", f09d898e),
_c(U+1D24F, "𝉏", f09d898f),
_c(U+1D250, "𝉐", f09d8990),
_c(U+1D251, "𝉑", f09d8991),
_c(U+1D252, "𝉒", f09d8992),
_c(U+1D253, "𝉓", f09d8993),
_c(U+1D254, "𝉔", f09d8994),
_c(U+1D255, "𝉕", f09d8995),
_c(U+1D256, "𝉖", f09d8996),
_c(U+1D257, "𝉗", f09d8997),
_c(U+1D258, "𝉘", f09d8998),
_c(U+1D259, "𝉙", f09d8999),
_c(U+1D25A, "𝉚", f09d899a),
_c(U+1D25B, "𝉛", f09d899b),
_c(U+1D25C, "𝉜", f09d899c),
_c(U+1D25D, "𝉝", f09d899d),
_c(U+1D25E, "𝉞", f09d899e),
_c(U+1D25F, "𝉟", f09d899f),
_c(U+1D260, "𝉠", f09d89a0),
_c(U+1D261, "𝉡", f09d89a1),
_c(U+1D262, "𝉢", f09d89a2),
_c(U+1D263, "𝉣", f09d89a3),
_c(U+1D264, "𝉤", f09d89a4),
_c(U+1D265, "𝉥", f09d89a5),
_c(U+1D266, "𝉦", f09d89a6),
_c(U+1D267, "𝉧", f09d89a7),
_c(U+1D268, "𝉨", f09d89a8),
_c(U+1D269, "𝉩", f09d89a9),
_c(U+1D26A, "𝉪", f09d89aa),
_c(U+1D26B, "𝉫", f09d89ab),
_c(U+1D26C, "𝉬", f09d89ac),
_c(U+1D26D, "𝉭", f09d89ad),
_c(U+1D26E, "𝉮", f09d89ae),
_c(U+1D26F, "𝉯", f09d89af),
_c(U+1D270, "𝉰", f09d89b0),
_c(U+1D271, "𝉱", f09d89b1),
_c(U+1D272, "𝉲", f09d89b2),
_c(U+1D273, "𝉳", f09d89b3),
_c(U+1D274, "𝉴", f09d89b4),
_c(U+1D275, "𝉵", f09d89b5),
_c(U+1D276, "𝉶", f09d89b6),
_c(U+1D277, "𝉷", f09d89b7),
_c(U+1D278, "𝉸", f09d89b8),
_c(U+1D279, "𝉹", f09d89b9),
_c(U+1D27A, "𝉺", f09d89ba),
_c(U+1D27B, "𝉻", f09d89bb),
_c(U+1D27C, "𝉼", f09d89bc),
_c(U+1D27D, "𝉽", f09d89bd),
_c(U+1D27E, "𝉾", f09d89be),
_c(U+1D27F, "𝉿", f09d89bf),
_c(U+1D280, "𝊀", f09d8a80),
_c(U+1D281, "𝊁", f09d8a81),
_c(U+1D282, "𝊂", f09d8a82),
_c(U+1D283, "𝊃", f09d8a83),
_c(U+1D284, "𝊄", f09d8a84),
_c(U+1D285, "𝊅", f09d8a85),
_c(U+1D286, "𝊆", f09d8a86),
_c(U+1D287, "𝊇", f09d8a87),
_c(U+1D288, "𝊈", f09d8a88),
_c(U+1D289, "𝊉", f09d8a89),
_c(U+1D28A, "𝊊", f09d8a8a),
_c(U+1D28B, "𝊋", f09d8a8b),
_c(U+1D28C, "𝊌", f09d8a8c),
_c(U+1D28D, "𝊍", f09d8a8d),
_c(U+1D28E, "𝊎", f09d8a8e),
_c(U+1D28F, "𝊏", f09d8a8f),
_c(U+1D290, "𝊐", f09d8a90),
_c(U+1D291, "𝊑", f09d8a91),
_c(U+1D292, "𝊒", f09d8a92),
_c(U+1D293, "𝊓", f09d8a93),
_c(U+1D294, "𝊔", f09d8a94),
_c(U+1D295, "𝊕", f09d8a95),
_c(U+1D296, "𝊖", f09d8a96),
_c(U+1D297, "𝊗", f09d8a97),
_c(U+1D298, "𝊘", f09d8a98),
_c(U+1D299, "𝊙", f09d8a99),
_c(U+1D29A, "𝊚", f09d8a9a),
_c(U+1D29B, "𝊛", f09d8a9b),
_c(U+1D29C, "𝊜", f09d8a9c),
_c(U+1D29D, "𝊝", f09d8a9d),
_c(U+1D29E, "𝊞", f09d8a9e),
_c(U+1D29F, "𝊟", f09d8a9f),
_c(U+1D2A0, "𝊠", f09d8aa0),
_c(U+1D2A1, "𝊡", f09d8aa1),
_c(U+1D2A2, "𝊢", f09d8aa2),
_c(U+1D2A3, "𝊣", f09d8aa3),
_c(U+1D2A4, "𝊤", f09d8aa4),
_c(U+1D2A5, "𝊥", f09d8aa5),
_c(U+1D2A6, "𝊦", f09d8aa6),
_c(U+1D2A7, "𝊧", f09d8aa7),
_c(U+1D2A8, "𝊨", f09d8aa8),
_c(U+1D2A9, "𝊩", f09d8aa9),
_c(U+1D2AA, "𝊪", f09d8aaa),
_c(U+1D2AB, "𝊫", f09d8aab),
_c(U+1D2AC, "𝊬", f09d8aac),
_c(U+1D2AD, "𝊭", f09d8aad),
_c(U+1D2AE, "𝊮", f09d8aae),
_c(U+1D2AF, "𝊯", f09d8aaf),
_c(U+1D2B0, "𝊰", f09d8ab0),
_c(U+1D2B1, "𝊱", f09d8ab1),
_c(U+1D2B2, "𝊲", f09d8ab2),
_c(U+1D2B3, "𝊳", f09d8ab3),
_c(U+1D2B4, "𝊴", f09d8ab4),
_c(U+1D2B5, "𝊵", f09d8ab5),
_c(U+1D2B6, "𝊶", f09d8ab6),
_c(U+1D2B7, "𝊷", f09d8ab7),
_c(U+1D2B8, "𝊸", f09d8ab8),
_c(U+1D2B9, "𝊹", f09d8ab9),
_c(U+1D2BA, "𝊺", f09d8aba),
_c(U+1D2BB, "𝊻", f09d8abb),
_c(U+1D2BC, "𝊼", f09d8abc),
_c(U+1D2BD, "𝊽", f09d8abd),
_c(U+1D2BE, "𝊾", f09d8abe),
_c(U+1D2BF, "𝊿", f09d8abf),
_c(U+1D2C0, "𝋀", f09d8b80),
_c(U+1D2C1, "𝋁", f09d8b81),
_c(U+1D2C2, "𝋂", f09d8b82),
_c(U+1D2C3, "𝋃", f09d8b83),
_c(U+1D2C4, "𝋄", f09d8b84),
_c(U+1D2C5, "𝋅", f09d8b85),
_c(U+1D2C6, "𝋆", f09d8b86),
_c(U+1D2C7, "𝋇", f09d8b87),
_c(U+1D2C8, "𝋈", f09d8b88),
_c(U+1D2C9, "𝋉", f09d8b89),
_c(U+1D2CA, "𝋊", f09d8b8a),
_c(U+1D2CB, "𝋋", f09d8b8b),
_c(U+1D2CC, "𝋌", f09d8b8c),
_c(U+1D2CD, "𝋍", f09d8b8d),
_c(U+1D2CE, "𝋎", f09d8b8e),
_c(U+1D2CF, "𝋏", f09d8b8f),
_c(U+1D2D0, "𝋐", f09d8b90),
_c(U+1D2D1, "𝋑", f09d8b91),
_c(U+1D2D2, "𝋒", f09d8b92),
_c(U+1D2D3, "𝋓", f09d8b93),
_c(U+1D2D4, "𝋔", f09d8b94),
_c(U+1D2D5, "𝋕", f09d8b95),
_c(U+1D2D6, "𝋖", f09d8b96),
_c(U+1D2D7, "𝋗", f09d8b97),
_c(U+1D2D8, "𝋘", f09d8b98),
_c(U+1D2D9, "𝋙", f09d8b99),
_c(U+1D2DA, "𝋚", f09d8b9a),
_c(U+1D2DB, "𝋛", f09d8b9b),
_c(U+1D2DC, "𝋜", f09d8b9c),
_c(U+1D2DD, "𝋝", f09d8b9d),
_c(U+1D2DE, "𝋞", f09d8b9e),
_c(U+1D2DF, "𝋟", f09d8b9f),
_c(U+1D2E0, "𝋠", f09d8ba0),
_c(U+1D2E1, "𝋡", f09d8ba1),
_c(U+1D2E2, "𝋢", f09d8ba2),
_c(U+1D2E3, "𝋣", f09d8ba3),
_c(U+1D2E4, "𝋤", f09d8ba4),
_c(U+1D2E5, "𝋥", f09d8ba5),
_c(U+1D2E6, "𝋦", f09d8ba6),
_c(U+1D2E7, "𝋧", f09d8ba7),
_c(U+1D2E8, "𝋨", f09d8ba8),
_c(U+1D2E9, "𝋩", f09d8ba9),
_c(U+1D2EA, "𝋪", f09d8baa),
_c(U+1D2EB, "𝋫", f09d8bab),
_c(U+1D2EC, "𝋬", f09d8bac),
_c(U+1D2ED, "𝋭", f09d8bad),
_c(U+1D2EE, "𝋮", f09d8bae),
_c(U+1D2EF, "𝋯", f09d8baf),
_c(U+1D2F0, "𝋰", f09d8bb0),
_c(U+1D2F1, "𝋱", f09d8bb1),
_c(U+1D2F2, "𝋲", f09d8bb2),
_c(U+1D2F3, "𝋳", f09d8bb3),
_c(U+1D2F4, "𝋴", f09d8bb4),
_c(U+1D2F5, "𝋵", f09d8bb5),
_c(U+1D2F6, "𝋶", f09d8bb6),
_c(U+1D2F7, "𝋷", f09d8bb7),
_c(U+1D2F8, "𝋸", f09d8bb8),
_c(U+1D2F9, "𝋹", f09d8bb9),
_c(U+1D2FA, "𝋺", f09d8bba),
_c(U+1D2FB, "𝋻", f09d8bbb),
_c(U+1D2FC, "𝋼", f09d8bbc),
_c(U+1D2FD, "𝋽", f09d8bbd),
_c(U+1D2FE, "𝋾", f09d8bbe),
_c(U+1D2FF, "𝋿", f09d8bbf),
_c(U+1D300, "𝌀", f09d8c80),
_c(U+1D301, "𝌁", f09d8c81),
_c(U+1D302, "𝌂", f09d8c82),
_c(U+1D303, "𝌃", f09d8c83),
_c(U+1D304, "𝌄", f09d8c84),
_c(U+1D305, "𝌅", f09d8c85),
_c(U+1D306, "𝌆", f09d8c86),
_c(U+1D307, "𝌇", f09d8c87),
_c(U+1D308, "𝌈", f09d8c88),
_c(U+1D309, "𝌉", f09d8c89),
_c(U+1D30A, "𝌊", f09d8c8a),
_c(U+1D30B, "𝌋", f09d8c8b),
_c(U+1D30C, "𝌌", f09d8c8c),
_c(U+1D30D, "𝌍", f09d8c8d),
_c(U+1D30E, "𝌎", f09d8c8e),
_c(U+1D30F, "𝌏", f09d8c8f),
_c(U+1D310, "𝌐", f09d8c90),
_c(U+1D311, "𝌑", f09d8c91),
_c(U+1D312, "𝌒", f09d8c92),
_c(U+1D313, "𝌓", f09d8c93),
_c(U+1D314, "𝌔", f09d8c94),
_c(U+1D315, "𝌕", f09d8c95),
_c(U+1D316, "𝌖", f09d8c96),
_c(U+1D317, "𝌗", f09d8c97),
_c(U+1D318, "𝌘", f09d8c98),
_c(U+1D319, "𝌙", f09d8c99),
_c(U+1D31A, "𝌚", f09d8c9a),
_c(U+1D31B, "𝌛", f09d8c9b),
_c(U+1D31C, "𝌜", f09d8c9c),
_c(U+1D31D, "𝌝", f09d8c9d),
_c(U+1D31E, "𝌞", f09d8c9e),
_c(U+1D31F, "𝌟", f09d8c9f),
_c(U+1D320, "𝌠", f09d8ca0),
_c(U+1D321, "𝌡", f09d8ca1),
_c(U+1D322, "𝌢", f09d8ca2),
_c(U+1D323, "𝌣", f09d8ca3),
_c(U+1D324, "𝌤", f09d8ca4),
_c(U+1D325, "𝌥", f09d8ca5),
_c(U+1D326, "𝌦", f09d8ca6),
_c(U+1D327, "𝌧", f09d8ca7),
_c(U+1D328, "𝌨", f09d8ca8),
_c(U+1D329, "𝌩", f09d8ca9),
_c(U+1D32A, "𝌪", f09d8caa),
_c(U+1D32B, "𝌫", f09d8cab),
_c(U+1D32C, "𝌬", f09d8cac),
_c(U+1D32D, "𝌭", f09d8cad),
_c(U+1D32E, "𝌮", f09d8cae),
_c(U+1D32F, "𝌯", f09d8caf),
_c(U+1D330, "𝌰", f09d8cb0),
_c(U+1D331, "𝌱", f09d8cb1),
_c(U+1D332, "𝌲", f09d8cb2),
_c(U+1D333, "𝌳", f09d8cb3),
_c(U+1D334, "𝌴", f09d8cb4),
_c(U+1D335, "𝌵", f09d8cb5),
_c(U+1D336, "𝌶", f09d8cb6),
_c(U+1D337, "𝌷", f09d8cb7),
_c(U+1D338, "𝌸", f09d8cb8),
_c(U+1D339, "𝌹", f09d8cb9),
_c(U+1D33A, "𝌺", f09d8cba),
_c(U+1D33B, "𝌻", f09d8cbb),
_c(U+1D33C, "𝌼", f09d8cbc),
_c(U+1D33D, "𝌽", f09d8cbd),
_c(U+1D33E, "𝌾", f09d8cbe),
_c(U+1D33F, "𝌿", f09d8cbf),
_c(U+1D340, "𝍀", f09d8d80),
_c(U+1D341, "𝍁", f09d8d81),
_c(U+1D342, "𝍂", f09d8d82),
_c(U+1D343, "𝍃", f09d8d83),
_c(U+1D344, "𝍄", f09d8d84),
_c(U+1D345, "𝍅", f09d8d85),
_c(U+1D346, "𝍆", f09d8d86),
_c(U+1D347, "𝍇", f09d8d87),
_c(U+1D348, "𝍈", f09d8d88),
_c(U+1D349, "𝍉", f09d8d89),
_c(U+1D34A, "𝍊", f09d8d8a),
_c(U+1D34B, "𝍋", f09d8d8b),
_c(U+1D34C, "𝍌", f09d8d8c),
_c(U+1D34D, "𝍍", f09d8d8d),
_c(U+1D34E, "𝍎", f09d8d8e),
_c(U+1D34F, "𝍏", f09d8d8f),
_c(U+1D350, "𝍐", f09d8d90),
_c(U+1D351, "𝍑", f09d8d91),
_c(U+1D352, "𝍒", f09d8d92),
_c(U+1D353, "𝍓", f09d8d93),
_c(U+1D354, "𝍔", f09d8d94),
_c(U+1D355, "𝍕", f09d8d95),
_c(U+1D356, "𝍖", f09d8d96),
_c(U+1D357, "𝍗", f09d8d97),
_c(U+1D358, "𝍘", f09d8d98),
_c(U+1D359, "𝍙", f09d8d99),
_c(U+1D35A, "𝍚", f09d8d9a),
_c(U+1D35B, "𝍛", f09d8d9b),
_c(U+1D35C, "𝍜", f09d8d9c),
_c(U+1D35D, "𝍝", f09d8d9d),
_c(U+1D35E, "𝍞", f09d8d9e),
_c(U+1D35F, "𝍟", f09d8d9f),
_c(U+1D360, "𝍠", f09d8da0),
_c(U+1D361, "𝍡", f09d8da1),
_c(U+1D362, "𝍢", f09d8da2),
_c(U+1D363, "𝍣", f09d8da3),
_c(U+1D364, "𝍤", f09d8da4),
_c(U+1D365, "𝍥", f09d8da5),
_c(U+1D366, "𝍦", f09d8da6),
_c(U+1D367, "𝍧", f09d8da7),
_c(U+1D368, "𝍨", f09d8da8),
_c(U+1D369, "𝍩", f09d8da9),
_c(U+1D36A, "𝍪", f09d8daa),
_c(U+1D36B, "𝍫", f09d8dab),
_c(U+1D36C, "𝍬", f09d8dac),
_c(U+1D36D, "𝍭", f09d8dad),
_c(U+1D36E, "𝍮", f09d8dae),
_c(U+1D36F, "𝍯", f09d8daf),
_c(U+1D370, "𝍰", f09d8db0),
_c(U+1D371, "𝍱", f09d8db1),
_c(U+1D372, "𝍲", f09d8db2),
_c(U+1D373, "𝍳", f09d8db3),
_c(U+1D374, "𝍴", f09d8db4),
_c(U+1D375, "𝍵", f09d8db5),
_c(U+1D376, "𝍶", f09d8db6),
_c(U+1D377, "𝍷", f09d8db7),
_c(U+1D378, "𝍸", f09d8db8),
_c(U+1D379, "𝍹", f09d8db9),
_c(U+1D37A, "𝍺", f09d8dba),
_c(U+1D37B, "𝍻", f09d8dbb),
_c(U+1D37C, "𝍼", f09d8dbc),
_c(U+1D37D, "𝍽", f09d8dbd),
_c(U+1D37E, "𝍾", f09d8dbe),
_c(U+1D37F, "𝍿", f09d8dbf),
_c(U+1D380, "𝎀", f09d8e80),
_c(U+1D381, "𝎁", f09d8e81),
_c(U+1D382, "𝎂", f09d8e82),
_c(U+1D383, "𝎃", f09d8e83),
_c(U+1D384, "𝎄", f09d8e84),
_c(U+1D385, "𝎅", f09d8e85),
_c(U+1D386, "𝎆", f09d8e86),
_c(U+1D387, "𝎇", f09d8e87),
_c(U+1D388, "𝎈", f09d8e88),
_c(U+1D389, "𝎉", f09d8e89),
_c(U+1D38A, "𝎊", f09d8e8a),
_c(U+1D38B, "𝎋", f09d8e8b),
_c(U+1D38C, "𝎌", f09d8e8c),
_c(U+1D38D, "𝎍", f09d8e8d),
_c(U+1D38E, "𝎎", f09d8e8e),
_c(U+1D38F, "𝎏", f09d8e8f),
_c(U+1D390, "𝎐", f09d8e90),
_c(U+1D391, "𝎑", f09d8e91),
_c(U+1D392, "𝎒", f09d8e92),
_c(U+1D393, "𝎓", f09d8e93),
_c(U+1D394, "𝎔", f09d8e94),
_c(U+1D395, "𝎕", f09d8e95),
_c(U+1D396, "𝎖", f09d8e96),
_c(U+1D397, "𝎗", f09d8e97),
_c(U+1D398, "𝎘", f09d8e98),
_c(U+1D399, "𝎙", f09d8e99),
_c(U+1D39A, "𝎚", f09d8e9a),
_c(U+1D39B, "𝎛", f09d8e9b),
_c(U+1D39C, "𝎜", f09d8e9c),
_c(U+1D39D, "𝎝", f09d8e9d),
_c(U+1D39E, "𝎞", f09d8e9e),
_c(U+1D39F, "𝎟", f09d8e9f),
_c(U+1D3A0, "𝎠", f09d8ea0),
_c(U+1D3A1, "𝎡", f09d8ea1),
_c(U+1D3A2, "𝎢", f09d8ea2),
_c(U+1D3A3, "𝎣", f09d8ea3),
_c(U+1D3A4, "𝎤", f09d8ea4),
_c(U+1D3A5, "𝎥", f09d8ea5),
_c(U+1D3A6, "𝎦", f09d8ea6),
_c(U+1D3A7, "𝎧", f09d8ea7),
_c(U+1D3A8, "𝎨", f09d8ea8),
_c(U+1D3A9, "𝎩", f09d8ea9),
_c(U+1D3AA, "𝎪", f09d8eaa),
_c(U+1D3AB, "𝎫", f09d8eab),
_c(U+1D3AC, "𝎬", f09d8eac),
_c(U+1D3AD, "𝎭", f09d8ead),
_c(U+1D3AE, "𝎮", f09d8eae),
_c(U+1D3AF, "𝎯", f09d8eaf),
_c(U+1D3B0, "𝎰", f09d8eb0),
_c(U+1D3B1, "𝎱", f09d8eb1),
_c(U+1D3B2, "𝎲", f09d8eb2),
_c(U+1D3B3, "𝎳", f09d8eb3),
_c(U+1D3B4, "𝎴", f09d8eb4),
_c(U+1D3B5, "𝎵", f09d8eb5),
_c(U+1D3B6, "𝎶", f09d8eb6),
_c(U+1D3B7, "𝎷", f09d8eb7),
_c(U+1D3B8, "𝎸", f09d8eb8),
_c(U+1D3B9, "𝎹", f09d8eb9),
_c(U+1D3BA, "𝎺", f09d8eba),
_c(U+1D3BB, "𝎻", f09d8ebb),
_c(U+1D3BC, "𝎼", f09d8ebc),
_c(U+1D3BD, "𝎽", f09d8ebd),
_c(U+1D3BE, "𝎾", f09d8ebe),
_c(U+1D3BF, "𝎿", f09d8ebf),
_c(U+1D3C0, "𝏀", f09d8f80),
_c(U+1D3C1, "𝏁", f09d8f81),
_c(U+1D3C2, "𝏂", f09d8f82),
_c(U+1D3C3, "𝏃", f09d8f83),
_c(U+1D3C4, "𝏄", f09d8f84),
_c(U+1D3C5, "𝏅", f09d8f85),
_c(U+1D3C6, "𝏆", f09d8f86),
_c(U+1D3C7, "𝏇", f09d8f87),
_c(U+1D3C8, "𝏈", f09d8f88),
_c(U+1D3C9, "𝏉", f09d8f89),
_c(U+1D3CA, "𝏊", f09d8f8a),
_c(U+1D3CB, "𝏋", f09d8f8b),
_c(U+1D3CC, "𝏌", f09d8f8c),
_c(U+1D3CD, "𝏍", f09d8f8d),
_c(U+1D3CE, "𝏎", f09d8f8e),
_c(U+1D3CF, "𝏏", f09d8f8f),
_c(U+1D3D0, "𝏐", f09d8f90),
_c(U+1D3D1, "𝏑", f09d8f91),
_c(U+1D3D2, "𝏒", f09d8f92),
_c(U+1D3D3, "𝏓", f09d8f93),
_c(U+1D3D4, "𝏔", f09d8f94),
_c(U+1D3D5, "𝏕", f09d8f95),
_c(U+1D3D6, "𝏖", f09d8f96),
_c(U+1D3D7, "𝏗", f09d8f97),
_c(U+1D3D8, "𝏘", f09d8f98),
_c(U+1D3D9, "𝏙", f09d8f99),
_c(U+1D3DA, "𝏚", f09d8f9a),
_c(U+1D3DB, "𝏛", f09d8f9b),
_c(U+1D3DC, "𝏜", f09d8f9c),
_c(U+1D3DD, "𝏝", f09d8f9d),
_c(U+1D3DE, "𝏞", f09d8f9e),
_c(U+1D3DF, "𝏟", f09d8f9f),
_c(U+1D3E0, "𝏠", f09d8fa0),
_c(U+1D3E1, "𝏡", f09d8fa1),
_c(U+1D3E2, "𝏢", f09d8fa2),
_c(U+1D3E3, "𝏣", f09d8fa3),
_c(U+1D3E4, "𝏤", f09d8fa4),
_c(U+1D3E5, "𝏥", f09d8fa5),
_c(U+1D3E6, "𝏦", f09d8fa6),
_c(U+1D3E7, "𝏧", f09d8fa7),
_c(U+1D3E8, "𝏨", f09d8fa8),
_c(U+1D3E9, "𝏩", f09d8fa9),
_c(U+1D3EA, "𝏪", f09d8faa),
_c(U+1D3EB, "𝏫", f09d8fab),
_c(U+1D3EC, "𝏬", f09d8fac),
_c(U+1D3ED, "𝏭", f09d8fad),
_c(U+1D3EE, "𝏮", f09d8fae),
_c(U+1D3EF, "𝏯", f09d8faf),
_c(U+1D3F0, "𝏰", f09d8fb0),
_c(U+1D3F1, "𝏱", f09d8fb1),
_c(U+1D3F2, "𝏲", f09d8fb2),
_c(U+1D3F3, "𝏳", f09d8fb3),
_c(U+1D3F4, "𝏴", f09d8fb4),
_c(U+1D3F5, "𝏵", f09d8fb5),
_c(U+1D3F6, "𝏶", f09d8fb6),
_c(U+1D3F7, "𝏷", f09d8fb7),
_c(U+1D3F8, "𝏸", f09d8fb8),
_c(U+1D3F9, "𝏹", f09d8fb9),
_c(U+1D3FA, "𝏺", f09d8fba),
_c(U+1D3FB, "𝏻", f09d8fbb),
_c(U+1D3FC, "𝏼", f09d8fbc),
_c(U+1D3FD, "𝏽", f09d8fbd),
_c(U+1D3FE, "𝏾", f09d8fbe),
_c(U+1D3FF, "𝏿", f09d8fbf),
_c(U+1D400, "𝐀", f09d9080),
_c(U+1D401, "𝐁", f09d9081),
_c(U+1D402, "𝐂", f09d9082),
_c(U+1D403, "𝐃", f09d9083),
_c(U+1D404, "𝐄", f09d9084),
_c(U+1D405, "𝐅", f09d9085),
_c(U+1D406, "𝐆", f09d9086),
_c(U+1D407, "𝐇", f09d9087),
_c(U+1D408, "𝐈", f09d9088),
_c(U+1D409, "𝐉", f09d9089),
_c(U+1D40A, "𝐊", f09d908a),
_c(U+1D40B, "𝐋", f09d908b),
_c(U+1D40C, "𝐌", f09d908c),
_c(U+1D40D, "𝐍", f09d908d),
_c(U+1D40E, "𝐎", f09d908e),
_c(U+1D40F, "𝐏", f09d908f),
_c(U+1D410, "𝐐", f09d9090),
_c(U+1D411, "𝐑", f09d9091),
_c(U+1D412, "𝐒", f09d9092),
_c(U+1D413, "𝐓", f09d9093),
_c(U+1D414, "𝐔", f09d9094),
_c(U+1D415, "𝐕", f09d9095),
_c(U+1D416, "𝐖", f09d9096),
_c(U+1D417, "𝐗", f09d9097),
_c(U+1D418, "𝐘", f09d9098),
_c(U+1D419, "𝐙", f09d9099),
_c(U+1D41A, "𝐚", f09d909a),
_c(U+1D41B, "𝐛", f09d909b),
_c(U+1D41C, "𝐜", f09d909c),
_c(U+1D41D, "𝐝", f09d909d),
_c(U+1D41E, "𝐞", f09d909e),
_c(U+1D41F, "𝐟", f09d909f),
_c(U+1D420, "𝐠", f09d90a0),
_c(U+1D421, "𝐡", f09d90a1),
_c(U+1D422, "𝐢", f09d90a2),
_c(U+1D423, "𝐣", f09d90a3),
_c(U+1D424, "𝐤", f09d90a4),
_c(U+1D425, "𝐥", f09d90a5),
_c(U+1D426, "𝐦", f09d90a6),
_c(U+1D427, "𝐧", f09d90a7),
_c(U+1D428, "𝐨", f09d90a8),
_c(U+1D429, "𝐩", f09d90a9),
_c(U+1D42A, "𝐪", f09d90aa),
_c(U+1D42B, "𝐫", f09d90ab),
_c(U+1D42C, "𝐬", f09d90ac),
_c(U+1D42D, "𝐭", f09d90ad),
_c(U+1D42E, "𝐮", f09d90ae),
_c(U+1D42F, "𝐯", f09d90af),
_c(U+1D430, "𝐰", f09d90b0),
_c(U+1D431, "𝐱", f09d90b1),
_c(U+1D432, "𝐲", f09d90b2),
_c(U+1D433, "𝐳", f09d90b3),
_c(U+1D434, "𝐴", f09d90b4),
_c(U+1D435, "𝐵", f09d90b5),
_c(U+1D436, "𝐶", f09d90b6),
_c(U+1D437, "𝐷", f09d90b7),
_c(U+1D438, "𝐸", f09d90b8),
_c(U+1D439, "𝐹", f09d90b9),
_c(U+1D43A, "𝐺", f09d90ba),
_c(U+1D43B, "𝐻", f09d90bb),
_c(U+1D43C, "𝐼", f09d90bc),
_c(U+1D43D, "𝐽", f09d90bd),
_c(U+1D43E, "𝐾", f09d90be),
_c(U+1D43F, "𝐿", f09d90bf),
_c(U+1D440, "𝑀", f09d9180),
_c(U+1D441, "𝑁", f09d9181),
_c(U+1D442, "𝑂", f09d9182),
_c(U+1D443, "𝑃", f09d9183),
_c(U+1D444, "𝑄", f09d9184),
_c(U+1D445, "𝑅", f09d9185),
_c(U+1D446, "𝑆", f09d9186),
_c(U+1D447, "𝑇", f09d9187),
_c(U+1D448, "𝑈", f09d9188),
_c(U+1D449, "𝑉", f09d9189),
_c(U+1D44A, "𝑊", f09d918a),
_c(U+1D44B, "𝑋", f09d918b),
_c(U+1D44C, "𝑌", f09d918c),
_c(U+1D44D, "𝑍", f09d918d),
_c(U+1D44E, "𝑎", f09d918e),
_c(U+1D44F, "𝑏", f09d918f),
_c(U+1D450, "𝑐", f09d9190),
_c(U+1D451, "𝑑", f09d9191),
_c(U+1D452, "𝑒", f09d9192),
_c(U+1D453, "𝑓", f09d9193),
_c(U+1D454, "𝑔", f09d9194),
_c(U+1D455, "𝑕", f09d9195),
_c(U+1D456, "𝑖", f09d9196),
_c(U+1D457, "𝑗", f09d9197),
_c(U+1D458, "𝑘", f09d9198),
_c(U+1D459, "𝑙", f09d9199),
_c(U+1D45A, "𝑚", f09d919a),
_c(U+1D45B, "𝑛", f09d919b),
_c(U+1D45C, "𝑜", f09d919c),
_c(U+1D45D, "𝑝", f09d919d),
_c(U+1D45E, "𝑞", f09d919e),
_c(U+1D45F, "𝑟", f09d919f),
_c(U+1D460, "𝑠", f09d91a0),
_c(U+1D461, "𝑡", f09d91a1),
_c(U+1D462, "𝑢", f09d91a2),
_c(U+1D463, "𝑣", f09d91a3),
_c(U+1D464, "𝑤", f09d91a4),
_c(U+1D465, "𝑥", f09d91a5),
_c(U+1D466, "𝑦", f09d91a6),
_c(U+1D467, "𝑧", f09d91a7),
_c(U+1D468, "𝑨", f09d91a8),
_c(U+1D469, "𝑩", f09d91a9),
_c(U+1D46A, "𝑪", f09d91aa),
_c(U+1D46B, "𝑫", f09d91ab),
_c(U+1D46C, "𝑬", f09d91ac),
_c(U+1D46D, "𝑭", f09d91ad),
_c(U+1D46E, "𝑮", f09d91ae),
_c(U+1D46F, "𝑯", f09d91af),
_c(U+1D470, "𝑰", f09d91b0),
_c(U+1D471, "𝑱", f09d91b1),
_c(U+1D472, "𝑲", f09d91b2),
_c(U+1D473, "𝑳", f09d91b3),
_c(U+1D474, "𝑴", f09d91b4),
_c(U+1D475, "𝑵", f09d91b5),
_c(U+1D476, "𝑶", f09d91b6),
_c(U+1D477, "𝑷", f09d91b7),
_c(U+1D478, "𝑸", f09d91b8),
_c(U+1D479, "𝑹", f09d91b9),
_c(U+1D47A, "𝑺", f09d91ba),
_c(U+1D47B, "𝑻", f09d91bb),
_c(U+1D47C, "𝑼", f09d91bc),
_c(U+1D47D, "𝑽", f09d91bd),
_c(U+1D47E, "𝑾", f09d91be),
_c(U+1D47F, "𝑿", f09d91bf),
_c(U+1D480, "𝒀", f09d9280),
_c(U+1D481, "𝒁", f09d9281),
_c(U+1D482, "𝒂", f09d9282),
_c(U+1D483, "𝒃", f09d9283),
_c(U+1D484, "𝒄", f09d9284),
_c(U+1D485, "𝒅", f09d9285),
_c(U+1D486, "𝒆", f09d9286),
_c(U+1D487, "𝒇", f09d9287),
_c(U+1D488, "𝒈", f09d9288),
_c(U+1D489, "𝒉", f09d9289),
_c(U+1D48A, "𝒊", f09d928a),
_c(U+1D48B, "𝒋", f09d928b),
_c(U+1D48C, "𝒌", f09d928c),
_c(U+1D48D, "𝒍", f09d928d),
_c(U+1D48E, "𝒎", f09d928e),
_c(U+1D48F, "𝒏", f09d928f),
_c(U+1D490, "𝒐", f09d9290),
_c(U+1D491, "𝒑", f09d9291),
_c(U+1D492, "𝒒", f09d9292),
_c(U+1D493, "𝒓", f09d9293),
_c(U+1D494, "𝒔", f09d9294),
_c(U+1D495, "𝒕", f09d9295),
_c(U+1D496, "𝒖", f09d9296),
_c(U+1D497, "𝒗", f09d9297),
_c(U+1D498, "𝒘", f09d9298),
_c(U+1D499, "𝒙", f09d9299),
_c(U+1D49A, "𝒚", f09d929a),
_c(U+1D49B, "𝒛", f09d929b),
_c(U+1D49C, "𝒜", f09d929c),
_c(U+1D49D, "𝒝", f09d929d),
_c(U+1D49E, "𝒞", f09d929e),
_c(U+1D49F, "𝒟", f09d929f),
_c(U+1D4A0, "𝒠", f09d92a0),
_c(U+1D4A1, "𝒡", f09d92a1),
_c(U+1D4A2, "𝒢", f09d92a2),
_c(U+1D4A3, "𝒣", f09d92a3),
_c(U+1D4A4, "𝒤", f09d92a4),
_c(U+1D4A5, "𝒥", f09d92a5),
_c(U+1D4A6, "𝒦", f09d92a6),
_c(U+1D4A7, "𝒧", f09d92a7),
_c(U+1D4A8, "𝒨", f09d92a8),
_c(U+1D4A9, "𝒩", f09d92a9),
_c(U+1D4AA, "𝒪", f09d92aa),
_c(U+1D4AB, "𝒫", f09d92ab),
_c(U+1D4AC, "𝒬", f09d92ac),
_c(U+1D4AD, "𝒭", f09d92ad),
_c(U+1D4AE, "𝒮", f09d92ae),
_c(U+1D4AF, "𝒯", f09d92af),
_c(U+1D4B0, "𝒰", f09d92b0),
_c(U+1D4B1, "𝒱", f09d92b1),
_c(U+1D4B2, "𝒲", f09d92b2),
_c(U+1D4B3, "𝒳", f09d92b3),
_c(U+1D4B4, "𝒴", f09d92b4),
_c(U+1D4B5, "𝒵", f09d92b5),
_c(U+1D4B6, "𝒶", f09d92b6),
_c(U+1D4B7, "𝒷", f09d92b7),
_c(U+1D4B8, "𝒸", f09d92b8),
_c(U+1D4B9, "𝒹", f09d92b9),
_c(U+1D4BA, "𝒺", f09d92ba),
_c(U+1D4BB, "𝒻", f09d92bb),
_c(U+1D4BC, "𝒼", f09d92bc),
_c(U+1D4BD, "𝒽", f09d92bd),
_c(U+1D4BE, "𝒾", f09d92be),
_c(U+1D4BF, "𝒿", f09d92bf),
_c(U+1D4C0, "𝓀", f09d9380),
_c(U+1D4C1, "𝓁", f09d9381),
_c(U+1D4C2, "𝓂", f09d9382),
_c(U+1D4C3, "𝓃", f09d9383),
_c(U+1D4C4, "𝓄", f09d9384),
_c(U+1D4C5, "𝓅", f09d9385),
_c(U+1D4C6, "𝓆", f09d9386),
_c(U+1D4C7, "𝓇", f09d9387),
_c(U+1D4C8, "𝓈", f09d9388),
_c(U+1D4C9, "𝓉", f09d9389),
_c(U+1D4CA, "𝓊", f09d938a),
_c(U+1D4CB, "𝓋", f09d938b),
_c(U+1D4CC, "𝓌", f09d938c),
_c(U+1D4CD, "𝓍", f09d938d),
_c(U+1D4CE, "𝓎", f09d938e),
_c(U+1D4CF, "𝓏", f09d938f),
_c(U+1D4D0, "𝓐", f09d9390),
_c(U+1D4D1, "𝓑", f09d9391),
_c(U+1D4D2, "𝓒", f09d9392),
_c(U+1D4D3, "𝓓", f09d9393),
_c(U+1D4D4, "𝓔", f09d9394),
_c(U+1D4D5, "𝓕", f09d9395),
_c(U+1D4D6, "𝓖", f09d9396),
_c(U+1D4D7, "𝓗", f09d9397),
_c(U+1D4D8, "𝓘", f09d9398),
_c(U+1D4D9, "𝓙", f09d9399),
_c(U+1D4DA, "𝓚", f09d939a),
_c(U+1D4DB, "𝓛", f09d939b),
_c(U+1D4DC, "𝓜", f09d939c),
_c(U+1D4DD, "𝓝", f09d939d),
_c(U+1D4DE, "𝓞", f09d939e),
_c(U+1D4DF, "𝓟", f09d939f),
_c(U+1D4E0, "𝓠", f09d93a0),
_c(U+1D4E1, "𝓡", f09d93a1),
_c(U+1D4E2, "𝓢", f09d93a2),
_c(U+1D4E3, "𝓣", f09d93a3),
_c(U+1D4E4, "𝓤", f09d93a4),
_c(U+1D4E5, "𝓥", f09d93a5),
_c(U+1D4E6, "𝓦", f09d93a6),
_c(U+1D4E7, "𝓧", f09d93a7),
_c(U+1D4E8, "𝓨", f09d93a8),
_c(U+1D4E9, "𝓩", f09d93a9),
_c(U+1D4EA, "𝓪", f09d93aa),
_c(U+1D4EB, "𝓫", f09d93ab),
_c(U+1D4EC, "𝓬", f09d93ac),
_c(U+1D4ED, "𝓭", f09d93ad),
_c(U+1D4EE, "𝓮", f09d93ae),
_c(U+1D4EF, "𝓯", f09d93af),
_c(U+1D4F0, "𝓰", f09d93b0),
_c(U+1D4F1, "𝓱", f09d93b1),
_c(U+1D4F2, "𝓲", f09d93b2),
_c(U+1D4F3, "𝓳", f09d93b3),
_c(U+1D4F4, "𝓴", f09d93b4),
_c(U+1D4F5, "𝓵", f09d93b5),
_c(U+1D4F6, "𝓶", f09d93b6),
_c(U+1D4F7, "𝓷", f09d93b7),
_c(U+1D4F8, "𝓸", f09d93b8),
_c(U+1D4F9, "𝓹", f09d93b9),
_c(U+1D4FA, "𝓺", f09d93ba),
_c(U+1D4FB, "𝓻", f09d93bb),
_c(U+1D4FC, "𝓼", f09d93bc),
_c(U+1D4FD, "𝓽", f09d93bd),
_c(U+1D4FE, "𝓾", f09d93be),
_c(U+1D4FF, "𝓿", f09d93bf),
_c(U+1F600, "😀", f09f9880),
_c(U+1F601, "😁", f09f9881),
_c(U+1F602, "😂", f09f9882),
_c(U+1F603, "😃", f09f9883),
_c(U+1F604, "😄", f09f9884),
_c(U+1F605, "😅", f09f9885),
_c(U+1F606, "😆", f09f9886),
_c(U+1F607, "😇", f09f9887),
_c(U+1F608, "😈", f09f9888),
_c(U+1F609, "😉", f09f9889),
_c(U+1F60A, "😊", f09f988a),
_c(U+1F60B, "😋", f09f988b),
_c(U+1F60C, "😌", f09f988c),
_c(U+1F60D, "😍", f09f988d),
_c(U+1F60E, "😎", f09f988e),
_c(U+1F60F, "😏", f09f988f),
_c(U+1F610, "😐", f09f9890),
_c(U+1F611, "😑", f09f9891),
_c(U+1F612, "😒", f09f9892),
_c(U+1F613, "😓", f09f9893),
_c(U+1F614, "😔", f09f9894),
_c(U+1F615, "😕", f09f9895),
_c(U+1F616, "😖", f09f9896),
_c(U+1F617, "😗", f09f9897),
_c(U+1F618, "😘", f09f9898),
_c(U+1F619, "😙", f09f9899),
_c(U+1F61A, "😚", f09f989a),
_c(U+1F61B, "😛", f09f989b),
_c(U+1F61C, "😜", f09f989c),
_c(U+1F61D, "😝", f09f989d),
_c(U+1F61E, "😞", f09f989e),
_c(U+1F61F, "😟", f09f989f),
_c(U+1F620, "😠", f09f98a0),
_c(U+1F621, "😡", f09f98a1),
_c(U+1F622, "😢", f09f98a2),
_c(U+1F623, "😣", f09f98a3),
_c(U+1F624, "😤", f09f98a4),
_c(U+1F625, "😥", f09f98a5),
_c(U+1F626, "😦", f09f98a6),
_c(U+1F627, "😧", f09f98a7),
_c(U+1F628, "😨", f09f98a8),
_c(U+1F629, "😩", f09f98a9),
_c(U+1F62A, "😪", f09f98aa),
_c(U+1F62B, "😫", f09f98ab),
_c(U+1F62C, "😬", f09f98ac),
_c(U+1F62D, "😭", f09f98ad),
_c(U+1F62E, "😮", f09f98ae),
_c(U+1F62F, "😯", f09f98af),
_c(U+1F630, "😰", f09f98b0),
_c(U+1F631, "😱", f09f98b1),
_c(U+1F632, "😲", f09f98b2),
_c(U+1F633, "😳", f09f98b3),
_c(U+1F634, "😴", f09f98b4),
_c(U+1F635, "😵", f09f98b5),
_c(U+1F636, "😶", f09f98b6),
_c(U+1F637, "😷", f09f98b7),
_c(U+1F638, "😸", f09f98b8),
_c(U+1F639, "😹", f09f98b9),
_c(U+1F63A, "😺", f09f98ba),
_c(U+1F63B, "😻", f09f98bb),
_c(U+1F63C, "😼", f09f98bc),
_c(U+1F63D, "😽", f09f98bd),
_c(U+1F63E, "😾", f09f98be),
_c(U+1F63F, "😿", f09f98bf),
_c(U+1F640, "🙀", f09f9980),
_c(U+1F641, "🙁", f09f9981),
_c(U+1F642, "🙂", f09f9982),
_c(U+1F643, "🙃", f09f9983),
_c(U+1F644, "🙄", f09f9984),
_c(U+1F645, "🙅", f09f9985),
_c(U+1F646, "🙆", f09f9986),
_c(U+1F647, "🙇", f09f9987),
_c(U+1F648, "🙈", f09f9988),
_c(U+1F649, "🙉", f09f9989),
_c(U+1F64A, "🙊", f09f998a),
_c(U+1F64B, "🙋", f09f998b),
_c(U+1F64C, "🙌", f09f998c),
_c(U+1F64D, "🙍", f09f998d),
_c(U+1F64E, "🙎", f09f998e),
_c(U+1F64F, "🙏", f09f998f),
_c(U+1F650, "🙐", f09f9990),
_c(U+1F651, "🙑", f09f9991),
_c(U+1F652, "🙒", f09f9992),
_c(U+1F653, "🙓", f09f9993),
_c(U+1F654, "🙔", f09f9994),
_c(U+1F655, "🙕", f09f9995),
_c(U+1F656, "🙖", f09f9996),
_c(U+1F657, "🙗", f09f9997),
_c(U+1F658, "🙘", f09f9998),
_c(U+1F659, "🙙", f09f9999),
_c(U+1F65A, "🙚", f09f999a),
_c(U+1F65B, "🙛", f09f999b),
_c(U+1F65C, "🙜", f09f999c),
_c(U+1F65D, "🙝", f09f999d),
_c(U+1F65E, "🙞", f09f999e),
_c(U+1F65F, "🙟", f09f999f),
_c(U+1F660, "🙠", f09f99a0),
_c(U+1F661, "🙡", f09f99a1),
_c(U+1F662, "🙢", f09f99a2),
_c(U+1F663, "🙣", f09f99a3),
_c(U+1F664, "🙤", f09f99a4),
_c(U+1F665, "🙥", f09f99a5),
_c(U+1F666, "🙦", f09f99a6),
_c(U+1F667, "🙧", f09f99a7),
_c(U+1F668, "🙨", f09f99a8),
_c(U+1F669, "🙩", f09f99a9),
_c(U+1F66A, "🙪", f09f99aa),
_c(U+1F66B, "🙫", f09f99ab),
_c(U+1F66C, "🙬", f09f99ac),
_c(U+1F66D, "🙭", f09f99ad),
_c(U+1F66E, "🙮", f09f99ae),
_c(U+1F66F, "🙯", f09f99af),
_c(U+1F670, "🙰", f09f99b0),
_c(U+1F671, "🙱", f09f99b1),
_c(U+1F672, "🙲", f09f99b2),
_c(U+1F673, "🙳", f09f99b3),
_c(U+1F674, "🙴", f09f99b4),
_c(U+1F675, "🙵", f09f99b5),
_c(U+1F676, "🙶", f09f99b6),
_c(U+1F677, "🙷", f09f99b7),
_c(U+1F678, "🙸", f09f99b8),
_c(U+1F679, "🙹", f09f99b9),
_c(U+1F67A, "🙺", f09f99ba),
_c(U+1F67B, "🙻", f09f99bb),
_c(U+1F67C, "🙼", f09f99bc),
_c(U+1F67D, "🙽", f09f99bd),
_c(U+1F67E, "🙾", f09f99be),
_c(U+1F67F, "🙿", f09f99bf),
_c(U+1F680, "🚀", f09f9a80),
_c(U+1F681, "🚁", f09f9a81),
_c(U+1F682, "🚂", f09f9a82),
_c(U+1F683, "🚃", f09f9a83),
_c(U+1F684, "🚄", f09f9a84),
_c(U+1F685, "🚅", f09f9a85),
_c(U+1F686, "🚆", f09f9a86),
_c(U+1F687, "🚇", f09f9a87),
_c(U+1F688, "🚈", f09f9a88),
_c(U+1F689, "🚉", f09f9a89),
_c(U+1F68A, "🚊", f09f9a8a),
_c(U+1F68B, "🚋", f09f9a8b),
_c(U+1F68C, "🚌", f09f9a8c),
_c(U+1F68D, "🚍", f09f9a8d),
_c(U+1F68E, "🚎", f09f9a8e),
_c(U+1F68F, "🚏", f09f9a8f),
_c(U+1F690, "🚐", f09f9a90),
_c(U+1F691, "🚑", f09f9a91),
_c(U+1F692, "🚒", f09f9a92),
_c(U+1F693, "🚓", f09f9a93),
_c(U+1F694, "🚔", f09f9a94),
_c(U+1F695, "🚕", f09f9a95),
_c(U+1F696, "🚖", f09f9a96),
_c(U+1F697, "🚗", f09f9a97),
_c(U+1F698, "🚘", f09f9a98),
_c(U+1F699, "🚙", f09f9a99),
_c(U+1F69A, "🚚", f09f9a9a),
_c(U+1F69B, "🚛", f09f9a9b),
_c(U+1F69C, "🚜", f09f9a9c),
_c(U+1F69D, "🚝", f09f9a9d),
_c(U+1F69E, "🚞", f09f9a9e),
_c(U+1F69F, "🚟", f09f9a9f),
_c(U+1F6A0, "🚠", f09f9aa0),
_c(U+1F6A1, "🚡", f09f9aa1),
_c(U+1F6A2, "🚢", f09f9aa2),
_c(U+1F6A3, "🚣", f09f9aa3),
_c(U+1F6A4, "🚤", f09f9aa4),
_c(U+1F6A5, "🚥", f09f9aa5),
_c(U+1F6A6, "🚦", f09f9aa6),
_c(U+1F6A7, "🚧", f09f9aa7),
_c(U+1F6A8, "🚨", f09f9aa8),
_c(U+1F6A9, "🚩", f09f9aa9),
_c(U+1F6AA, "🚪", f09f9aaa),
_c(U+1F6AB, "🚫", f09f9aab),
_c(U+1F6AC, "🚬", f09f9aac),
_c(U+1F6AD, "🚭", f09f9aad),
_c(U+1F6AE, "🚮", f09f9aae),
_c(U+1F6AF, "🚯", f09f9aaf),
_c(U+1F6B0, "🚰", f09f9ab0),
_c(U+1F6B1, "🚱", f09f9ab1),
_c(U+1F6B2, "🚲", f09f9ab2),
_c(U+1F6B3, "🚳", f09f9ab3),
_c(U+1F6B4, "🚴", f09f9ab4),
_c(U+1F6B5, "🚵", f09f9ab5),
_c(U+1F6B6, "🚶", f09f9ab6),
_c(U+1F6B7, "🚷", f09f9ab7),
_c(U+1F6B8, "🚸", f09f9ab8),
_c(U+1F6B9, "🚹", f09f9ab9),
_c(U+1F6BA, "🚺", f09f9aba),
_c(U+1F6BB, "🚻", f09f9abb),
_c(U+1F6BC, "🚼", f09f9abc),
_c(U+1F6BD, "🚽", f09f9abd),
_c(U+1F6BE, "🚾", f09f9abe),
_c(U+1F6BF, "🚿", f09f9abf),
_c(U+1F6C0, "🛀", f09f9b80),
_c(U+1F6C1, "🛁", f09f9b81),
_c(U+1F6C2, "🛂", f09f9b82),
_c(U+1F6C3, "🛃", f09f9b83),
_c(U+1F6C4, "🛄", f09f9b84),
_c(U+1F6C5, "🛅", f09f9b85),
_c(U+1F6C6, "🛆", f09f9b86),
_c(U+1F6C7, "🛇", f09f9b87),
_c(U+1F6C8, "🛈", f09f9b88),
_c(U+1F6C9, "🛉", f09f9b89),
_c(U+1F6CA, "🛊", f09f9b8a),
_c(U+1F6CB, "🛋", f09f9b8b),
_c(U+1F6CC, "🛌", f09f9b8c),
_c(U+1F6CD, "🛍", f09f9b8d),
_c(U+1F6CE, "🛎", f09f9b8e),
_c(U+1F6CF, "🛏", f09f9b8f),
_c(U+1F6D0, "🛐", f09f9b90),
_c(U+1F6D1, "🛑", f09f9b91),
_c(U+1F6D2, "🛒", f09f9b92),
_c(U+1F6D3, "🛓", f09f9b93),
_c(U+1F6D4, "🛔", f09f9b94),
_c(U+1F6D5, "🛕", f09f9b95),
_c(U+1F6D6, "🛖", f09f9b96),
_c(U+1F6D7, "🛗", f09f9b97),
_c(U+1F6D8, "🛘", f09f9b98),
_c(U+1F6D9, "🛙", f09f9b99),
_c(U+1F6DA, "🛚", f09f9b9a),
_c(U+1F6DB, "🛛", f09f9b9b),
_c(U+1F6DC, "🛜", f09f9b9c),
_c(U+1F6DD, "🛝", f09f9b9d),
_c(U+1F6DE, "🛞", f09f9b9e),
_c(U+1F6DF, "🛟", f09f9b9f),
_c(U+1F6E0, "🛠", f09f9ba0),
_c(U+1F6E1, "🛡", f09f9ba1),
_c(U+1F6E2, "🛢", f09f9ba2),
_c(U+1F6E3, "🛣", f09f9ba3),
_c(U+1F6E4, "🛤", f09f9ba4),
_c(U+1F6E5, "🛥", f09f9ba5),
_c(U+1F6E6, "🛦", f09f9ba6),
_c(U+1F6E7, "🛧", f09f9ba7),
_c(U+1F6E8, "🛨", f09f9ba8),
_c(U+1F6E9, "🛩", f09f9ba9),
_c(U+1F6EA, "🛪", f09f9baa),
_c(U+1F6EB, "🛫", f09f9bab),
_c(U+1F6EC, "🛬", f09f9bac),
_c(U+1F6ED, "🛭", f09f9bad),
_c(U+1F6EE, "🛮", f09f9bae),
_c(U+1F6EF, "🛯", f09f9baf),
_c(U+1F6F0, "🛰", f09f9bb0),
_c(U+1F6F1, "🛱", f09f9bb1),
_c(U+1F6F2, "🛲", f09f9bb2),
_c(U+1F6F3, "🛳", f09f9bb3),
_c(U+1F6F4, "🛴", f09f9bb4),
_c(U+1F6F5, "🛵", f09f9bb5),
_c(U+1F6F6, "🛶", f09f9bb6),
_c(U+1F6F7, "🛷", f09f9bb7),
_c(U+1F6F8, "🛸", f09f9bb8),
_c(U+1F6F9, "🛹", f09f9bb9),
_c(U+1F6FA, "🛺", f09f9bba),
_c(U+1F6FB, "🛻", f09f9bbb),
_c(U+1F6FC, "🛼", f09f9bbc),
_c(U+1F6FD, "🛽", f09f9bbd),
_c(U+1F6FE, "🛾", f09f9bbe),
_c(U+1F6FF, "🛿", f09f9bbf),
_c(U+1F700, "🜀", f09f9c80),
_c(U+1F701, "🜁", f09f9c81),
_c(U+1F702, "🜂", f09f9c82),
_c(U+1F703, "🜃", f09f9c83),
_c(U+1F704, "🜄", f09f9c84),
_c(U+1F705, "🜅", f09f9c85),
_c(U+1F706, "🜆", f09f9c86),
_c(U+1F707, "🜇", f09f9c87),
_c(U+1F708, "🜈", f09f9c88),
_c(U+1F709, "🜉", f09f9c89),
_c(U+1F70A, "🜊", f09f9c8a),
_c(U+1F70B, "🜋", f09f9c8b),
_c(U+1F70C, "🜌", f09f9c8c),
_c(U+1F70D, "🜍", f09f9c8d),
_c(U+1F70E, "🜎", f09f9c8e),
_c(U+1F70F, "🜏", f09f9c8f),
_c(U+1F710, "🜐", f09f9c90),
_c(U+1F711, "🜑", f09f9c91),
_c(U+1F712, "🜒", f09f9c92),
_c(U+1F713, "🜓", f09f9c93),
_c(U+1F714, "🜔", f09f9c94),
_c(U+1F715, "🜕", f09f9c95),
_c(U+1F716, "🜖", f09f9c96),
_c(U+1F717, "🜗", f09f9c97),
_c(U+1F718, "🜘", f09f9c98),
_c(U+1F719, "🜙", f09f9c99),
_c(U+1F71A, "🜚", f09f9c9a),
_c(U+1F71B, "🜛", f09f9c9b),
_c(U+1F71C, "🜜", f09f9c9c),
_c(U+1F71D, "🜝", f09f9c9d),
_c(U+1F71E, "🜞", f09f9c9e),
_c(U+1F71F, "🜟", f09f9c9f),
_c(U+1F720, "🜠", f09f9ca0),
_c(U+1F721, "🜡", f09f9ca1),
_c(U+1F722, "🜢", f09f9ca2),
_c(U+1F723, "🜣", f09f9ca3),
_c(U+1F724, "🜤", f09f9ca4),
_c(U+1F725, "🜥", f09f9ca5),
_c(U+1F726, "🜦", f09f9ca6),
_c(U+1F727, "🜧", f09f9ca7),
_c(U+1F728, "🜨", f09f9ca8),
_c(U+1F729, "🜩", f09f9ca9),
_c(U+1F72A, "🜪", f09f9caa),
_c(U+1F72B, "🜫", f09f9cab),
_c(U+1F72C, "🜬", f09f9cac),
_c(U+1F72D, "🜭", f09f9cad),
_c(U+1F72E, "🜮", f09f9cae),
_c(U+1F72F, "🜯", f09f9caf),
_c(U+1F730, "🜰", f09f9cb0),
_c(U+1F731, "🜱", f09f9cb1),
_c(U+1F732, "🜲", f09f9cb2),
_c(U+1F733, "🜳", f09f9cb3),
_c(U+1F734, "🜴", f09f9cb4),
_c(U+1F735, "🜵", f09f9cb5),
_c(U+1F736, "🜶", f09f9cb6),
_c(U+1F737, "🜷", f09f9cb7),
_c(U+1F738, "🜸", f09f9cb8),
_c(U+1F739, "🜹", f09f9cb9),
_c(U+1F73A, "🜺", f09f9cba),
_c(U+1F73B, "🜻", f09f9cbb),
_c(U+1F73C, "🜼", f09f9cbc),
_c(U+1F73D, "🜽", f09f9cbd),
_c(U+1F73E, "🜾", f09f9cbe),
_c(U+1F73F, "🜿", f09f9cbf),
_c(U+1F740, "🝀", f09f9d80),
_c(U+1F741, "🝁", f09f9d81),
_c(U+1F742, "🝂", f09f9d82),
_c(U+1F743, "🝃", f09f9d83),
_c(U+1F744, "🝄", f09f9d84),
_c(U+1F745, "🝅", f09f9d85),
_c(U+1F746, "🝆", f09f9d86),
_c(U+1F747, "🝇", f09f9d87),
_c(U+1F748, "🝈", f09f9d88),
_c(U+1F749, "🝉", f09f9d89),
_c(U+1F74A, "🝊", f09f9d8a),
_c(U+1F74B, "🝋", f09f9d8b),
_c(U+1F74C, "🝌", f09f9d8c),
_c(U+1F74D, "🝍", f09f9d8d),
_c(U+1F74E, "🝎", f09f9d8e),
_c(U+1F74F, "🝏", f09f9d8f),
_c(U+1F750, "🝐", f09f9d90),
_c(U+1F751, "🝑", f09f9d91),
_c(U+1F752, "🝒", f09f9d92),
_c(U+1F753, "🝓", f09f9d93),
_c(U+1F754, "🝔", f09f9d94),
_c(U+1F755, "🝕", f09f9d95),
_c(U+1F756, "🝖", f09f9d96),
_c(U+1F757, "🝗", f09f9d97),
_c(U+1F758, "🝘", f09f9d98),
_c(U+1F759, "🝙", f09f9d99),
_c(U+1F75A, "🝚", f09f9d9a),
_c(U+1F75B, "🝛", f09f9d9b),
_c(U+1F75C, "🝜", f09f9d9c),
_c(U+1F75D, "🝝", f09f9d9d),
_c(U+1F75E, "🝞", f09f9d9e),
_c(U+1F75F, "🝟", f09f9d9f),
_c(U+1F760, "🝠", f09f9da0),
_c(U+1F761, "🝡", f09f9da1),
_c(U+1F762, "🝢", f09f9da2),
_c(U+1F763, "🝣", f09f9da3),
_c(U+1F764, "🝤", f09f9da4),
_c(U+1F765, "🝥", f09f9da5),
_c(U+1F766, "🝦", f09f9da6),
_c(U+1F767, "🝧", f09f9da7),
_c(U+1F768, "🝨", f09f9da8),
_c(U+1F769, "🝩", f09f9da9),
_c(U+1F76A, "🝪", f09f9daa),
_c(U+1F76B, "🝫", f09f9dab),
_c(U+1F76C, "🝬", f09f9dac),
_c(U+1F76D, "🝭", f09f9dad),
_c(U+1F76E, "🝮", f09f9dae),
_c(U+1F76F, "🝯", f09f9daf),
_c(U+1F770, "🝰", f09f9db0),
_c(U+1F771, "🝱", f09f9db1),
_c(U+1F772, "🝲", f09f9db2),
_c(U+1F773, "🝳", f09f9db3),
_c(U+1F774, "🝴", f09f9db4),
_c(U+1F775, "🝵", f09f9db5),
_c(U+1F776, "🝶", f09f9db6),
_c(U+1F777, "🝷", f09f9db7),
_c(U+1F778, "🝸", f09f9db8),
_c(U+1F779, "🝹", f09f9db9),
_c(U+1F77A, "🝺", f09f9dba),
_c(U+1F77B, "🝻", f09f9dbb),
_c(U+1F77C, "🝼", f09f9dbc),
_c(U+1F77D, "🝽", f09f9dbd),
_c(U+1F77E, "🝾", f09f9dbe),
_c(U+1F77F, "🝿", f09f9dbf),
_c(U+1F780, "🞀", f09f9e80),
_c(U+1F781, "🞁", f09f9e81),
_c(U+1F782, "🞂", f09f9e82),
_c(U+1F783, "🞃", f09f9e83),
_c(U+1F784, "🞄", f09f9e84),
_c(U+1F785, "🞅", f09f9e85),
_c(U+1F786, "🞆", f09f9e86),
_c(U+1F787, "🞇", f09f9e87),
_c(U+1F788, "🞈", f09f9e88),
_c(U+1F789, "🞉", f09f9e89),
_c(U+1F78A, "🞊", f09f9e8a),
_c(U+1F78B, "🞋", f09f9e8b),
_c(U+1F78C, "🞌", f09f9e8c),
_c(U+1F78D, "🞍", f09f9e8d),
_c(U+1F78E, "🞎", f09f9e8e),
_c(U+1F78F, "🞏", f09f9e8f),
_c(U+1F790, "🞐", f09f9e90),
_c(U+1F791, "🞑", f09f9e91),
_c(U+1F792, "🞒", f09f9e92),
_c(U+1F793, "🞓", f09f9e93),
_c(U+1F794, "🞔", f09f9e94),
_c(U+1F795, "🞕", f09f9e95),
_c(U+1F796, "🞖", f09f9e96),
_c(U+1F797, "🞗", f09f9e97),
_c(U+1F798, "🞘", f09f9e98),
_c(U+1F799, "🞙", f09f9e99),
_c(U+1F79A, "🞚", f09f9e9a),
_c(U+1F79B, "🞛", f09f9e9b),
_c(U+1F79C, "🞜", f09f9e9c),
_c(U+1F79D, "🞝", f09f9e9d),
_c(U+1F79E, "🞞", f09f9e9e),
_c(U+1F79F, "🞟", f09f9e9f),
_c(U+1F7A0, "🞠", f09f9ea0),
_c(U+1F7A1, "🞡", f09f9ea1),
_c(U+1F7A2, "🞢", f09f9ea2),
_c(U+1F7A3, "🞣", f09f9ea3),
_c(U+1F7A4, "🞤", f09f9ea4),
_c(U+1F7A5, "🞥", f09f9ea5),
_c(U+1F7A6, "🞦", f09f9ea6),
_c(U+1F7A7, "🞧", f09f9ea7),
_c(U+1F7A8, "🞨", f09f9ea8),
_c(U+1F7A9, "🞩", f09f9ea9),
_c(U+1F7AA, "🞪", f09f9eaa),
_c(U+1F7AB, "🞫", f09f9eab),
_c(U+1F7AC, "🞬", f09f9eac),
_c(U+1F7AD, "🞭", f09f9ead),
_c(U+1F7AE, "🞮", f09f9eae),
_c(U+1F7AF, "🞯", f09f9eaf),
_c(U+1F7B0, "🞰", f09f9eb0),
_c(U+1F7B1, "🞱", f09f9eb1),
_c(U+1F7B2, "🞲", f09f9eb2),
_c(U+1F7B3, "🞳", f09f9eb3),
_c(U+1F7B4, "🞴", f09f9eb4),
_c(U+1F7B5, "🞵", f09f9eb5),
_c(U+1F7B6, "🞶", f09f9eb6),
_c(U+1F7B7, "🞷", f09f9eb7),
_c(U+1F7B8, "🞸", f09f9eb8),
_c(U+1F7B9, "🞹", f09f9eb9),
_c(U+1F7BA, "🞺", f09f9eba),
_c(U+1F7BB, "🞻", f09f9ebb),
_c(U+1F7BC, "🞼", f09f9ebc),
_c(U+1F7BD, "🞽", f09f9ebd),
_c(U+1F7BE, "🞾", f09f9ebe),
_c(U+1F7BF, "🞿", f09f9ebf),
_c(U+1F7C0, "🟀", f09f9f80),
_c(U+1F7C1, "🟁", f09f9f81),
_c(U+1F7C2, "🟂", f09f9f82),
_c(U+1F7C3, "🟃", f09f9f83),
_c(U+1F7C4, "🟄", f09f9f84),
_c(U+1F7C5, "🟅", f09f9f85),
_c(U+1F7C6, "🟆", f09f9f86),
_c(U+1F7C7, "🟇", f09f9f87),
_c(U+1F7C8, "🟈", f09f9f88),
_c(U+1F7C9, "🟉", f09f9f89),
_c(U+1F7CA, "🟊", f09f9f8a),
_c(U+1F7CB, "🟋", f09f9f8b),
_c(U+1F7CC, "🟌", f09f9f8c),
_c(U+1F7CD, "🟍", f09f9f8d),
_c(U+1F7CE, "🟎", f09f9f8e),
_c(U+1F7CF, "🟏", f09f9f8f),
_c(U+1F7D0, "🟐", f09f9f90),
_c(U+1F7D1, "🟑", f09f9f91),
_c(U+1F7D2, "🟒", f09f9f92),
_c(U+1F7D3, "🟓", f09f9f93),
_c(U+1F7D4, "🟔", f09f9f94),
_c(U+1F7D5, "🟕", f09f9f95),
_c(U+1F7D6, "🟖", f09f9f96),
_c(U+1F7D7, "🟗", f09f9f97),
_c(U+1F7D8, "🟘", f09f9f98),
_c(U+1F7D9, "🟙", f09f9f99),
_c(U+1F7DA, "🟚", f09f9f9a),
_c(U+1F7DB, "🟛", f09f9f9b),
_c(U+1F7DC, "🟜", f09f9f9c),
_c(U+1F7DD, "🟝", f09f9f9d),
_c(U+1F7DE, "🟞", f09f9f9e),
_c(U+1F7DF, "🟟", f09f9f9f),
_c(U+1F7E0, "🟠", f09f9fa0),
_c(U+1F7E1, "🟡", f09f9fa1),
_c(U+1F7E2, "🟢", f09f9fa2),
_c(U+1F7E3, "🟣", f09f9fa3),
_c(U+1F7E4, "🟤", f09f9fa4),
_c(U+1F7E5, "🟥", f09f9fa5),
_c(U+1F7E6, "🟦", f09f9fa6),
_c(U+1F7E7, "🟧", f09f9fa7),
_c(U+1F7E8, "🟨", f09f9fa8),
_c(U+1F7E9, "🟩", f09f9fa9),
_c(U+1F7EA, "🟪", f09f9faa),
_c(U+1F7EB, "🟫", f09f9fab),
_c(U+1F7EC, "🟬", f09f9fac),
_c(U+1F7ED, "🟭", f09f9fad),
_c(U+1F7EE, "🟮", f09f9fae),
_c(U+1F7EF, "🟯", f09f9faf),
_c(U+1F7F0, "🟰", f09f9fb0),
_c(U+1F7F1, "🟱", f09f9fb1),
_c(U+1F7F2, "🟲", f09f9fb2),
_c(U+1F7F3, "🟳", f09f9fb3),
_c(U+1F7F4, "🟴", f09f9fb4),
_c(U+1F7F5, "🟵", f09f9fb5),
_c(U+1F7F6, "🟶", f09f9fb6),
_c(U+1F7F7, "🟷", f09f9fb7),
_c(U+1F7F8, "🟸", f09f9fb8),
_c(U+1F7F9, "🟹", f09f9fb9),
_c(U+1F7FA, "🟺", f09f9fba),
_c(U+1F7FB, "🟻", f09f9fbb),
_c(U+1F7FC, "🟼", f09f9fbc),
_c(U+1F7FD, "🟽", f09f9fbd),
_c(U+1F7FE, "🟾", f09f9fbe),
_c(U+1F7FF, "🟿", f09f9fbf),
_c(U+1F800, "🠀", f09fa080),
_c(U+1F801, "🠁", f09fa081),
_c(U+1F802, "🠂", f09fa082),
_c(U+1F803, "🠃", f09fa083),
_c(U+1F804, "🠄", f09fa084),
_c(U+1F805, "🠅", f09fa085),
_c(U+1F806, "🠆", f09fa086),
_c(U+1F807, "🠇", f09fa087),
_c(U+1F808, "🠈", f09fa088),
_c(U+1F809, "🠉", f09fa089),
_c(U+1F80A, "🠊", f09fa08a),
_c(U+1F80B, "🠋", f09fa08b),
_c(U+1F80C, "🠌", f09fa08c),
_c(U+1F80D, "🠍", f09fa08d),
_c(U+1F80E, "🠎", f09fa08e),
_c(U+1F80F, "🠏", f09fa08f),
_c(U+1F810, "🠐", f09fa090),
_c(U+1F811, "🠑", f09fa091),
_c(U+1F812, "🠒", f09fa092),
_c(U+1F813, "🠓", f09fa093),
_c(U+1F814, "🠔", f09fa094),
_c(U+1F815, "🠕", f09fa095),
_c(U+1F816, "🠖", f09fa096),
_c(U+1F817, "🠗", f09fa097),
_c(U+1F818, "🠘", f09fa098),
_c(U+1F819, "🠙", f09fa099),
_c(U+1F81A, "🠚", f09fa09a),
_c(U+1F81B, "🠛", f09fa09b),
_c(U+1F81C, "🠜", f09fa09c),
_c(U+1F81D, "🠝", f09fa09d),
_c(U+1F81E, "🠞", f09fa09e),
_c(U+1F81F, "🠟", f09fa09f),
_c(U+1F820, "🠠", f09fa0a0),
_c(U+1F821, "🠡", f09fa0a1),
_c(U+1F822, "🠢", f09fa0a2),
_c(U+1F823, "🠣", f09fa0a3),
_c(U+1F824, "🠤", f09fa0a4),
_c(U+1F825, "🠥", f09fa0a5),
_c(U+1F826, "🠦", f09fa0a6),
_c(U+1F827, "🠧", f09fa0a7),
_c(U+1F828, "🠨", f09fa0a8),
_c(U+1F829, "🠩", f09fa0a9),
_c(U+1F82A, "🠪", f09fa0aa),
_c(U+1F82B, "🠫", f09fa0ab),
_c(U+1F82C, "🠬", f09fa0ac),
_c(U+1F82D, "🠭", f09fa0ad),
_c(U+1F82E, "🠮", f09fa0ae),
_c(U+1F82F, "🠯", f09fa0af),
_c(U+1F830, "🠰", f09fa0b0),
_c(U+1F831, "🠱", f09fa0b1),
_c(U+1F832, "🠲", f09fa0b2),
_c(U+1F833, "🠳", f09fa0b3),
_c(U+1F834, "🠴", f09fa0b4),
_c(U+1F835, "🠵", f09fa0b5),
_c(U+1F836, "🠶", f09fa0b6),
_c(U+1F837, "🠷", f09fa0b7),
_c(U+1F838, "🠸", f09fa0b8),
_c(U+1F839, "🠹", f09fa0b9),
_c(U+1F83A, "🠺", f09fa0ba),
_c(U+1F83B, "🠻", f09fa0bb),
_c(U+1F83C, "🠼", f09fa0bc),
_c(U+1F83D, "🠽", f09fa0bd),
_c(U+1F83E, "🠾", f09fa0be),
_c(U+1F83F, "🠿", f09fa0bf),
_c(U+1F840, "🡀", f09fa180),
_c(U+1F841, "🡁", f09fa181),
_c(U+1F842, "🡂", f09fa182),
_c(U+1F843, "🡃", f09fa183),
_c(U+1F844, "🡄", f09fa184),
_c(U+1F845, "🡅", f09fa185),
_c(U+1F846, "🡆", f09fa186),
_c(U+1F847, "🡇", f09fa187),
_c(U+1F848, "🡈", f09fa188),
_c(U+1F849, "🡉", f09fa189),
_c(U+1F84A, "🡊", f09fa18a),
_c(U+1F84B, "🡋", f09fa18b),
_c(U+1F84C, "🡌", f09fa18c),
_c(U+1F84D, "🡍", f09fa18d),
_c(U+1F84E, "🡎", f09fa18e),
_c(U+1F84F, "🡏", f09fa18f),
_c(U+1F850, "🡐", f09fa190),
_c(U+1F851, "🡑", f09fa191),
_c(U+1F852, "🡒", f09fa192),
_c(U+1F853, "🡓", f09fa193),
_c(U+1F854, "🡔", f09fa194),
_c(U+1F855, "🡕", f09fa195),
_c(U+1F856, "🡖", f09fa196),
_c(U+1F857, "🡗", f09fa197),
_c(U+1F858, "🡘", f09fa198),
_c(U+1F859, "🡙", f09fa199),
_c(U+1F85A, "🡚", f09fa19a),
_c(U+1F85B, "🡛", f09fa19b),
_c(U+1F85C, "🡜", f09fa19c),
_c(U+1F85D, "🡝", f09fa19d),
_c(U+1F85E, "🡞", f09fa19e),
_c(U+1F85F, "🡟", f09fa19f),
_c(U+1F860, "🡠", f09fa1a0),
_c(U+1F861, "🡡", f09fa1a1),
_c(U+1F862, "🡢", f09fa1a2),
_c(U+1F863, "🡣", f09fa1a3),
_c(U+1F864, "🡤", f09fa1a4),
_c(U+1F865, "🡥", f09fa1a5),
_c(U+1F866, "🡦", f09fa1a6),
_c(U+1F867, "🡧", f09fa1a7),
_c(U+1F868, "🡨", f09fa1a8),
_c(U+1F869, "🡩", f09fa1a9),
_c(U+1F86A, "🡪", f09fa1aa),
_c(U+1F86B, "🡫", f09fa1ab),
_c(U+1F86C, "🡬", f09fa1ac),
_c(U+1F86D, "🡭", f09fa1ad),
_c(U+1F86E, "🡮", f09fa1ae),
_c(U+1F86F, "🡯", f09fa1af),
_c(U+1F870, "🡰", f09fa1b0),
_c(U+1F871, "🡱", f09fa1b1),
_c(U+1F872, "🡲", f09fa1b2),
_c(U+1F873, "🡳", f09fa1b3),
_c(U+1F874, "🡴", f09fa1b4),
_c(U+1F875, "🡵", f09fa1b5),
_c(U+1F876, "🡶", f09fa1b6),
_c(U+1F877, "🡷", f09fa1b7),
_c(U+1F878, "🡸", f09fa1b8),
_c(U+1F879, "🡹", f09fa1b9),
_c(U+1F87A, "🡺", f09fa1ba),
_c(U+1F87B, "🡻", f09fa1bb),
_c(U+1F87C, "🡼", f09fa1bc),
_c(U+1F87D, "🡽", f09fa1bd),
_c(U+1F87E, "🡾", f09fa1be),
_c(U+1F87F, "🡿", f09fa1bf),
_c(U+1F880, "🢀", f09fa280),
_c(U+1F881, "🢁", f09fa281),
_c(U+1F882, "🢂", f09fa282),
_c(U+1F883, "🢃", f09fa283),
_c(U+1F884, "🢄", f09fa284),
_c(U+1F885, "🢅", f09fa285),
_c(U+1F886, "🢆", f09fa286),
_c(U+1F887, "🢇", f09fa287),
_c(U+1F888, "🢈", f09fa288),
_c(U+1F889, "🢉", f09fa289),
_c(U+1F88A, "🢊", f09fa28a),
_c(U+1F88B, "🢋", f09fa28b),
_c(U+1F88C, "🢌", f09fa28c),
_c(U+1F88D, "🢍", f09fa28d),
_c(U+1F88E, "🢎", f09fa28e),
_c(U+1F88F, "🢏", f09fa28f),
_c(U+1F890, "🢐", f09fa290),
_c(U+1F891, "🢑", f09fa291),
_c(U+1F892, "🢒", f09fa292),
_c(U+1F893, "🢓", f09fa293),
_c(U+1F894, "🢔", f09fa294),
_c(U+1F895, "🢕", f09fa295),
_c(U+1F896, "🢖", f09fa296),
_c(U+1F897, "🢗", f09fa297),
_c(U+1F898, "🢘", f09fa298),
_c(U+1F899, "🢙", f09fa299),
_c(U+1F89A, "🢚", f09fa29a),
_c(U+1F89B, "🢛", f09fa29b),
_c(U+1F89C, "🢜", f09fa29c),
_c(U+1F89D, "🢝", f09fa29d),
_c(U+1F89E, "🢞", f09fa29e),
_c(U+1F89F, "🢟", f09fa29f),
_c(U+1F8A0, "🢠", f09fa2a0),
_c(U+1F8A1, "🢡", f09fa2a1),
_c(U+1F8A2, "🢢", f09fa2a2),
_c(U+1F8A3, "🢣", f09fa2a3),
_c(U+1F8A4, "🢤", f09fa2a4),
_c(U+1F8A5, "🢥", f09fa2a5),
_c(U+1F8A6, "🢦", f09fa2a6),
_c(U+1F8A7, "🢧", f09fa2a7),
_c(U+1F8A8, "🢨", f09fa2a8),
_c(U+1F8A9, "🢩", f09fa2a9),
_c(U+1F8AA, "🢪", f09fa2aa),
_c(U+1F8AB, "🢫", f09fa2ab),
_c(U+1F8AC, "🢬", f09fa2ac),
_c(U+1F8AD, "🢭", f09fa2ad),
_c(U+1F8AE, "🢮", f09fa2ae),
_c(U+1F8AF, "🢯", f09fa2af),
_c(U+1F8B0, "🢰", f09fa2b0),
_c(U+1F8B1, "🢱", f09fa2b1),
_c(U+1F8B2, "🢲", f09fa2b2),
_c(U+1F8B3, "🢳", f09fa2b3),
_c(U+1F8B4, "🢴", f09fa2b4),
_c(U+1F8B5, "🢵", f09fa2b5),
_c(U+1F8B6, "🢶", f09fa2b6),
_c(U+1F8B7, "🢷", f09fa2b7),
_c(U+1F8B8, "🢸", f09fa2b8),
_c(U+1F8B9, "🢹", f09fa2b9),
_c(U+1F8BA, "🢺", f09fa2ba),
_c(U+1F8BB, "🢻", f09fa2bb),
_c(U+1F8BC, "🢼", f09fa2bc),
_c(U+1F8BD, "🢽", f09fa2bd),
_c(U+1F8BE, "🢾", f09fa2be),
_c(U+1F8BF, "🢿", f09fa2bf),
_c(U+1F8C0, "🣀", f09fa380),
_c(U+1F8C1, "🣁", f09fa381),
_c(U+1F8C2, "🣂", f09fa382),
_c(U+1F8C3, "🣃", f09fa383),
_c(U+1F8C4, "🣄", f09fa384),
_c(U+1F8C5, "🣅", f09fa385),
_c(U+1F8C6, "🣆", f09fa386),
_c(U+1F8C7, "🣇", f09fa387),
_c(U+1F8C8, "🣈", f09fa388),
_c(U+1F8C9, "🣉", f09fa389),
_c(U+1F8CA, "🣊", f09fa38a),
_c(U+1F8CB, "🣋", f09fa38b),
_c(U+1F8CC, "🣌", f09fa38c),
_c(U+1F8CD, "🣍", f09fa38d),
_c(U+1F8CE, "🣎", f09fa38e),
_c(U+1F8CF, "🣏", f09fa38f),
_c(U+1F8D0, "🣐", f09fa390),
_c(U+1F8D1, "🣑", f09fa391),
_c(U+1F8D2, "🣒", f09fa392),
_c(U+1F8D3, "🣓", f09fa393),
_c(U+1F8D4, "🣔", f09fa394),
_c(U+1F8D5, "🣕", f09fa395),
_c(U+1F8D6, "🣖", f09fa396),
_c(U+1F8D7, "🣗", f09fa397),
_c(U+1F8D8, "🣘", f09fa398),
_c(U+1F8D9, "🣙", f09fa399),
_c(U+1F8DA, "🣚", f09fa39a),
_c(U+1F8DB, "🣛", f09fa39b),
_c(U+1F8DC, "🣜", f09fa39c),
_c(U+1F8DD, "🣝", f09fa39d),
_c(U+1F8DE, "🣞", f09fa39e),
_c(U+1F8DF, "🣟", f09fa39f),
_c(U+1F8E0, "🣠", f09fa3a0),
_c(U+1F8E1, "🣡", f09fa3a1),
_c(U+1F8E2, "🣢", f09fa3a2),
_c(U+1F8E3, "🣣", f09fa3a3),
_c(U+1F8E4, "🣤", f09fa3a4),
_c(U+1F8E5, "🣥", f09fa3a5),
_c(U+1F8E6, "🣦", f09fa3a6),
_c(U+1F8E7, "🣧", f09fa3a7),
_c(U+1F8E8, "🣨", f09fa3a8),
_c(U+1F8E9, "🣩", f09fa3a9),
_c(U+1F8EA, "🣪", f09fa3aa),
_c(U+1F8EB, "🣫", f09fa3ab),
_c(U+1F8EC, "🣬", f09fa3ac),
_c(U+1F8ED, "🣭", f09fa3ad),
_c(U+1F8EE, "🣮", f09fa3ae),
_c(U+1F8EF, "🣯", f09fa3af),
_c(U+1F8F0, "🣰", f09fa3b0),
_c(U+1F8F1, "🣱", f09fa3b1),
_c(U+1F8F2, "🣲", f09fa3b2),
_c(U+1F8F3, "🣳", f09fa3b3),
_c(U+1F8F4, "🣴", f09fa3b4),
_c(U+1F8F5, "🣵", f09fa3b5),
_c(U+1F8F6, "🣶", f09fa3b6),
_c(U+1F8F7, "🣷", f09fa3b7),
_c(U+1F8F8, "🣸", f09fa3b8),
_c(U+1F8F9, "🣹", f09fa3b9),
_c(U+1F8FA, "🣺", f09fa3ba),
_c(U+1F8FB, "🣻", f09fa3bb),
_c(U+1F8FC, "🣼", f09fa3bc),
_c(U+1F8FD, "🣽", f09fa3bd),
_c(U+1F8FE, "🣾", f09fa3be),
_c(U+1F8FF, "🣿", f09fa3bf),
_c(U+1F900, "🤀", f09fa480),
_c(U+1F901, "🤁", f09fa481),
_c(U+1F902, "🤂", f09fa482),
_c(U+1F903, "🤃", f09fa483),
_c(U+1F904, "🤄", f09fa484),
_c(U+1F905, "🤅", f09fa485),
_c(U+1F906, "🤆", f09fa486),
_c(U+1F907, "🤇", f09fa487),
_c(U+1F908, "🤈", f09fa488),
_c(U+1F909, "🤉", f09fa489),
_c(U+1F90A, "🤊", f09fa48a),
_c(U+1F90B, "🤋", f09fa48b),
_c(U+1F90C, "🤌", f09fa48c),
_c(U+1F90D, "🤍", f09fa48d),
_c(U+1F90E, "🤎", f09fa48e),
_c(U+1F90F, "🤏", f09fa48f),
_c(U+1F910, "🤐", f09fa490),
_c(U+1F911, "🤑", f09fa491),
_c(U+1F912, "🤒", f09fa492),
_c(U+1F913, "🤓", f09fa493),
_c(U+1F914, "🤔", f09fa494),
_c(U+1F915, "🤕", f09fa495),
_c(U+1F916, "🤖", f09fa496),
_c(U+1F917, "🤗", f09fa497),
_c(U+1F918, "🤘", f09fa498),
_c(U+1F919, "🤙", f09fa499),
_c(U+1F91A, "🤚", f09fa49a),
_c(U+1F91B, "🤛", f09fa49b),
_c(U+1F91C, "🤜", f09fa49c),
_c(U+1F91D, "🤝", f09fa49d),
_c(U+1F91E, "🤞", f09fa49e),
_c(U+1F91F, "🤟", f09fa49f),
_c(U+1F920, "🤠", f09fa4a0),
_c(U+1F921, "🤡", f09fa4a1),
_c(U+1F922, "🤢", f09fa4a2),
_c(U+1F923, "🤣", f09fa4a3),
_c(U+1F924, "🤤", f09fa4a4),
_c(U+1F925, "🤥", f09fa4a5),
_c(U+1F926, "🤦", f09fa4a6),
_c(U+1F927, "🤧", f09fa4a7),
_c(U+1F928, "🤨", f09fa4a8),
_c(U+1F929, "🤩", f09fa4a9),
_c(U+1F92A, "🤪", f09fa4aa),
_c(U+1F92B, "🤫", f09fa4ab),
_c(U+1F92C, "🤬", f09fa4ac),
_c(U+1F92D, "🤭", f09fa4ad),
_c(U+1F92E, "🤮", f09fa4ae),
_c(U+1F92F, "🤯", f09fa4af),
_c(U+1F930, "🤰", f09fa4b0),
_c(U+1F931, "🤱", f09fa4b1),
_c(U+1F932, "🤲", f09fa4b2),
_c(U+1F933, "🤳", f09fa4b3),
_c(U+1F934, "🤴", f09fa4b4),
_c(U+1F935, "🤵", f09fa4b5),
_c(U+1F936, "🤶", f09fa4b6),
_c(U+1F937, "🤷", f09fa4b7),
_c(U+1F938, "🤸", f09fa4b8),
_c(U+1F939, "🤹", f09fa4b9),
_c(U+1F93A, "🤺", f09fa4ba),
_c(U+1F93B, "🤻", f09fa4bb),
_c(U+1F93C, "🤼", f09fa4bc),
_c(U+1F93D, "🤽", f09fa4bd),
_c(U+1F93E, "🤾", f09fa4be),
_c(U+1F93F, "🤿", f09fa4bf),
_c(U+1F940, "🥀", f09fa580),
_c(U+1F941, "🥁", f09fa581),
_c(U+1F942, "🥂", f09fa582),
_c(U+1F943, "🥃", f09fa583),
_c(U+1F944, "🥄", f09fa584),
_c(U+1F945, "🥅", f09fa585),
_c(U+1F946, "🥆", f09fa586),
_c(U+1F947, "🥇", f09fa587),
_c(U+1F948, "🥈", f09fa588),
_c(U+1F949, "🥉", f09fa589),
_c(U+1F94A, "🥊", f09fa58a),
_c(U+1F94B, "🥋", f09fa58b),
_c(U+1F94C, "🥌", f09fa58c),
_c(U+1F94D, "🥍", f09fa58d),
_c(U+1F94E, "🥎", f09fa58e),
_c(U+1F94F, "🥏", f09fa58f),
_c(U+1F950, "🥐", f09fa590),
_c(U+1F951, "🥑", f09fa591),
_c(U+1F952, "🥒", f09fa592),
_c(U+1F953, "🥓", f09fa593),
_c(U+1F954, "🥔", f09fa594),
_c(U+1F955, "🥕", f09fa595),
_c(U+1F956, "🥖", f09fa596),
_c(U+1F957, "🥗", f09fa597),
_c(U+1F958, "🥘", f09fa598),
_c(U+1F959, "🥙", f09fa599),
_c(U+1F95A, "🥚", f09fa59a),
_c(U+1F95B, "🥛", f09fa59b),
_c(U+1F95C, "🥜", f09fa59c),
_c(U+1F95D, "🥝", f09fa59d),
_c(U+1F95E, "🥞", f09fa59e),
_c(U+1F95F, "🥟", f09fa59f),
_c(U+1F960, "🥠", f09fa5a0),
_c(U+1F961, "🥡", f09fa5a1),
_c(U+1F962, "🥢", f09fa5a2),
_c(U+1F963, "🥣", f09fa5a3),
_c(U+1F964, "🥤", f09fa5a4),
_c(U+1F965, "🥥", f09fa5a5),
_c(U+1F966, "🥦", f09fa5a6),
_c(U+1F967, "🥧", f09fa5a7),
_c(U+1F968, "🥨", f09fa5a8),
_c(U+1F969, "🥩", f09fa5a9),
_c(U+1F96A, "🥪", f09fa5aa),
_c(U+1F96B, "🥫", f09fa5ab),
_c(U+1F96C, "🥬", f09fa5ac),
_c(U+1F96D, "🥭", f09fa5ad),
_c(U+1F96E, "🥮", f09fa5ae),
_c(U+1F96F, "🥯", f09fa5af),
_c(U+1F970, "🥰", f09fa5b0),
_c(U+1F971, "🥱", f09fa5b1),
_c(U+1F972, "🥲", f09fa5b2),
_c(U+1F973, "🥳", f09fa5b3),
_c(U+1F974, "🥴", f09fa5b4),
_c(U+1F975, "🥵", f09fa5b5),
_c(U+1F976, "🥶", f09fa5b6),
_c(U+1F977, "🥷", f09fa5b7),
_c(U+1F978, "🥸", f09fa5b8),
_c(U+1F979, "🥹", f09fa5b9),
_c(U+1F97A, "🥺", f09fa5ba),
_c(U+1F97B, "🥻", f09fa5bb),
_c(U+1F97C, "🥼", f09fa5bc),
_c(U+1F97D, "🥽", f09fa5bd),
_c(U+1F97E, "🥾", f09fa5be),
_c(U+1F97F, "🥿", f09fa5bf),
_c(U+1F980, "🦀", f09fa680),
_c(U+1F981, "🦁", f09fa681),
_c(U+1F982, "🦂", f09fa682),
_c(U+1F983, "🦃", f09fa683),
_c(U+1F984, "🦄", f09fa684),
_c(U+1F985, "🦅", f09fa685),
_c(U+1F986, "🦆", f09fa686),
_c(U+1F987, "🦇", f09fa687),
_c(U+1F988, "🦈", f09fa688),
_c(U+1F989, "🦉", f09fa689),
_c(U+1F98A, "🦊", f09fa68a),
_c(U+1F98B, "🦋", f09fa68b),
_c(U+1F98C, "🦌", f09fa68c),
_c(U+1F98D, "🦍", f09fa68d),
_c(U+1F98E, "🦎", f09fa68e),
_c(U+1F98F, "🦏", f09fa68f),
_c(U+1F990, "🦐", f09fa690),
_c(U+1F991, "🦑", f09fa691),
_c(U+1F992, "🦒", f09fa692),
_c(U+1F993, "🦓", f09fa693),
_c(U+1F994, "🦔", f09fa694),
_c(U+1F995, "🦕", f09fa695),
_c(U+1F996, "🦖", f09fa696),
_c(U+1F997, "🦗", f09fa697),
_c(U+1F998, "🦘", f09fa698),
_c(U+1F999, "🦙", f09fa699),
_c(U+1F99A, "🦚", f09fa69a),
_c(U+1F99B, "🦛", f09fa69b),
_c(U+1F99C, "🦜", f09fa69c),
_c(U+1F99D, "🦝", f09fa69d),
_c(U+1F99E, "🦞", f09fa69e),
_c(U+1F99F, "🦟", f09fa69f),
_c(U+1F9A0, "🦠", f09fa6a0),
_c(U+1F9A1, "🦡", f09fa6a1),
_c(U+1F9A2, "🦢", f09fa6a2),
_c(U+1F9A3, "🦣", f09fa6a3),
_c(U+1F9A4, "🦤", f09fa6a4),
_c(U+1F9A5, "🦥", f09fa6a5),
_c(U+1F9A6, "🦦", f09fa6a6),
_c(U+1F9A7, "🦧", f09fa6a7),
_c(U+1F9A8, "🦨", f09fa6a8),
_c(U+1F9A9, "🦩", f09fa6a9),
_c(U+1F9AA, "🦪", f09fa6aa),
_c(U+1F9AB, "🦫", f09fa6ab),
_c(U+1F9AC, "🦬", f09fa6ac),
_c(U+1F9AD, "🦭", f09fa6ad),
_c(U+1F9AE, "🦮", f09fa6ae),
_c(U+1F9AF, "🦯", f09fa6af),
_c(U+1F9B0, "🦰", f09fa6b0),
_c(U+1F9B1, "🦱", f09fa6b1),
_c(U+1F9B2, "🦲", f09fa6b2),
_c(U+1F9B3, "🦳", f09fa6b3),
_c(U+1F9B4, "🦴", f09fa6b4),
_c(U+1F9B5, "🦵", f09fa6b5),
_c(U+1F9B6, "🦶", f09fa6b6),
_c(U+1F9B7, "🦷", f09fa6b7),
_c(U+1F9B8, "🦸", f09fa6b8),
_c(U+1F9B9, "🦹", f09fa6b9),
_c(U+1F9BA, "🦺", f09fa6ba),
_c(U+1F9BB, "🦻", f09fa6bb),
_c(U+1F9BC, "🦼", f09fa6bc),
_c(U+1F9BD, "🦽", f09fa6bd),
_c(U+1F9BE, "🦾", f09fa6be),
_c(U+1F9BF, "🦿", f09fa6bf),
_c(U+1F9C0, "🧀", f09fa780),
_c(U+1F9C1, "🧁", f09fa781),
_c(U+1F9C2, "🧂", f09fa782),
_c(U+1F9C3, "🧃", f09fa783),
_c(U+1F9C4, "🧄", f09fa784),
_c(U+1F9C5, "🧅", f09fa785),
_c(U+1F9C6, "🧆", f09fa786),
_c(U+1F9C7, "🧇", f09fa787),
_c(U+1F9C8, "🧈", f09fa788),
_c(U+1F9C9, "🧉", f09fa789),
_c(U+1F9CA, "🧊", f09fa78a),
_c(U+1F9CB, "🧋", f09fa78b),
_c(U+1F9CC, "🧌", f09fa78c),
_c(U+1F9CD, "🧍", f09fa78d),
_c(U+1F9CE, "🧎", f09fa78e),
_c(U+1F9CF, "🧏", f09fa78f),
_c(U+1F9D0, "🧐", f09fa790),
_c(U+1F9D1, "🧑", f09fa791),
_c(U+1F9D2, "🧒", f09fa792),
_c(U+1F9D3, "🧓", f09fa793),
_c(U+1F9D4, "🧔", f09fa794),
_c(U+1F9D5, "🧕", f09fa795),
_c(U+1F9D6, "🧖", f09fa796),
_c(U+1F9D7, "🧗", f09fa797),
_c(U+1F9D8, "🧘", f09fa798),
_c(U+1F9D9, "🧙", f09fa799),
_c(U+1F9DA, "🧚", f09fa79a),
_c(U+1F9DB, "🧛", f09fa79b),
_c(U+1F9DC, "🧜", f09fa79c),
_c(U+1F9DD, "🧝", f09fa79d),
_c(U+1F9DE, "🧞", f09fa79e),
_c(U+1F9DF, "🧟", f09fa79f),
_c(U+1F9E0, "🧠", f09fa7a0),
_c(U+1F9E1, "🧡", f09fa7a1),
_c(U+1F9E2, "🧢", f09fa7a2),
_c(U+1F9E3, "🧣", f09fa7a3),
_c(U+1F9E4, "🧤", f09fa7a4),
_c(U+1F9E5, "🧥", f09fa7a5),
_c(U+1F9E6, "🧦", f09fa7a6),
_c(U+1F9E7, "🧧", f09fa7a7),
_c(U+1F9E8, "🧨", f09fa7a8),
_c(U+1F9E9, "🧩", f09fa7a9),
_c(U+1F9EA, "🧪", f09fa7aa),
_c(U+1F9EB, "🧫", f09fa7ab),
_c(U+1F9EC, "🧬", f09fa7ac),
_c(U+1F9ED, "🧭", f09fa7ad),
_c(U+1F9EE, "🧮", f09fa7ae),
_c(U+1F9EF, "🧯", f09fa7af),
_c(U+1F9F0, "🧰", f09fa7b0),
_c(U+1F9F1, "🧱", f09fa7b1),
_c(U+1F9F2, "🧲", f09fa7b2),
_c(U+1F9F3, "🧳", f09fa7b3),
_c(U+1F9F4, "🧴", f09fa7b4),
_c(U+1F9F5, "🧵", f09fa7b5),
_c(U+1F9F6, "🧶", f09fa7b6),
_c(U+1F9F7, "🧷", f09fa7b7),
_c(U+1F9F8, "🧸", f09fa7b8),
_c(U+1F9F9, "🧹", f09fa7b9),
_c(U+1F9FA, "🧺", f09fa7ba),
_c(U+1F9FB, "🧻", f09fa7bb),
_c(U+1F9FC, "🧼", f09fa7bc),
_c(U+1F9FD, "🧽", f09fa7bd),
_c(U+1F9FE, "🧾", f09fa7be),
_c(U+1F9FF, "🧿", f09fa7bf),
_c(U+100000, "􀀀", f4808080),
_c(U+100001, "􀀁", f4808081),
_c(U+100002, "􀀂", f4808082),
_c(U+100003, "􀀃", f4808083),
_c(U+100004, "􀀄", f4808084),
_c(U+100005, "􀀅", f4808085),
_c(U+100006, "􀀆", f4808086),
_c(U+100007, "􀀇", f4808087),
_c(U+100008, "􀀈", f4808088),
_c(U+100009, "􀀉", f4808089),
_c(U+10000A, "􀀊", f480808a),
_c(U+10000B, "􀀋", f480808b),
_c(U+10000C, "􀀌", f480808c),
_c(U+10000D, "􀀍", f480808d),
_c(U+10000E, "􀀎", f480808e),
_c(U+10000F, "􀀏", f480808f),
_c(U+100010, "􀀐", f4808090),
_c(U+100011, "􀀑", f4808091),
_c(U+100012, "􀀒", f4808092),
_c(U+100013, "􀀓", f4808093),
_c(U+100014, "􀀔", f4808094),
_c(U+100015, "􀀕", f4808095),
_c(U+100016, "􀀖", f4808096),
_c(U+100017, "􀀗", f4808097),
_c(U+100018, "􀀘", f4808098),
_c(U+100019, "􀀙", f4808099),
_c(U+10001A, "􀀚", f480809a),
_c(U+10001B, "􀀛", f480809b),
_c(U+10001C, "􀀜", f480809c),
_c(U+10001D, "􀀝", f480809d),
_c(U+10001E, "􀀞", f480809e),
_c(U+10001F, "􀀟", f480809f),
_c(U+100020, "􀀠", f48080a0),
_c(U+100021, "􀀡", f48080a1),
_c(U+100022, "􀀢", f48080a2),
_c(U+100023, "􀀣", f48080a3),
_c(U+100024, "􀀤", f48080a4),
_c(U+100025, "􀀥", f48080a5),
_c(U+100026, "􀀦", f48080a6),
_c(U+100027, "􀀧", f48080a7),
_c(U+100028, "􀀨", f48080a8),
_c(U+100029, "􀀩", f48080a9),
_c(U+10002A, "􀀪", f48080aa),
_c(U+10002B, "􀀫", f48080ab),
_c(U+10002C, "􀀬", f48080ac),
_c(U+10002D, "􀀭", f48080ad),
_c(U+10002E, "􀀮", f48080ae),
_c(U+10002F, "􀀯", f48080af),
_c(U+100030, "􀀰", f48080b0),
_c(U+100031, "􀀱", f48080b1),
_c(U+100032, "􀀲", f48080b2),
_c(U+100033, "􀀳", f48080b3),
_c(U+100034, "􀀴", f48080b4),
_c(U+100035, "􀀵", f48080b5),
_c(U+100036, "􀀶", f48080b6),
_c(U+100037, "􀀷", f48080b7),
_c(U+100038, "􀀸", f48080b8),
_c(U+100039, "􀀹", f48080b9),
_c(U+10003A, "􀀺", f48080ba),
_c(U+10003B, "􀀻", f48080bb),
_c(U+10003C, "􀀼", f48080bc),
_c(U+10003D, "􀀽", f48080bd),
_c(U+10003E, "􀀾", f48080be),
_c(U+10003F, "􀀿", f48080bf),
_c(U+100040, "􀁀", f4808180),
_c(U+100041, "􀁁", f4808181),
_c(U+100042, "􀁂", f4808182),
_c(U+100043, "􀁃", f4808183),
_c(U+100044, "􀁄", f4808184),
_c(U+100045, "􀁅", f4808185),
_c(U+100046, "􀁆", f4808186),
_c(U+100047, "􀁇", f4808187),
_c(U+100048, "􀁈", f4808188),
_c(U+100049, "􀁉", f4808189),
_c(U+10004A, "􀁊", f480818a),
_c(U+10004B, "􀁋", f480818b),
_c(U+10004C, "􀁌", f480818c),
_c(U+10004D, "􀁍", f480818d),
_c(U+10004E, "􀁎", f480818e),
_c(U+10004F, "􀁏", f480818f),
_c(U+100050, "􀁐", f4808190),
_c(U+100051, "􀁑", f4808191),
_c(U+100052, "􀁒", f4808192),
_c(U+100053, "􀁓", f4808193),
_c(U+100054, "􀁔", f4808194),
_c(U+100055, "􀁕", f4808195),
_c(U+100056, "􀁖", f4808196),
_c(U+100057, "􀁗", f4808197),
_c(U+100058, "􀁘", f4808198),
_c(U+100059, "􀁙", f4808199),
_c(U+10005A, "􀁚", f480819a),
_c(U+10005B, "􀁛", f480819b),
_c(U+10005C, "􀁜", f480819c),
_c(U+10005D, "􀁝", f480819d),
_c(U+10005E, "􀁞", f480819e),
_c(U+10005F, "􀁟", f480819f),
_c(U+100060, "􀁠", f48081a0),
_c(U+100061, "􀁡", f48081a1),
_c(U+100062, "􀁢", f48081a2),
_c(U+100063, "􀁣", f48081a3),
_c(U+100064, "􀁤", f48081a4),
_c(U+100065, "􀁥", f48081a5),
_c(U+100066, "􀁦", f48081a6),
_c(U+100067, "􀁧", f48081a7),
_c(U+100068, "􀁨", f48081a8),
_c(U+100069, "􀁩", f48081a9),
_c(U+10006A, "􀁪", f48081aa),
_c(U+10006B, "􀁫", f48081ab),
_c(U+10006C, "􀁬", f48081ac),
_c(U+10006D, "􀁭", f48081ad),
_c(U+10006E, "􀁮", f48081ae),
_c(U+10006F, "􀁯", f48081af),
_c(U+100070, "􀁰", f48081b0),
_c(U+100071, "􀁱", f48081b1),
_c(U+100072, "􀁲", f48081b2),
_c(U+100073, "􀁳", f48081b3),
_c(U+100074, "􀁴", f48081b4),
_c(U+100075, "􀁵", f48081b5),
_c(U+100076, "􀁶", f48081b6),
_c(U+100077, "􀁷", f48081b7),
_c(U+100078, "􀁸", f48081b8),
_c(U+100079, "􀁹", f48081b9),
_c(U+10007A, "􀁺", f48081ba),
_c(U+10007B, "􀁻", f48081bb),
_c(U+10007C, "􀁼", f48081bc),
_c(U+10007D, "􀁽", f48081bd),
_c(U+10007E, "􀁾", f48081be),
_c(U+10007F, "􀁿", f48081bf),
_c(U+100080, "􀂀", f4808280),
_c(U+100081, "􀂁", f4808281),
_c(U+100082, "􀂂", f4808282),
_c(U+100083, "􀂃", f4808283),
_c(U+100084, "􀂄", f4808284),
_c(U+100085, "􀂅", f4808285),
_c(U+100086, "􀂆", f4808286),
_c(U+100087, "􀂇", f4808287),
_c(U+100088, "􀂈", f4808288),
_c(U+100089, "􀂉", f4808289),
_c(U+10008A, "􀂊", f480828a),
_c(U+10008B, "􀂋", f480828b),
_c(U+10008C, "􀂌", f480828c),
_c(U+10008D, "􀂍", f480828d),
_c(U+10008E, "􀂎", f480828e),
_c(U+10008F, "􀂏", f480828f),
_c(U+100090, "􀂐", f4808290),
_c(U+100091, "􀂑", f4808291),
_c(U+100092, "􀂒", f4808292),
_c(U+100093, "􀂓", f4808293),
_c(U+100094, "􀂔", f4808294),
_c(U+100095, "􀂕", f4808295),
_c(U+100096, "􀂖", f4808296),
_c(U+100097, "􀂗", f4808297),
_c(U+100098, "􀂘", f4808298),
_c(U+100099, "􀂙", f4808299),
_c(U+10009A, "􀂚", f480829a),
_c(U+10009B, "􀂛", f480829b),
_c(U+10009C, "􀂜", f480829c),
_c(U+10009D, "􀂝", f480829d),
_c(U+10009E, "􀂞", f480829e),
_c(U+10009F, "􀂟", f480829f),
_c(U+1000A0, "􀂠", f48082a0),
_c(U+1000A1, "􀂡", f48082a1),
_c(U+1000A2, "􀂢", f48082a2),
_c(U+1000A3, "􀂣", f48082a3),
_c(U+1000A4, "􀂤", f48082a4),
_c(U+1000A5, "􀂥", f48082a5),
_c(U+1000A6, "􀂦", f48082a6),
_c(U+1000A7, "􀂧", f48082a7),
_c(U+1000A8, "􀂨", f48082a8),
_c(U+1000A9, "􀂩", f48082a9),
_c(U+1000AA, "􀂪", f48082aa),
_c(U+1000AB, "􀂫", f48082ab),
_c(U+1000AC, "􀂬", f48082ac),
_c(U+1000AD, "􀂭", f48082ad),
_c(U+1000AE, "􀂮", f48082ae),
_c(U+1000AF, "􀂯", f48082af),
_c(U+1000B0, "􀂰", f48082b0),
_c(U+1000B1, "􀂱", f48082b1),
_c(U+1000B2, "􀂲", f48082b2),
_c(U+1000B3, "􀂳", f48082b3),
_c(U+1000B4, "􀂴", f48082b4),
_c(U+1000B5, "􀂵", f48082b5),
_c(U+1000B6, "􀂶", f48082b6),
_c(U+1000B7, "􀂷", f48082b7),
_c(U+1000B8, "􀂸", f48082b8),
_c(U+1000B9, "􀂹", f48082b9),
_c(U+1000BA, "􀂺", f48082ba),
_c(U+1000BB, "􀂻", f48082bb),
_c(U+1000BC, "􀂼", f48082bc),
_c(U+1000BD, "􀂽", f48082bd),
_c(U+1000BE, "􀂾", f48082be),
_c(U+1000BF, "􀂿", f48082bf),
_c(U+1000C0, "􀃀", f4808380),
_c(U+1000C1, "􀃁", f4808381),
_c(U+1000C2, "􀃂", f4808382),
_c(U+1000C3, "􀃃", f4808383),
_c(U+1000C4, "􀃄", f4808384),
_c(U+1000C5, "􀃅", f4808385),
_c(U+1000C6, "􀃆", f4808386),
_c(U+1000C7, "􀃇", f4808387),
_c(U+1000C8, "􀃈", f4808388),
_c(U+1000C9, "􀃉", f4808389),
_c(U+1000CA, "􀃊", f480838a),
_c(U+1000CB, "􀃋", f480838b),
_c(U+1000CC, "􀃌", f480838c),
_c(U+1000CD, "􀃍", f480838d),
_c(U+1000CE, "􀃎", f480838e),
_c(U+1000CF, "􀃏", f480838f),
_c(U+1000D0, "􀃐", f4808390),
_c(U+1000D1, "􀃑", f4808391),
_c(U+1000D2, "􀃒", f4808392),
_c(U+1000D3, "􀃓", f4808393),
_c(U+1000D4, "􀃔", f4808394),
_c(U+1000D5, "􀃕", f4808395),
_c(U+1000D6, "􀃖", f4808396),
_c(U+1000D7, "􀃗", f4808397),
_c(U+1000D8, "􀃘", f4808398),
_c(U+1000D9, "􀃙", f4808399),
_c(U+1000DA, "􀃚", f480839a),
_c(U+1000DB, "􀃛", f480839b),
_c(U+1000DC, "􀃜", f480839c),
_c(U+1000DD, "􀃝", f480839d),
_c(U+1000DE, "􀃞", f480839e),
_c(U+1000DF, "􀃟", f480839f),
_c(U+1000E0, "􀃠", f48083a0),
_c(U+1000E1, "􀃡", f48083a1),
_c(U+1000E2, "􀃢", f48083a2),
_c(U+1000E3, "􀃣", f48083a3),
_c(U+1000E4, "􀃤", f48083a4),
_c(U+1000E5, "􀃥", f48083a5),
_c(U+1000E6, "􀃦", f48083a6),
_c(U+1000E7, "􀃧", f48083a7),
_c(U+1000E8, "􀃨", f48083a8),
_c(U+1000E9, "􀃩", f48083a9),
_c(U+1000EA, "􀃪", f48083aa),
_c(U+1000EB, "􀃫", f48083ab),
_c(U+1000EC, "􀃬", f48083ac),
_c(U+1000ED, "􀃭", f48083ad),
_c(U+1000EE, "􀃮", f48083ae),
_c(U+1000EF, "􀃯", f48083af),
_c(U+1000F0, "􀃰", f48083b0),
_c(U+1000F1, "􀃱", f48083b1),
_c(U+1000F2, "􀃲", f48083b2),
_c(U+1000F3, "􀃳", f48083b3),
_c(U+1000F4, "􀃴", f48083b4),
_c(U+1000F5, "􀃵", f48083b5),
_c(U+1000F6, "􀃶", f48083b6),
_c(U+1000F7, "􀃷", f48083b7),
_c(U+1000F8, "􀃸", f48083b8),
_c(U+1000F9, "􀃹", f48083b9),
_c(U+1000FA, "􀃺", f48083ba),
_c(U+1000FB, "􀃻", f48083bb),
_c(U+1000FC, "􀃼", f48083bc),
_c(U+1000FD, "􀃽", f48083bd),
_c(U+1000FE, "􀃾", f48083be),
_c(U+1000FF, "􀃿", f48083bf),
_c(U+100100, "􀄀", f4808480),
_c(U+100101, "􀄁", f4808481),
_c(U+100102, "􀄂", f4808482),
_c(U+100103, "􀄃", f4808483),
_c(U+100104, "􀄄", f4808484),
_c(U+100105, "􀄅", f4808485),
_c(U+100106, "􀄆", f4808486),
_c(U+100107, "􀄇", f4808487),
_c(U+100108, "􀄈", f4808488),
_c(U+100109, "􀄉", f4808489),
_c(U+10010A, "􀄊", f480848a),
_c(U+10010B, "􀄋", f480848b),
_c(U+10010C, "􀄌", f480848c),
_c(U+10010D, "􀄍", f480848d),
_c(U+10010E, "􀄎", f480848e),
_c(U+10010F, "􀄏", f480848f),
_c(U+100110, "􀄐", f4808490),
_c(U+100111, "􀄑", f4808491),
_c(U+100112, "􀄒", f4808492),
_c(U+100113, "􀄓", f4808493),
_c(U+100114, "􀄔", f4808494),
_c(U+100115, "􀄕", f4808495),
_c(U+100116, "􀄖", f4808496),
_c(U+100117, "􀄗", f4808497),
_c(U+100118, "􀄘", f4808498),
_c(U+100119, "􀄙", f4808499),
_c(U+10011A, "􀄚", f480849a),
_c(U+10011B, "􀄛", f480849b),
_c(U+10011C, "􀄜", f480849c),
_c(U+10011D, "􀄝", f480849d),
_c(U+10011E, "􀄞", f480849e),
_c(U+10011F, "􀄟", f480849f),
_c(U+100120, "􀄠", f48084a0),
_c(U+100121, "􀄡", f48084a1),
_c(U+100122, "􀄢", f48084a2),
_c(U+100123, "􀄣", f48084a3),
_c(U+100124, "􀄤", f48084a4),
_c(U+100125, "􀄥", f48084a5),
_c(U+100126, "􀄦", f48084a6),
_c(U+100127, "􀄧", f48084a7),
_c(U+100128, "􀄨", f48084a8),
_c(U+100129, "􀄩", f48084a9),
_c(U+10012A, "􀄪", f48084aa),
_c(U+10012B, "􀄫", f48084ab),
_c(U+10012C, "􀄬", f48084ac),
_c(U+10012D, "􀄭", f48084ad),
_c(U+10012E, "􀄮", f48084ae),
_c(U+10012F, "􀄯", f48084af),
_c(U+100130, "􀄰", f48084b0),
_c(U+100131, "􀄱", f48084b1),
_c(U+100132, "􀄲", f48084b2),
_c(U+100133, "􀄳", f48084b3),
_c(U+100134, "􀄴", f48084b4),
_c(U+100135, "􀄵", f48084b5),
_c(U+100136, "􀄶", f48084b6),
_c(U+100137, "􀄷", f48084b7),
_c(U+100138, "􀄸", f48084b8),
_c(U+100139, "􀄹", f48084b9),
_c(U+10013A, "􀄺", f48084ba),
_c(U+10013B, "􀄻", f48084bb),
_c(U+10013C, "􀄼", f48084bc),
_c(U+10013D, "􀄽", f48084bd),
_c(U+10013E, "􀄾", f48084be),
_c(U+10013F, "􀄿", f48084bf),
_c(U+100140, "􀅀", f4808580),
_c(U+100141, "􀅁", f4808581),
_c(U+100142, "􀅂", f4808582),
_c(U+100143, "􀅃", f4808583),
_c(U+100144, "􀅄", f4808584),
_c(U+100145, "􀅅", f4808585),
_c(U+100146, "􀅆", f4808586),
_c(U+100147, "􀅇", f4808587),
_c(U+100148, "􀅈", f4808588),
_c(U+100149, "􀅉", f4808589),
_c(U+10014A, "􀅊", f480858a),
_c(U+10014B, "􀅋", f480858b),
_c(U+10014C, "􀅌", f480858c),
_c(U+10014D, "􀅍", f480858d),
_c(U+10014E, "􀅎", f480858e),
_c(U+10014F, "􀅏", f480858f),
_c(U+100150, "􀅐", f4808590),
_c(U+100151, "􀅑", f4808591),
_c(U+100152, "􀅒", f4808592),
_c(U+100153, "􀅓", f4808593),
_c(U+100154, "􀅔", f4808594),
_c(U+100155, "􀅕", f4808595),
_c(U+100156, "􀅖", f4808596),
_c(U+100157, "􀅗", f4808597),
_c(U+100158, "􀅘", f4808598),
_c(U+100159, "􀅙", f4808599),
_c(U+10015A, "􀅚", f480859a),
_c(U+10015B, "􀅛", f480859b),
_c(U+10015C, "􀅜", f480859c),
_c(U+10015D, "􀅝", f480859d),
_c(U+10015E, "􀅞", f480859e),
_c(U+10015F, "􀅟", f480859f),
_c(U+100160, "􀅠", f48085a0),
_c(U+100161, "􀅡", f48085a1),
_c(U+100162, "􀅢", f48085a2),
_c(U+100163, "􀅣", f48085a3),
_c(U+100164, "􀅤", f48085a4),
_c(U+100165, "􀅥", f48085a5),
_c(U+100166, "􀅦", f48085a6),
_c(U+100167, "􀅧", f48085a7),
_c(U+100168, "􀅨", f48085a8),
_c(U+100169, "􀅩", f48085a9),
_c(U+10016A, "􀅪", f48085aa),
_c(U+10016B, "􀅫", f48085ab),
_c(U+10016C, "􀅬", f48085ac),
_c(U+10016D, "􀅭", f48085ad),
_c(U+10016E, "􀅮", f48085ae),
_c(U+10016F, "􀅯", f48085af),
_c(U+100170, "􀅰", f48085b0),
_c(U+100171, "􀅱", f48085b1),
_c(U+100172, "􀅲", f48085b2),
_c(U+100173, "􀅳", f48085b3),
_c(U+100174, "􀅴", f48085b4),
_c(U+100175, "􀅵", f48085b5),
_c(U+100176, "􀅶", f48085b6),
_c(U+100177, "􀅷", f48085b7),
_c(U+100178, "􀅸", f48085b8),
_c(U+100179, "􀅹", f48085b9),
_c(U+10017A, "􀅺", f48085ba),
_c(U+10017B, "􀅻", f48085bb),
_c(U+10017C, "􀅼", f48085bc),
_c(U+10017D, "􀅽", f48085bd),
_c(U+10017E, "􀅾", f48085be),
_c(U+10017F, "􀅿", f48085bf),
_c(U+100180, "􀆀", f4808680),
_c(U+100181, "􀆁", f4808681),
_c(U+100182, "􀆂", f4808682),
_c(U+100183, "􀆃", f4808683),
_c(U+100184, "􀆄", f4808684),
_c(U+100185, "􀆅", f4808685),
_c(U+100186, "􀆆", f4808686),
_c(U+100187, "􀆇", f4808687),
_c(U+100188, "􀆈", f4808688),
_c(U+100189, "􀆉", f4808689),
_c(U+10018A, "􀆊", f480868a),
_c(U+10018B, "􀆋", f480868b),
_c(U+10018C, "􀆌", f480868c),
_c(U+10018D, "􀆍", f480868d),
_c(U+10018E, "􀆎", f480868e),
_c(U+10018F, "􀆏", f480868f),
_c(U+100190, "􀆐", f4808690),
_c(U+100191, "􀆑", f4808691),
_c(U+100192, "􀆒", f4808692),
_c(U+100193, "􀆓", f4808693),
_c(U+100194, "􀆔", f4808694),
_c(U+100195, "􀆕", f4808695),
_c(U+100196, "􀆖", f4808696),
_c(U+100197, "􀆗", f4808697),
_c(U+100198, "􀆘", f4808698),
_c(U+100199, "􀆙", f4808699),
_c(U+10019A, "􀆚", f480869a),
_c(U+10019B, "􀆛", f480869b),
_c(U+10019C, "􀆜", f480869c),
_c(U+10019D, "􀆝", f480869d),
_c(U+10019E, "􀆞", f480869e),
_c(U+10019F, "􀆟", f480869f),
_c(U+1001A0, "􀆠", f48086a0),
_c(U+1001A1, "􀆡", f48086a1),
_c(U+1001A2, "􀆢", f48086a2),
_c(U+1001A3, "􀆣", f48086a3),
_c(U+1001A4, "􀆤", f48086a4),
_c(U+1001A5, "􀆥", f48086a5),
_c(U+1001A6, "􀆦", f48086a6),
_c(U+1001A7, "􀆧", f48086a7),
_c(U+1001A8, "􀆨", f48086a8),
_c(U+1001A9, "􀆩", f48086a9),
_c(U+1001AA, "􀆪", f48086aa),
_c(U+1001AB, "􀆫", f48086ab),
_c(U+1001AC, "􀆬", f48086ac),
_c(U+1001AD, "􀆭", f48086ad),
_c(U+1001AE, "􀆮", f48086ae),
_c(U+1001AF, "􀆯", f48086af),
_c(U+1001B0, "􀆰", f48086b0),
_c(U+1001B1, "􀆱", f48086b1),
_c(U+1001B2, "􀆲", f48086b2),
_c(U+1001B3, "􀆳", f48086b3),
_c(U+1001B4, "􀆴", f48086b4),
_c(U+1001B5, "􀆵", f48086b5),
_c(U+1001B6, "􀆶", f48086b6),
_c(U+1001B7, "􀆷", f48086b7),
_c(U+1001B8, "􀆸", f48086b8),
_c(U+1001B9, "􀆹", f48086b9),
_c(U+1001BA, "􀆺", f48086ba),
_c(U+1001BB, "􀆻", f48086bb),
_c(U+1001BC, "􀆼", f48086bc),
_c(U+1001BD, "􀆽", f48086bd),
_c(U+1001BE, "􀆾", f48086be),
_c(U+1001BF, "􀆿", f48086bf),
_c(U+1001C0, "􀇀", f4808780),
_c(U+1001C1, "􀇁", f4808781),
_c(U+1001C2, "􀇂", f4808782),
_c(U+1001C3, "􀇃", f4808783),
_c(U+1001C4, "􀇄", f4808784),
_c(U+1001C5, "􀇅", f4808785),
_c(U+1001C6, "􀇆", f4808786),
_c(U+1001C7, "􀇇", f4808787),
_c(U+1001C8, "􀇈", f4808788),
_c(U+1001C9, "􀇉", f4808789),
_c(U+1001CA, "􀇊", f480878a),
_c(U+1001CB, "􀇋", f480878b),
_c(U+1001CC, "􀇌", f480878c),
_c(U+1001CD, "􀇍", f480878d),
_c(U+1001CE, "􀇎", f480878e),
_c(U+1001CF, "􀇏", f480878f),
_c(U+1001D0, "􀇐", f4808790),
_c(U+1001D1, "􀇑", f4808791),
_c(U+1001D2, "􀇒", f4808792),
_c(U+1001D3, "􀇓", f4808793),
_c(U+1001D4, "􀇔", f4808794),
_c(U+1001D5, "􀇕", f4808795),
_c(U+1001D6, "􀇖", f4808796),
_c(U+1001D7, "􀇗", f4808797),
_c(U+1001D8, "􀇘", f4808798),
_c(U+1001D9, "􀇙", f4808799),
_c(U+1001DA, "􀇚", f480879a),
_c(U+1001DB, "􀇛", f480879b),
_c(U+1001DC, "􀇜", f480879c),
_c(U+1001DD, "􀇝", f480879d),
_c(U+1001DE, "􀇞", f480879e),
_c(U+1001DF, "􀇟", f480879f),
_c(U+1001E0, "􀇠", f48087a0),
_c(U+1001E1, "􀇡", f48087a1),
_c(U+1001E2, "􀇢", f48087a2),
_c(U+1001E3, "􀇣", f48087a3),
_c(U+1001E4, "􀇤", f48087a4),
_c(U+1001E5, "􀇥", f48087a5),
_c(U+1001E6, "􀇦", f48087a6),
_c(U+1001E7, "􀇧", f48087a7),
_c(U+1001E8, "􀇨", f48087a8),
_c(U+1001E9, "􀇩", f48087a9),
_c(U+1001EA, "􀇪", f48087aa),
_c(U+1001EB, "􀇫", f48087ab),
_c(U+1001EC, "􀇬", f48087ac),
_c(U+1001ED, "􀇭", f48087ad),
_c(U+1001EE, "􀇮", f48087ae),
_c(U+1001EF, "􀇯", f48087af),
_c(U+1001F0, "􀇰", f48087b0),
_c(U+1001F1, "􀇱", f48087b1),
_c(U+1001F2, "􀇲", f48087b2),
_c(U+1001F3, "􀇳", f48087b3),
_c(U+1001F4, "􀇴", f48087b4),
_c(U+1001F5, "􀇵", f48087b5),
_c(U+1001F6, "􀇶", f48087b6),
_c(U+1001F7, "􀇷", f48087b7),
_c(U+1001F8, "􀇸", f48087b8),
_c(U+1001F9, "􀇹", f48087b9),
_c(U+1001FA, "􀇺", f48087ba),
_c(U+1001FB, "􀇻", f48087bb),
_c(U+1001FC, "􀇼", f48087bc),
_c(U+1001FD, "􀇽", f48087bd),
_c(U+1001FE, "􀇾", f48087be),
_c(U+1001FF, "􀇿", f48087bf),
_c(U+100200, "􀈀", f4808880),
_c(U+100201, "􀈁", f4808881),
_c(U+100202, "􀈂", f4808882),
_c(U+100203, "􀈃", f4808883),
_c(U+100204, "􀈄", f4808884),
_c(U+100205, "􀈅", f4808885),
_c(U+100206, "􀈆", f4808886),
_c(U+100207, "􀈇", f4808887),
_c(U+100208, "􀈈", f4808888),
_c(U+100209, "􀈉", f4808889),
_c(U+10020A, "􀈊", f480888a),
_c(U+10020B, "􀈋", f480888b),
_c(U+10020C, "􀈌", f480888c),
_c(U+10020D, "􀈍", f480888d),
_c(U+10020E, "􀈎", f480888e),
_c(U+10020F, "􀈏", f480888f),
_c(U+100210, "􀈐", f4808890),
_c(U+100211, "􀈑", f4808891),
_c(U+100212, "􀈒", f4808892),
_c(U+100213, "􀈓", f4808893),
_c(U+100214, "􀈔", f4808894),
_c(U+100215, "􀈕", f4808895),
_c(U+100216, "􀈖", f4808896),
_c(U+100217, "􀈗", f4808897),
_c(U+100218, "􀈘", f4808898),
_c(U+100219, "􀈙", f4808899),
_c(U+10021A, "􀈚", f480889a),
_c(U+10021B, "􀈛", f480889b),
_c(U+10021C, "􀈜", f480889c),
_c(U+10021D, "􀈝", f480889d),
_c(U+10021E, "􀈞", f480889e),
_c(U+10021F, "􀈟", f480889f),
_c(U+100220, "􀈠", f48088a0),
_c(U+100221, "􀈡", f48088a1),
_c(U+100222, "􀈢", f48088a2),
_c(U+100223, "􀈣", f48088a3),
_c(U+100224, "􀈤", f48088a4),
_c(U+100225, "􀈥", f48088a5),
_c(U+100226, "􀈦", f48088a6),
_c(U+100227, "􀈧", f48088a7),
_c(U+100228, "􀈨", f48088a8),
_c(U+100229, "􀈩", f48088a9),
_c(U+10022A, "􀈪", f48088aa),
_c(U+10022B, "􀈫", f48088ab),
_c(U+10022C, "􀈬", f48088ac),
_c(U+10022D, "􀈭", f48088ad),
_c(U+10022E, "􀈮", f48088ae),
_c(U+10022F, "􀈯", f48088af),
_c(U+100230, "􀈰", f48088b0),
_c(U+100231, "􀈱", f48088b1),
_c(U+100232, "􀈲", f48088b2),
_c(U+100233, "􀈳", f48088b3),
_c(U+100234, "􀈴", f48088b4),
_c(U+100235, "􀈵", f48088b5),
_c(U+100236, "􀈶", f48088b6),
_c(U+100237, "􀈷", f48088b7),
_c(U+100238, "􀈸", f48088b8),
_c(U+100239, "􀈹", f48088b9),
_c(U+10023A, "􀈺", f48088ba),
_c(U+10023B, "􀈻", f48088bb),
_c(U+10023C, "􀈼", f48088bc),
_c(U+10023D, "􀈽", f48088bd),
_c(U+10023E, "􀈾", f48088be),
_c(U+10023F, "􀈿", f48088bf),
_c(U+100240, "􀉀", f4808980),
_c(U+100241, "􀉁", f4808981),
_c(U+100242, "􀉂", f4808982),
_c(U+100243, "􀉃", f4808983),
_c(U+100244, "􀉄", f4808984),
_c(U+100245, "􀉅", f4808985),
_c(U+100246, "􀉆", f4808986),
_c(U+100247, "􀉇", f4808987),
_c(U+100248, "􀉈", f4808988),
_c(U+100249, "􀉉", f4808989),
_c(U+10024A, "􀉊", f480898a),
_c(U+10024B, "􀉋", f480898b),
_c(U+10024C, "􀉌", f480898c),
_c(U+10024D, "􀉍", f480898d),
_c(U+10024E, "􀉎", f480898e),
_c(U+10024F, "􀉏", f480898f),
_c(U+100250, "􀉐", f4808990),
_c(U+100251, "􀉑", f4808991),
_c(U+100252, "􀉒", f4808992),
_c(U+100253, "􀉓", f4808993),
_c(U+100254, "􀉔", f4808994),
_c(U+100255, "􀉕", f4808995),
_c(U+100256, "􀉖", f4808996),
_c(U+100257, "􀉗", f4808997),
_c(U+100258, "􀉘", f4808998),
_c(U+100259, "􀉙", f4808999),
_c(U+10025A, "􀉚", f480899a),
_c(U+10025B, "􀉛", f480899b),
_c(U+10025C, "􀉜", f480899c),
_c(U+10025D, "􀉝", f480899d),
_c(U+10025E, "􀉞", f480899e),
_c(U+10025F, "􀉟", f480899f),
_c(U+100260, "􀉠", f48089a0),
_c(U+100261, "􀉡", f48089a1),
_c(U+100262, "􀉢", f48089a2),
_c(U+100263, "􀉣", f48089a3),
_c(U+100264, "􀉤", f48089a4),
_c(U+100265, "􀉥", f48089a5),
_c(U+100266, "􀉦", f48089a6),
_c(U+100267, "􀉧", f48089a7),
_c(U+100268, "􀉨", f48089a8),
_c(U+100269, "􀉩", f48089a9),
_c(U+10026A, "􀉪", f48089aa),
_c(U+10026B, "􀉫", f48089ab),
_c(U+10026C, "􀉬", f48089ac),
_c(U+10026D, "􀉭", f48089ad),
_c(U+10026E, "􀉮", f48089ae),
_c(U+10026F, "􀉯", f48089af),
_c(U+100270, "􀉰", f48089b0),
_c(U+100271, "􀉱", f48089b1),
_c(U+100272, "􀉲", f48089b2),
_c(U+100273, "􀉳", f48089b3),
_c(U+100274, "􀉴", f48089b4),
_c(U+100275, "􀉵", f48089b5),
_c(U+100276, "􀉶", f48089b6),
_c(U+100277, "􀉷", f48089b7),
_c(U+100278, "􀉸", f48089b8),
_c(U+100279, "􀉹", f48089b9),
_c(U+10027A, "􀉺", f48089ba),
_c(U+10027B, "􀉻", f48089bb),
_c(U+10027C, "􀉼", f48089bc),
_c(U+10027D, "􀉽", f48089bd),
_c(U+10027E, "􀉾", f48089be),
_c(U+10027F, "􀉿", f48089bf),
_c(U+100280, "􀊀", f4808a80),
_c(U+100281, "􀊁", f4808a81),
_c(U+100282, "􀊂", f4808a82),
_c(U+100283, "􀊃", f4808a83),
_c(U+100284, "􀊄", f4808a84),
_c(U+100285, "􀊅", f4808a85),
_c(U+100286, "􀊆", f4808a86),
_c(U+100287, "􀊇", f4808a87),
_c(U+100288, "􀊈", f4808a88),
_c(U+100289, "􀊉", f4808a89),
_c(U+10028A, "􀊊", f4808a8a),
_c(U+10028B, "􀊋", f4808a8b),
_c(U+10028C, "􀊌", f4808a8c),
_c(U+10028D, "􀊍", f4808a8d),
_c(U+10028E, "􀊎", f4808a8e),
_c(U+10028F, "􀊏", f4808a8f),
_c(U+100290, "􀊐", f4808a90),
_c(U+100291, "􀊑", f4808a91),
_c(U+100292, "􀊒", f4808a92),
_c(U+100293, "􀊓", f4808a93),
_c(U+100294, "􀊔", f4808a94),
_c(U+100295, "􀊕", f4808a95),
_c(U+100296, "􀊖", f4808a96),
_c(U+100297, "􀊗", f4808a97),
_c(U+100298, "􀊘", f4808a98),
_c(U+100299, "􀊙", f4808a99),
_c(U+10029A, "􀊚", f4808a9a),
_c(U+10029B, "􀊛", f4808a9b),
_c(U+10029C, "􀊜", f4808a9c),
_c(U+10029D, "􀊝", f4808a9d),
_c(U+10029E, "􀊞", f4808a9e),
_c(U+10029F, "􀊟", f4808a9f),
_c(U+1002A0, "􀊠", f4808aa0),
_c(U+1002A1, "􀊡", f4808aa1),
_c(U+1002A2, "􀊢", f4808aa2),
_c(U+1002A3, "􀊣", f4808aa3),
_c(U+1002A4, "􀊤", f4808aa4),
_c(U+1002A5, "􀊥", f4808aa5),
_c(U+1002A6, "􀊦", f4808aa6),
_c(U+1002A7, "􀊧", f4808aa7),
_c(U+1002A8, "􀊨", f4808aa8),
_c(U+1002A9, "􀊩", f4808aa9),
_c(U+1002AA, "􀊪", f4808aaa),
_c(U+1002AB, "􀊫", f4808aab),
_c(U+1002AC, "􀊬", f4808aac),
_c(U+1002AD, "􀊭", f4808aad),
_c(U+1002AE, "􀊮", f4808aae),
_c(U+1002AF, "􀊯", f4808aaf),
_c(U+1002B0, "􀊰", f4808ab0),
_c(U+1002B1, "􀊱", f4808ab1),
_c(U+1002B2, "􀊲", f4808ab2),
_c(U+1002B3, "􀊳", f4808ab3),
_c(U+1002B4, "􀊴", f4808ab4),
_c(U+1002B5, "􀊵", f4808ab5),
_c(U+1002B6, "􀊶", f4808ab6),
_c(U+1002B7, "􀊷", f4808ab7),
_c(U+1002B8, "􀊸", f4808ab8),
_c(U+1002B9, "􀊹", f4808ab9),
_c(U+1002BA, "􀊺", f4808aba),
_c(U+1002BB, "􀊻", f4808abb),
_c(U+1002BC, "􀊼", f4808abc),
_c(U+1002BD, "􀊽", f4808abd),
_c(U+1002BE, "􀊾", f4808abe),
_c(U+1002BF, "􀊿", f4808abf),
_c(U+1002C0, "􀋀", f4808b80),
_c(U+1002C1, "􀋁", f4808b81),
_c(U+1002C2, "􀋂", f4808b82),
_c(U+1002C3, "􀋃", f4808b83),
_c(U+1002C4, "􀋄", f4808b84),
_c(U+1002C5, "􀋅", f4808b85),
_c(U+1002C6, "􀋆", f4808b86),
_c(U+1002C7, "􀋇", f4808b87),
_c(U+1002C8, "􀋈", f4808b88),
_c(U+1002C9, "􀋉", f4808b89),
_c(U+1002CA, "􀋊", f4808b8a),
_c(U+1002CB, "􀋋", f4808b8b),
_c(U+1002CC, "􀋌", f4808b8c),
_c(U+1002CD, "􀋍", f4808b8d),
_c(U+1002CE, "􀋎", f4808b8e),
_c(U+1002CF, "􀋏", f4808b8f),
_c(U+1002D0, "􀋐", f4808b90),
_c(U+1002D1, "􀋑", f4808b91),
_c(U+1002D2, "􀋒", f4808b92),
_c(U+1002D3, "􀋓", f4808b93),
_c(U+1002D4, "􀋔", f4808b94),
_c(U+1002D5, "􀋕", f4808b95),
_c(U+1002D6, "􀋖", f4808b96),
_c(U+1002D7, "􀋗", f4808b97),
_c(U+1002D8, "􀋘", f4808b98),
_c(U+1002D9, "􀋙", f4808b99),
_c(U+1002DA, "􀋚", f4808b9a),
_c(U+1002DB, "􀋛", f4808b9b),
_c(U+1002DC, "􀋜", f4808b9c),
_c(U+1002DD, "􀋝", f4808b9d),
_c(U+1002DE, "􀋞", f4808b9e),
_c(U+1002DF, "􀋟", f4808b9f),
_c(U+1002E0, "􀋠", f4808ba0),
_c(U+1002E1, "􀋡", f4808ba1),
_c(U+1002E2, "􀋢", f4808ba2),
_c(U+1002E3, "􀋣", f4808ba3),
_c(U+1002E4, "􀋤", f4808ba4),
_c(U+1002E5, "􀋥", f4808ba5),
_c(U+1002E6, "􀋦", f4808ba6),
_c(U+1002E7, "􀋧", f4808ba7),
_c(U+1002E8, "􀋨", f4808ba8),
_c(U+1002E9, "􀋩", f4808ba9),
_c(U+1002EA, "􀋪", f4808baa),
_c(U+1002EB, "􀋫", f4808bab),
_c(U+1002EC, "􀋬", f4808bac),
_c(U+1002ED, "􀋭", f4808bad),
_c(U+1002EE, "􀋮", f4808bae),
_c(U+1002EF, "􀋯", f4808baf),
_c(U+1002F0, "􀋰", f4808bb0),
_c(U+1002F1, "􀋱", f4808bb1),
_c(U+1002F2, "􀋲", f4808bb2),
_c(U+1002F3, "􀋳", f4808bb3),
_c(U+1002F4, "􀋴", f4808bb4),
_c(U+1002F5, "􀋵", f4808bb5),
_c(U+1002F6, "􀋶", f4808bb6),
_c(U+1002F7, "􀋷", f4808bb7),
_c(U+1002F8, "􀋸", f4808bb8),
_c(U+1002F9, "􀋹", f4808bb9),
_c(U+1002FA, "􀋺", f4808bba),
_c(U+1002FB, "􀋻", f4808bbb),
_c(U+1002FC, "􀋼", f4808bbc),
_c(U+1002FD, "􀋽", f4808bbd),
_c(U+1002FE, "􀋾", f4808bbe),
_c(U+1002FF, "􀋿", f4808bbf),
_c(U+100300, "􀌀", f4808c80),
_c(U+100301, "􀌁", f4808c81),
_c(U+100302, "􀌂", f4808c82),
_c(U+100303, "􀌃", f4808c83),
_c(U+100304, "􀌄", f4808c84),
_c(U+100305, "􀌅", f4808c85),
_c(U+100306, "􀌆", f4808c86),
_c(U+100307, "􀌇", f4808c87),
_c(U+100308, "􀌈", f4808c88),
_c(U+100309, "􀌉", f4808c89),
_c(U+10030A, "􀌊", f4808c8a),
_c(U+10030B, "􀌋", f4808c8b),
_c(U+10030C, "􀌌", f4808c8c),
_c(U+10030D, "􀌍", f4808c8d),
_c(U+10030E, "􀌎", f4808c8e),
_c(U+10030F, "􀌏", f4808c8f),
_c(U+100310, "􀌐", f4808c90),
_c(U+100311, "􀌑", f4808c91),
_c(U+100312, "􀌒", f4808c92),
_c(U+100313, "􀌓", f4808c93),
_c(U+100314, "􀌔", f4808c94),
_c(U+100315, "􀌕", f4808c95),
_c(U+100316, "􀌖", f4808c96),
_c(U+100317, "􀌗", f4808c97),
_c(U+100318, "􀌘", f4808c98),
_c(U+100319, "􀌙", f4808c99),
_c(U+10031A, "􀌚", f4808c9a),
_c(U+10031B, "􀌛", f4808c9b),
_c(U+10031C, "􀌜", f4808c9c),
_c(U+10031D, "􀌝", f4808c9d),
_c(U+10031E, "􀌞", f4808c9e),
_c(U+10031F, "􀌟", f4808c9f),
_c(U+100320, "􀌠", f4808ca0),
_c(U+100321, "􀌡", f4808ca1),
_c(U+100322, "􀌢", f4808ca2),
_c(U+100323, "􀌣", f4808ca3),
_c(U+100324, "􀌤", f4808ca4),
_c(U+100325, "􀌥", f4808ca5),
_c(U+100326, "􀌦", f4808ca6),
_c(U+100327, "􀌧", f4808ca7),
_c(U+100328, "􀌨", f4808ca8),
_c(U+100329, "􀌩", f4808ca9),
_c(U+10032A, "􀌪", f4808caa),
_c(U+10032B, "􀌫", f4808cab),
_c(U+10032C, "􀌬", f4808cac),
_c(U+10032D, "􀌭", f4808cad),
_c(U+10032E, "􀌮", f4808cae),
_c(U+10032F, "􀌯", f4808caf),
_c(U+100330, "􀌰", f4808cb0),
_c(U+100331, "􀌱", f4808cb1),
_c(U+100332, "􀌲", f4808cb2),
_c(U+100333, "􀌳", f4808cb3),
_c(U+100334, "􀌴", f4808cb4),
_c(U+100335, "􀌵", f4808cb5),
_c(U+100336, "􀌶", f4808cb6),
_c(U+100337, "􀌷", f4808cb7),
_c(U+100338, "􀌸", f4808cb8),
_c(U+100339, "􀌹", f4808cb9),
_c(U+10033A, "􀌺", f4808cba),
_c(U+10033B, "􀌻", f4808cbb),
_c(U+10033C, "􀌼", f4808cbc),
_c(U+10033D, "􀌽", f4808cbd),
_c(U+10033E, "􀌾", f4808cbe),
_c(U+10033F, "􀌿", f4808cbf),
_c(U+100340, "􀍀", f4808d80),
_c(U+100341, "􀍁", f4808d81),
_c(U+100342, "􀍂", f4808d82),
_c(U+100343, "􀍃", f4808d83),
_c(U+100344, "􀍄", f4808d84),
_c(U+100345, "􀍅", f4808d85),
_c(U+100346, "􀍆", f4808d86),
_c(U+100347, "􀍇", f4808d87),
_c(U+100348, "􀍈", f4808d88),
_c(U+100349, "􀍉", f4808d89),
_c(U+10034A, "􀍊", f4808d8a),
_c(U+10034B, "􀍋", f4808d8b),
_c(U+10034C, "􀍌", f4808d8c),
_c(U+10034D, "􀍍", f4808d8d),
_c(U+10034E, "􀍎", f4808d8e),
_c(U+10034F, "􀍏", f4808d8f),
_c(U+100350, "􀍐", f4808d90),
_c(U+100351, "􀍑", f4808d91),
_c(U+100352, "􀍒", f4808d92),
_c(U+100353, "􀍓", f4808d93),
_c(U+100354, "􀍔", f4808d94),
_c(U+100355, "􀍕", f4808d95),
_c(U+100356, "􀍖", f4808d96),
_c(U+100357, "􀍗", f4808d97),
_c(U+100358, "􀍘", f4808d98),
_c(U+100359, "􀍙", f4808d99),
_c(U+10035A, "􀍚", f4808d9a),
_c(U+10035B, "􀍛", f4808d9b),
_c(U+10035C, "􀍜", f4808d9c),
_c(U+10035D, "􀍝", f4808d9d),
_c(U+10035E, "􀍞", f4808d9e),
_c(U+10035F, "􀍟", f4808d9f),
_c(U+100360, "􀍠", f4808da0),
_c(U+100361, "􀍡", f4808da1),
_c(U+100362, "􀍢", f4808da2),
_c(U+100363, "􀍣", f4808da3),
_c(U+100364, "􀍤", f4808da4),
_c(U+100365, "􀍥", f4808da5),
_c(U+100366, "􀍦", f4808da6),
_c(U+100367, "􀍧", f4808da7),
_c(U+100368, "􀍨", f4808da8),
_c(U+100369, "􀍩", f4808da9),
_c(U+10036A, "􀍪", f4808daa),
_c(U+10036B, "􀍫", f4808dab),
_c(U+10036C, "􀍬", f4808dac),
_c(U+10036D, "􀍭", f4808dad),
_c(U+10036E, "􀍮", f4808dae),
_c(U+10036F, "􀍯", f4808daf),
_c(U+100370, "􀍰", f4808db0),
_c(U+100371, "􀍱", f4808db1),
_c(U+100372, "􀍲", f4808db2),
_c(U+100373, "􀍳", f4808db3),
_c(U+100374, "􀍴", f4808db4),
_c(U+100375, "􀍵", f4808db5),
_c(U+100376, "􀍶", f4808db6),
_c(U+100377, "􀍷", f4808db7),
_c(U+100378, "􀍸", f4808db8),
_c(U+100379, "􀍹", f4808db9),
_c(U+10037A, "􀍺", f4808dba),
_c(U+10037B, "􀍻", f4808dbb),
_c(U+10037C, "􀍼", f4808dbc),
_c(U+10037D, "􀍽", f4808dbd),
_c(U+10037E, "􀍾", f4808dbe),
_c(U+10037F, "􀍿", f4808dbf),
_c(U+100380, "􀎀", f4808e80),
_c(U+100381, "􀎁", f4808e81),
_c(U+100382, "􀎂", f4808e82),
_c(U+100383, "􀎃", f4808e83),
_c(U+100384, "􀎄", f4808e84),
_c(U+100385, "􀎅", f4808e85),
_c(U+100386, "􀎆", f4808e86),
_c(U+100387, "􀎇", f4808e87),
_c(U+100388, "􀎈", f4808e88),
_c(U+100389, "􀎉", f4808e89),
_c(U+10038A, "􀎊", f4808e8a),
_c(U+10038B, "􀎋", f4808e8b),
_c(U+10038C, "􀎌", f4808e8c),
_c(U+10038D, "􀎍", f4808e8d),
_c(U+10038E, "􀎎", f4808e8e),
_c(U+10038F, "􀎏", f4808e8f),
_c(U+100390, "􀎐", f4808e90),
_c(U+100391, "􀎑", f4808e91),
_c(U+100392, "􀎒", f4808e92),
_c(U+100393, "􀎓", f4808e93),
_c(U+100394, "􀎔", f4808e94),
_c(U+100395, "􀎕", f4808e95),
_c(U+100396, "􀎖", f4808e96),
_c(U+100397, "􀎗", f4808e97),
_c(U+100398, "􀎘", f4808e98),
_c(U+100399, "􀎙", f4808e99),
_c(U+10039A, "􀎚", f4808e9a),
_c(U+10039B, "􀎛", f4808e9b),
_c(U+10039C, "􀎜", f4808e9c),
_c(U+10039D, "􀎝", f4808e9d),
_c(U+10039E, "􀎞", f4808e9e),
_c(U+10039F, "􀎟", f4808e9f),
_c(U+1003A0, "􀎠", f4808ea0),
_c(U+1003A1, "􀎡", f4808ea1),
_c(U+1003A2, "􀎢", f4808ea2),
_c(U+1003A3, "􀎣", f4808ea3),
_c(U+1003A4, "􀎤", f4808ea4),
_c(U+1003A5, "􀎥", f4808ea5),
_c(U+1003A6, "􀎦", f4808ea6),
_c(U+1003A7, "􀎧", f4808ea7),
_c(U+1003A8, "􀎨", f4808ea8),
_c(U+1003A9, "􀎩", f4808ea9),
_c(U+1003AA, "􀎪", f4808eaa),
_c(U+1003AB, "􀎫", f4808eab),
_c(U+1003AC, "􀎬", f4808eac),
_c(U+1003AD, "􀎭", f4808ead),
_c(U+1003AE, "􀎮", f4808eae),
_c(U+1003AF, "􀎯", f4808eaf),
_c(U+1003B0, "􀎰", f4808eb0),
_c(U+1003B1, "􀎱", f4808eb1),
_c(U+1003B2, "􀎲", f4808eb2),
_c(U+1003B3, "􀎳", f4808eb3),
_c(U+1003B4, "􀎴", f4808eb4),
_c(U+1003B5, "􀎵", f4808eb5),
_c(U+1003B6, "􀎶", f4808eb6),
_c(U+1003B7, "􀎷", f4808eb7),
_c(U+1003B8, "􀎸", f4808eb8),
_c(U+1003B9, "􀎹", f4808eb9),
_c(U+1003BA, "􀎺", f4808eba),
_c(U+1003BB, "􀎻", f4808ebb),
_c(U+1003BC, "􀎼", f4808ebc),
_c(U+1003BD, "􀎽", f4808ebd),
_c(U+1003BE, "􀎾", f4808ebe),
_c(U+1003BF, "􀎿", f4808ebf),
_c(U+1003C0, "􀏀", f4808f80),
_c(U+1003C1, "􀏁", f4808f81),
_c(U+1003C2, "􀏂", f4808f82),
_c(U+1003C3, "􀏃", f4808f83),
_c(U+1003C4, "􀏄", f4808f84),
_c(U+1003C5, "􀏅", f4808f85),
_c(U+1003C6, "􀏆", f4808f86),
_c(U+1003C7, "􀏇", f4808f87),
_c(U+1003C8, "􀏈", f4808f88),
_c(U+1003C9, "􀏉", f4808f89),
_c(U+1003CA, "􀏊", f4808f8a),
_c(U+1003CB, "􀏋", f4808f8b),
_c(U+1003CC, "􀏌", f4808f8c),
_c(U+1003CD, "􀏍", f4808f8d),
_c(U+1003CE, "􀏎", f4808f8e),
_c(U+1003CF, "􀏏", f4808f8f),
_c(U+1003D0, "􀏐", f4808f90),
_c(U+1003D1, "􀏑", f4808f91),
_c(U+1003D2, "􀏒", f4808f92),
_c(U+1003D3, "􀏓", f4808f93),
_c(U+1003D4, "􀏔", f4808f94),
_c(U+1003D5, "􀏕", f4808f95),
_c(U+1003D6, "􀏖", f4808f96),
_c(U+1003D7, "􀏗", f4808f97),
_c(U+1003D8, "􀏘", f4808f98),
_c(U+1003D9, "􀏙", f4808f99),
_c(U+1003DA, "􀏚", f4808f9a),
_c(U+1003DB, "􀏛", f4808f9b),
_c(U+1003DC, "􀏜", f4808f9c),
_c(U+1003DD, "􀏝", f4808f9d),
_c(U+1003DE, "􀏞", f4808f9e),
_c(U+1003DF, "􀏟", f4808f9f),
_c(U+1003E0, "􀏠", f4808fa0),
_c(U+1003E1, "􀏡", f4808fa1),
_c(U+1003E2, "􀏢", f4808fa2),
_c(U+1003E3, "􀏣", f4808fa3),
_c(U+1003E4, "􀏤", f4808fa4),
_c(U+1003E5, "􀏥", f4808fa5),
_c(U+1003E6, "􀏦", f4808fa6),
_c(U+1003E7, "􀏧", f4808fa7),
_c(U+1003E8, "􀏨", f4808fa8),
_c(U+1003E9, "􀏩", f4808fa9),
_c(U+1003EA, "􀏪", f4808faa),
_c(U+1003EB, "􀏫", f4808fab),
_c(U+1003EC, "􀏬", f4808fac),
_c(U+1003ED, "􀏭", f4808fad),
_c(U+1003EE, "􀏮", f4808fae),
_c(U+1003EF, "􀏯", f4808faf),
_c(U+1003F0, "􀏰", f4808fb0),
_c(U+1003F1, "􀏱", f4808fb1),
_c(U+1003F2, "􀏲", f4808fb2),
_c(U+1003F3, "􀏳", f4808fb3),
_c(U+1003F4, "􀏴", f4808fb4),
_c(U+1003F5, "􀏵", f4808fb5),
_c(U+1003F6, "􀏶", f4808fb6),
_c(U+1003F7, "􀏷", f4808fb7),
_c(U+1003F8, "􀏸", f4808fb8),
_c(U+1003F9, "􀏹", f4808fb9),
_c(U+1003FA, "􀏺", f4808fba),
_c(U+1003FB, "􀏻", f4808fbb),
_c(U+1003FC, "􀏼", f4808fbc),
_c(U+1003FD, "􀏽", f4808fbd),
_c(U+1003FE, "􀏾", f4808fbe),
_c(U+1003FF, "􀏿", f4808fbf),
#undef _c
