.TH XWIN 1 @vendorversion@
.SH NAME
XWin \- X Server for the Cygwin environment on Microsoft Windows


.SH SYNOPSIS
.B XWin
[ options ] ...


.SH DESCRIPTION
\fIXWin\fP is an X Server for the X Window System on the Cygwin environment
running on Microsoft Windows.


.SH MODES
\fIXWin\fP can operate in 3 different modes:
.br
* \fISingle Window\fP: This is the default mode.  Each X screen
appears as a single \fIWindows\fP window and all X windows are contained
within this window.
(In X terminology, the \fIWindows\fP window contains the root window for
the screen)
.br
* \fIMulti-Window\fP: In this mode \fIXWin\fP uses its own integrated
window manager in order to handle the top-level X windows, in such a
way that they appear as normal \fIWindows\fP windows.
.br
* \fIRootless\fP: In this mode the X server works in a window
containing the whole screen but this root window (traditionally covered with an X hatch
pattern) is hidden from view, so only top-level X windows are seen.

.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXWin\fP accepts the following command line switches,
\fIall\fP of which are optional:

.SH OPTIONS CONTROLLING WINDOWING MODE
Only one of these options may be specified.
.TP 8
.B (default)
Windowed or rooted mode.
Each X screen appears as a single \fIWindows\fP window and all X windows are
contained within those windows.
.TP 8
.B \-multiwindow
Each top-level X window appears in its own \fIWindows\fP window.
Also start the integrated \fIWindows\fP-based window manager.
.TP 8
.B \-rootless
Run the server in rootless mode.
The X server works on a window covering the whole screen but the root window
is hidden from view.
.PP
\fBNOTE:\fP \fI-multiwindow\fP mode uses its own internal window manager.
All other modes require an external window manager in order to move, resize, and perform other
operations on the individual X windows.

.SH OPTIONS FOR SPECIFYING X SCREENS
An X display may be composed of multiple screens.
The default behaviour is to create a single screen 0 that is roughly the
size of useful area of the primary monitor (allowing for any window
decorations and the task-bar).

Screen specific parameters can be applied as a
default to all screens by placing those screen specific parameters
before any \fB\-screen\fP parameter.  Screen specific parameters placed after
the first \fB\-screen\fP parameter will apply only to the immediately
preceding \fB\-screen\fP parameter.
.TP 8
.B \-[no]multimonitors or \-[no]multiplemonitors
Create a screen 0 that covers all monitors [the primary monitor] on a system with
multiple monitors.
Fake XINERAMA data is created describing the individual monitors,
(This is similar to the 'merged framebuffer' or 'pseudo-xinerama' mode provided by
some drivers for the xorg X server).
This option is currently enabled by default in \fB\-multiwindow\fP mode.
.TP 8
.B "\-screen \fIscreen_number\fP [\fIW\fP \fIH\fP [\fIX\fP \fIY\fP] | [[\fIW\fPx\fIH\fP[+\fIX\fP+\fIY\fP]][@\fIM\fP]] ] "
Create screen number
.I screen_number
and optionally specify its
.I height,
.I width
and
.I initial position.
Additionally a
.I
monitor number
(which count from 1) can be specified to place the screen on,
at which point, all coordinates become relative to that monitor.
Screen numbers must be contiguous starting from zero and cannot be duplicated.

Examples:

.I "  -screen 0 @1 ; on 1st monitor using its full resolution (the default)"

.I "  -screen 0 800x600+100+100@2 ; on 2nd monitor offset 100,100 size 800x600"

.I "  -screen 0 1024x768@3        ; on 3rd monitor size 1024x768"

.SH OPTIONS CONTROLLING THE APPEARANCE OF THE X SCREEN WINDOWS
These parameters only apply to windowed mode screens i.e. not
in \fB-multiwindow\fP or \fB-rootless\fP mode.
.TP 8
.B "\-fullscreen"
The X server window takes the full screen, covering completely the
\fIWindows\fP desktop.
Currently \fB\-fullscreen\fP may only be applied to one X screen.
.TP 8
.B "\-icon" \fIicon-specifier\fP
Override the window icon for the screen window from the default.
The \fIicon-specifier\fP is as defined in \fIXWinrc(@filemansuffix@)\fP.
.TP 8
.B \-nodecoration
Do not give the Cygwin/X window a \fIWindows\fP window border, title bar,
etc.
This parameter is ignored when the \fB\-fullscreen\fP parameter is specified.
.TP 8
.B \-scrollbars
Alternative name for \fB\-resize=scrollbars\fP.

.SH OPTIONS CONTROLLING RESIZE BEHAVIOUR
.TP 8
.B \-resize[=none|scrollbars|randr]
Select the resize mode of an X screen.
The default is \fBnone\fP if \fB\-fullscreen\fP is used, \fBrandr\fP otherwise.

.RS
.IP \fB\-resize=none\fP 8
The screen is not resizable.

In windowed mode, if the window has decorations, a fixed frame is used.

Alternative name is \fB\-noresize\fP.

.IP \fB\-resize=scrollbars\fP 8
The screen window is resizeable, but the screen is not resizable.

In windowed mode, if the window has decorations, a resizing frame is used.
Scrollbars are drawn when needed to allow the entire X screen
to viewed by adjusting them.

This also permits screens bigger than the \fIWindows\fP virtual desktop to be used.

This parameter is ignored in \fB-multiwindow\fP or \fB-rootless\fP mode.
Alternative name is \fB\-scrollbars\fP.

.IP \fB\-resize=randr\fP 8
The screen is resizable and the screen window is resizeable.

In windowed mode, if the window has decorations, a resizing frame is used.

Resizing the  \fIWindows\fP window will use the RANDR extension to change
the size of the X screen.  Likewise, changing the size of
the X screen using the RANDR extension will cause the size
of the \fIWindows\fP window containing the X screen to be changed.

In \fB-multiwindow\fP or \fB-rootless\fP mode, if the X screen is
of the same dimensions as a Windows monitor or the virtual desktop,
the X server will respond to the WM_DISPLAYCHANGED sent when those
dimensions change by resizing the X screen.  Changing the size
of the X screen using the RANDR extension is not permitted.

The maximum dimensions of the screen are the dimensions of the \fIWindows\fP virtual desktop.

.IP \fB\-resize\fP 8
on its own is equivalent to \fB\-resize=randr\fP
.RE

.SH OPTIONS FOR MULTIWINDOW MODE
.TP 8
.B \-[no]hostintitle
Add the host name to the window title for X applications which are running
on remote hosts, when that information is available and it's useful to do so.
The default is enabled.
.TP 8
.B \-[no]compositewm
Use Composite extension redirection to maintain a bitmap image of each top-level
X window, so window contents which are occluded show correctly in task bar and
task switcher previews.
The default is enabled.
.TP 8
.B \-[no]compositealpha
X windows with per-pixel alpha are composited into the \fIWindows\fP desktop
(i.e. a \fIWindows\fP window can be seen through any transparency in an X window
placed over it).

This option has no effect on Windows 8 and 8.1.
This option has no effect if \fB-compositewm\fP is disabled.
The default is disabled.

.SH OPTIONS CONTROLLING WINDOWS INTEGRATION
.TP 8
.B \-[no]clipboard
Enables [disables] the integration between the X11 clipboard and
\fIWindows\fP clipboard.  The default is enabled.
.TP 8
.B "\-emulate3buttons [\fItimeout\fP]"
Emulate a three button mouse; pressing both buttons within
.I timeout
milliseconds causes an emulated middle button press.  The default
.I timeout
is 50 milliseconds.  Note that most mice with scroll wheel have middle
button functionality, usually you will need this option only if you have
a two button mouse without scroll wheel.  Default is to enable this
option if  \fIWindows\fP reports a two button mouse, disabled otherwise.
.TP 8
.B \-[no]keyhook
Enable [disable] a low-level keyboard hook for catching
special keypresses like Menu and Alt+Tab and passing them to the X
Server instead of letting \fIWindows\fP handle them.
.TP 8
.B \-lesspointer
Normally the \fIWindows\fP mouse cursor is hidden when the mouse is
over an active Cygwin/X window.  This option causes the mouse cursor
also to be hidden when it is over an inactive Cygwin/X window.  This
prevents the \fIWindows\fP mouse cursor from being drawn on top of the X
cursor.
This parameter has no effect unless \fB-swcursor\fP is also specified.
.TP 8
.B \-[no]primary
Clipboard integration may [will not] use the PRIMARY selection.
The default is enabled.
.TP 8
.B \-swcursor
Disable the usage of the \fIWindows\fP cursor and use the X11 software cursor instead.
This option is ignored if \fB-compositewm\fP is also enabled.
.TP 8
.B \-[no]trayicon
Do not create a tray icon.  Default is to create one
icon per screen.  You can globally disable tray icons with
\fB\-notrayicon\fP, then enable it for specific screens with
\fB\-trayicon\fP for those screens.
.TP 8
.B \-[no]unixkill
Enable or disable the \fICtrl-Alt-Backspace\fP key combination as a
signal to exit the X Server.  The \fICtrl-Alt-Backspace\fP key combination
is disabled by default.
.TP 8
.B \-[no]wgl
Enable [disable] the GLX extension to use the native Windows WGL interface
for hardware accelerated OpenGL (AIGLX). The default is enabled.
.TP 8
.B \-[no]winkill
Enable or disable the \fIAlt-F4\fP key combination as a signal to exit the
X Server.
The \fIAlt-F4\fP key combination is enabled by default.

.SH DRAWING ENGINE OPTIONS
.TP 8
.B "\-clipupdates \fInum_boxes\fP"
Specify an optional threshold, above which the regions in a shadow
update operation will be collected into a GDI clipping region.  The
clipping region is then used to do a single bit block transfer that is
constrained to the updated area by the clipping region.  There is some
overhead involved in creating, installing, destroying, and removing
the clipping region, thus there may not be much benefit for a small
number of boxes (less than 10).  It is even possible that this
functionality does not provide a benefit at any number of boxes; we
can only determine the usefulness of this feature through testing.
This option probably has limited effect on current \fIWindows\fP versions
as they already perform GDI batching.
.TP 8
.B "\-engine \fIengine_type_id\fP"
This option, which is intended for Cygwin/X developers,
overrides the server's automatically selected drawing engine type.  This
parameter will be ignored if the specified drawing engine type is not
supported on the current system.

Default behavior is to select the drawing engine with optimum performance that
supports the specified depth and window configuration.

The engine type ids are:
.RS
.IP 1 4
Shadow GDI
.IP 4 4
Shadow DirectDraw Non-Locking
.RE

.SH FULLSCREEN OPTIONS
.TP 8
.B "\-depth \fIdepth\fP"
Specify the color depth, in bits per pixel, to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.
.TP 8
.B "\-refresh \fIrate_in_Hz\fP"
Specify an optional refresh rate to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.

.SH MISCELLANEOUS OPTIONS
See also the normal server options described in the \fIXserver(1)\fP
manual page

.TP 8
.B \-help
Write a help text listing supported command line options and their description to the console.
.TP 8
.B \-ignoreinput
Ignore keyboard and mouse input.  This is usually only used for testing
and debugging purposes.
.TP 8
.B "\-logfile \fIfilename\fP"
Change the server log file from the default of \fI
@logdir@/XWin.n.log\fP,
where \fIn\fP is the display number of the XWin server, to \fIfilename\fP.
.TP 8
.B "\-logverbose \fIlevel\fP"
Control the degree of verbosity of the log messages with the integer
parameter \fIlevel\fP.  For \fIlevel\fP=0 only fatal errors are
reported, for \fIlevel\fP=1 simple information about
configuration is also given, for \fIlevel\fP=2 (default)
additional runtime information is recorded
and for \fIlevel\fP=3 detailed log
information (including trace and debug output) is produced.  Bigger
values will yield a still more detailed debug output.
.TP 8
.B "\-xkblayout \fIlayout\fP"
.TP 8
.B "\-xkbmodel \fImodel\fP"
.TP 8
.B "\-xkboptions \fIoption\fP"
.TP 8
.B "\-xkbrules \fIrule\fP"
.TP 8
.B "\-xkbvariant \fIvariant\fp"
These options configure the xkeyboard extension to load
a particular keyboard map as the X server starts.  The behavior is similar
to the \fIsetxkbmap\fP(1) program.

See the \fIxkeyboard-config\fP(@miscmansuffix@) manual page for a list of
keyboard configurations.

The keyboard layout data is located at \fI@datadir@/X11/xkb/\fP.  Additional information
can be found in the README files there and in the \fIsetxkbmap\fP(1) manual page.

For example, in order to load a German layout for a pc105 keyboard, use the options:
.br
.I " \-xkblayout de \-xkbmodel pc105"

Alternatively, you can use the \fIsetxkbmap\fP(1) program after \fIXWin\fP is
running.

The default is to select a keyboard configuration matching your current layout as
reported by \fIWindows\fP, if known, or the default X server configuration
if no matching keyboard configuration was found.

.SH UNDOCUMENTED OPTIONS
These options are undocumented.  Do not use them.

.TP 8
.B \-emulatepseudo
Create a depth 8 PseudoColor visual when running in depths 15, 16, 24,
or 32, collectively known as TrueColor depths.
Color map manipulation is not supported, so the PseudoColor visual will
not have the correct colors.
This option is intended to allow applications which only work with a depth 8
visual to operate in TrueColor modes.

.SH LOG FILE
As it runs \fIXWin\fP writes messages indicating the most relevant events
to  the console
from which it was called and to a log file that by default is located at \fI
@logdir@/XWin.0.log\fP.  This file is mainly for debugging purposes.


.SH PREFERENCES FILE
On startup \fIXWin\fP looks for the file \fI$HOME/.XWinrc\fP or, if
the previous file does not exist, \fI
@sysconfdir@/X11/system.XWinrc\fP.  \fI.XWinrc\fP allows setting
preferences for the following:
.br
* To include items into the menu associated with the \fIXWin\fP icon
which is in the \fIWindows\fP system tray.  This functions in all
modes that have a tray icon.
.br
* To include items in the system menu which is associated with the \fIWindows\fP
window that \fIXWin -multiwindow\fP produces for each top-level X
window, in both the generic case and for particular programs.
.br
* To change the icon that is associated to the \fIWindows\fP window that
\fIXWin -multiwindow\fP produces for each top-level X-window.
.br
* To change the style that is associated to the \fIWindows\fP window that
\fXWin I-multiwindow\fP produces for each top-level X window.
.PP
The format of the \fI.XWinrc\fP file is given in the XWinrc(5) manual page.

.SH EXAMPLES
Need some examples


.SH "SEE ALSO"
X(@miscmansuffix@), Xserver(1), xdm(1), xinit(1), XWinrc(@filemansuffix@),
setxkbmap(1), xkeyboard-config(@miscmansuffix@).


.SH BUGS
.I XWin
and this manual page still have many limitations.

The \fIXWin\fP software is continuously developing; it is therefore possible that
this manual page is not up to date.  It is always prudent to
look also at the output of \fIXWin -help\fP in order to
check the options that are operative.


.SH AUTHORS
This list is by no means complete, but direct contributors to the
Cygwin/X project include (in alphabetical order by last name): Stuart
Adamson, Michael Bax, Jehan Bing, Lev Bishop, Dr. Peter Busch, Biju G
C, Robert Collins, Nick Crabtree, Early Ehlinger, Christopher Faylor,
John Fortin, Brian Genisio, Fabrizio Gennari, Alexander Gottwald, Ralf
Habacker, Colin Harrison, Matthieu Herrb, Alan Hourihane, Pierre A
Humblet, Harold L Hunt II, Dakshinamurthy Karra, Joe Krahn,
Paul Loewenstein, Kensuke Matsuzaki,
Takuma Murakami, Earle F. Philhower III, Benjamin Riefenstahl, Yaakov Selkowitz,
Suhaib Siddiqi, Jack Tanner, Jon Turney and Nicholas Wourms.
