%define rtlmajor 3
%define linuxversion 2.3.51
%define rtlrelease rtl3.0pre5
%define kver 2.3.51-rtl3.0pre5
Summary: The RTLinux %{rtlmajor}.x kernel
Name: rtlinux%{rtlmajor}-kernel
Version: %{linuxversion}%{rtlrelease}
Release: 1
Copyright: GPL
Group: Base
URL: http://www.rtlinux.org/
Packager: Michael Barabanov <baraban@fsmlabs.com>
Source0: ftp://ftp.fsmlabs.com/pub/rtlinux/rtlinux-kernel-%{linuxversion}.tar.gz
Source1: config-%{linuxversion}-x86
Patch: kernel_patch-%{linuxversion}-%{rtlrelease}
BuildRoot: /tmp/rtlinux-kernel-root

%define rtlinstdir /usr/src/rtlinux%{rtlmajor}

%description
This package contains the RTLinux kernel.

%prep
%setup -n linux
%ifarch i386 i486 i586 i686
%patch -p1
cp -fv $RPM_SOURCE_DIR/config-%{linuxversion}-x86 .config
%endif

%build
make oldconfig

%ifarch i386 i486 i586 i686
make bzImage
%endif

make modules

%install

make modules_install INSTALL_MOD_PATH="$RPM_BUILD_ROOT"
mkdir -p $RPM_BUILD_ROOT/%{rtlinstdir}/linux
cp .config $RPM_BUILD_ROOT/%{rtlinstdir}/linux

%ifarch i386 i486 i586 i686
mkdir -p $RPM_BUILD_ROOT/boot
cp arch/i386/boot/bzImage $RPM_BUILD_ROOT/boot/rtzImage%{rtlmajor}
cp System.map $RPM_BUILD_ROOT/boot/System.map-%{kver}
%endif

%ifarch i386 i486 i586 i686
find include -name 'asm-*' -and -not -name asm-i386 -prune -or -print|cpio -pd $RPM_BUILD_ROOT/%rtlinstdir/linux
%else
find include -print|cpio -pd $RPM_BUILD_ROOT/%rtlinstdir/linux
%endif

%post
%ifarch i386 i486 i586 i686
if [ -x /sbin/lilo -a -f /etc/lilo.conf ]; then
	/sbin/lilo > /dev/null 2>&1
	exit 0
fi
%endif

%preun
rm -f /lib/modules/%{kver}/modules.dep

%clean
rm -rf $RPM_BUILD_ROOT

%files
/lib/modules/
/boot
%rtlinstdir
%config
