/*
 * Main system for RTL.
 * 
 * Copyright (C) 1999 Cort Dougan <cort@fsmlabs.com>
 * Copyright (C) 1999 Victor Yodaiken <yodaiken@fsmlabs.com>
 */

#ifndef __RTL_CORE_H__
#define __RTL_CORE_H__

#include <rtl_version.h>

#include <linux/version.h>
#include <linux/types.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,0)
#include <linux/threads.h>
#else
#include <linux/tasks.h>
#endif
#include <linux/string.h>
#include <linux/smp.h>
#include <rtl_printf.h>
#include <asm/ptrace.h>
#include <asm/current.h>
#include <arch/constants.h>
#include <arch/rtl_io.h>

/*
 * This check should be for 2.4.0-final or greater but a check
 * for for 2.4.1 or later is much simpler.
 */
#define LINUX_2_4_0_FINAL_OR_LATER (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,1))

/* some old programs need this */
#define DECLARE_CPUID(cpu_id)   unsigned int cpu_id = rtl_getcpuid()

intercept_t  rtl_intercept(MACHDEPREGS regs);
void rtl_soft_sti(void);
void rtl_soft_cli(void);
void rtl_soft_save_flags(unsigned long *);
void rtl_soft_restore_flags(unsigned long);
void rtl_soft_save_and_cli(unsigned long *);
void rtl_global_pend_irq(int);
int rtl_global_ispending_irq(int);
int rtl_local_ispending_irq(int);
void rtl_virt_disable(unsigned int);
void rtl_virt_enable(unsigned int);
void rtl_process_pending(void);

#ifdef __LOCAL_IRQS__
#define LOCAL_PND_MAX 32
void dispatch_local_linux_irq(struct pt_regs *, int pnd);
void rtl_local_pend_vec(int vector,int cpu_id);
int rtl_request_local_irq(int i, unsigned int (*handler)(struct pt_regs *r), unsigned int cpu);
void soft_dispatch_local(unsigned int);
int rtl_free_local_irq(int i, unsigned int cpu);
#endif
int arch_takeover(void);
void arch_giveup(void);
void rtl_hard_disable_irq(unsigned int);
void rtl_hard_enable_irq(unsigned int);
int rtl_request_global_irq(unsigned int irq, unsigned int (*handler)(unsigned int, struct pt_regs *));
int rtl_free_global_irq(unsigned int irq );
int rtl_get_soft_irq (void (*handler) (int, void *, struct pt_regs *),
		      const char *devname);

int rtl_irq_set_affinity (unsigned int irq, const unsigned long *mask, unsigned long *oldmask);

#define rtl_request_irq rtl_request_global_irq
#define rtl_free_irq rtl_free_global_irq

void rtl_make_rt_system_active(void);
void rtl_make_rt_system_idle(void);
unsigned int rtl_rt_system_is_idle(void);

extern void rtl_free_soft_irq(unsigned int irq);

typedef unsigned int (*rtl_local_handler_t)(struct pt_regs *r);

struct rtl_local {
	__u32    flags;
#ifdef __LOCAL_IRQS__
	__u32    pending;
	__u32    rtirq;
        rtl_local_handler_t rt_handlers[LOCAL_PND_MAX];
#endif
};

#ifdef CONFIG_SMP
extern int rtl_request_ipi (unsigned int (*f)(struct pt_regs *r), int cpu);
extern int rtl_free_ipi (int cpu);
extern void rtl_reschedule(unsigned int);
#endif

#define rtl_num_cpus() (smp_num_cpus)

extern int rtl_cpu_exists (int cpu);

/* #define __RTL_LOCALIRQS__ */

extern struct rtl_local rtl_local[NR_CPUS];
void conprn(const unsigned int hexnum);
void conpr(const char *s);
#endif
